/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.initialization;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Properties;
import javax.validation.Validation;
import javax.validation.Validator;
import org.apache.druid.guice.DruidGuiceExtensions;
import org.apache.druid.guice.LifecycleModule;
import org.apache.druid.jackson.JacksonModule;
import org.apache.druid.java.util.emitter.core.Emitter;
import org.apache.druid.server.emitter.SwitchingEmitterConfig;
import org.apache.druid.server.emitter.SwitchingEmitterModule;
import org.easymock.EasyMock;
import org.junit.Before;
import org.junit.Test;

public class SwitchingEmitterModuleTest {
    private static final String DEFAULT_EMITTER_TYPE = "http";
    private static final String FEED_1_EMITTER_TYPE = "logging";
    private static final String FEED_1 = "metrics";
    private Emitter defaultEmitter;
    private Emitter feed1Emitter;

    @Before
    public void setup() {
        this.defaultEmitter = (Emitter)EasyMock.createMock(Emitter.class);
        this.feed1Emitter = (Emitter)EasyMock.createMock(Emitter.class);
        this.defaultEmitter.start();
        this.feed1Emitter.start();
        EasyMock.replay((Object[])new Object[]{this.defaultEmitter});
        EasyMock.replay((Object[])new Object[]{this.feed1Emitter});
    }

    @Test
    public void testGetEmitter() {
        SwitchingEmitterConfig config = (SwitchingEmitterConfig)EasyMock.createMock(SwitchingEmitterConfig.class);
        EasyMock.expect((Object)config.getDefaultEmitter()).andReturn((Object)ImmutableList.of((Object)DEFAULT_EMITTER_TYPE)).anyTimes();
        EasyMock.expect((Object)config.getEmitters()).andReturn((Object)ImmutableMap.of((Object)FEED_1, (Object)ImmutableList.of((Object)FEED_1_EMITTER_TYPE))).anyTimes();
        Injector injector = (Injector)EasyMock.createMock(Injector.class);
        EasyMock.expect((Object)((Emitter)injector.getInstance(Key.get(Emitter.class, (Annotation)Names.named((String)DEFAULT_EMITTER_TYPE))))).andReturn((Object)this.defaultEmitter);
        EasyMock.expect((Object)((Emitter)injector.getInstance(Key.get(Emitter.class, (Annotation)Names.named((String)FEED_1_EMITTER_TYPE))))).andReturn((Object)this.feed1Emitter);
        EasyMock.replay((Object[])new Object[]{config, injector});
        Emitter switchingEmitter = new SwitchingEmitterModule().makeEmitter(config, injector);
        switchingEmitter.start();
        EasyMock.verify((Object[])new Object[]{config, this.defaultEmitter, this.feed1Emitter, injector});
    }

    @Test
    public void testGetEmitterViaRealGuice() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new DruidGuiceExtensions(), new LifecycleModule(), new JacksonModule(), new Module(){

            public void configure(Binder binder) {
                Properties props = new Properties();
                String defaultEmittersValue = "[\"http\"]";
                String emittersValue = "{\"metrics\":[\"logging\"]}";
                props.put("druid.emitter.switching.defaultEmitters", defaultEmittersValue);
                props.put("druid.emitter.switching.emitters", emittersValue);
                binder.bind(Properties.class).toInstance((Object)props);
                binder.bind(Validator.class).toInstance((Object)Validation.buildDefaultValidatorFactory().getValidator());
                binder.bind(Emitter.class).annotatedWith((Annotation)Names.named((String)SwitchingEmitterModuleTest.DEFAULT_EMITTER_TYPE)).toInstance((Object)SwitchingEmitterModuleTest.this.defaultEmitter);
                binder.bind(Emitter.class).annotatedWith((Annotation)Names.named((String)SwitchingEmitterModuleTest.FEED_1_EMITTER_TYPE)).toInstance((Object)SwitchingEmitterModuleTest.this.feed1Emitter);
            }
        }, new SwitchingEmitterModule()});
        ((Emitter)injector.getInstance(Key.get(Emitter.class, (Annotation)Names.named((String)"switching")))).start();
        EasyMock.verify((Object[])new Object[]{this.defaultEmitter});
        EasyMock.verify((Object[])new Object[]{this.feed1Emitter});
    }
}

