/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.druid.metadata.TestDerbyConnector;
import org.apache.druid.segment.metadata.CentralizedDatasourceSchemaConfig;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class SQLMetadataConnectorSchemaPersistenceTest {
    @Rule
    public final TestDerbyConnector.DerbyConnectorRule derbyConnectorRule = new TestDerbyConnector.DerbyConnectorRule(CentralizedDatasourceSchemaConfig.create((boolean)true));
    private TestDerbyConnector connector;
    private MetadataStorageTablesConfig tablesConfig;

    @Before
    public void setUp() {
        this.connector = this.derbyConnectorRule.getConnector();
        this.tablesConfig = (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get();
    }

    @Test
    public void testCreateTables() {
        ArrayList<String> tables = new ArrayList<String>();
        String entryType = this.tablesConfig.getTaskEntryType();
        tables.add(this.tablesConfig.getConfigTable());
        tables.add(this.tablesConfig.getSegmentSchemasTable());
        tables.add(this.tablesConfig.getSegmentsTable());
        tables.add(this.tablesConfig.getRulesTable());
        tables.add(this.tablesConfig.getLockTable(entryType));
        tables.add(this.tablesConfig.getEntryTable(entryType));
        tables.add(this.tablesConfig.getAuditTable());
        tables.add(this.tablesConfig.getSupervisorTable());
        ArrayList<String> dropSequence = new ArrayList<String>();
        dropSequence.add(this.tablesConfig.getConfigTable());
        dropSequence.add(this.tablesConfig.getSegmentsTable());
        dropSequence.add(this.tablesConfig.getSegmentSchemasTable());
        dropSequence.add(this.tablesConfig.getRulesTable());
        dropSequence.add(this.tablesConfig.getLockTable(entryType));
        dropSequence.add(this.tablesConfig.getEntryTable(entryType));
        dropSequence.add(this.tablesConfig.getAuditTable());
        dropSequence.add(this.tablesConfig.getSupervisorTable());
        this.connector.createSegmentSchemasTable();
        this.connector.createSegmentTable();
        this.connector.createConfigTable();
        this.connector.createRulesTable();
        this.connector.createTaskTables();
        this.connector.createAuditTable();
        this.connector.createSupervisorsTable();
        this.connector.getDBI().withHandle(handle -> {
            for (String table : tables) {
                Assert.assertTrue((String)StringUtils.format((String)"table %s was not created!", (Object[])new Object[]{table}), (boolean)this.connector.tableExists(handle, table));
            }
            String taskTable = this.tablesConfig.getTasksTable();
            for (String column : Arrays.asList("type", "group_id")) {
                Assert.assertTrue((String)StringUtils.format((String)"Tasks table column %s was not created!", (Object[])new Object[]{column}), (boolean)this.connector.tableHasColumn(taskTable, column));
            }
            return null;
        });
        for (String table : dropSequence) {
            this.dropTable(table);
        }
    }

    private void dropTable(String tableName) {
        this.connector.getDBI().withHandle(handle -> handle.createStatement(StringUtils.format((String)"DROP TABLE %s", (Object[])new Object[]{tableName})).execute());
    }

    @Test
    public void testAlterSegmentTable() {
        this.connector.createSegmentTable(this.tablesConfig.getSegmentsTable());
        this.derbyConnectorRule.segments().update("ALTER TABLE %1$s DROP COLUMN USED_STATUS_LAST_UPDATED", new Object[0]);
        this.derbyConnectorRule.segments().update("ALTER TABLE %1$s DROP COLUMN SCHEMA_FINGERPRINT", new Object[0]);
        this.derbyConnectorRule.segments().update("ALTER TABLE %1$s DROP COLUMN NUM_ROWS", new Object[0]);
        this.connector.alterSegmentTable();
        Assert.assertTrue((boolean)this.connector.tableHasColumn(((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getSegmentsTable(), "USED_STATUS_LAST_UPDATED"));
        Assert.assertTrue((boolean)this.connector.tableHasColumn(((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getSegmentsTable(), "SCHEMA_FINGERPRINT"));
        Assert.assertTrue((boolean)this.connector.tableHasColumn(((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getSegmentsTable(), "NUM_ROWS"));
    }
}

