/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.druid.indexing.overlord.supervisor.NoopSupervisorSpec;
import org.apache.druid.indexing.overlord.supervisor.Supervisor;
import org.apache.druid.indexing.overlord.supervisor.SupervisorSpec;
import org.apache.druid.indexing.overlord.supervisor.VersionedSupervisorSpec;
import org.apache.druid.indexing.overlord.supervisor.autoscaler.SupervisorTaskAutoScaler;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.druid.metadata.SQLMetadataConnector;
import org.apache.druid.metadata.SQLMetadataSupervisorManager;
import org.apache.druid.metadata.TestDerbyConnector;
import org.apache.druid.metadata.TestSupervisorSpec;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.tweak.HandleCallback;

public class SQLMetadataSupervisorManagerTest {
    private static final ObjectMapper MAPPER = new DefaultObjectMapper();
    private TestDerbyConnector connector;
    private MetadataStorageTablesConfig tablesConfig;
    private SQLMetadataSupervisorManager supervisorManager;
    @Rule
    public final TestDerbyConnector.DerbyConnectorRule derbyConnectorRule = new TestDerbyConnector.DerbyConnectorRule();

    @BeforeClass
    public static void setupStatic() {
        MAPPER.registerSubtypes(new Class[]{TestSupervisorSpec.class});
    }

    @After
    public void cleanup() {
        this.connector.getDBI().withHandle((HandleCallback)new HandleCallback<Void>(){

            public Void withHandle(Handle handle) {
                handle.createStatement(StringUtils.format((String)"DROP TABLE %s", (Object[])new Object[]{SQLMetadataSupervisorManagerTest.this.tablesConfig.getSupervisorTable()})).execute();
                return null;
            }
        });
    }

    @Before
    public void setUp() {
        this.connector = this.derbyConnectorRule.getConnector();
        this.tablesConfig = (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get();
        this.connector.createSupervisorsTable();
        this.supervisorManager = new SQLMetadataSupervisorManager(MAPPER, (SQLMetadataConnector)this.connector, Suppliers.ofInstance((Object)this.tablesConfig));
    }

    @Test
    public void testRemoveTerminatedSupervisorsOlderThanSupervisorActiveShouldNotBeDeleted() {
        String supervisor1 = "test-supervisor-1";
        ImmutableMap data1rev1 = ImmutableMap.of((Object)"key1-1", (Object)"value1-1-1", (Object)"key1-2", (Object)"value1-2-1");
        Assert.assertTrue((boolean)this.supervisorManager.getAll().isEmpty());
        this.supervisorManager.insert("test-supervisor-1", (SupervisorSpec)new TestSupervisorSpec("test-supervisor-1", data1rev1));
        Map supervisorSpecs = this.supervisorManager.getAll();
        Assert.assertEquals((long)1L, (long)supervisorSpecs.size());
        Map latestSpecs = this.supervisorManager.getLatest();
        Assert.assertEquals((long)1L, (long)latestSpecs.size());
        int deleteCount = this.supervisorManager.removeTerminatedSupervisorsOlderThan(System.currentTimeMillis());
        Assert.assertEquals((long)0L, (long)deleteCount);
        supervisorSpecs = this.supervisorManager.getAll();
        Assert.assertEquals((long)1L, (long)supervisorSpecs.size());
        latestSpecs = this.supervisorManager.getLatest();
        Assert.assertEquals((long)1L, (long)latestSpecs.size());
    }

    @Test
    public void testRemoveTerminatedSupervisorsOlderThanWithSupervisorTerminatedAndOlderThanTimeShouldBeDeleted() {
        String supervisor1 = "test-supervisor-1";
        String datasource1 = "datasource-1";
        ImmutableMap data1rev1 = ImmutableMap.of((Object)"key1-1", (Object)"value1-1-1", (Object)"key1-2", (Object)"value1-2-1");
        Assert.assertTrue((boolean)this.supervisorManager.getAll().isEmpty());
        this.supervisorManager.insert("test-supervisor-1", (SupervisorSpec)new TestSupervisorSpec("test-supervisor-1", data1rev1));
        this.supervisorManager.insert("test-supervisor-1", (SupervisorSpec)new NoopSupervisorSpec("test-supervisor-1", (List)ImmutableList.of((Object)"datasource-1")));
        Map supervisorSpecs = this.supervisorManager.getAll();
        Assert.assertEquals((long)1L, (long)supervisorSpecs.size());
        Assert.assertEquals((long)2L, (long)((List)supervisorSpecs.get("test-supervisor-1")).size());
        Map latestSpecs = this.supervisorManager.getLatest();
        Assert.assertEquals((long)1L, (long)latestSpecs.size());
        Assert.assertEquals((Object)ImmutableList.of((Object)"datasource-1"), (Object)((NoopSupervisorSpec)latestSpecs.get("test-supervisor-1")).getDataSources());
        int deleteCount = this.supervisorManager.removeTerminatedSupervisorsOlderThan(System.currentTimeMillis());
        Assert.assertEquals((long)2L, (long)deleteCount);
        supervisorSpecs = this.supervisorManager.getAll();
        Assert.assertEquals((long)0L, (long)supervisorSpecs.size());
        latestSpecs = this.supervisorManager.getLatest();
        Assert.assertEquals((long)0L, (long)latestSpecs.size());
    }

    @Test
    public void testRemoveTerminatedSupervisorsOlderThanWithSupervisorTerminatedButNotOlderThanTimeShouldNotBeDeleted() {
        String supervisor1 = "test-supervisor-1";
        String datasource1 = "datasource-1";
        ImmutableMap data1rev1 = ImmutableMap.of((Object)"key1-1", (Object)"value1-1-1", (Object)"key1-2", (Object)"value1-2-1");
        Assert.assertTrue((boolean)this.supervisorManager.getAll().isEmpty());
        this.supervisorManager.insert("test-supervisor-1", (SupervisorSpec)new TestSupervisorSpec("test-supervisor-1", data1rev1));
        this.supervisorManager.insert("test-supervisor-1", (SupervisorSpec)new NoopSupervisorSpec("test-supervisor-1", (List)ImmutableList.of((Object)"datasource-1")));
        Map supervisorSpecs = this.supervisorManager.getAll();
        Assert.assertEquals((long)1L, (long)supervisorSpecs.size());
        Assert.assertEquals((long)2L, (long)((List)supervisorSpecs.get("test-supervisor-1")).size());
        Map latestSpecs = this.supervisorManager.getLatest();
        Assert.assertEquals((long)1L, (long)latestSpecs.size());
        Assert.assertEquals((Object)ImmutableList.of((Object)"datasource-1"), (Object)((NoopSupervisorSpec)latestSpecs.get("test-supervisor-1")).getDataSources());
        int deleteCount = this.supervisorManager.removeTerminatedSupervisorsOlderThan(DateTimes.of((String)"2012-01-01T00:00:00Z").getMillis());
        Assert.assertEquals((long)0L, (long)deleteCount);
        supervisorSpecs = this.supervisorManager.getAll();
        Assert.assertEquals((long)1L, (long)supervisorSpecs.size());
        Assert.assertEquals((long)2L, (long)((List)supervisorSpecs.get("test-supervisor-1")).size());
        latestSpecs = this.supervisorManager.getLatest();
        Assert.assertEquals((long)1L, (long)latestSpecs.size());
        Assert.assertEquals((Object)ImmutableList.of((Object)"datasource-1"), (Object)((NoopSupervisorSpec)latestSpecs.get("test-supervisor-1")).getDataSources());
    }

    @Test
    public void testInsertAndGet() {
        String supervisor1 = "test-supervisor-1";
        String supervisor2 = "test-supervisor-2";
        ImmutableMap data1rev1 = ImmutableMap.of((Object)"key1-1", (Object)"value1-1-1", (Object)"key1-2", (Object)"value1-2-1");
        ImmutableMap data1rev2 = ImmutableMap.of((Object)"key1-1", (Object)"value1-1-2", (Object)"key1-2", (Object)"value1-2-2");
        ImmutableMap data1rev3 = ImmutableMap.of((Object)"key1-1", (Object)"value1-1-3", (Object)"key1-2", (Object)"value1-2-3");
        ImmutableMap data2rev1 = ImmutableMap.of((Object)"key2-1", (Object)"value2-1-1", (Object)"key2-2", (Object)"value2-2-1");
        ImmutableMap data2rev2 = ImmutableMap.of((Object)"key2-3", (Object)"value2-3-2", (Object)"key2-4", (Object)"value2-4-2");
        Assert.assertTrue((boolean)this.supervisorManager.getAll().isEmpty());
        this.supervisorManager.insert("test-supervisor-1", (SupervisorSpec)new TestSupervisorSpec("test-supervisor-1", data1rev1));
        this.supervisorManager.insert("test-supervisor-2", (SupervisorSpec)new TestSupervisorSpec("test-supervisor-2", data2rev1));
        Map supervisorSpecs = this.supervisorManager.getAll();
        Map latestSpecs = this.supervisorManager.getLatest();
        Assert.assertEquals((long)2L, (long)supervisorSpecs.size());
        Assert.assertEquals((long)1L, (long)((List)supervisorSpecs.get("test-supervisor-1")).size());
        Assert.assertEquals((long)1L, (long)((List)supervisorSpecs.get("test-supervisor-2")).size());
        Assert.assertEquals((Object)"test-supervisor-1", (Object)((VersionedSupervisorSpec)((List)supervisorSpecs.get("test-supervisor-1")).get(0)).getSpec().getId());
        Assert.assertEquals((Object)"test-supervisor-2", (Object)((VersionedSupervisorSpec)((List)supervisorSpecs.get("test-supervisor-2")).get(0)).getSpec().getId());
        Assert.assertEquals((Object)data1rev1, (Object)((TestSupervisorSpec)((VersionedSupervisorSpec)((List)supervisorSpecs.get("test-supervisor-1")).get(0)).getSpec()).getData());
        Assert.assertEquals((Object)data2rev1, (Object)((TestSupervisorSpec)((VersionedSupervisorSpec)((List)supervisorSpecs.get("test-supervisor-2")).get(0)).getSpec()).getData());
        Assert.assertEquals((long)2L, (long)latestSpecs.size());
        Assert.assertEquals((Object)data1rev1, (Object)((TestSupervisorSpec)latestSpecs.get("test-supervisor-1")).getData());
        Assert.assertEquals((Object)data2rev1, (Object)((TestSupervisorSpec)latestSpecs.get("test-supervisor-2")).getData());
        this.supervisorManager.insert("test-supervisor-1", (SupervisorSpec)new TestSupervisorSpec("test-supervisor-1", data1rev2));
        this.supervisorManager.insert("test-supervisor-1", (SupervisorSpec)new TestSupervisorSpec("test-supervisor-1", data1rev3));
        this.supervisorManager.insert("test-supervisor-2", (SupervisorSpec)new TestSupervisorSpec("test-supervisor-2", data2rev2));
        supervisorSpecs = this.supervisorManager.getAll();
        latestSpecs = this.supervisorManager.getLatest();
        Assert.assertEquals((long)2L, (long)supervisorSpecs.size());
        Assert.assertEquals((long)3L, (long)((List)supervisorSpecs.get("test-supervisor-1")).size());
        Assert.assertEquals((long)2L, (long)((List)supervisorSpecs.get("test-supervisor-2")).size());
        Assert.assertEquals((Object)data1rev3, (Object)((TestSupervisorSpec)((VersionedSupervisorSpec)((List)supervisorSpecs.get("test-supervisor-1")).get(0)).getSpec()).getData());
        Assert.assertEquals((Object)data1rev2, (Object)((TestSupervisorSpec)((VersionedSupervisorSpec)((List)supervisorSpecs.get("test-supervisor-1")).get(1)).getSpec()).getData());
        Assert.assertEquals((Object)data1rev1, (Object)((TestSupervisorSpec)((VersionedSupervisorSpec)((List)supervisorSpecs.get("test-supervisor-1")).get(2)).getSpec()).getData());
        Assert.assertEquals((Object)data2rev2, (Object)((TestSupervisorSpec)((VersionedSupervisorSpec)((List)supervisorSpecs.get("test-supervisor-2")).get(0)).getSpec()).getData());
        Assert.assertEquals((Object)data2rev1, (Object)((TestSupervisorSpec)((VersionedSupervisorSpec)((List)supervisorSpecs.get("test-supervisor-2")).get(1)).getSpec()).getData());
        Assert.assertEquals((Object)data1rev3, (Object)((TestSupervisorSpec)latestSpecs.get("test-supervisor-1")).getData());
        Assert.assertEquals((Object)data2rev2, (Object)((TestSupervisorSpec)latestSpecs.get("test-supervisor-2")).getData());
    }

    @Test
    public void testInsertAndGetForId() {
        String supervisor1 = "test-supervisor-1";
        String supervisor2 = "test-supervisor-2";
        ImmutableMap data1rev1 = ImmutableMap.of((Object)"key1-1", (Object)"value1-1-1", (Object)"key1-2", (Object)"value1-2-1");
        ImmutableMap data1rev2 = ImmutableMap.of((Object)"key1-1", (Object)"value1-1-2", (Object)"key1-2", (Object)"value1-2-2");
        ImmutableMap data1rev3 = ImmutableMap.of((Object)"key1-1", (Object)"value1-1-3", (Object)"key1-2", (Object)"value1-2-3");
        ImmutableMap data2rev1 = ImmutableMap.of((Object)"key2-1", (Object)"value2-1-1", (Object)"key2-2", (Object)"value2-2-1");
        ImmutableMap data2rev2 = ImmutableMap.of((Object)"key2-3", (Object)"value2-3-2", (Object)"key2-4", (Object)"value2-4-2");
        Assert.assertTrue((boolean)this.supervisorManager.getAllForId("test-supervisor-1").isEmpty());
        Assert.assertTrue((boolean)this.supervisorManager.getAllForId("test-supervisor-2").isEmpty());
        this.supervisorManager.insert("test-supervisor-1", (SupervisorSpec)new TestSupervisorSpec("test-supervisor-1", data1rev1));
        this.supervisorManager.insert("test-supervisor-1", (SupervisorSpec)new TestSupervisorSpec("test-supervisor-1", data1rev2));
        this.supervisorManager.insert("test-supervisor-1", (SupervisorSpec)new TestSupervisorSpec("test-supervisor-1", data1rev3));
        this.supervisorManager.insert("test-supervisor-2", (SupervisorSpec)new TestSupervisorSpec("test-supervisor-2", data2rev1));
        this.supervisorManager.insert("test-supervisor-2", (SupervisorSpec)new TestSupervisorSpec("test-supervisor-2", data2rev2));
        List supervisor1Specs = this.supervisorManager.getAllForId("test-supervisor-1");
        List supervisor2Specs = this.supervisorManager.getAllForId("test-supervisor-2");
        Assert.assertEquals((long)3L, (long)supervisor1Specs.size());
        Assert.assertEquals((long)2L, (long)supervisor2Specs.size());
        Assert.assertEquals((Object)data1rev3, (Object)((TestSupervisorSpec)((VersionedSupervisorSpec)supervisor1Specs.get(0)).getSpec()).getData());
        Assert.assertEquals((Object)data1rev2, (Object)((TestSupervisorSpec)((VersionedSupervisorSpec)supervisor1Specs.get(1)).getSpec()).getData());
        Assert.assertEquals((Object)data1rev1, (Object)((TestSupervisorSpec)((VersionedSupervisorSpec)supervisor1Specs.get(2)).getSpec()).getData());
        Assert.assertEquals((Object)data2rev2, (Object)((TestSupervisorSpec)((VersionedSupervisorSpec)supervisor2Specs.get(0)).getSpec()).getData());
        Assert.assertEquals((Object)data2rev1, (Object)((TestSupervisorSpec)((VersionedSupervisorSpec)supervisor2Specs.get(1)).getSpec()).getData());
    }

    @Test
    public void testSkipDeserializingBadSpecs() {
        String supervisor1 = "test-supervisor-1";
        String supervisor2 = "test-supervisor-2";
        ImmutableMap data1rev1 = ImmutableMap.of((Object)"key1-1", (Object)"value1-1-1", (Object)"key1-2", (Object)"value1-2-1");
        ImmutableMap data1rev2 = ImmutableMap.of((Object)"key1-1", (Object)"value1-1-2", (Object)"key1-2", (Object)"value1-2-2");
        this.supervisorManager.insert("test-supervisor-1", (SupervisorSpec)new TestSupervisorSpec("test-supervisor-1", data1rev1));
        this.supervisorManager.insert("test-supervisor-2", (SupervisorSpec)new BadSupervisorSpec("test-supervisor-2", "test-supervisor-2"));
        this.supervisorManager.insert("test-supervisor-1", (SupervisorSpec)new TestSupervisorSpec("test-supervisor-1", data1rev2));
        Map allSpecs = this.supervisorManager.getAll();
        Assert.assertEquals((long)2L, (long)allSpecs.size());
        List specs = (List)allSpecs.get("test-supervisor-1");
        Assert.assertEquals((long)2L, (long)specs.size());
        Assert.assertEquals((Object)new TestSupervisorSpec("test-supervisor-1", data1rev2), (Object)((VersionedSupervisorSpec)specs.get(0)).getSpec());
        Assert.assertEquals((Object)new TestSupervisorSpec("test-supervisor-1", data1rev1), (Object)((VersionedSupervisorSpec)specs.get(1)).getSpec());
        specs = (List)allSpecs.get("test-supervisor-2");
        Assert.assertEquals((long)1L, (long)specs.size());
        Assert.assertNull((Object)((VersionedSupervisorSpec)specs.get(0)).getSpec());
        Map latestSupervisorSpec = this.supervisorManager.getLatest();
        Assert.assertEquals((long)1L, (long)latestSupervisorSpec.size());
    }

    @Test
    public void testGetLatestActiveOnly() {
        String supervisor1 = "test-supervisor-1";
        String datasource1 = "datasource-1";
        String supervisor2 = "test-supervisor-2";
        ImmutableMap data1rev1 = ImmutableMap.of((Object)"key1-1", (Object)"value1-1-1", (Object)"key1-2", (Object)"value1-2-1");
        Assert.assertTrue((boolean)this.supervisorManager.getAll().isEmpty());
        this.supervisorManager.insert("test-supervisor-1", (SupervisorSpec)new TestSupervisorSpec("test-supervisor-1", data1rev1));
        this.supervisorManager.insert("test-supervisor-1", (SupervisorSpec)new NoopSupervisorSpec("test-supervisor-1", (List)ImmutableList.of((Object)"datasource-1")));
        this.supervisorManager.insert("test-supervisor-2", (SupervisorSpec)new TestSupervisorSpec("test-supervisor-2", data1rev1));
        Map actual = this.supervisorManager.getLatestActiveOnly();
        Assert.assertEquals((long)1L, (long)actual.size());
        Assert.assertTrue((boolean)actual.containsKey("test-supervisor-2"));
    }

    @Test
    public void testGetLatestTerminatedOnly() {
        String supervisor1 = "test-supervisor-1";
        String datasource1 = "datasource-1";
        String supervisor2 = "test-supervisor-2";
        ImmutableMap data1rev1 = ImmutableMap.of((Object)"key1-1", (Object)"value1-1-1", (Object)"key1-2", (Object)"value1-2-1");
        Assert.assertTrue((boolean)this.supervisorManager.getAll().isEmpty());
        this.supervisorManager.insert("test-supervisor-1", (SupervisorSpec)new TestSupervisorSpec("test-supervisor-1", data1rev1));
        this.supervisorManager.insert("test-supervisor-1", (SupervisorSpec)new NoopSupervisorSpec("test-supervisor-1", (List)ImmutableList.of((Object)"datasource-1")));
        this.supervisorManager.insert("test-supervisor-2", (SupervisorSpec)new TestSupervisorSpec("test-supervisor-2", data1rev1));
        Map actual = this.supervisorManager.getLatestTerminatedOnly();
        Assert.assertEquals((long)1L, (long)actual.size());
        Assert.assertTrue((boolean)actual.containsKey("test-supervisor-1"));
    }

    private static class BadSupervisorSpec
    implements SupervisorSpec {
        private final String id;
        private final String dataSource;

        private BadSupervisorSpec(String id, String dataSource) {
            this.id = id;
            this.dataSource = dataSource;
        }

        public String getId() {
            return this.id;
        }

        public Supervisor createSupervisor() {
            throw new UnsupportedOperationException();
        }

        public SupervisorTaskAutoScaler createAutoscaler(Supervisor supervisor) {
            return null;
        }

        public List<String> getDataSources() {
            return Collections.singletonList(this.dataSource);
        }

        public String getType() {
            return null;
        }

        public String getSource() {
            return null;
        }
    }
}

