/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.InlineDataSource;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.segment.InlineSegmentWrangler;
import org.apache.druid.segment.RowBasedSegment;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class InlineSegmentWranglerTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private final InlineSegmentWrangler factory = new InlineSegmentWrangler();
    private final InlineDataSource inlineDataSource = InlineDataSource.fromIterable((Iterable)ImmutableList.of((Object)new Object[]{"foo", 1L}, (Object)new Object[]{"bar", 2L}), (RowSignature)RowSignature.builder().add("str", ColumnType.STRING).add("long", ColumnType.LONG).build());

    @Test
    public void test_getSegmentsForIntervals_nonInline() {
        this.expectedException.expect(ClassCastException.class);
        this.expectedException.expectMessage("TableDataSource cannot be cast");
        Iterable ignored = this.factory.getSegmentsForIntervals((DataSource)new TableDataSource("foo"), (Iterable)Intervals.ONLY_ETERNITY);
    }

    @Test
    public void test_getSegmentsForIntervals_inline() {
        ImmutableList segments = ImmutableList.copyOf((Iterable)this.factory.getSegmentsForIntervals((DataSource)this.inlineDataSource, (Iterable)Intervals.ONLY_ETERNITY));
        Assert.assertEquals((long)1L, (long)segments.size());
        Segment segment = (Segment)Iterables.getOnlyElement((Iterable)segments);
        Assert.assertThat((Object)segment, (Matcher)CoreMatchers.instanceOf(RowBasedSegment.class));
    }
}

