/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.loading;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.guice.ObjectMapperModule;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.validation.Validation;
import javax.validation.Validator;
import org.apache.druid.guice.DruidGuiceExtensions;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.JsonConfigurator;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.StorageNodeModule;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.segment.loading.LeastBytesUsedStorageLocationSelectorStrategy;
import org.apache.druid.segment.loading.MostAvailableSizeStorageLocationSelectorStrategy;
import org.apache.druid.segment.loading.RandomStorageLocationSelectorStrategy;
import org.apache.druid.segment.loading.RoundRobinStorageLocationSelectorStrategy;
import org.apache.druid.segment.loading.SegmentLoaderConfig;
import org.apache.druid.segment.loading.StorageLocation;
import org.apache.druid.segment.loading.StorageLocationSelectorStrategy;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class StorageLocationSelectorStrategyTest {
    @Rule
    public final TemporaryFolder tmpFolder = new TemporaryFolder();

    @Test
    public void testLeastBytesUsedLocationSelectorStrategy() throws Exception {
        ArrayList<StorageLocation> storageLocations = new ArrayList<StorageLocation>();
        File localStorageFolder1 = this.tmpFolder.newFolder("local_storage_folder_1");
        File localStorageFolder2 = this.tmpFolder.newFolder("local_storage_folder_2");
        File localStorageFolder3 = this.tmpFolder.newFolder("local_storage_folder_3");
        StorageLocation storageLocation1 = new StorageLocation(localStorageFolder1, 10000000000L, null);
        storageLocations.add(storageLocation1);
        storageLocations.add(new StorageLocation(localStorageFolder2, 10000000000L, null));
        storageLocations.add(new StorageLocation(localStorageFolder3, 10000000000L, null));
        LeastBytesUsedStorageLocationSelectorStrategy leastBytesUsedStrategy = new LeastBytesUsedStorageLocationSelectorStrategy(storageLocations);
        storageLocation1.reserve("tmp_loc1", "__seg1", 1024L);
        Iterator locations = leastBytesUsedStrategy.getLocations();
        StorageLocation loc1 = (StorageLocation)locations.next();
        Assert.assertEquals((String)"The next element of the iterator should point to path local_storage_folder_2", (Object)localStorageFolder2, (Object)loc1.getPath());
        StorageLocation loc2 = (StorageLocation)locations.next();
        Assert.assertEquals((String)"The next element of the iterator should point to path local_storage_folder_3", (Object)localStorageFolder3, (Object)loc2.getPath());
        StorageLocation loc3 = (StorageLocation)locations.next();
        Assert.assertEquals((String)"The next element of the iterator should point to path local_storage_folder_1", (Object)localStorageFolder1, (Object)loc3.getPath());
    }

    @Test
    public void testRoundRobinLocationSelectorStrategySingleLocation() throws Exception {
        ArrayList<StorageLocation> storageLocations = new ArrayList<StorageLocation>();
        File localStorageFolder1 = this.tmpFolder.newFolder("local_storage_folder_1");
        storageLocations.add(new StorageLocation(localStorageFolder1, 10000000000L, null));
        RoundRobinStorageLocationSelectorStrategy roundRobinStrategy = new RoundRobinStorageLocationSelectorStrategy(storageLocations);
        Iterator locations = roundRobinStrategy.getLocations();
        StorageLocation loc1 = (StorageLocation)locations.next();
        Assert.assertEquals((String)"The next element of the iterator should point to path local_storage_folder_1", (Object)localStorageFolder1, (Object)loc1.getPath());
        locations = roundRobinStrategy.getLocations();
        StorageLocation loc2 = (StorageLocation)locations.next();
        Assert.assertEquals((String)"The next element of the iterator should point to path local_storage_folder_1", (Object)localStorageFolder1, (Object)loc2.getPath());
    }

    @Test
    public void testRoundRobinLocationSelectorStrategy() throws Exception {
        ArrayList<StorageLocation> storageLocations = new ArrayList<StorageLocation>();
        File localStorageFolder1 = this.tmpFolder.newFolder("local_storage_folder_1");
        File localStorageFolder2 = this.tmpFolder.newFolder("local_storage_folder_2");
        File localStorageFolder3 = this.tmpFolder.newFolder("local_storage_folder_3");
        storageLocations.add(new StorageLocation(localStorageFolder1, 10000000000L, null));
        storageLocations.add(new StorageLocation(localStorageFolder2, 10000000000L, null));
        storageLocations.add(new StorageLocation(localStorageFolder3, 10000000000L, null));
        RoundRobinStorageLocationSelectorStrategy roundRobinStrategy = new RoundRobinStorageLocationSelectorStrategy(storageLocations);
        Iterator locations = roundRobinStrategy.getLocations();
        StorageLocation loc1 = (StorageLocation)locations.next();
        Assert.assertEquals((String)"The next element of the iterator should point to path local_storage_folder_1", (Object)localStorageFolder1, (Object)loc1.getPath());
        StorageLocation loc2 = (StorageLocation)locations.next();
        Assert.assertEquals((String)"The next element of the iterator should point to path local_storage_folder_2", (Object)localStorageFolder2, (Object)loc2.getPath());
        StorageLocation loc3 = (StorageLocation)locations.next();
        Assert.assertEquals((String)"The next element of the iterator should point to path local_storage_folder_3", (Object)localStorageFolder3, (Object)loc3.getPath());
        locations = roundRobinStrategy.getLocations();
        loc2 = (StorageLocation)locations.next();
        Assert.assertEquals((String)"The next element of the iterator should point to path local_storage_folder_2", (Object)localStorageFolder2, (Object)loc2.getPath());
        loc3 = (StorageLocation)locations.next();
        Assert.assertEquals((String)"The next element of the iterator should point to path local_storage_folder_3", (Object)localStorageFolder3, (Object)loc3.getPath());
        loc1 = (StorageLocation)locations.next();
        Assert.assertEquals((String)"The next element of the iterator should point to path local_storage_folder_1", (Object)localStorageFolder1, (Object)loc1.getPath());
    }

    @Test
    public void testRoundRobinLocationSelectorStrategyMultipleCallsToGetLocations() throws Exception {
        ArrayList<StorageLocation> storageLocations = new ArrayList<StorageLocation>();
        File localStorageFolder1 = this.tmpFolder.newFolder("local_storage_folder_1");
        File localStorageFolder2 = this.tmpFolder.newFolder("local_storage_folder_2");
        File localStorageFolder3 = this.tmpFolder.newFolder("local_storage_folder_3");
        storageLocations.add(new StorageLocation(localStorageFolder1, 10000000000L, null));
        storageLocations.add(new StorageLocation(localStorageFolder2, 10000000000L, null));
        storageLocations.add(new StorageLocation(localStorageFolder3, 10000000000L, null));
        RoundRobinStorageLocationSelectorStrategy roundRobinStrategy = new RoundRobinStorageLocationSelectorStrategy(storageLocations);
        Iterator locations = roundRobinStrategy.getLocations();
        StorageLocation loc1 = (StorageLocation)locations.next();
        Assert.assertEquals((String)"The next element of the iterator should point to path local_storage_folder_1", (Object)localStorageFolder1, (Object)loc1.getPath());
        locations = roundRobinStrategy.getLocations();
        StorageLocation loc2 = (StorageLocation)locations.next();
        Assert.assertEquals((String)"The next element of the iterator should point to path local_storage_folder_2", (Object)localStorageFolder2, (Object)loc2.getPath());
        locations = roundRobinStrategy.getLocations();
        StorageLocation loc3 = (StorageLocation)locations.next();
        Assert.assertEquals((String)"The next element of the iterator should point to path local_storage_folder_3", (Object)localStorageFolder3, (Object)loc3.getPath());
        loc1 = (StorageLocation)locations.next();
        Assert.assertEquals((String)"The next element of the iterator should point to path local_storage_folder_1", (Object)localStorageFolder1, (Object)loc1.getPath());
    }

    @Test
    public void testRandomLocationSelectorStrategy() throws Exception {
        ArrayList<StorageLocation> storageLocations = new ArrayList<StorageLocation>();
        File localStorageFolder1 = this.tmpFolder.newFolder("local_storage_folder_1");
        File localStorageFolder2 = this.tmpFolder.newFolder("local_storage_folder_2");
        File localStorageFolder3 = this.tmpFolder.newFolder("local_storage_folder_3");
        storageLocations.add(new StorageLocation(localStorageFolder1, 3000L, null));
        storageLocations.add(new StorageLocation(localStorageFolder2, 2000L, null));
        storageLocations.add(new StorageLocation(localStorageFolder3, 1000L, null));
        RandomStorageLocationSelectorStrategy leastBytesUsedStrategy = new RandomStorageLocationSelectorStrategy(storageLocations);
        Iterator locations = leastBytesUsedStrategy.getLocations();
        StorageLocation loc1 = (StorageLocation)locations.next();
        StorageLocation loc2 = (StorageLocation)locations.next();
        StorageLocation loc3 = (StorageLocation)locations.next();
        Object[] result = new File[]{loc1.getPath(), loc2.getPath(), loc3.getPath()};
        Arrays.sort(result);
        Assert.assertArrayEquals((Object[])new File[]{localStorageFolder1, localStorageFolder2, localStorageFolder3}, (Object[])result);
    }

    @Test
    public void testMostAvailableSizeLocationSelectorStrategy() throws Exception {
        ArrayList<StorageLocation> storageLocations = new ArrayList<StorageLocation>();
        File localStorageFolder1 = this.tmpFolder.newFolder("local_storage_folder_1");
        File localStorageFolder2 = this.tmpFolder.newFolder("local_storage_folder_2");
        File localStorageFolder3 = this.tmpFolder.newFolder("local_storage_folder_3");
        StorageLocation storageLocation1 = new StorageLocation(localStorageFolder1, 10000000000L, null);
        storageLocations.add(storageLocation1);
        StorageLocation storageLocation2 = new StorageLocation(localStorageFolder2, 20000000000L, null);
        storageLocations.add(storageLocation2);
        StorageLocation storageLocation3 = new StorageLocation(localStorageFolder3, 15000000000L, null);
        storageLocations.add(storageLocation3);
        MostAvailableSizeStorageLocationSelectorStrategy mostAvailableStrategy = new MostAvailableSizeStorageLocationSelectorStrategy(storageLocations);
        Iterator locations = mostAvailableStrategy.getLocations();
        StorageLocation loc1 = (StorageLocation)locations.next();
        Assert.assertEquals((String)"The next element of the iterator should point to path local_storage_folder_2", (Object)localStorageFolder2, (Object)loc1.getPath());
        StorageLocation loc2 = (StorageLocation)locations.next();
        Assert.assertEquals((String)"The next element of the iterator should point to path local_storage_folder_3", (Object)localStorageFolder3, (Object)loc2.getPath());
        StorageLocation loc3 = (StorageLocation)locations.next();
        Assert.assertEquals((String)"The next element of the iterator should point to path local_storage_folder_1", (Object)localStorageFolder1, (Object)loc3.getPath());
        storageLocation2.reserve("tmp_loc2", "__seg2", 6000000000L);
        locations = mostAvailableStrategy.getLocations();
        loc1 = (StorageLocation)locations.next();
        Assert.assertEquals((String)"The next element of the iterator should point to path local_storage_folder_3", (Object)localStorageFolder3, (Object)loc1.getPath());
        loc2 = (StorageLocation)locations.next();
        Assert.assertEquals((String)"The next element of the iterator should point to path local_storage_folder_2", (Object)localStorageFolder2, (Object)loc2.getPath());
        loc3 = (StorageLocation)locations.next();
        Assert.assertEquals((String)"The next element of the iterator should point to path local_storage_folder_1", (Object)localStorageFolder1, (Object)loc3.getPath());
    }

    @Test
    public void testDefaultSelectorStrategyConfig() {
        Properties props = new Properties();
        props.setProperty("druid.segmentCache.locations", "[{\"path\": \"/tmp/druid/indexCache\"}]");
        StorageLocationSelectorStrategy strategy = (StorageLocationSelectorStrategy)this.makeInjectorWithProperties(props).getInstance(StorageLocationSelectorStrategy.class);
        Assert.assertEquals(LeastBytesUsedStorageLocationSelectorStrategy.class, (Object)strategy.getClass());
        Assert.assertEquals((Object)"/tmp/druid/indexCache", (Object)((StorageLocation)strategy.getLocations().next()).getPath().getAbsolutePath());
    }

    @Test
    public void testRoundRobinSelectorStrategyConfig() {
        Properties props = new Properties();
        props.setProperty("druid.segmentCache.locations", "[{\"path\": \"/tmp/druid/indexCache\"}]");
        props.setProperty("druid.segmentCache.locationSelector.strategy", "roundRobin");
        Injector injector = this.makeInjectorWithProperties(props);
        StorageLocationSelectorStrategy strategy = (StorageLocationSelectorStrategy)injector.getInstance(StorageLocationSelectorStrategy.class);
        Assert.assertEquals(RoundRobinStorageLocationSelectorStrategy.class, (Object)strategy.getClass());
        Assert.assertEquals((Object)"/tmp/druid/indexCache", (Object)((StorageLocation)strategy.getLocations().next()).getPath().getAbsolutePath());
    }

    @Test
    public void testLeastBytesUsedSelectorStrategyConfig() {
        Properties props = new Properties();
        props.setProperty("druid.segmentCache.locations", "[{\"path\": \"/tmp/druid/indexCache\"}]");
        props.setProperty("druid.segmentCache.locationSelector.strategy", "leastBytesUsed");
        Injector injector = this.makeInjectorWithProperties(props);
        StorageLocationSelectorStrategy strategy = (StorageLocationSelectorStrategy)injector.getInstance(StorageLocationSelectorStrategy.class);
        Assert.assertEquals(LeastBytesUsedStorageLocationSelectorStrategy.class, (Object)strategy.getClass());
        Assert.assertEquals((Object)"/tmp/druid/indexCache", (Object)((StorageLocation)strategy.getLocations().next()).getPath().getAbsolutePath());
    }

    @Test
    public void testRandomSelectorStrategyConfig() {
        Properties props = new Properties();
        props.setProperty("druid.segmentCache.locations", "[{\"path\": \"/tmp/druid/indexCache\"}]");
        props.setProperty("druid.segmentCache.locationSelector.strategy", "random");
        Injector injector = this.makeInjectorWithProperties(props);
        StorageLocationSelectorStrategy strategy = (StorageLocationSelectorStrategy)injector.getInstance(StorageLocationSelectorStrategy.class);
        Assert.assertEquals(RandomStorageLocationSelectorStrategy.class, (Object)strategy.getClass());
        Assert.assertEquals((Object)"/tmp/druid/indexCache", (Object)((StorageLocation)strategy.getLocations().next()).getPath().getAbsolutePath());
    }

    @Test
    public void testMostAvailableSizeSelectorStrategyConfig() {
        Properties props = new Properties();
        props.setProperty("druid.segmentCache.locationSelector.strategy", "mostAvailableSize");
        props.setProperty("druid.segmentCache.locations", "[{\"path\": \"/tmp/druid/indexCache\"}]");
        Injector injector = this.makeInjectorWithProperties(props);
        StorageLocationSelectorStrategy strategy = (StorageLocationSelectorStrategy)injector.getInstance(StorageLocationSelectorStrategy.class);
        Assert.assertEquals(MostAvailableSizeStorageLocationSelectorStrategy.class, (Object)strategy.getClass());
        Assert.assertEquals((Object)"/tmp/druid/indexCache", (Object)((StorageLocation)strategy.getLocations().next()).getPath().getAbsolutePath());
    }

    private Injector makeInjectorWithProperties(final Properties props) {
        return Guice.createInjector((Module[])new Module[]{new Module(){

            public void configure(Binder binder) {
                binder.install((Module)new ObjectMapperModule().withObjectMapper((ObjectMapper)new DefaultObjectMapper()));
                binder.install((Module)new DruidGuiceExtensions());
                binder.bind(Validator.class).toInstance((Object)Validation.buildDefaultValidatorFactory().getValidator());
                binder.bind(JsonConfigurator.class).in(LazySingleton.class);
                binder.bind(Properties.class).toInstance((Object)props);
                JsonConfigProvider.bind((Binder)binder, (String)"druid.segmentCache", SegmentLoaderConfig.class);
                StorageNodeModule.bindLocationSelectorStrategy((Binder)binder);
            }

            @Provides
            public List provideStorageLocation(SegmentLoaderConfig segmentLoader) {
                return segmentLoader.toStorageLocations();
            }
        }});
    }
}

