/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.realtime.appenderator;

import java.io.File;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.incremental.AppendableIndexSpec;
import org.apache.druid.segment.realtime.appenderator.AppenderatorConfig;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.joda.time.Period;

public class TestAppenderatorConfig
implements AppenderatorConfig {
    private final AppendableIndexSpec appendableIndexSpec;
    private final int maxRowsInMemory;
    private final long maxBytesInMemory;
    private final boolean skipBytesInMemoryOverheadCheck;
    private final int maxColumnsToMerge;
    private final PartitionsSpec partitionsSpec;
    private final IndexSpec indexSpec;
    private final File basePersistDirectory;
    private final int maxPendingPersists;
    private final boolean reportParseExceptions;
    private final long pushTimeout;
    private final IndexSpec indexSpecForIntermediatePersists;
    @Nullable
    private final SegmentWriteOutMediumFactory segmentWriteOutMediumFactory;

    public TestAppenderatorConfig(AppendableIndexSpec appendableIndexSpec, Integer maxRowsInMemory, Long maxBytesInMemory, Boolean skipBytesInMemoryOverheadCheck, IndexSpec indexSpec, Integer maxPendingPersists, Boolean reportParseExceptions, Long pushTimeout, @Nullable SegmentWriteOutMediumFactory segmentWriteOutMediumFactory, Integer maxColumnsToMerge, File basePersistDirectory) {
        this.appendableIndexSpec = appendableIndexSpec;
        this.maxRowsInMemory = maxRowsInMemory;
        this.maxBytesInMemory = maxBytesInMemory;
        this.skipBytesInMemoryOverheadCheck = skipBytesInMemoryOverheadCheck;
        this.indexSpec = indexSpec;
        this.maxPendingPersists = maxPendingPersists;
        this.reportParseExceptions = reportParseExceptions;
        this.pushTimeout = pushTimeout;
        this.segmentWriteOutMediumFactory = segmentWriteOutMediumFactory;
        this.maxColumnsToMerge = maxColumnsToMerge;
        this.basePersistDirectory = basePersistDirectory;
        this.partitionsSpec = null;
        this.indexSpecForIntermediatePersists = this.indexSpec;
    }

    public TestAppenderatorConfig withBasePersistDirectory(File dir) {
        throw new UnsupportedOperationException();
    }

    public AppendableIndexSpec getAppendableIndexSpec() {
        return this.appendableIndexSpec;
    }

    public int getMaxRowsInMemory() {
        return this.maxRowsInMemory;
    }

    public long getMaxBytesInMemory() {
        return this.maxBytesInMemory;
    }

    public boolean isSkipBytesInMemoryOverheadCheck() {
        return this.skipBytesInMemoryOverheadCheck;
    }

    @Nullable
    public PartitionsSpec getPartitionsSpec() {
        return this.partitionsSpec;
    }

    public IndexSpec getIndexSpec() {
        return this.indexSpec;
    }

    public IndexSpec getIndexSpecForIntermediatePersists() {
        return this.indexSpecForIntermediatePersists;
    }

    public int getMaxPendingPersists() {
        return this.maxPendingPersists;
    }

    public boolean isReportParseExceptions() {
        return this.reportParseExceptions;
    }

    @Nullable
    public SegmentWriteOutMediumFactory getSegmentWriteOutMediumFactory() {
        return this.segmentWriteOutMediumFactory;
    }

    public int getMaxColumnsToMerge() {
        return this.maxColumnsToMerge;
    }

    public File getBasePersistDirectory() {
        return this.basePersistDirectory;
    }

    public Period getIntermediatePersistPeriod() {
        return new Period(Integer.MAX_VALUE);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestAppenderatorConfig that = (TestAppenderatorConfig)o;
        return Objects.equals(this.appendableIndexSpec, that.appendableIndexSpec) && this.maxRowsInMemory == that.maxRowsInMemory && this.maxBytesInMemory == that.maxBytesInMemory && this.skipBytesInMemoryOverheadCheck == that.skipBytesInMemoryOverheadCheck && this.maxColumnsToMerge == that.maxColumnsToMerge && this.maxPendingPersists == that.maxPendingPersists && this.reportParseExceptions == that.reportParseExceptions && this.pushTimeout == that.pushTimeout && Objects.equals(this.partitionsSpec, that.partitionsSpec) && Objects.equals(this.indexSpec, that.indexSpec) && Objects.equals(this.indexSpecForIntermediatePersists, that.indexSpecForIntermediatePersists) && Objects.equals(this.basePersistDirectory, that.basePersistDirectory) && Objects.equals(this.segmentWriteOutMediumFactory, that.segmentWriteOutMediumFactory);
    }

    public int hashCode() {
        return Objects.hash(this.appendableIndexSpec, this.maxRowsInMemory, this.maxBytesInMemory, this.skipBytesInMemoryOverheadCheck, this.maxColumnsToMerge, this.partitionsSpec, this.indexSpec, this.indexSpecForIntermediatePersists, this.basePersistDirectory, this.maxPendingPersists, this.reportParseExceptions, this.pushTimeout, this.segmentWriteOutMediumFactory);
    }

    public String toString() {
        return "TestAppenderatorConfig{maxRowsInMemory=" + this.maxRowsInMemory + ", maxBytesInMemory=" + this.maxBytesInMemory + ", skipBytesInMemoryOverheadCheck=" + this.skipBytesInMemoryOverheadCheck + ", maxColumnsToMerge=" + this.maxColumnsToMerge + ", partitionsSpec=" + this.partitionsSpec + ", indexSpec=" + this.indexSpec + ", indexSpecForIntermediatePersists=" + this.indexSpecForIntermediatePersists + ", basePersistDirectory=" + this.basePersistDirectory + ", maxPendingPersists=" + this.maxPendingPersists + ", reportParseExceptions=" + this.reportParseExceptions + ", pushTimeout=" + this.pushTimeout + ", segmentWriteOutMediumFactory=" + this.segmentWriteOutMediumFactory + '}';
    }
}

