/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server;

import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import org.apache.druid.java.util.common.HumanReadableBytes;
import org.apache.druid.query.lookup.LookupExtractor;
import org.apache.druid.query.lookup.LookupExtractorFactory;
import org.apache.druid.query.lookup.LookupExtractorFactoryContainer;
import org.apache.druid.query.lookup.LookupExtractorFactoryContainerProvider;
import org.apache.druid.server.SubqueryGuardrailHelper;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class SubqueryGuardrailHelperTest {
    @Test
    public void testConvertSubqueryLimitStringToLongWithoutLookups() {
        Assert.assertEquals((long)10737418L, (long)this.fetchSubqueryLimitUtilsForNoLookups(SubqueryGuardrailHelperTest.humanReadableSizeToBytes("512MiB"), 25).convertSubqueryLimitStringToLong("auto"));
        Assert.assertEquals((long)0xCCCCCCL, (long)this.fetchSubqueryLimitUtilsForNoLookups(SubqueryGuardrailHelperTest.humanReadableSizeToBytes("640MiB"), 25).convertSubqueryLimitStringToLong("auto"));
        Assert.assertEquals((long)16106127L, (long)this.fetchSubqueryLimitUtilsForNoLookups(SubqueryGuardrailHelperTest.humanReadableSizeToBytes("768MiB"), 25).convertSubqueryLimitStringToLong("auto"));
        Assert.assertEquals((long)21474836L, (long)this.fetchSubqueryLimitUtilsForNoLookups(SubqueryGuardrailHelperTest.humanReadableSizeToBytes("1GiB"), 25).convertSubqueryLimitStringToLong("auto"));
        Assert.assertEquals((long)171798691L, (long)this.fetchSubqueryLimitUtilsForNoLookups(SubqueryGuardrailHelperTest.humanReadableSizeToBytes("8GiB"), 25).convertSubqueryLimitStringToLong("auto"));
        Assert.assertEquals((long)0x19999999L, (long)this.fetchSubqueryLimitUtilsForNoLookups(SubqueryGuardrailHelperTest.humanReadableSizeToBytes("20GiB"), 25).convertSubqueryLimitStringToLong("auto"));
    }

    @Test
    public void testConvertSubqueryLimitStringToLongWithLookups() {
        Assert.assertEquals((long)10527703L, (long)this.fetchSubqueryLimitUtilsForLookups(SubqueryGuardrailHelperTest.humanReadableSizeToBytes("512MiB"), 25).convertSubqueryLimitStringToLong("auto"));
        Assert.assertEquals((long)0xC99999L, (long)this.fetchSubqueryLimitUtilsForLookups(SubqueryGuardrailHelperTest.humanReadableSizeToBytes("640MiB"), 25).convertSubqueryLimitStringToLong("auto"));
        Assert.assertEquals((long)15896412L, (long)this.fetchSubqueryLimitUtilsForLookups(SubqueryGuardrailHelperTest.humanReadableSizeToBytes("768MiB"), 25).convertSubqueryLimitStringToLong("auto"));
        Assert.assertEquals((long)21265121L, (long)this.fetchSubqueryLimitUtilsForLookups(SubqueryGuardrailHelperTest.humanReadableSizeToBytes("1GiB"), 25).convertSubqueryLimitStringToLong("auto"));
        Assert.assertEquals((long)171588976L, (long)this.fetchSubqueryLimitUtilsForLookups(SubqueryGuardrailHelperTest.humanReadableSizeToBytes("8GiB"), 25).convertSubqueryLimitStringToLong("auto"));
        Assert.assertEquals((long)0x19966666L, (long)this.fetchSubqueryLimitUtilsForLookups(SubqueryGuardrailHelperTest.humanReadableSizeToBytes("20GiB"), 25).convertSubqueryLimitStringToLong("auto"));
    }

    private SubqueryGuardrailHelper fetchSubqueryLimitUtilsForNoLookups(long maxMemoryInJvm, int brokerNumHttpConnections) {
        return new SubqueryGuardrailHelper(null, maxMemoryInJvm, brokerNumHttpConnections);
    }

    private SubqueryGuardrailHelper fetchSubqueryLimitUtilsForLookups(long maxMemoryInJvm, int brokerNumHttpConnections) {
        return new SubqueryGuardrailHelper(SubqueryGuardrailHelperTest.lookupManager(), maxMemoryInJvm, brokerNumHttpConnections);
    }

    private static long humanReadableSizeToBytes(String humanReadableSize) {
        return new HumanReadableBytes(humanReadableSize).getBytes();
    }

    public static LookupExtractorFactoryContainerProvider lookupManager() {
        LookupExtractorFactoryContainerProvider lookupManager = (LookupExtractorFactoryContainerProvider)EasyMock.mock(LookupExtractorFactoryContainerProvider.class);
        EasyMock.expect((Object)lookupManager.getAllLookupNames()).andReturn((Object)ImmutableSet.of((Object)"lookupFoo", (Object)"lookupBar")).anyTimes();
        LookupExtractorFactoryContainer lookupFooContainer = (LookupExtractorFactoryContainer)EasyMock.mock(LookupExtractorFactoryContainer.class);
        EasyMock.expect((Object)lookupManager.get("lookupFoo")).andReturn(Optional.of(lookupFooContainer));
        LookupExtractorFactory lookupFooExtractorFactory = (LookupExtractorFactory)EasyMock.mock(LookupExtractorFactory.class);
        EasyMock.expect((Object)lookupFooContainer.getLookupExtractorFactory()).andReturn((Object)lookupFooExtractorFactory);
        LookupExtractor lookupFooExtractor = (LookupExtractor)EasyMock.mock(LookupExtractor.class);
        EasyMock.expect((Object)((LookupExtractor)lookupFooExtractorFactory.get())).andReturn((Object)lookupFooExtractor);
        EasyMock.expect((Object)lookupFooExtractor.estimateHeapFootprint()).andReturn((Object)SubqueryGuardrailHelperTest.humanReadableSizeToBytes("10MiB"));
        EasyMock.expect((Object)lookupManager.get("lookupBar")).andReturn(Optional.empty());
        EasyMock.replay((Object[])new Object[]{lookupManager, lookupFooContainer, lookupFooExtractor, lookupFooExtractorFactory});
        return lookupManager;
    }
}

