/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.duty;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.druid.client.DataSourcesSnapshot;
import org.apache.druid.client.indexing.ClientCompactionIOConfig;
import org.apache.druid.client.indexing.ClientCompactionIntervalSpec;
import org.apache.druid.client.indexing.ClientCompactionTaskGranularitySpec;
import org.apache.druid.client.indexing.ClientCompactionTaskQuery;
import org.apache.druid.client.indexing.ClientCompactionTaskQueryTuningConfig;
import org.apache.druid.client.indexing.ClientTaskQuery;
import org.apache.druid.client.indexing.IndexingTotalWorkerCapacityInfo;
import org.apache.druid.client.indexing.NoopOverlordClient;
import org.apache.druid.client.indexing.TaskPayloadResponse;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.indexer.CompactionEngine;
import org.apache.druid.indexer.RunnerTaskState;
import org.apache.druid.indexer.TaskLocation;
import org.apache.druid.indexer.TaskState;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexer.TaskStatusPlus;
import org.apache.druid.indexer.partitions.DynamicPartitionsSpec;
import org.apache.druid.indexer.partitions.HashedPartitionsSpec;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.indexer.partitions.SingleDimensionPartitionsSpec;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.CloseableIterators;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.JodaUtils;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.metadata.LockFilterPolicy;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.rpc.indexing.OverlordClient;
import org.apache.druid.segment.incremental.OnheapIncrementalIndex;
import org.apache.druid.segment.transform.TransformSpec;
import org.apache.druid.server.compaction.CompactionStatusTracker;
import org.apache.druid.server.coordinator.AutoCompactionSnapshot;
import org.apache.druid.server.coordinator.DataSourceCompactionConfig;
import org.apache.druid.server.coordinator.DruidCompactionConfig;
import org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.druid.server.coordinator.UserCompactionTaskDimensionsConfig;
import org.apache.druid.server.coordinator.UserCompactionTaskGranularityConfig;
import org.apache.druid.server.coordinator.UserCompactionTaskIOConfig;
import org.apache.druid.server.coordinator.UserCompactionTaskQueryTuningConfig;
import org.apache.druid.server.coordinator.UserCompactionTaskTransformConfig;
import org.apache.druid.server.coordinator.config.DruidCoordinatorConfig;
import org.apache.druid.server.coordinator.duty.CompactSegments;
import org.apache.druid.server.coordinator.stats.CoordinatorRunStats;
import org.apache.druid.server.coordinator.stats.Stats;
import org.apache.druid.timeline.CompactionState;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentTimeline;
import org.apache.druid.timeline.TimelineObjectHolder;
import org.apache.druid.timeline.partition.HashBasedNumberedShardSpec;
import org.apache.druid.timeline.partition.NumberedShardSpec;
import org.apache.druid.timeline.partition.PartitionChunk;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.druid.timeline.partition.SingleDimensionShardSpec;
import org.apache.druid.utils.Streams;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class CompactSegmentsTest {
    private static final ObjectMapper JSON_MAPPER = new DefaultObjectMapper();
    private static final DruidCoordinatorConfig COORDINATOR_CONFIG = (DruidCoordinatorConfig)Mockito.mock(DruidCoordinatorConfig.class);
    private static final String DATA_SOURCE_PREFIX = "dataSource_";
    private static final int PARTITION_PER_TIME_INTERVAL = 4;
    private static final int TOTAL_BYTE_PER_DATASOURCE = 440;
    private static final int TOTAL_SEGMENT_PER_DATASOURCE = 44;
    private static final int TOTAL_INTERVAL_PER_DATASOURCE = 11;
    private static final int MAXIMUM_CAPACITY_WITH_AUTO_SCALE = 10;
    private final PartitionsSpec partitionsSpec;
    private final BiFunction<Integer, Integer, ShardSpec> shardSpecFactory;
    private final CompactionEngine engine;
    private DataSourcesSnapshot dataSources;
    private CompactionStatusTracker statusTracker;
    Map<String, List<DataSegment>> datasourceToSegments = new HashMap<String, List<DataSegment>>();

    @Parameterized.Parameters(name="scenario: {0}, engine: {2}")
    public static Collection<Object[]> constructorFeeder() {
        MutableInt nextRangePartitionBoundary = new MutableInt(0);
        DynamicPartitionsSpec dynamicPartitionsSpec = new DynamicPartitionsSpec(Integer.valueOf(300000), Long.valueOf(Long.MAX_VALUE));
        BiFunction<Integer, Integer, ShardSpec> numberedShardSpecCreator = NumberedShardSpec::new;
        HashedPartitionsSpec hashedPartitionsSpec = new HashedPartitionsSpec(null, Integer.valueOf(2), (List)ImmutableList.of((Object)"dim"));
        BiFunction<Integer, Integer, ShardSpec> hashBasedNumberedShardSpecCreator = (bucketId, numBuckets) -> new HashBasedNumberedShardSpec(bucketId.intValue(), numBuckets.intValue(), bucketId, numBuckets, (List)ImmutableList.of((Object)"dim"), null, JSON_MAPPER);
        SingleDimensionPartitionsSpec singleDimensionPartitionsSpec = new SingleDimensionPartitionsSpec(Integer.valueOf(300000), null, "dim", false);
        BiFunction<Integer, Integer, ShardSpec> singleDimensionShardSpecCreator = (bucketId, numBuckets) -> new SingleDimensionShardSpec("dim", bucketId == 0 ? null : String.valueOf(nextRangePartitionBoundary.getAndIncrement()), bucketId.equals(numBuckets) ? null : String.valueOf(nextRangePartitionBoundary.getAndIncrement()), bucketId.intValue(), numBuckets);
        return ImmutableList.of((Object)new Object[]{dynamicPartitionsSpec, numberedShardSpecCreator, CompactionEngine.NATIVE}, (Object)new Object[]{hashedPartitionsSpec, hashBasedNumberedShardSpecCreator, CompactionEngine.NATIVE}, (Object)new Object[]{singleDimensionPartitionsSpec, singleDimensionShardSpecCreator, CompactionEngine.NATIVE}, (Object)new Object[]{dynamicPartitionsSpec, numberedShardSpecCreator, CompactionEngine.MSQ}, (Object)new Object[]{singleDimensionPartitionsSpec, singleDimensionShardSpecCreator, CompactionEngine.MSQ});
    }

    public CompactSegmentsTest(PartitionsSpec partitionsSpec, BiFunction<Integer, Integer, ShardSpec> shardSpecFactory, CompactionEngine engine) {
        this.partitionsSpec = partitionsSpec;
        this.shardSpecFactory = shardSpecFactory;
        this.engine = engine;
    }

    @Before
    public void setup() {
        ArrayList<DataSegment> allSegments = new ArrayList<DataSegment>();
        for (int i = 0; i < 3; ++i) {
            String dataSource = DATA_SOURCE_PREFIX + i;
            for (int j : new int[]{0, 1, 2, 3, 7, 8}) {
                for (int k = 0; k < 4; ++k) {
                    List segmentForDatasource = this.datasourceToSegments.computeIfAbsent(dataSource, key -> new ArrayList());
                    DataSegment dataSegment = this.createSegment(dataSource, j, true, k);
                    allSegments.add(dataSegment);
                    segmentForDatasource.add(dataSegment);
                    dataSegment = this.createSegment(dataSource, j, false, k);
                    allSegments.add(dataSegment);
                    segmentForDatasource.add(dataSegment);
                }
            }
        }
        this.dataSources = DataSourcesSnapshot.fromUsedSegments(allSegments, (ImmutableMap)ImmutableMap.of());
        this.statusTracker = new CompactionStatusTracker(JSON_MAPPER);
    }

    private DataSegment createSegment(String dataSource, int startDay, boolean beforeNoon, int partition) {
        ShardSpec shardSpec = this.shardSpecFactory.apply(partition, 2);
        Interval interval = beforeNoon ? Intervals.of((String)StringUtils.format((String)"2017-01-%02dT00:00:00/2017-01-%02dT12:00:00", (Object[])new Object[]{startDay + 1, startDay + 1})) : Intervals.of((String)StringUtils.format((String)"2017-01-%02dT12:00:00/2017-01-%02dT00:00:00", (Object[])new Object[]{startDay + 1, startDay + 2}));
        return new DataSegment(dataSource, interval, "version", null, Collections.emptyList(), Collections.emptyList(), shardSpec, Integer.valueOf(0), 10L);
    }

    @Test
    public void testSerde() throws Exception {
        TestOverlordClient overlordClient = new TestOverlordClient(JSON_MAPPER);
        JSON_MAPPER.setInjectableValues((InjectableValues)new InjectableValues.Std().addValue(DruidCoordinatorConfig.class, (Object)COORDINATOR_CONFIG).addValue(OverlordClient.class, (Object)overlordClient).addValue(CompactionStatusTracker.class, (Object)this.statusTracker));
        CompactSegments compactSegments = new CompactSegments(this.statusTracker, (OverlordClient)overlordClient);
        String compactSegmentString = JSON_MAPPER.writeValueAsString((Object)compactSegments);
        CompactSegments serdeCompactSegments = (CompactSegments)JSON_MAPPER.readValue(compactSegmentString, CompactSegments.class);
        Assert.assertNotNull((Object)serdeCompactSegments);
        Assert.assertSame((Object)overlordClient, (Object)serdeCompactSegments.getOverlordClient());
    }

    @Test
    public void testRun() {
        TestOverlordClient overlordClient = new TestOverlordClient(JSON_MAPPER);
        CompactSegments compactSegments = new CompactSegments(this.statusTracker, (OverlordClient)overlordClient);
        Supplier<String> expectedVersionSupplier = new Supplier<String>(){
            private int i = 0;

            @Override
            public String get() {
                return "newVersion_" + this.i++;
            }
        };
        int expectedCompactTaskCount = 1;
        int expectedRemainingSegments = 400;
        this.assertCompactSegments(compactSegments, Intervals.of((String)"2017-01-%02dT00:00:00/2017-01-%02dT12:00:00", (Object[])new Object[]{9, 9}), expectedRemainingSegments, expectedCompactTaskCount, expectedVersionSupplier);
        this.assertCompactSegments(compactSegments, Intervals.of((String)"2017-01-%02dT12:00:00/2017-01-%02dT00:00:00", (Object[])new Object[]{8, 9}), expectedRemainingSegments -= 40, expectedCompactTaskCount, expectedVersionSupplier);
        this.assertCompactSegments(compactSegments, Intervals.of((String)"2017-01-%02dT00:00:00/2017-01-%02dT12:00:00", (Object[])new Object[]{8, 8}), expectedRemainingSegments -= 40, expectedCompactTaskCount, expectedVersionSupplier);
        this.assertCompactSegments(compactSegments, Intervals.of((String)"2017-01-%02dT12:00:00/2017-01-%02dT00:00:00", (Object[])new Object[]{4, 5}), expectedRemainingSegments -= 40, expectedCompactTaskCount, expectedVersionSupplier);
        for (int endDay = 4; endDay > 1; --endDay) {
            this.assertCompactSegments(compactSegments, Intervals.of((String)"2017-01-%02dT00:00:00/2017-01-%02dT12:00:00", (Object[])new Object[]{endDay, endDay}), expectedRemainingSegments -= 40, expectedCompactTaskCount, expectedVersionSupplier);
            this.assertCompactSegments(compactSegments, Intervals.of((String)"2017-01-%02dT12:00:00/2017-01-%02dT00:00:00", (Object[])new Object[]{endDay - 1, endDay}), expectedRemainingSegments -= 40, expectedCompactTaskCount, expectedVersionSupplier);
        }
        this.assertLastSegmentNotCompacted(compactSegments);
    }

    @Test
    public void testMakeStats() {
        TestOverlordClient overlordClient = new TestOverlordClient(JSON_MAPPER);
        CompactSegments compactSegments = new CompactSegments(this.statusTracker, (OverlordClient)overlordClient);
        Map autoCompactionSnapshots = compactSegments.getAutoCompactionSnapshot();
        Assert.assertEquals((long)0L, (long)autoCompactionSnapshots.size());
        for (int compactionRunCount = 0; compactionRunCount < 11; ++compactionRunCount) {
            this.doCompactionAndAssertCompactSegmentStatistics(compactSegments, compactionRunCount);
        }
        CoordinatorRunStats stats = this.doCompactSegments(compactSegments);
        Assert.assertEquals((long)0L, (long)stats.get(Stats.Compaction.SUBMITTED_TASKS));
        for (int i = 0; i < 3; ++i) {
            this.verifySnapshot(compactSegments, AutoCompactionSnapshot.AutoCompactionScheduleStatus.RUNNING, DATA_SOURCE_PREFIX + i, 0L, 440L, 40L, 0L, 11L, 1L, 0L, 22L, 4L);
        }
        List<DataSourceCompactionConfig> removedOneConfig = this.createCompactionConfigs();
        removedOneConfig.remove(0);
        this.doCompactSegments(compactSegments, removedOneConfig);
        for (int i = 1; i < 3; ++i) {
            this.verifySnapshot(compactSegments, AutoCompactionSnapshot.AutoCompactionScheduleStatus.RUNNING, DATA_SOURCE_PREFIX + i, 0L, 440L, 40L, 0L, 11L, 1L, 0L, 22L, 4L);
        }
        this.doCompactSegments(compactSegments, new ArrayList<DataSourceCompactionConfig>());
        Assert.assertEquals((long)0L, (long)stats.get(Stats.Compaction.SUBMITTED_TASKS));
        Assert.assertTrue((boolean)compactSegments.getAutoCompactionSnapshot().isEmpty());
        this.assertLastSegmentNotCompacted(compactSegments);
    }

    @Test
    public void testMakeStatsForDataSourceWithCompactedIntervalBetweenNonCompactedIntervals() {
        String dataSourceName = "dataSource_1";
        ArrayList<DataSegment> segments = new ArrayList<DataSegment>();
        for (int j : new int[]{0, 1, 2, 3, 7, 8}) {
            for (int k = 0; k < 4; ++k) {
                DataSegment beforeNoon = this.createSegment(dataSourceName, j, true, k);
                DataSegment afterNoon = this.createSegment(dataSourceName, j, false, k);
                if (j == 3) {
                    beforeNoon = beforeNoon.withLastCompactionState(new CompactionState(this.partitionsSpec, null, null, null, (Map)ImmutableMap.of(), (Map)ImmutableMap.of()));
                    afterNoon = afterNoon.withLastCompactionState(new CompactionState(this.partitionsSpec, null, null, null, (Map)ImmutableMap.of(), (Map)ImmutableMap.of()));
                }
                if (j == 1) {
                    afterNoon = afterNoon.withLastCompactionState(new CompactionState(this.partitionsSpec, null, null, null, (Map)ImmutableMap.of(), (Map)ImmutableMap.of()));
                }
                segments.add(beforeNoon);
                segments.add(afterNoon);
            }
        }
        this.dataSources = DataSourcesSnapshot.fromUsedSegments(segments, (ImmutableMap)ImmutableMap.of());
        TestOverlordClient overlordClient = new TestOverlordClient(JSON_MAPPER);
        CompactSegments compactSegments = new CompactSegments(this.statusTracker, (OverlordClient)overlordClient);
        Map autoCompactionSnapshots = compactSegments.getAutoCompactionSnapshot();
        Assert.assertEquals((long)0L, (long)autoCompactionSnapshots.size());
        for (int compactionRunCount = 0; compactionRunCount < 8; ++compactionRunCount) {
            CoordinatorRunStats stats = this.doCompactSegments(compactSegments);
            Assert.assertEquals((long)1L, (long)stats.get(Stats.Compaction.SUBMITTED_TASKS));
            this.verifySnapshot(compactSegments, AutoCompactionSnapshot.AutoCompactionScheduleStatus.RUNNING, dataSourceName, 320 - 40 * (compactionRunCount + 1), 120 + 40 * (compactionRunCount + 1), 40L, 8 - (compactionRunCount + 1), 3 + (compactionRunCount + 1), 1L, 32 - 4 * (compactionRunCount + 1), 16 + 2 * compactionRunCount, 4L);
        }
        CoordinatorRunStats stats = this.doCompactSegments(compactSegments);
        Assert.assertEquals((long)0L, (long)stats.get(Stats.Compaction.SUBMITTED_TASKS));
        this.verifySnapshot(compactSegments, AutoCompactionSnapshot.AutoCompactionScheduleStatus.RUNNING, dataSourceName, 0L, 440L, 40L, 0L, 11L, 1L, 0L, 28L, 4L);
    }

    @Test
    public void testMakeStatsWithDeactivatedDatasource() {
        int i;
        TestOverlordClient overlordClient = new TestOverlordClient(JSON_MAPPER);
        CompactSegments compactSegments = new CompactSegments(this.statusTracker, (OverlordClient)overlordClient);
        Map autoCompactionSnapshots = compactSegments.getAutoCompactionSnapshot();
        Assert.assertEquals((long)0L, (long)autoCompactionSnapshots.size());
        for (int compactionRunCount = 0; compactionRunCount < 11; ++compactionRunCount) {
            this.doCompactionAndAssertCompactSegmentStatistics(compactSegments, compactionRunCount);
        }
        CoordinatorRunStats stats = this.doCompactSegments(compactSegments);
        Assert.assertEquals((long)0L, (long)stats.get(Stats.Compaction.SUBMITTED_TASKS));
        for (i = 0; i < 3; ++i) {
            this.verifySnapshot(compactSegments, AutoCompactionSnapshot.AutoCompactionScheduleStatus.RUNNING, DATA_SOURCE_PREFIX + i, 0L, 440L, 40L, 0L, 11L, 1L, 0L, 22L, 4L);
        }
        this.dataSources.getUsedSegmentsTimelinesPerDataSource().remove("dataSource_0");
        this.doCompactSegments(compactSegments);
        for (i = 1; i < 3; ++i) {
            this.verifySnapshot(compactSegments, AutoCompactionSnapshot.AutoCompactionScheduleStatus.RUNNING, DATA_SOURCE_PREFIX + i, 0L, 440L, 40L, 0L, 11L, 1L, 0L, 22L, 4L);
        }
        Assert.assertEquals((long)2L, (long)compactSegments.getAutoCompactionSnapshot().size());
        Assert.assertTrue((boolean)compactSegments.getAutoCompactionSnapshot().containsKey("dataSource_1"));
        Assert.assertTrue((boolean)compactSegments.getAutoCompactionSnapshot().containsKey("dataSource_2"));
        Assert.assertFalse((boolean)compactSegments.getAutoCompactionSnapshot().containsKey("dataSource_0"));
    }

    @Test
    public void testMakeStatsForDataSourceWithSkipped() {
        String dataSourceName = "dataSource_1";
        ArrayList<DataSegment> segments = new ArrayList<DataSegment>();
        for (int j : new int[]{0, 1, 2, 3, 7, 8}) {
            for (int k = 0; k < 4; ++k) {
                DataSegment beforeNoon = this.createSegment(dataSourceName, j, true, k);
                DataSegment afterNoon = this.createSegment(dataSourceName, j, false, k);
                if (j == 3) {
                    beforeNoon = beforeNoon.withSize(100L);
                    afterNoon = afterNoon.withSize(100L);
                }
                if (j == 1) {
                    afterNoon = afterNoon.withSize(100L);
                }
                segments.add(beforeNoon);
                segments.add(afterNoon);
            }
        }
        this.dataSources = DataSourcesSnapshot.fromUsedSegments(segments, (ImmutableMap)ImmutableMap.of());
        TestOverlordClient overlordClient = new TestOverlordClient(JSON_MAPPER);
        CompactSegments compactSegments = new CompactSegments(this.statusTracker, (OverlordClient)overlordClient);
        Map autoCompactionSnapshots = compactSegments.getAutoCompactionSnapshot();
        Assert.assertEquals((long)0L, (long)autoCompactionSnapshots.size());
        for (int compactionRunCount = 0; compactionRunCount < 8; ++compactionRunCount) {
            CoordinatorRunStats stats = this.doCompactSegments(compactSegments);
            Assert.assertEquals((long)1L, (long)stats.get(Stats.Compaction.SUBMITTED_TASKS));
            this.verifySnapshot(compactSegments, AutoCompactionSnapshot.AutoCompactionScheduleStatus.RUNNING, dataSourceName, 320 - 40 * (compactionRunCount + 1), 40 * (compactionRunCount + 1), 1240L, 8 - (compactionRunCount + 1), compactionRunCount + 1, 4L, 32 - 4 * (compactionRunCount + 1), 4 + 2 * compactionRunCount, 16L);
        }
        CoordinatorRunStats stats = this.doCompactSegments(compactSegments);
        Assert.assertEquals((long)0L, (long)stats.get(Stats.Compaction.SUBMITTED_TASKS));
        this.verifySnapshot(compactSegments, AutoCompactionSnapshot.AutoCompactionScheduleStatus.RUNNING, dataSourceName, 0L, 320L, 1240L, 0L, 8L, 4L, 0L, 16L, 16L);
    }

    @Test
    public void testRunMultipleCompactionTaskSlots() {
        TestOverlordClient overlordClient = new TestOverlordClient(JSON_MAPPER);
        CompactSegments compactSegments = new CompactSegments(this.statusTracker, (OverlordClient)overlordClient);
        CoordinatorRunStats stats = this.doCompactSegments(compactSegments, 3);
        Assert.assertEquals((long)3L, (long)stats.get(Stats.Compaction.AVAILABLE_SLOTS));
        Assert.assertEquals((long)3L, (long)stats.get(Stats.Compaction.MAX_SLOTS));
        if (this.engine == CompactionEngine.NATIVE) {
            Assert.assertEquals((long)3L, (long)stats.get(Stats.Compaction.SUBMITTED_TASKS));
        } else {
            Assert.assertEquals((long)1L, (long)stats.get(Stats.Compaction.SUBMITTED_TASKS));
        }
    }

    @Test
    public void testRunMultipleCompactionTaskSlotsWithUseAutoScaleSlotsOverMaxSlot() {
        int maxCompactionSlot = 3;
        Assert.assertTrue((maxCompactionSlot < 10 ? 1 : 0) != 0);
        TestOverlordClient overlordClient = new TestOverlordClient(JSON_MAPPER);
        CompactSegments compactSegments = new CompactSegments(this.statusTracker, (OverlordClient)overlordClient);
        CoordinatorRunStats stats = this.doCompactSegments(compactSegments, this.createCompactionConfigs(), maxCompactionSlot, true);
        Assert.assertEquals((long)maxCompactionSlot, (long)stats.get(Stats.Compaction.AVAILABLE_SLOTS));
        Assert.assertEquals((long)maxCompactionSlot, (long)stats.get(Stats.Compaction.MAX_SLOTS));
        if (this.engine == CompactionEngine.NATIVE) {
            Assert.assertEquals((long)maxCompactionSlot, (long)stats.get(Stats.Compaction.SUBMITTED_TASKS));
        } else {
            Assert.assertEquals((long)1L, (long)stats.get(Stats.Compaction.SUBMITTED_TASKS));
        }
    }

    @Test
    public void testRunMultipleCompactionTaskSlotsWithUseAutoScaleSlotsUnderMaxSlot() {
        int maxCompactionSlot = 100;
        Assert.assertFalse((maxCompactionSlot < 10 ? 1 : 0) != 0);
        TestOverlordClient overlordClient = new TestOverlordClient(JSON_MAPPER);
        CompactSegments compactSegments = new CompactSegments(this.statusTracker, (OverlordClient)overlordClient);
        CoordinatorRunStats stats = this.doCompactSegments(compactSegments, this.createCompactionConfigs(), maxCompactionSlot, true);
        Assert.assertEquals((long)10L, (long)stats.get(Stats.Compaction.AVAILABLE_SLOTS));
        Assert.assertEquals((long)10L, (long)stats.get(Stats.Compaction.MAX_SLOTS));
        if (this.engine == CompactionEngine.NATIVE) {
            Assert.assertEquals((long)10L, (long)stats.get(Stats.Compaction.SUBMITTED_TASKS));
        } else {
            Assert.assertEquals((long)2L, (long)stats.get(Stats.Compaction.SUBMITTED_TASKS));
        }
    }

    @Test
    public void testCompactWithoutGranularitySpec() {
        OverlordClient mockClient = (OverlordClient)Mockito.mock(OverlordClient.class);
        ArgumentCaptor<Object> payloadCaptor = CompactSegmentsTest.setUpMockClient(mockClient);
        CompactSegments compactSegments = new CompactSegments(this.statusTracker, mockClient);
        ArrayList<DataSourceCompactionConfig> compactionConfigs = new ArrayList<DataSourceCompactionConfig>();
        String dataSource = "dataSource_0";
        compactionConfigs.add(new DataSourceCompactionConfig("dataSource_0", Integer.valueOf(0), Long.valueOf(500L), null, new Period((Object)"PT0H"), new UserCompactionTaskQueryTuningConfig(null, null, null, null, null, this.partitionsSpec, null, null, null, null, null, Integer.valueOf(3), null, null, null, null, null, null, null), null, null, null, null, null, this.engine, null));
        this.doCompactSegments(compactSegments, compactionConfigs);
        ClientCompactionTaskQuery taskPayload = (ClientCompactionTaskQuery)payloadCaptor.getValue();
        Assert.assertEquals((Object)Intervals.of((String)"2017-01-09T12:00:00.000Z/2017-01-10T00:00:00.000Z"), (Object)taskPayload.getIoConfig().getInputSpec().getInterval());
        Assert.assertNull((Object)taskPayload.getGranularitySpec().getSegmentGranularity());
        Assert.assertNull((Object)taskPayload.getGranularitySpec().getQueryGranularity());
        Assert.assertNull((Object)taskPayload.getGranularitySpec().isRollup());
    }

    @Test
    public void testCompactWithNotNullIOConfig() {
        OverlordClient mockClient = (OverlordClient)Mockito.mock(OverlordClient.class);
        ArgumentCaptor<Object> payloadCaptor = CompactSegmentsTest.setUpMockClient(mockClient);
        CompactSegments compactSegments = new CompactSegments(this.statusTracker, mockClient);
        ArrayList<DataSourceCompactionConfig> compactionConfigs = new ArrayList<DataSourceCompactionConfig>();
        String dataSource = "dataSource_0";
        compactionConfigs.add(new DataSourceCompactionConfig("dataSource_0", Integer.valueOf(0), Long.valueOf(500L), null, new Period((Object)"PT0H"), new UserCompactionTaskQueryTuningConfig(null, null, null, null, null, this.partitionsSpec, null, null, null, null, null, Integer.valueOf(3), null, null, null, null, null, null, null), null, null, null, null, new UserCompactionTaskIOConfig(Boolean.valueOf(true)), this.engine, null));
        this.doCompactSegments(compactSegments, compactionConfigs);
        ClientCompactionTaskQuery taskPayload = (ClientCompactionTaskQuery)payloadCaptor.getValue();
        Assert.assertTrue((boolean)taskPayload.getIoConfig().isDropExisting());
    }

    @Test
    public void testCompactWithNullIOConfig() {
        OverlordClient mockClient = (OverlordClient)Mockito.mock(OverlordClient.class);
        ArgumentCaptor<Object> payloadCaptor = CompactSegmentsTest.setUpMockClient(mockClient);
        CompactSegments compactSegments = new CompactSegments(this.statusTracker, mockClient);
        ArrayList<DataSourceCompactionConfig> compactionConfigs = new ArrayList<DataSourceCompactionConfig>();
        String dataSource = "dataSource_0";
        compactionConfigs.add(new DataSourceCompactionConfig("dataSource_0", Integer.valueOf(0), Long.valueOf(500L), null, new Period((Object)"PT0H"), new UserCompactionTaskQueryTuningConfig(null, null, null, null, null, this.partitionsSpec, null, null, null, null, null, Integer.valueOf(3), null, null, null, null, null, null, null), null, null, null, null, null, this.engine, null));
        this.doCompactSegments(compactSegments, compactionConfigs);
        ClientCompactionTaskQuery taskPayload = (ClientCompactionTaskQuery)payloadCaptor.getValue();
        Assert.assertEquals((Object)false, (Object)taskPayload.getIoConfig().isDropExisting());
    }

    @Test
    public void testCompactWithGranularitySpec() {
        OverlordClient mockClient = (OverlordClient)Mockito.mock(OverlordClient.class);
        ArgumentCaptor<Object> payloadCaptor = CompactSegmentsTest.setUpMockClient(mockClient);
        CompactSegments compactSegments = new CompactSegments(this.statusTracker, mockClient);
        ArrayList<DataSourceCompactionConfig> compactionConfigs = new ArrayList<DataSourceCompactionConfig>();
        String dataSource = "dataSource_0";
        compactionConfigs.add(new DataSourceCompactionConfig("dataSource_0", Integer.valueOf(0), Long.valueOf(500L), null, new Period((Object)"PT0H"), new UserCompactionTaskQueryTuningConfig(null, null, null, null, null, this.partitionsSpec, null, null, null, null, null, Integer.valueOf(3), null, null, null, null, null, null, null), new UserCompactionTaskGranularityConfig(Granularities.YEAR, null, null), null, null, null, null, this.engine, null));
        this.doCompactSegments(compactSegments, compactionConfigs);
        ClientCompactionTaskQuery taskPayload = (ClientCompactionTaskQuery)payloadCaptor.getValue();
        Assert.assertEquals((Object)ClientCompactionIntervalSpec.fromSegments(this.datasourceToSegments.get("dataSource_0"), (Granularity)Granularities.YEAR), (Object)taskPayload.getIoConfig().getInputSpec());
        ClientCompactionTaskGranularitySpec expectedGranularitySpec = new ClientCompactionTaskGranularitySpec(Granularities.YEAR, null, null);
        Assert.assertEquals((Object)expectedGranularitySpec, (Object)taskPayload.getGranularitySpec());
    }

    @Test
    public void testCompactWithDimensionSpec() {
        OverlordClient mockClient = (OverlordClient)Mockito.mock(OverlordClient.class);
        ArgumentCaptor<Object> payloadCaptor = CompactSegmentsTest.setUpMockClient(mockClient);
        CompactSegments compactSegments = new CompactSegments(this.statusTracker, mockClient);
        ArrayList<DataSourceCompactionConfig> compactionConfigs = new ArrayList<DataSourceCompactionConfig>();
        String dataSource = "dataSource_0";
        compactionConfigs.add(new DataSourceCompactionConfig("dataSource_0", Integer.valueOf(0), Long.valueOf(500L), null, new Period((Object)"PT0H"), new UserCompactionTaskQueryTuningConfig(null, null, null, null, null, this.partitionsSpec, null, null, null, null, null, Integer.valueOf(3), null, null, null, null, null, null, null), null, new UserCompactionTaskDimensionsConfig(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"bar", (Object)"foo"))), null, null, null, this.engine, null));
        this.doCompactSegments(compactSegments, compactionConfigs);
        ClientCompactionTaskQuery taskPayload = (ClientCompactionTaskQuery)payloadCaptor.getValue();
        Assert.assertEquals((Object)DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"bar", (Object)"foo")), (Object)taskPayload.getDimensionsSpec().getDimensions());
    }

    @Test
    public void testCompactWithoutDimensionSpec() {
        OverlordClient mockClient = (OverlordClient)Mockito.mock(OverlordClient.class);
        ArgumentCaptor<Object> payloadCaptor = CompactSegmentsTest.setUpMockClient(mockClient);
        CompactSegments compactSegments = new CompactSegments(this.statusTracker, mockClient);
        ArrayList<DataSourceCompactionConfig> compactionConfigs = new ArrayList<DataSourceCompactionConfig>();
        String dataSource = "dataSource_0";
        compactionConfigs.add(new DataSourceCompactionConfig("dataSource_0", Integer.valueOf(0), Long.valueOf(500L), null, new Period((Object)"PT0H"), new UserCompactionTaskQueryTuningConfig(null, null, null, null, null, this.partitionsSpec, null, null, null, null, null, Integer.valueOf(3), null, null, null, null, null, null, null), null, null, null, null, null, this.engine, null));
        this.doCompactSegments(compactSegments, compactionConfigs);
        ClientCompactionTaskQuery taskPayload = (ClientCompactionTaskQuery)payloadCaptor.getValue();
        Assert.assertNull((Object)taskPayload.getDimensionsSpec());
    }

    @Test
    public void testCompactWithRollupInGranularitySpec() {
        OverlordClient mockClient = (OverlordClient)Mockito.mock(OverlordClient.class);
        ArgumentCaptor<Object> payloadCaptor = CompactSegmentsTest.setUpMockClient(mockClient);
        CompactSegments compactSegments = new CompactSegments(this.statusTracker, mockClient);
        ArrayList<DataSourceCompactionConfig> compactionConfigs = new ArrayList<DataSourceCompactionConfig>();
        String dataSource = "dataSource_0";
        compactionConfigs.add(new DataSourceCompactionConfig("dataSource_0", Integer.valueOf(0), Long.valueOf(500L), null, new Period((Object)"PT0H"), new UserCompactionTaskQueryTuningConfig(null, null, null, null, null, this.partitionsSpec, null, null, null, null, null, Integer.valueOf(3), null, null, null, null, null, null, null), new UserCompactionTaskGranularityConfig(Granularities.YEAR, null, Boolean.valueOf(true)), null, null, null, null, this.engine, null));
        this.doCompactSegments(compactSegments, compactionConfigs);
        ClientCompactionTaskQuery taskPayload = (ClientCompactionTaskQuery)payloadCaptor.getValue();
        Assert.assertEquals((Object)ClientCompactionIntervalSpec.fromSegments(this.datasourceToSegments.get("dataSource_0"), (Granularity)Granularities.YEAR), (Object)taskPayload.getIoConfig().getInputSpec());
        ClientCompactionTaskGranularitySpec expectedGranularitySpec = new ClientCompactionTaskGranularitySpec(Granularities.YEAR, null, Boolean.valueOf(true));
        Assert.assertEquals((Object)expectedGranularitySpec, (Object)taskPayload.getGranularitySpec());
    }

    @Test
    public void testCompactWithGranularitySpecConflictWithActiveCompactionTask() {
        String dataSource = "dataSource_0";
        String conflictTaskId = "taskIdDummy";
        TaskStatusPlus runningConflictCompactionTask = new TaskStatusPlus("taskIdDummy", "groupId", "compact", DateTimes.EPOCH, DateTimes.EPOCH, TaskState.RUNNING, RunnerTaskState.RUNNING, Long.valueOf(-1L), TaskLocation.unknown(), "dataSource_0", null);
        TaskPayloadResponse runningConflictCompactionTaskPayload = new TaskPayloadResponse("taskIdDummy", (ClientTaskQuery)new ClientCompactionTaskQuery("taskIdDummy", "dataSource_0", new ClientCompactionIOConfig(new ClientCompactionIntervalSpec(Intervals.of((String)"2000/2099"), "testSha256OfSortedSegmentIds"), null), null, new ClientCompactionTaskGranularitySpec(Granularities.DAY, null, null), null, null, null, null, null));
        OverlordClient mockClient = (OverlordClient)Mockito.mock(OverlordClient.class);
        ArgumentCaptor payloadCaptor = ArgumentCaptor.forClass(Object.class);
        Mockito.when((Object)mockClient.runTask(ArgumentMatchers.anyString(), payloadCaptor.capture())).thenReturn((Object)Futures.immediateFuture(null));
        Mockito.when((Object)mockClient.taskStatuses(null, null, Integer.valueOf(0))).thenReturn((Object)Futures.immediateFuture((Object)CloseableIterators.withEmptyBaggage((Iterator)ImmutableList.of((Object)runningConflictCompactionTask).iterator())));
        Mockito.when((Object)mockClient.taskStatuses((Set)ArgumentMatchers.any())).thenReturn((Object)Futures.immediateFuture(Collections.emptyMap()));
        Mockito.when((Object)mockClient.findLockedIntervals((List)ArgumentMatchers.any())).thenReturn((Object)Futures.immediateFuture(Collections.emptyMap()));
        Mockito.when((Object)mockClient.cancelTask("taskIdDummy")).thenReturn((Object)Futures.immediateFuture(null));
        Mockito.when((Object)mockClient.getTotalWorkerCapacity()).thenReturn((Object)Futures.immediateFuture((Object)new IndexingTotalWorkerCapacityInfo(0, 0)));
        Mockito.when((Object)mockClient.taskPayload((String)ArgumentMatchers.eq((Object)"taskIdDummy"))).thenReturn((Object)Futures.immediateFuture((Object)runningConflictCompactionTaskPayload));
        CompactSegments compactSegments = new CompactSegments(this.statusTracker, mockClient);
        ArrayList<DataSourceCompactionConfig> compactionConfigs = new ArrayList<DataSourceCompactionConfig>();
        compactionConfigs.add(new DataSourceCompactionConfig("dataSource_0", Integer.valueOf(0), Long.valueOf(500L), null, new Period((Object)"PT0H"), new UserCompactionTaskQueryTuningConfig(null, null, null, null, null, this.partitionsSpec, null, null, null, null, null, Integer.valueOf(3), null, null, null, null, null, null, null), new UserCompactionTaskGranularityConfig(Granularities.YEAR, null, null), null, null, null, null, this.engine, null));
        this.doCompactSegments(compactSegments, compactionConfigs);
        ((OverlordClient)Mockito.verify((Object)mockClient)).cancelTask("taskIdDummy");
        ClientCompactionTaskQuery taskPayload = (ClientCompactionTaskQuery)payloadCaptor.getValue();
        Assert.assertEquals((Object)ClientCompactionIntervalSpec.fromSegments(this.datasourceToSegments.get("dataSource_0"), (Granularity)Granularities.YEAR), (Object)taskPayload.getIoConfig().getInputSpec());
        ClientCompactionTaskGranularitySpec expectedGranularitySpec = new ClientCompactionTaskGranularitySpec(Granularities.YEAR, null, null);
        Assert.assertEquals((Object)expectedGranularitySpec, (Object)taskPayload.getGranularitySpec());
    }

    @Test
    public void testIntervalIsCompactedAgainWhenSegmentIsAdded() {
        TestOverlordClient overlordClient = new TestOverlordClient(JSON_MAPPER);
        CompactSegments compactSegments = new CompactSegments(this.statusTracker, (OverlordClient)overlordClient);
        String dataSource = "dataSource_0";
        DataSourceCompactionConfig compactionConfig = DataSourceCompactionConfig.builder().forDataSource("dataSource_0").withSkipOffsetFromLatest(Period.seconds((int)0)).withGranularitySpec(new UserCompactionTaskGranularityConfig(Granularities.DAY, null, null)).build();
        CoordinatorRunStats stats = this.doCompactSegments(compactSegments, (List<DataSourceCompactionConfig>)ImmutableList.of((Object)compactionConfig));
        Assert.assertEquals((long)1L, (long)stats.get(Stats.Compaction.SUBMITTED_TASKS));
        Assert.assertEquals((long)1L, (long)overlordClient.submittedCompactionTasks.size());
        ClientCompactionTaskQuery submittedTask = (ClientCompactionTaskQuery)overlordClient.submittedCompactionTasks.get(0);
        Assert.assertEquals((Object)submittedTask.getDataSource(), (Object)"dataSource_0");
        Assert.assertEquals((Object)Intervals.of((String)"2017-01-09/P1D"), (Object)submittedTask.getIoConfig().getInputSpec().getInterval());
        this.addMoreData("dataSource_0", 8);
        stats = this.doCompactSegments(compactSegments, (List<DataSourceCompactionConfig>)ImmutableList.of((Object)compactionConfig));
        Assert.assertEquals((long)1L, (long)stats.get(Stats.Compaction.SUBMITTED_TASKS));
        Assert.assertEquals((long)2L, (long)overlordClient.submittedCompactionTasks.size());
        submittedTask = (ClientCompactionTaskQuery)overlordClient.submittedCompactionTasks.get(1);
        Assert.assertEquals((Object)submittedTask.getDataSource(), (Object)"dataSource_0");
        Assert.assertEquals((Object)Intervals.of((String)"2017-01-09/P1D"), (Object)submittedTask.getIoConfig().getInputSpec().getInterval());
    }

    @Test
    public void testRunParallelCompactionMultipleCompactionTaskSlots() {
        TestOverlordClient overlordClient = new TestOverlordClient(JSON_MAPPER);
        CompactSegments compactSegments = new CompactSegments(this.statusTracker, (OverlordClient)overlordClient);
        CoordinatorRunStats stats = this.engine == CompactionEngine.NATIVE ? this.doCompactSegments(compactSegments, this.createcompactionConfigsForNative(2), 4) : this.doCompactSegments(compactSegments, this.createcompactionConfigsForMSQ(2), 4);
        Assert.assertEquals((long)4L, (long)stats.get(Stats.Compaction.AVAILABLE_SLOTS));
        Assert.assertEquals((long)4L, (long)stats.get(Stats.Compaction.MAX_SLOTS));
        Assert.assertEquals((long)2L, (long)stats.get(Stats.Compaction.SUBMITTED_TASKS));
    }

    @Test
    public void testRunWithLockedIntervals() {
        TestOverlordClient overlordClient = new TestOverlordClient(JSON_MAPPER);
        String datasource1 = "dataSource_1";
        overlordClient.lockedIntervals.computeIfAbsent("dataSource_1", k -> new ArrayList()).add(Intervals.of((String)"2017/2018"));
        String datasource2 = "dataSource_2";
        overlordClient.lockedIntervals.computeIfAbsent("dataSource_2", k -> new ArrayList()).add(Intervals.of((String)"2017/2018"));
        String datasource0 = "dataSource_0";
        overlordClient.lockedIntervals.computeIfAbsent("dataSource_0", k -> new ArrayList()).add(Intervals.of((String)"2017-01-01T13:00:00Z/2017-02-01"));
        CompactSegments compactSegments = new CompactSegments(this.statusTracker, (OverlordClient)overlordClient);
        CoordinatorRunStats stats = this.doCompactSegments(compactSegments, this.createcompactionConfigsForNative(2), 4);
        Assert.assertEquals((long)1L, (long)stats.get(Stats.Compaction.SUBMITTED_TASKS));
        Assert.assertEquals((long)1L, (long)overlordClient.submittedCompactionTasks.size());
        ClientCompactionTaskQuery compactionTask = (ClientCompactionTaskQuery)overlordClient.submittedCompactionTasks.get(0);
        Assert.assertEquals((Object)"dataSource_0", (Object)compactionTask.getDataSource());
        Assert.assertEquals((Object)Intervals.of((String)"2017-01-01T00:00:00/2017-01-01T12:00:00"), (Object)compactionTask.getIoConfig().getInputSpec().getInterval());
    }

    @Test
    public void testCompactWithTransformSpec() {
        NullHandling.initializeForTests();
        OverlordClient mockClient = (OverlordClient)Mockito.mock(OverlordClient.class);
        ArgumentCaptor<Object> payloadCaptor = CompactSegmentsTest.setUpMockClient(mockClient);
        CompactSegments compactSegments = new CompactSegments(this.statusTracker, mockClient);
        ArrayList<DataSourceCompactionConfig> compactionConfigs = new ArrayList<DataSourceCompactionConfig>();
        String dataSource = "dataSource_0";
        compactionConfigs.add(new DataSourceCompactionConfig("dataSource_0", Integer.valueOf(0), Long.valueOf(500L), null, new Period((Object)"PT0H"), new UserCompactionTaskQueryTuningConfig(null, null, null, null, null, this.partitionsSpec, null, null, null, null, null, Integer.valueOf(3), null, null, null, null, null, null, null), null, null, null, new UserCompactionTaskTransformConfig((DimFilter)new SelectorDimFilter("dim1", "foo", null)), null, this.engine, null));
        this.doCompactSegments(compactSegments, compactionConfigs);
        ClientCompactionTaskQuery taskPayload = (ClientCompactionTaskQuery)payloadCaptor.getValue();
        Assert.assertNotNull((Object)taskPayload.getTransformSpec());
        Assert.assertEquals((Object)new SelectorDimFilter("dim1", "foo", null), (Object)taskPayload.getTransformSpec().getFilter());
    }

    @Test
    public void testCompactWithoutCustomSpecs() {
        OverlordClient mockClient = (OverlordClient)Mockito.mock(OverlordClient.class);
        ArgumentCaptor<Object> payloadCaptor = CompactSegmentsTest.setUpMockClient(mockClient);
        CompactSegments compactSegments = new CompactSegments(this.statusTracker, mockClient);
        ArrayList<DataSourceCompactionConfig> compactionConfigs = new ArrayList<DataSourceCompactionConfig>();
        String dataSource = "dataSource_0";
        compactionConfigs.add(new DataSourceCompactionConfig("dataSource_0", Integer.valueOf(0), Long.valueOf(500L), null, new Period((Object)"PT0H"), new UserCompactionTaskQueryTuningConfig(null, null, null, null, null, this.partitionsSpec, null, null, null, null, null, Integer.valueOf(3), null, null, null, null, null, null, null), null, null, null, null, null, this.engine, null));
        this.doCompactSegments(compactSegments, compactionConfigs);
        ClientCompactionTaskQuery taskPayload = (ClientCompactionTaskQuery)payloadCaptor.getValue();
        Assert.assertNull((Object)taskPayload.getTransformSpec());
        Assert.assertNull((Object)taskPayload.getMetricsSpec());
    }

    @Test
    public void testCompactWithMetricsSpec() {
        NullHandling.initializeForTests();
        Object[] aggregatorFactories = new AggregatorFactory[]{new CountAggregatorFactory("cnt")};
        OverlordClient mockClient = (OverlordClient)Mockito.mock(OverlordClient.class);
        ArgumentCaptor<Object> payloadCaptor = CompactSegmentsTest.setUpMockClient(mockClient);
        CompactSegments compactSegments = new CompactSegments(this.statusTracker, mockClient);
        ArrayList<DataSourceCompactionConfig> compactionConfigs = new ArrayList<DataSourceCompactionConfig>();
        String dataSource = "dataSource_0";
        compactionConfigs.add(new DataSourceCompactionConfig("dataSource_0", Integer.valueOf(0), Long.valueOf(500L), null, new Period((Object)"PT0H"), new UserCompactionTaskQueryTuningConfig(null, null, null, null, null, this.partitionsSpec, null, null, null, null, null, Integer.valueOf(3), null, null, null, null, null, null, null), null, null, (AggregatorFactory[])aggregatorFactories, null, null, this.engine, null));
        this.doCompactSegments(compactSegments, compactionConfigs);
        ClientCompactionTaskQuery taskPayload = (ClientCompactionTaskQuery)payloadCaptor.getValue();
        Object[] actual = taskPayload.getMetricsSpec();
        Assert.assertNotNull((Object)actual);
        Assert.assertArrayEquals((Object[])aggregatorFactories, (Object[])actual);
    }

    @Test
    public void testDetermineSegmentGranularityFromSegmentsToCompact() {
        String dataSourceName = "dataSource_1";
        ArrayList<DataSegment> segments = new ArrayList<DataSegment>();
        segments.add(new DataSegment(dataSourceName, Intervals.of((String)"2017-01-01T00:00:00/2017-01-02T00:00:00"), "1", null, (List)ImmutableList.of(), (List)ImmutableList.of(), this.shardSpecFactory.apply(0, 2), Integer.valueOf(0), 10L));
        segments.add(new DataSegment(dataSourceName, Intervals.of((String)"2017-01-01T00:00:00/2017-01-02T00:00:00"), "1", null, (List)ImmutableList.of(), (List)ImmutableList.of(), this.shardSpecFactory.apply(1, 2), Integer.valueOf(0), 10L));
        this.dataSources = DataSourcesSnapshot.fromUsedSegments(segments, (ImmutableMap)ImmutableMap.of());
        OverlordClient mockClient = (OverlordClient)Mockito.mock(OverlordClient.class);
        ArgumentCaptor<Object> payloadCaptor = CompactSegmentsTest.setUpMockClient(mockClient);
        CompactSegments compactSegments = new CompactSegments(this.statusTracker, mockClient);
        ArrayList<DataSourceCompactionConfig> compactionConfigs = new ArrayList<DataSourceCompactionConfig>();
        compactionConfigs.add(new DataSourceCompactionConfig(dataSourceName, Integer.valueOf(0), Long.valueOf(500L), null, new Period((Object)"PT0H"), new UserCompactionTaskQueryTuningConfig(null, null, null, null, null, this.partitionsSpec, null, null, null, null, null, Integer.valueOf(3), null, null, null, null, null, null, null), null, null, null, null, null, this.engine, null));
        this.doCompactSegments(compactSegments, compactionConfigs);
        ClientCompactionTaskQuery taskPayload = (ClientCompactionTaskQuery)payloadCaptor.getValue();
        Assert.assertEquals((Object)ClientCompactionIntervalSpec.fromSegments(segments, (Granularity)Granularities.DAY), (Object)taskPayload.getIoConfig().getInputSpec());
        ClientCompactionTaskGranularitySpec expectedGranularitySpec = new ClientCompactionTaskGranularitySpec(Granularities.DAY, null, null);
        Assert.assertEquals((Object)expectedGranularitySpec, (Object)taskPayload.getGranularitySpec());
    }

    @Test
    public void testDetermineSegmentGranularityFromSegmentGranularityInCompactionConfig() {
        String dataSourceName = "dataSource_1";
        ArrayList<DataSegment> segments = new ArrayList<DataSegment>();
        segments.add(new DataSegment(dataSourceName, Intervals.of((String)"2017-01-01T00:00:00/2017-01-02T00:00:00"), "1", null, (List)ImmutableList.of(), (List)ImmutableList.of(), this.shardSpecFactory.apply(0, 2), Integer.valueOf(0), 10L));
        segments.add(new DataSegment(dataSourceName, Intervals.of((String)"2017-01-01T00:00:00/2017-01-02T00:00:00"), "1", null, (List)ImmutableList.of(), (List)ImmutableList.of(), this.shardSpecFactory.apply(1, 2), Integer.valueOf(0), 10L));
        this.dataSources = DataSourcesSnapshot.fromUsedSegments(segments, (ImmutableMap)ImmutableMap.of());
        OverlordClient mockClient = (OverlordClient)Mockito.mock(OverlordClient.class);
        ArgumentCaptor<Object> payloadCaptor = CompactSegmentsTest.setUpMockClient(mockClient);
        CompactSegments compactSegments = new CompactSegments(this.statusTracker, mockClient);
        ArrayList<DataSourceCompactionConfig> compactionConfigs = new ArrayList<DataSourceCompactionConfig>();
        compactionConfigs.add(new DataSourceCompactionConfig(dataSourceName, Integer.valueOf(0), Long.valueOf(500L), null, new Period((Object)"PT0H"), new UserCompactionTaskQueryTuningConfig(null, null, null, null, null, this.partitionsSpec, null, null, null, null, null, Integer.valueOf(3), null, null, null, null, null, null, null), new UserCompactionTaskGranularityConfig(Granularities.YEAR, null, null), null, null, null, null, this.engine, null));
        this.doCompactSegments(compactSegments, compactionConfigs);
        ClientCompactionTaskQuery taskPayload = (ClientCompactionTaskQuery)payloadCaptor.getValue();
        Assert.assertEquals((Object)ClientCompactionIntervalSpec.fromSegments(segments, (Granularity)Granularities.YEAR), (Object)taskPayload.getIoConfig().getInputSpec());
        ClientCompactionTaskGranularitySpec expectedGranularitySpec = new ClientCompactionTaskGranularitySpec(Granularities.YEAR, null, null);
        Assert.assertEquals((Object)expectedGranularitySpec, (Object)taskPayload.getGranularitySpec());
    }

    @Test
    public void testCompactWithMetricsSpecShouldSetPreserveExistingMetricsTrue() {
        OverlordClient mockClient = (OverlordClient)Mockito.mock(OverlordClient.class);
        ArgumentCaptor<Object> payloadCaptor = CompactSegmentsTest.setUpMockClient(mockClient);
        CompactSegments compactSegments = new CompactSegments(this.statusTracker, mockClient);
        ArrayList<DataSourceCompactionConfig> compactionConfigs = new ArrayList<DataSourceCompactionConfig>();
        String dataSource = "dataSource_0";
        compactionConfigs.add(new DataSourceCompactionConfig("dataSource_0", Integer.valueOf(0), Long.valueOf(500L), null, new Period((Object)"PT0H"), new UserCompactionTaskQueryTuningConfig(null, null, null, null, null, this.partitionsSpec, null, null, null, null, null, Integer.valueOf(3), null, null, null, null, null, null, null), null, null, new AggregatorFactory[]{new CountAggregatorFactory("cnt")}, null, null, this.engine, null));
        this.doCompactSegments(compactSegments, compactionConfigs);
        ClientCompactionTaskQuery taskPayload = (ClientCompactionTaskQuery)payloadCaptor.getValue();
        Assert.assertNotNull((Object)taskPayload.getTuningConfig());
        Assert.assertNotNull((Object)taskPayload.getTuningConfig().getAppendableIndexSpec());
        Assert.assertTrue((boolean)((OnheapIncrementalIndex.Spec)taskPayload.getTuningConfig().getAppendableIndexSpec()).isPreserveExistingMetrics());
    }

    @Test
    public void testCompactWithoutMetricsSpecShouldSetPreserveExistingMetricsFalse() {
        OverlordClient mockClient = (OverlordClient)Mockito.mock(OverlordClient.class);
        ArgumentCaptor<Object> payloadCaptor = CompactSegmentsTest.setUpMockClient(mockClient);
        CompactSegments compactSegments = new CompactSegments(this.statusTracker, mockClient);
        ArrayList<DataSourceCompactionConfig> compactionConfigs = new ArrayList<DataSourceCompactionConfig>();
        String dataSource = "dataSource_0";
        compactionConfigs.add(new DataSourceCompactionConfig("dataSource_0", Integer.valueOf(0), Long.valueOf(500L), null, new Period((Object)"PT0H"), new UserCompactionTaskQueryTuningConfig(null, null, null, null, null, this.partitionsSpec, null, null, null, null, null, Integer.valueOf(3), null, null, null, null, null, null, null), null, null, null, null, null, this.engine, null));
        this.doCompactSegments(compactSegments, compactionConfigs);
        ClientCompactionTaskQuery taskPayload = (ClientCompactionTaskQuery)payloadCaptor.getValue();
        Assert.assertNotNull((Object)taskPayload.getTuningConfig());
        Assert.assertNotNull((Object)taskPayload.getTuningConfig().getAppendableIndexSpec());
        Assert.assertFalse((boolean)((OnheapIncrementalIndex.Spec)taskPayload.getTuningConfig().getAppendableIndexSpec()).isPreserveExistingMetrics());
    }

    private void verifySnapshot(CompactSegments compactSegments, AutoCompactionSnapshot.AutoCompactionScheduleStatus scheduleStatus, String dataSourceName, long expectedByteCountAwaitingCompaction, long expectedByteCountCompressed, long expectedByteCountSkipped, long expectedIntervalCountAwaitingCompaction, long expectedIntervalCountCompressed, long expectedIntervalCountSkipped, long expectedSegmentCountAwaitingCompaction, long expectedSegmentCountCompressed, long expectedSegmentCountSkipped) {
        Map autoCompactionSnapshots = compactSegments.getAutoCompactionSnapshot();
        AutoCompactionSnapshot snapshot = (AutoCompactionSnapshot)autoCompactionSnapshots.get(dataSourceName);
        Assert.assertEquals((Object)dataSourceName, (Object)snapshot.getDataSource());
        Assert.assertEquals((Object)scheduleStatus, (Object)snapshot.getScheduleStatus());
        Assert.assertEquals((long)expectedByteCountAwaitingCompaction, (long)snapshot.getBytesAwaitingCompaction());
        Assert.assertEquals((long)expectedByteCountCompressed, (long)snapshot.getBytesCompacted());
        Assert.assertEquals((long)expectedByteCountSkipped, (long)snapshot.getBytesSkipped());
        Assert.assertEquals((long)expectedIntervalCountAwaitingCompaction, (long)snapshot.getIntervalCountAwaitingCompaction());
        Assert.assertEquals((long)expectedIntervalCountCompressed, (long)snapshot.getIntervalCountCompacted());
        Assert.assertEquals((long)expectedIntervalCountSkipped, (long)snapshot.getIntervalCountSkipped());
        Assert.assertEquals((long)expectedSegmentCountAwaitingCompaction, (long)snapshot.getSegmentCountAwaitingCompaction());
        Assert.assertEquals((long)expectedSegmentCountCompressed, (long)snapshot.getSegmentCountCompacted());
        Assert.assertEquals((long)expectedSegmentCountSkipped, (long)snapshot.getSegmentCountSkipped());
    }

    private void doCompactionAndAssertCompactSegmentStatistics(CompactSegments compactSegments, int compactionRunCount) {
        for (int dataSourceIndex = 0; dataSourceIndex < 3; ++dataSourceIndex) {
            int i;
            CoordinatorRunStats stats = this.doCompactSegments(compactSegments);
            Assert.assertEquals((long)1L, (long)stats.get(Stats.Compaction.SUBMITTED_TASKS));
            for (i = 0; i <= dataSourceIndex; ++i) {
                if (i != dataSourceIndex) {
                    this.verifySnapshot(compactSegments, AutoCompactionSnapshot.AutoCompactionScheduleStatus.RUNNING, DATA_SOURCE_PREFIX + i, 440L - 40L * (long)(compactionRunCount + 1), 40L * (long)(compactionRunCount + 1), 40L, 11 - (compactionRunCount + 1), compactionRunCount + 1, 1L, 44L - 4L * (long)(compactionRunCount + 1), 2L * (long)(compactionRunCount + 1), 4L);
                    continue;
                }
                this.verifySnapshot(compactSegments, AutoCompactionSnapshot.AutoCompactionScheduleStatus.RUNNING, DATA_SOURCE_PREFIX + i, 440L - 40L * (long)(compactionRunCount + 1), 40L * (long)(compactionRunCount + 1), 40L, 11 - (compactionRunCount + 1), compactionRunCount + 1, 1L, 44L - 4L * (long)(compactionRunCount + 1), 2L * (long)compactionRunCount + 4L, 4L);
            }
            for (i = dataSourceIndex + 1; i < 3; ++i) {
                this.verifySnapshot(compactSegments, AutoCompactionSnapshot.AutoCompactionScheduleStatus.RUNNING, DATA_SOURCE_PREFIX + i, 440L - 40L * (long)compactionRunCount, 40L * (long)compactionRunCount, 40L, 11 - compactionRunCount, compactionRunCount, 1L, 44L - 4L * (long)compactionRunCount, 2L * (long)compactionRunCount, 4L);
            }
        }
    }

    private CoordinatorRunStats doCompactSegments(CompactSegments compactSegments) {
        return this.doCompactSegments(compactSegments, (Integer)null);
    }

    private CoordinatorRunStats doCompactSegments(CompactSegments compactSegments, @Nullable Integer numCompactionTaskSlots) {
        return this.doCompactSegments(compactSegments, this.createCompactionConfigs(), numCompactionTaskSlots);
    }

    private CoordinatorRunStats doCompactSegments(CompactSegments compactSegments, List<DataSourceCompactionConfig> compactionConfigs) {
        return this.doCompactSegments(compactSegments, compactionConfigs, null);
    }

    private CoordinatorRunStats doCompactSegments(CompactSegments compactSegments, List<DataSourceCompactionConfig> compactionConfigs, @Nullable Integer numCompactionTaskSlots) {
        return this.doCompactSegments(compactSegments, compactionConfigs, numCompactionTaskSlots, false);
    }

    private CoordinatorRunStats doCompactSegments(CompactSegments compactSegments, List<DataSourceCompactionConfig> compactionConfigs, @Nullable Integer numCompactionTaskSlots, boolean useAutoScaleSlots) {
        DruidCoordinatorRuntimeParams params = DruidCoordinatorRuntimeParams.builder().withDataSourcesSnapshot(this.dataSources).withCompactionConfig(new DruidCompactionConfig(compactionConfigs, numCompactionTaskSlots == null ? null : Double.valueOf(1.0), numCompactionTaskSlots, Boolean.valueOf(useAutoScaleSlots), null)).build();
        return compactSegments.run(params).getCoordinatorStats();
    }

    private void assertCompactSegments(CompactSegments compactSegments, Interval expectedInterval, int expectedRemainingSegments, int expectedCompactTaskCount, Supplier<String> expectedVersionSupplier) {
        for (int i = 0; i < 3; ++i) {
            CoordinatorRunStats stats = this.doCompactSegments(compactSegments);
            Assert.assertEquals((long)expectedCompactTaskCount, (long)stats.get(Stats.Compaction.SUBMITTED_TASKS));
            AtomicInteger numDatasources = new AtomicInteger();
            stats.forEachStat((stat, rowKey, value) -> {
                if (stat.equals(Stats.Compaction.PENDING_BYTES) && (expectedRemainingSegments <= 0 || value == (long)expectedRemainingSegments)) {
                    numDatasources.incrementAndGet();
                }
            });
            if (expectedRemainingSegments > 0) {
                Assert.assertEquals((long)(i + 1), (long)numDatasources.get());
                continue;
            }
            Assert.assertEquals((long)(2 - i), (long)numDatasources.get());
        }
        Map dataSourceToTimeline = this.dataSources.getUsedSegmentsTimelinesPerDataSource();
        for (int i = 0; i < 3; ++i) {
            String dataSource = DATA_SOURCE_PREFIX + i;
            List holders = ((SegmentTimeline)dataSourceToTimeline.get(dataSource)).lookup(expectedInterval);
            Assert.assertEquals((long)1L, (long)holders.size());
            ArrayList chunks = Lists.newArrayList((Iterable)((TimelineObjectHolder)holders.get(0)).getObject());
            Assert.assertEquals((long)2L, (long)chunks.size());
            String expectedVersion = expectedVersionSupplier.get();
            for (PartitionChunk chunk : chunks) {
                Assert.assertEquals((Object)expectedInterval, (Object)((DataSegment)chunk.getObject()).getInterval());
                Assert.assertEquals((Object)expectedVersion, (Object)((DataSegment)chunk.getObject()).getVersion());
            }
        }
    }

    private void assertLastSegmentNotCompacted(CompactSegments compactSegments) {
        Map dataSourceToTimeline = this.dataSources.getUsedSegmentsTimelinesPerDataSource();
        for (int i = 0; i < 3; ++i) {
            String dataSource = DATA_SOURCE_PREFIX + i;
            Interval interval = Intervals.of((String)StringUtils.format((String)"2017-01-09T12:00:00/2017-01-10", (Object[])new Object[0]));
            List holders = ((SegmentTimeline)dataSourceToTimeline.get(dataSource)).lookup(interval);
            Assert.assertEquals((long)1L, (long)holders.size());
            for (TimelineObjectHolder holder : holders) {
                ArrayList chunks = Lists.newArrayList((Iterable)holder.getObject());
                Assert.assertEquals((long)4L, (long)chunks.size());
                for (PartitionChunk chunk : chunks) {
                    DataSegment segment = (DataSegment)chunk.getObject();
                    Assert.assertEquals((Object)interval, (Object)segment.getInterval());
                    Assert.assertEquals((Object)"version", (Object)segment.getVersion());
                }
            }
        }
        String dataSource = "dataSource_0";
        this.addMoreData("dataSource_0", 9);
        CoordinatorRunStats stats = this.doCompactSegments(compactSegments);
        Assert.assertEquals((long)1L, (long)stats.get(Stats.Compaction.SUBMITTED_TASKS));
        this.addMoreData("dataSource_0", 10);
        stats = this.doCompactSegments(compactSegments);
        Assert.assertEquals((long)1L, (long)stats.get(Stats.Compaction.SUBMITTED_TASKS));
    }

    private void addMoreData(String dataSource, int day) {
        SegmentTimeline timeline = (SegmentTimeline)this.dataSources.getUsedSegmentsTimelinesPerDataSource().get(dataSource);
        for (int i = 0; i < 2; ++i) {
            DataSegment newSegment = this.createSegment(dataSource, day, true, i);
            timeline.add(newSegment.getInterval(), (Object)newSegment.getVersion(), newSegment.getShardSpec().createChunk((Object)newSegment));
            newSegment = this.createSegment(dataSource, day, false, i);
            timeline.add(newSegment.getInterval(), (Object)newSegment.getVersion(), newSegment.getShardSpec().createChunk((Object)newSegment));
        }
    }

    private List<DataSourceCompactionConfig> createCompactionConfigs() {
        return this.createCompactionConfigs(null, null);
    }

    private List<DataSourceCompactionConfig> createcompactionConfigsForNative(@Nullable Integer maxNumConcurrentSubTasks) {
        return this.createCompactionConfigs(maxNumConcurrentSubTasks, null);
    }

    private List<DataSourceCompactionConfig> createcompactionConfigsForMSQ(Integer maxNumTasks) {
        return this.createCompactionConfigs(null, maxNumTasks);
    }

    private List<DataSourceCompactionConfig> createCompactionConfigs(@Nullable Integer maxNumConcurrentSubTasksForNative, @Nullable Integer maxNumTasksForMSQ) {
        ArrayList<DataSourceCompactionConfig> compactionConfigs = new ArrayList<DataSourceCompactionConfig>();
        for (int i = 0; i < 3; ++i) {
            String dataSource = DATA_SOURCE_PREFIX + i;
            compactionConfigs.add(new DataSourceCompactionConfig(dataSource, Integer.valueOf(0), Long.valueOf(50L), null, new Period((Object)"PT1H"), new UserCompactionTaskQueryTuningConfig(null, null, null, null, null, this.partitionsSpec, null, null, null, null, null, maxNumConcurrentSubTasksForNative, null, null, null, null, null, null, null), null, null, null, null, null, this.engine, maxNumTasksForMSQ == null ? null : ImmutableMap.of((Object)"maxNumTasks", (Object)maxNumTasksForMSQ)));
        }
        return compactionConfigs;
    }

    private static ArgumentCaptor<Object> setUpMockClient(OverlordClient mockClient) {
        ArgumentCaptor payloadCaptor = ArgumentCaptor.forClass(Object.class);
        Mockito.when((Object)mockClient.taskStatuses(null, null, Integer.valueOf(0))).thenReturn((Object)Futures.immediateFuture((Object)CloseableIterators.withEmptyBaggage(Collections.emptyIterator())));
        Mockito.when((Object)mockClient.taskStatuses((Set)ArgumentMatchers.any())).thenReturn((Object)Futures.immediateFuture(Collections.emptyMap()));
        Mockito.when((Object)mockClient.findLockedIntervals((List)ArgumentMatchers.any())).thenReturn((Object)Futures.immediateFuture(Collections.emptyMap()));
        Mockito.when((Object)mockClient.getTotalWorkerCapacity()).thenReturn((Object)Futures.immediateFuture((Object)new IndexingTotalWorkerCapacityInfo(0, 0)));
        Mockito.when((Object)mockClient.runTask(ArgumentMatchers.anyString(), payloadCaptor.capture())).thenReturn((Object)Futures.immediateFuture(null));
        return payloadCaptor;
    }

    private class TestOverlordClient
    extends NoopOverlordClient {
        private final ObjectMapper jsonMapper;
        private final Map<String, List<Interval>> lockedIntervals = new HashMap<String, List<Interval>>();
        private final List<ClientCompactionTaskQuery> submittedCompactionTasks = new ArrayList<ClientCompactionTaskQuery>();
        private int compactVersionSuffix = 0;

        private TestOverlordClient(ObjectMapper jsonMapper) {
            this.jsonMapper = jsonMapper;
        }

        @Override
        public ListenableFuture<URI> findCurrentLeader() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ListenableFuture<Void> runTask(String taskId, Object taskObject) {
            ClientTaskQuery taskQuery = (ClientTaskQuery)this.jsonMapper.convertValue(taskObject, ClientTaskQuery.class);
            if (!(taskQuery instanceof ClientCompactionTaskQuery)) {
                throw new IAE("Cannot run non-compaction task", new Object[0]);
            }
            ClientCompactionTaskQuery compactionTaskQuery = (ClientCompactionTaskQuery)taskQuery;
            this.submittedCompactionTasks.add(compactionTaskQuery);
            Interval intervalToCompact = compactionTaskQuery.getIoConfig().getInputSpec().getInterval();
            SegmentTimeline timeline = (SegmentTimeline)CompactSegmentsTest.this.dataSources.getUsedSegmentsTimelinesPerDataSource().get(compactionTaskQuery.getDataSource());
            List<DataSegment> segments = timeline.lookup(intervalToCompact).stream().flatMap(holder -> Streams.sequentialStreamFrom((Iterable)holder.getObject())).map(PartitionChunk::getObject).collect(Collectors.toList());
            this.compactSegments(timeline, segments, compactionTaskQuery);
            return Futures.immediateFuture(null);
        }

        @Override
        public ListenableFuture<Map<String, List<Interval>>> findLockedIntervals(List<LockFilterPolicy> lockFilterPolicies) {
            return Futures.immediateFuture(this.lockedIntervals);
        }

        @Override
        public ListenableFuture<CloseableIterator<TaskStatusPlus>> taskStatuses(@Nullable String state, @Nullable String dataSource, @Nullable Integer maxCompletedTasks) {
            return Futures.immediateFuture((Object)CloseableIterators.withEmptyBaggage(Collections.emptyIterator()));
        }

        @Override
        public ListenableFuture<Map<String, TaskStatus>> taskStatuses(Set<String> taskIds) {
            return Futures.immediateFuture(Collections.emptyMap());
        }

        @Override
        public ListenableFuture<IndexingTotalWorkerCapacityInfo> getTotalWorkerCapacity() {
            return Futures.immediateFuture((Object)new IndexingTotalWorkerCapacityInfo(5, 10));
        }

        private void compactSegments(SegmentTimeline timeline, List<DataSegment> segments, ClientCompactionTaskQuery clientCompactionTaskQuery) {
            Preconditions.checkArgument((segments.size() > 1 ? 1 : 0) != 0);
            Interval compactInterval = JodaUtils.umbrellaInterval((Iterable)segments.stream().map(DataSegment::getInterval).collect(Collectors.toList()));
            segments.forEach(segment -> timeline.remove(segment.getInterval(), (Object)segment.getVersion(), segment.getShardSpec().createChunk(segment)));
            String version = "newVersion_" + this.compactVersionSuffix++;
            long segmentSize = segments.stream().mapToLong(DataSegment::getSize).sum() / 2L;
            Object compactionPartitionsSpec = clientCompactionTaskQuery.getTuningConfig().getPartitionsSpec() instanceof DynamicPartitionsSpec ? new DynamicPartitionsSpec(clientCompactionTaskQuery.getTuningConfig().getPartitionsSpec().getMaxRowsPerSegment(), Long.valueOf(((DynamicPartitionsSpec)clientCompactionTaskQuery.getTuningConfig().getPartitionsSpec()).getMaxTotalRowsOr(Long.MAX_VALUE))) : clientCompactionTaskQuery.getTuningConfig().getPartitionsSpec();
            Map transformSpec = null;
            try {
                if (clientCompactionTaskQuery.getTransformSpec() != null) {
                    transformSpec = (Map)this.jsonMapper.readValue(this.jsonMapper.writeValueAsString((Object)new TransformSpec(clientCompactionTaskQuery.getTransformSpec().getFilter(), null)), (TypeReference)new TypeReference<Map<String, Object>>(){});
                }
            }
            catch (JsonProcessingException e) {
                throw new IAE("Invalid Json payload", new Object[0]);
            }
            List metricsSpec = null;
            if (clientCompactionTaskQuery.getMetricsSpec() != null) {
                metricsSpec = (List)this.jsonMapper.convertValue((Object)clientCompactionTaskQuery.getMetricsSpec(), (TypeReference)new TypeReference<List<Object>>(){});
            }
            for (int i = 0; i < 2; ++i) {
                DataSegment compactSegment = new DataSegment(segments.get(0).getDataSource(), compactInterval, version, null, segments.get(0).getDimensions(), segments.get(0).getMetrics(), (ShardSpec)CompactSegmentsTest.this.shardSpecFactory.apply(i, 2), new CompactionState(compactionPartitionsSpec, clientCompactionTaskQuery.getDimensionsSpec() == null ? null : new DimensionsSpec(clientCompactionTaskQuery.getDimensionsSpec().getDimensions()), metricsSpec, transformSpec, (Map)ImmutableMap.of((Object)"bitmap", (Object)ImmutableMap.of((Object)"type", (Object)"roaring"), (Object)"dimensionCompression", (Object)"lz4", (Object)"metricCompression", (Object)"lz4", (Object)"longEncoding", (Object)"longs"), (Map)ImmutableMap.of()), Integer.valueOf(1), segmentSize);
                timeline.add(compactInterval, (Object)compactSegment.getVersion(), compactSegment.getShardSpec().createChunk((Object)compactSegment));
            }
        }
    }

    public static class StaticUtilsTest {
        @Test
        public void testIsParalleModeNullTuningConfigReturnFalse() {
            Assert.assertFalse((boolean)CompactSegments.isParallelMode(null));
        }

        @Test
        public void testIsParallelModeNullPartitionsSpecReturnFalse() {
            ClientCompactionTaskQueryTuningConfig tuningConfig = (ClientCompactionTaskQueryTuningConfig)Mockito.mock(ClientCompactionTaskQueryTuningConfig.class);
            Mockito.when((Object)tuningConfig.getPartitionsSpec()).thenReturn(null);
            Assert.assertFalse((boolean)CompactSegments.isParallelMode((ClientCompactionTaskQueryTuningConfig)tuningConfig));
        }

        @Test
        public void testIsParallelModeNonRangePartitionVaryingMaxNumConcurrentSubTasks() {
            ClientCompactionTaskQueryTuningConfig tuningConfig = (ClientCompactionTaskQueryTuningConfig)Mockito.mock(ClientCompactionTaskQueryTuningConfig.class);
            Mockito.when((Object)tuningConfig.getPartitionsSpec()).thenReturn((Object)((PartitionsSpec)Mockito.mock(PartitionsSpec.class)));
            Mockito.when((Object)tuningConfig.getMaxNumConcurrentSubTasks()).thenReturn(null);
            Assert.assertFalse((boolean)CompactSegments.isParallelMode((ClientCompactionTaskQueryTuningConfig)tuningConfig));
            Mockito.when((Object)tuningConfig.getMaxNumConcurrentSubTasks()).thenReturn((Object)1);
            Assert.assertFalse((boolean)CompactSegments.isParallelMode((ClientCompactionTaskQueryTuningConfig)tuningConfig));
            Mockito.when((Object)tuningConfig.getMaxNumConcurrentSubTasks()).thenReturn((Object)2);
            Assert.assertTrue((boolean)CompactSegments.isParallelMode((ClientCompactionTaskQueryTuningConfig)tuningConfig));
        }

        @Test
        public void testIsParallelModeRangePartitionVaryingMaxNumConcurrentSubTasks() {
            ClientCompactionTaskQueryTuningConfig tuningConfig = (ClientCompactionTaskQueryTuningConfig)Mockito.mock(ClientCompactionTaskQueryTuningConfig.class);
            Mockito.when((Object)tuningConfig.getPartitionsSpec()).thenReturn((Object)((PartitionsSpec)Mockito.mock(SingleDimensionPartitionsSpec.class)));
            Mockito.when((Object)tuningConfig.getMaxNumConcurrentSubTasks()).thenReturn(null);
            Assert.assertFalse((boolean)CompactSegments.isParallelMode((ClientCompactionTaskQueryTuningConfig)tuningConfig));
            Mockito.when((Object)tuningConfig.getMaxNumConcurrentSubTasks()).thenReturn((Object)1);
            Assert.assertTrue((boolean)CompactSegments.isParallelMode((ClientCompactionTaskQueryTuningConfig)tuningConfig));
            Mockito.when((Object)tuningConfig.getMaxNumConcurrentSubTasks()).thenReturn((Object)2);
            Assert.assertTrue((boolean)CompactSegments.isParallelMode((ClientCompactionTaskQueryTuningConfig)tuningConfig));
        }

        @Test
        public void testFindMaxNumTaskSlotsUsedByOneCompactionTaskWhenIsParallelMode() {
            ClientCompactionTaskQueryTuningConfig tuningConfig = (ClientCompactionTaskQueryTuningConfig)Mockito.mock(ClientCompactionTaskQueryTuningConfig.class);
            Mockito.when((Object)tuningConfig.getPartitionsSpec()).thenReturn((Object)((PartitionsSpec)Mockito.mock(PartitionsSpec.class)));
            Mockito.when((Object)tuningConfig.getMaxNumConcurrentSubTasks()).thenReturn((Object)2);
            Assert.assertEquals((long)3L, (long)CompactSegments.findMaxNumTaskSlotsUsedByOneNativeCompactionTask((ClientCompactionTaskQueryTuningConfig)tuningConfig));
        }

        @Test
        public void testFindMaxNumTaskSlotsUsedByOneCompactionTaskWhenIsSequentialMode() {
            ClientCompactionTaskQueryTuningConfig tuningConfig = (ClientCompactionTaskQueryTuningConfig)Mockito.mock(ClientCompactionTaskQueryTuningConfig.class);
            Mockito.when((Object)tuningConfig.getPartitionsSpec()).thenReturn((Object)((PartitionsSpec)Mockito.mock(PartitionsSpec.class)));
            Mockito.when((Object)tuningConfig.getMaxNumConcurrentSubTasks()).thenReturn((Object)1);
            Assert.assertEquals((long)1L, (long)CompactSegments.findMaxNumTaskSlotsUsedByOneNativeCompactionTask((ClientCompactionTaskQueryTuningConfig)tuningConfig));
        }
    }
}

