/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.loading;

import java.util.Random;
import org.apache.druid.error.DruidException;
import org.apache.druid.server.coordinator.loading.LoadingRateTracker;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LoadingRateTrackerTest {
    private LoadingRateTracker tracker;

    @Before
    public void setup() {
        this.tracker = new LoadingRateTracker();
    }

    @Test
    public void testUpdateThrowsExceptionIfBatchNotStarted() {
        DruidException e = (DruidException)Assert.assertThrows(DruidException.class, () -> this.tracker.incrementBytesLoadedInBatch(1000L, 10L));
        Assert.assertEquals((Object)"markBatchLoadingStarted() must be called before tracking load progress.", (Object)e.getMessage());
    }

    @Test
    public void testRateIsZeroWhenEmpty() {
        Assert.assertEquals((long)0L, (long)this.tracker.getMovingAverageLoadRateKbps());
    }

    @Test
    public void testRateIsZeroAfterStop() {
        this.tracker.markBatchLoadingStarted();
        this.tracker.incrementBytesLoadedInBatch(1000L, 10L);
        Assert.assertEquals((long)800L, (long)this.tracker.getMovingAverageLoadRateKbps());
        this.tracker.stop();
        Assert.assertEquals((long)0L, (long)this.tracker.getMovingAverageLoadRateKbps());
    }

    @Test
    public void testRateAfter2UpdatesInBatch() {
        this.tracker.markBatchLoadingStarted();
        this.tracker.incrementBytesLoadedInBatch(1000L, 10L);
        Assert.assertEquals((long)800L, (long)this.tracker.getMovingAverageLoadRateKbps());
        this.tracker.incrementBytesLoadedInBatch(1000L, 15L);
        Assert.assertEquals((long)1066L, (long)this.tracker.getMovingAverageLoadRateKbps());
    }

    @Test
    public void testRateAfter2Batches() {
        this.tracker.markBatchLoadingStarted();
        this.tracker.incrementBytesLoadedInBatch(1000L, 10L);
        Assert.assertEquals((long)800L, (long)this.tracker.getMovingAverageLoadRateKbps());
        this.tracker.markBatchLoadingFinished();
        this.tracker.markBatchLoadingStarted();
        this.tracker.incrementBytesLoadedInBatch(1000L, 5L);
        Assert.assertEquals((long)1066L, (long)this.tracker.getMovingAverageLoadRateKbps());
        this.tracker.markBatchLoadingFinished();
    }

    @Test
    public void test100UpdatesInABatch() {
        Random random = new Random(1001L);
        this.tracker.markBatchLoadingStarted();
        long totalUpdateBytes = 0L;
        long monoticBatchDuration = 0L;
        for (int i = 0; i < 100; ++i) {
            long updateBytes = 1 + random.nextInt(1000);
            monoticBatchDuration = 1 + random.nextInt(10);
            this.tracker.incrementBytesLoadedInBatch(updateBytes, monoticBatchDuration);
            Assert.assertEquals((long)(8L * (totalUpdateBytes += updateBytes) / monoticBatchDuration), (long)this.tracker.getMovingAverageLoadRateKbps());
        }
        this.tracker.markBatchLoadingFinished();
        Assert.assertEquals((long)(8L * totalUpdateBytes / monoticBatchDuration), (long)this.tracker.getMovingAverageLoadRateKbps());
    }

    @Test
    public void testRateIsMovingAverage() {
        Random random = new Random(1001L);
        int windowSize = 10;
        long minEntrySizeBytes = 0x40000000L;
        long[] updateBytes = new long[10];
        long[] updateMillis = new long[10];
        long totalBytes = 0L;
        long totalMillis = 0L;
        for (int i = 0; i < 10; ++i) {
            updateBytes[i] = 0x40000000L + (long)random.nextInt(0x40000000);
            updateMillis[i] = 1 + random.nextInt(1000);
            this.tracker.markBatchLoadingStarted();
            this.tracker.incrementBytesLoadedInBatch(updateBytes[i], updateMillis[i]);
            Assert.assertEquals((long)(8L * (totalBytes += updateBytes[i]) / (totalMillis += updateMillis[i])), (long)this.tracker.getMovingAverageLoadRateKbps());
            this.tracker.markBatchLoadingFinished();
        }
        long latestUpdateBytes = 1L;
        long latestUpdateMillis = 1 + random.nextInt(1000);
        this.tracker.markBatchLoadingStarted();
        this.tracker.incrementBytesLoadedInBatch(latestUpdateBytes, latestUpdateMillis);
        this.tracker.markBatchLoadingFinished();
        totalBytes = totalBytes - updateBytes[0] + latestUpdateBytes;
        totalMillis = totalMillis - updateMillis[0] + latestUpdateMillis;
        Assert.assertEquals((long)(8L * totalBytes / totalMillis), (long)this.tracker.getMovingAverageLoadRateKbps());
    }

    @Test
    public void testWindowMovesOnlyAfterMinSizeUpdates() {
        Random random = new Random(1001L);
        long totalBytes = 0L;
        long totalMillis = 0L;
        int windowSize = 10;
        long minEntrySizeBytes = 0x40000000L;
        for (int i = 0; i < 100; ++i) {
            long updateBytes = 1 + random.nextInt(10737418);
            long updateMillis = 1 + random.nextInt(1000);
            this.tracker.markBatchLoadingStarted();
            this.tracker.incrementBytesLoadedInBatch(updateBytes, updateMillis);
            this.tracker.markBatchLoadingFinished();
            Assert.assertEquals((long)(8L * (totalBytes += updateBytes) / (totalMillis += updateMillis)), (long)this.tracker.getMovingAverageLoadRateKbps());
        }
    }
}

