/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.initialization;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.servlet.GuiceFilter;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.druid.guice.annotations.Self;
import org.apache.druid.java.util.common.lifecycle.Lifecycle;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.java.util.http.client.HttpClientConfig;
import org.apache.druid.java.util.http.client.HttpClientInit;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.initialization.jetty.JettyServerInitUtils;
import org.apache.druid.server.initialization.jetty.JettyServerInitializer;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.joda.time.Duration;
import org.junit.After;
import org.junit.Before;

public abstract class BaseJettyTest {
    protected static final String DEFAULT_RESPONSE_CONTENT = "hello";
    protected Lifecycle lifecycle;
    protected HttpClient client;
    protected Server server;
    protected int port = -1;
    protected int tlsPort = -1;

    protected void setProperties() {
        System.setProperty("druid.server.http.numThreads", "20");
        System.setProperty("druid.server.http.maxIdleTime", "PT1S");
        System.setProperty("druid.global.http.readTimeout", "PT1S");
    }

    @Before
    public void setup() throws Exception {
        this.setProperties();
        Injector injector = this.setupInjector();
        DruidNode node = (DruidNode)injector.getInstance(Key.get(DruidNode.class, Self.class));
        this.port = node.getPlaintextPort();
        this.tlsPort = node.getTlsPort();
        this.lifecycle = (Lifecycle)injector.getInstance(Lifecycle.class);
        this.lifecycle.start();
        ClientHolder holder = (ClientHolder)injector.getInstance(ClientHolder.class);
        this.server = (Server)injector.getInstance(Server.class);
        this.client = holder.getClient();
    }

    protected abstract Injector setupInjector();

    @After
    public void teardown() {
        this.lifecycle.stop();
    }

    public static class ClientHolder {
        HttpClient client;

        ClientHolder() {
            this(1);
        }

        ClientHolder(int maxClientConnections) {
            Lifecycle druidLifecycle = new Lifecycle();
            try {
                this.client = HttpClientInit.createClient((HttpClientConfig)HttpClientConfig.builder().withNumConnections(maxClientConnections).withSslContext(SSLContext.getDefault()).withReadTimeout(Duration.ZERO).withEagerInitialization(true).build(), (Lifecycle)druidLifecycle);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public HttpClient getClient() {
            return this.client;
        }
    }

    public static class DummyAuthFilter
    implements Filter {
        public static final String AUTH_HDR = "secretUser";
        public static final String SECRET_USER = "bob";

        public void init(FilterConfig filterConfig) {
        }

        public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
            HttpServletRequest request = (HttpServletRequest)req;
            if (request.getHeader(AUTH_HDR) == null || request.getHeader(AUTH_HDR).equals(SECRET_USER)) {
                chain.doFilter(req, resp);
            } else {
                HttpServletResponse response = (HttpServletResponse)resp;
                response.sendError(401, "Failed even fake authentication.");
            }
        }

        public void destroy() {
        }
    }

    @Path(value="/exception")
    public static class ExceptionResource {
        @GET
        @Path(value="/exception")
        @Produces(value={"application/json"})
        public Response exception(@Context HttpServletResponse resp) throws IOException {
            ServletOutputStream outputStream = resp.getOutputStream();
            outputStream.println(BaseJettyTest.DEFAULT_RESPONSE_CONTENT);
            outputStream.flush();
            try {
                TimeUnit.MILLISECONDS.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            throw new IOException();
        }
    }

    @Path(value="/return")
    public static class DirectlyReturnResource {
        @POST
        @Consumes(value={"text/plain"})
        @Produces(value={"text/plain"})
        public Response postText(String text) {
            return Response.ok((Object)text).build();
        }
    }

    @Path(value="/default")
    public static class DefaultResource {
        @DELETE
        @Path(value="{resource}")
        @Produces(value={"application/json"})
        public Response delete() {
            return Response.ok((Object)BaseJettyTest.DEFAULT_RESPONSE_CONTENT).build();
        }

        @GET
        @Produces(value={"application/json"})
        public Response get() {
            return Response.ok((Object)BaseJettyTest.DEFAULT_RESPONSE_CONTENT).build();
        }

        @POST
        @Produces(value={"application/json"})
        public Response post() {
            return Response.ok((Object)BaseJettyTest.DEFAULT_RESPONSE_CONTENT).build();
        }
    }

    public static class LatchedRequestStateHolder {
        private static final int TIMEOUT_MILLIS = 10000;
        private CountDownLatch requestStartLatch;
        private CountDownLatch requestEndLatch;

        public LatchedRequestStateHolder() {
            this.reset();
        }

        public void reset() {
            this.requestStartLatch = new CountDownLatch(1);
            this.requestEndLatch = new CountDownLatch(1);
        }

        public void clientWaitForServerToStartRequest() throws InterruptedException {
            this.requestStartLatch.await(10000L, TimeUnit.MILLISECONDS);
        }

        public void serverStartRequest() {
            this.requestStartLatch.countDown();
        }

        public void serverWaitForClientReadyToFinishRequest() throws InterruptedException {
            this.requestEndLatch.await(10000L, TimeUnit.MILLISECONDS);
        }

        public void clientReadyToFinishRequest() {
            this.requestEndLatch.countDown();
        }
    }

    @Path(value="/latched")
    public static class LatchedResource {
        private final LatchedRequestStateHolder state;

        @Inject
        public LatchedResource(LatchedRequestStateHolder state) {
            this.state = state;
        }

        @GET
        @Path(value="/hello")
        @Produces(value={"application/json"})
        public Response hello() {
            this.state.serverStartRequest();
            try {
                this.state.serverWaitForClientReadyToFinishRequest();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return Response.ok((Object)BaseJettyTest.DEFAULT_RESPONSE_CONTENT).build();
        }
    }

    @Path(value="/slow")
    public static class SlowResource {
        @GET
        @Path(value="/hello")
        @Produces(value={"application/json"})
        public Response hello() {
            try {
                TimeUnit.MILLISECONDS.sleep(500 + ThreadLocalRandom.current().nextInt(1600));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return Response.ok((Object)BaseJettyTest.DEFAULT_RESPONSE_CONTENT).build();
        }
    }

    public static class JettyServerInit
    implements JettyServerInitializer {
        public void initialize(Server server, Injector injector) {
            ServletContextHandler root = new ServletContextHandler(1);
            root.addServlet(new ServletHolder((Servlet)new DefaultServlet()), "/*");
            JettyServerInitUtils.addQosFilters((ServletContextHandler)root, (Injector)injector);
            JettyServerInitUtils.addExtensionFilters((ServletContextHandler)root, (Injector)injector);
            root.addFilter(GuiceFilter.class, "/*", null);
            HandlerList handlerList = new HandlerList();
            handlerList.setHandlers(new Handler[]{JettyServerInitUtils.wrapWithDefaultGzipHandler((Handler)root, (int)4096, (int)-1)});
            server.setHandler((Handler)handlerList);
        }
    }
}

