/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.catalog.model.table;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.catalog.CatalogTest;
import org.apache.druid.catalog.model.ColumnSpec;
import org.apache.druid.catalog.model.Columns;
import org.apache.druid.catalog.model.ResolvedTable;
import org.apache.druid.catalog.model.TableDefnRegistry;
import org.apache.druid.catalog.model.TableSpec;
import org.apache.druid.catalog.model.facade.DatasourceFacade;
import org.apache.druid.catalog.model.table.ClusterKeySpec;
import org.apache.druid.catalog.model.table.DatasourceDefn;
import org.apache.druid.catalog.model.table.TableBuilder;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.segment.column.ColumnType;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={CatalogTest.class})
public class DatasourceTableTest {
    private static final Logger LOG = new Logger(DatasourceTableTest.class);
    private final ObjectMapper mapper = DefaultObjectMapper.INSTANCE;
    private final TableDefnRegistry registry = new TableDefnRegistry(this.mapper);

    @Test
    public void testMinimalSpec() {
        ImmutableMap props = ImmutableMap.of((Object)"segmentGranularity", (Object)"P1D");
        TableSpec spec = new TableSpec("datasource", (Map)props, null);
        ResolvedTable table = this.registry.resolve(spec);
        Assert.assertNotNull((Object)table);
        Assert.assertTrue((boolean)(table.defn() instanceof DatasourceDefn));
        table.validate();
        DatasourceFacade facade = new DatasourceFacade(this.registry.resolve(table.spec()));
        Assert.assertEquals((Object)"P1D", (Object)facade.segmentGranularityString());
        Assert.assertNull((Object)facade.targetSegmentRows());
        Assert.assertTrue((boolean)facade.hiddenColumns().isEmpty());
        Assert.assertFalse((boolean)facade.isSealed());
    }

    private void expectValidationFails(ResolvedTable table) {
        Assert.assertThrows(IAE.class, () -> table.validate());
    }

    private void expectValidationFails(TableSpec spec) {
        ResolvedTable table = this.registry.resolve(spec);
        this.expectValidationFails(table);
    }

    private void expectValidationSucceeds(TableSpec spec) {
        ResolvedTable table = this.registry.resolve(spec);
        table.validate();
    }

    @Test
    public void testEmptySpec() {
        TableSpec spec = new TableSpec(null, (Map)ImmutableMap.of(), null);
        Assert.assertThrows(IAE.class, () -> this.registry.resolve(spec));
        spec = new TableSpec("datasource", (Map)ImmutableMap.of(), null);
        this.expectValidationSucceeds(spec);
    }

    @Test
    public void testSpecWithClusterKeyProp() {
        TableSpec spec = new TableSpec("datasource", (Map)ImmutableMap.of((Object)"clusterKeys", (Object)ImmutableList.of((Object)new ClusterKeySpec("clusterKeyA", Boolean.valueOf(true)))), null);
        this.expectValidationFails(spec);
        spec = new TableSpec("datasource", (Map)ImmutableMap.of((Object)"clusterKeys", (Object)ImmutableList.of((Object)new ClusterKeySpec("clusterKeyA", Boolean.valueOf(false)))), null);
        this.expectValidationSucceeds(spec);
    }

    @Test
    public void testAllProperties() {
        ImmutableMap props = ImmutableMap.builder().put((Object)"description", (Object)"My table").put((Object)"segmentGranularity", (Object)"P1D").put((Object)"targetSegmentRows", (Object)1000000).put((Object)"hiddenColumns", Arrays.asList("foo", "bar")).put((Object)"sealed", (Object)true).put((Object)"clusterKeys", (Object)ImmutableList.of((Object)new ClusterKeySpec("clusterKeyA", Boolean.valueOf(false)))).build();
        TableSpec spec = new TableSpec("datasource", (Map)props, null);
        DatasourceFacade facade = new DatasourceFacade(this.registry.resolve(spec));
        Assert.assertEquals((Object)"P1D", (Object)facade.segmentGranularityString());
        Assert.assertEquals((long)1000000L, (long)facade.targetSegmentRows().intValue());
        Assert.assertEquals(Arrays.asList("foo", "bar"), (Object)facade.hiddenColumns());
        Assert.assertEquals(Collections.singletonList(new ClusterKeySpec("clusterKeyA", Boolean.valueOf(false))), (Object)facade.clusterKeys());
        Assert.assertTrue((boolean)facade.isSealed());
    }

    @Test
    public void testWrongTypes() {
        TableSpec spec = new TableSpec("bogus", (Map)ImmutableMap.of(), null);
        Assert.assertThrows(IAE.class, () -> this.registry.resolve(spec));
        spec = TableBuilder.datasource((String)"foo", (String)"bogus").buildSpec();
        this.expectValidationFails(spec);
        spec = TableBuilder.datasource((String)"foo", (String)"bogus").buildSpec();
        this.expectValidationFails(spec);
        spec = TableBuilder.datasource((String)"foo", (String)"P1D").property("targetSegmentRows", (Object)"bogus").buildSpec();
        this.expectValidationFails(spec);
        spec = TableBuilder.datasource((String)"foo", (String)"P1D").property("hiddenColumns", (Object)"bogus").buildSpec();
        this.expectValidationFails(spec);
        spec = TableBuilder.datasource((String)"foo", (String)"P1D").hiddenColumns(new String[]{"a", "__time"}).buildSpec();
        this.expectValidationFails(spec);
        spec = TableBuilder.datasource((String)"foo", (String)"P1D").property("sealed", (Object)"bogus").buildSpec();
        this.expectValidationFails(spec);
    }

    @Test
    public void testExtendedProperties() {
        TableSpec spec = TableBuilder.datasource((String)"foo", (String)"P1D").property("foo", (Object)10).property("bar", (Object)"mumble").buildSpec();
        this.expectValidationSucceeds(spec);
    }

    @Test
    public void testColumnSpec() {
        ColumnSpec spec = new ColumnSpec(null, null, null);
        Assert.assertThrows(IAE.class, () -> spec.validate());
        spec = new ColumnSpec("foo", null, null);
        spec.validate();
        spec = new ColumnSpec("foo", "VARCHAR", null);
        spec.validate();
    }

    @Test
    public void testColumns() {
        TableBuilder builder = TableBuilder.datasource((String)"foo", (String)"P1D");
        TableSpec spec = builder.copy().buildSpec();
        ResolvedTable table = this.registry.resolve(spec);
        table.validate();
        DatasourceFacade facade = new DatasourceFacade(this.registry.resolve(table.spec()));
        Assert.assertTrue((boolean)facade.columnFacades().isEmpty());
        spec = builder.copy().column("foo", null).buildSpec();
        table = this.registry.resolve(spec);
        table.validate();
        facade = new DatasourceFacade(this.registry.resolve(table.spec()));
        Assert.assertEquals((long)1L, (long)facade.columnFacades().size());
        DatasourceFacade.ColumnFacade col = (DatasourceFacade.ColumnFacade)facade.columnFacades().get(0);
        Assert.assertSame(spec.columns().get(0), (Object)col.spec());
        Assert.assertFalse((boolean)col.isTime());
        Assert.assertFalse((boolean)col.hasType());
        Assert.assertNull((Object)col.druidType());
        spec = builder.copy().column("foo", Columns.STRING).buildSpec();
        table = this.registry.resolve(spec);
        table.validate();
        facade = new DatasourceFacade(this.registry.resolve(table.spec()));
        Assert.assertEquals((long)1L, (long)facade.columnFacades().size());
        col = (DatasourceFacade.ColumnFacade)facade.columnFacades().get(0);
        Assert.assertSame(spec.columns().get(0), (Object)col.spec());
        Assert.assertFalse((boolean)col.isTime());
        Assert.assertTrue((boolean)col.hasType());
        Assert.assertSame((Object)ColumnType.STRING, (Object)col.druidType());
        spec = builder.copy().column("foo", Columns.STRING).column("bar", Columns.LONG).buildSpec();
        this.expectValidationSucceeds(spec);
        spec = builder.copy().column("foo", Columns.STRING).column("foo", Columns.LONG).buildSpec();
        this.expectValidationFails(spec);
    }

    @Test
    public void testTimeColumn() {
        TableBuilder builder = TableBuilder.datasource((String)"foo", (String)"P1D");
        TableSpec spec = builder.copy().column("__time", null).buildSpec();
        ResolvedTable table = this.registry.resolve(spec);
        table.validate();
        DatasourceFacade facade = new DatasourceFacade(this.registry.resolve(table.spec()));
        Assert.assertEquals((long)1L, (long)facade.columnFacades().size());
        DatasourceFacade.ColumnFacade col = (DatasourceFacade.ColumnFacade)facade.columnFacades().get(0);
        Assert.assertSame(spec.columns().get(0), (Object)col.spec());
        Assert.assertTrue((boolean)col.isTime());
        Assert.assertTrue((boolean)col.hasType());
        Assert.assertSame((Object)ColumnType.LONG, (Object)col.druidType());
        spec = builder.copy().timeColumn().buildSpec();
        table = this.registry.resolve(spec);
        table.validate();
        facade = new DatasourceFacade(this.registry.resolve(table.spec()));
        Assert.assertEquals((long)1L, (long)facade.columnFacades().size());
        col = (DatasourceFacade.ColumnFacade)facade.columnFacades().get(0);
        Assert.assertSame(spec.columns().get(0), (Object)col.spec());
        Assert.assertTrue((boolean)col.isTime());
        Assert.assertTrue((boolean)col.hasType());
        Assert.assertSame((Object)ColumnType.LONG, (Object)col.druidType());
        spec = builder.copy().column("__time", Columns.STRING).buildSpec();
        this.expectValidationFails(spec);
    }

    @Test
    public void testEquals() {
        EqualsVerifier.forClass(ColumnSpec.class).usingGetClass().verify();
        EqualsVerifier.forClass(TableSpec.class).usingGetClass().verify();
    }

    private TableSpec exampleSpec() {
        ImmutableMap colProps = ImmutableMap.builder().put((Object)"colProp1", (Object)"value 1").put((Object)"colProp2", (Object)"value 2").build();
        TableSpec spec = TableBuilder.datasource((String)"foo", (String)"PT1H").description("My table").property("targetSegmentRows", (Object)1000000).hiddenColumns(new String[]{"foo", "bar"}).property("tag1", (Object)"some value").property("tag2", (Object)"second value").column(new ColumnSpec("a", null, (Map)colProps)).column("b", Columns.STRING).buildSpec();
        this.expectValidationSucceeds(spec);
        return spec;
    }

    private TableSpec mergeTables(TableSpec spec, TableSpec update) {
        ResolvedTable table = this.registry.resolve(spec);
        Assert.assertNotNull((Object)table);
        return table.merge(update).spec();
    }

    @Test
    public void testMergeEmpty() {
        TableSpec spec = this.exampleSpec();
        TableSpec update = new TableSpec(null, null, null);
        TableSpec merged = this.mergeTables(spec, update);
        Assert.assertEquals((Object)spec, (Object)merged);
    }

    private void assertMergeFails(TableSpec spec, TableSpec update) {
        Assert.assertThrows(IAE.class, () -> this.mergeTables(spec, update));
    }

    @Test
    public void testMergeTableType() {
        TableSpec spec = this.exampleSpec();
        TableSpec update = new TableSpec("bogus", null, null);
        this.assertMergeFails(spec, update);
        update = new TableSpec(spec.type(), null, null);
        TableSpec merged = this.mergeTables(spec, update);
        Assert.assertEquals((Object)spec, (Object)merged);
    }

    @Test
    public void testMergeProperties() {
        TableSpec spec = this.exampleSpec();
        HashMap<String, String> updatedProps = new HashMap<String, String>();
        updatedProps.put("segmentGranularity", "P1D");
        updatedProps.put("tag1", null);
        updatedProps.put("tag3", "third value");
        TableSpec update = new TableSpec(null, updatedProps, null);
        TableSpec merged = this.mergeTables(spec, update);
        this.expectValidationSucceeds(merged);
        Assert.assertNotEquals((Object)spec, (Object)merged);
        Assert.assertEquals(updatedProps.get("segmentGranularity"), merged.properties().get("segmentGranularity"));
        Assert.assertFalse((boolean)merged.properties().containsKey("tag1"));
        Assert.assertEquals(updatedProps.get("tag3"), merged.properties().get("tag3"));
    }

    @Test
    public void testMergeHiddenCols() {
        TableSpec spec = this.exampleSpec();
        ImmutableMap updatedProps = new HashMap();
        updatedProps.put("hiddenColumns", null);
        TableSpec update = new TableSpec(null, updatedProps, null);
        TableSpec merged = this.mergeTables(spec, update);
        this.expectValidationSucceeds(merged);
        Assert.assertFalse((boolean)merged.properties().containsKey("hiddenColumns"));
        updatedProps = ImmutableMap.of((Object)"hiddenColumns", (Object)"mumble");
        update = new TableSpec(null, (Map)updatedProps, null);
        this.assertMergeFails(spec, update);
        updatedProps = ImmutableMap.of((Object)"hiddenColumns", Collections.singletonList("mumble"));
        update = new TableSpec(null, (Map)updatedProps, null);
        merged = this.mergeTables(spec, update);
        this.expectValidationSucceeds(merged);
        Assert.assertEquals(Arrays.asList("foo", "bar", "mumble"), merged.properties().get("hiddenColumns"));
    }

    @Test
    public void testMergeColsWithEmptyList() {
        ImmutableMap props = ImmutableMap.of((Object)"segmentGranularity", (Object)"P1D");
        TableSpec spec = new TableSpec("datasource", (Map)props, null);
        List<ColumnSpec> colUpdates = Collections.singletonList(new ColumnSpec("a", Columns.LONG, null));
        TableSpec update = new TableSpec(null, null, colUpdates);
        TableSpec merged = this.mergeTables(spec, update);
        List columns = merged.columns();
        Assert.assertEquals((long)1L, (long)columns.size());
        Assert.assertEquals((Object)"a", (Object)((ColumnSpec)columns.get(0)).name());
        Assert.assertEquals((Object)Columns.LONG, (Object)((ColumnSpec)columns.get(0)).dataType());
    }

    @Test
    public void testMergeCols() {
        TableSpec spec = this.exampleSpec();
        HashMap<String, String> updatedProps = new HashMap<String, String>();
        updatedProps.put("colProp1", "new value");
        updatedProps.put("colProp2", null);
        updatedProps.put("tag3", "third value");
        List<ColumnSpec> colUpdates = Arrays.asList(new ColumnSpec("a", Columns.LONG, updatedProps), new ColumnSpec("c", Columns.STRING, null));
        TableSpec update = new TableSpec(null, null, colUpdates);
        TableSpec merged = this.mergeTables(spec, update);
        Assert.assertNotEquals((Object)spec, (Object)merged);
        List columns = merged.columns();
        Assert.assertEquals((long)3L, (long)columns.size());
        Assert.assertEquals((Object)"a", (Object)((ColumnSpec)columns.get(0)).name());
        Assert.assertEquals((Object)Columns.LONG, (Object)((ColumnSpec)columns.get(0)).dataType());
        Map colProps = ((ColumnSpec)columns.get(0)).properties();
        Assert.assertEquals((long)2L, (long)colProps.size());
        Assert.assertEquals((Object)"new value", colProps.get("colProp1"));
        Assert.assertEquals((Object)"third value", colProps.get("tag3"));
        Assert.assertEquals((Object)"c", (Object)((ColumnSpec)columns.get(2)).name());
        Assert.assertEquals((Object)Columns.STRING, (Object)((ColumnSpec)columns.get(2)).dataType());
    }

    @Test
    @Ignore
    public void docExample() {
        TableSpec spec = TableBuilder.datasource((String)"foo", (String)"PT1H").description("Web server performance metrics").property("targetSegmentRows", (Object)1000000).hiddenColumns(new String[]{"foo", "bar"}).column("__time", Columns.LONG).column("host", Columns.STRING, (Map)ImmutableMap.of((Object)"description", (Object)"The web server host")).column("bytesSent", Columns.LONG, (Map)ImmutableMap.of((Object)"description", (Object)"Number of response bytes sent")).clusterColumns(new ClusterKeySpec[]{new ClusterKeySpec("a", Boolean.valueOf(false)), new ClusterKeySpec("b", Boolean.valueOf(true))}).sealed(true).buildSpec();
        LOG.info(spec.toString(), new Object[0]);
    }
}

