/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.discovery;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.druid.discovery.BrokerClient;
import org.apache.druid.discovery.DiscoveryDruidNode;
import org.apache.druid.discovery.DruidLeaderClientTest;
import org.apache.druid.discovery.DruidNodeDiscovery;
import org.apache.druid.discovery.DruidNodeDiscoveryProvider;
import org.apache.druid.discovery.NodeRole;
import org.apache.druid.guice.GuiceInjectors;
import org.apache.druid.guice.Jerseys;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.LifecycleModule;
import org.apache.druid.guice.annotations.Self;
import org.apache.druid.initialization.Initialization;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.java.util.http.client.Request;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.initialization.BaseJettyTest;
import org.apache.druid.server.initialization.jetty.JettyServerInitializer;
import org.easymock.EasyMock;
import org.eclipse.jetty.server.Server;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.junit.Assert;
import org.junit.Test;

public class BrokerClientTest
extends BaseJettyTest {
    private DiscoveryDruidNode discoveryDruidNode;
    private HttpClient httpClient;

    @Override
    protected Injector setupInjector() {
        DruidNode node = new DruidNode("test", "localhost", false, null, null, true, false);
        this.discoveryDruidNode = new DiscoveryDruidNode(node, NodeRole.BROKER, (Map)ImmutableMap.of());
        Injector injector = Initialization.makeInjectorWithModules((Injector)GuiceInjectors.makeStartupInjector(), (Iterable)ImmutableList.of(binder -> {
            JsonConfigProvider.bindInstance((Binder)binder, (Key)Key.get(DruidNode.class, Self.class), (Object)node);
            binder.bind(Integer.class).annotatedWith((Annotation)Names.named((String)"port")).toInstance((Object)node.getPlaintextPort());
            binder.bind(JettyServerInitializer.class).to(DruidLeaderClientTest.TestJettyServerInitializer.class).in(LazySingleton.class);
            Jerseys.addResource((Binder)binder, SimpleResource.class);
            LifecycleModule.register((Binder)binder, Server.class);
        }));
        this.httpClient = ((BaseJettyTest.ClientHolder)injector.getInstance(BaseJettyTest.ClientHolder.class)).getClient();
        return injector;
    }

    @Test
    public void testSimple() throws Exception {
        DruidNodeDiscovery druidNodeDiscovery = (DruidNodeDiscovery)EasyMock.createMock(DruidNodeDiscovery.class);
        EasyMock.expect((Object)druidNodeDiscovery.getAllNodes()).andReturn((Object)ImmutableList.of((Object)this.discoveryDruidNode)).anyTimes();
        DruidNodeDiscoveryProvider druidNodeDiscoveryProvider = (DruidNodeDiscoveryProvider)EasyMock.createMock(DruidNodeDiscoveryProvider.class);
        EasyMock.expect((Object)druidNodeDiscoveryProvider.getForNodeRole(NodeRole.BROKER)).andReturn((Object)druidNodeDiscovery);
        EasyMock.replay((Object[])new Object[]{druidNodeDiscovery, druidNodeDiscoveryProvider});
        BrokerClient brokerClient = new BrokerClient(this.httpClient, druidNodeDiscoveryProvider);
        Request request = brokerClient.makeRequest(HttpMethod.POST, "/simple/direct");
        request.setContent("hello".getBytes(StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"hello", (Object)brokerClient.sendQuery(request));
    }

    @Test
    public void testRetryableError() throws Exception {
        DruidNodeDiscovery druidNodeDiscovery = (DruidNodeDiscovery)EasyMock.createMock(DruidNodeDiscovery.class);
        EasyMock.expect((Object)druidNodeDiscovery.getAllNodes()).andReturn((Object)ImmutableList.of((Object)this.discoveryDruidNode)).anyTimes();
        DruidNodeDiscoveryProvider druidNodeDiscoveryProvider = (DruidNodeDiscoveryProvider)EasyMock.createMock(DruidNodeDiscoveryProvider.class);
        EasyMock.expect((Object)druidNodeDiscoveryProvider.getForNodeRole(NodeRole.BROKER)).andReturn((Object)druidNodeDiscovery);
        EasyMock.replay((Object[])new Object[]{druidNodeDiscovery, druidNodeDiscoveryProvider});
        BrokerClient brokerClient = new BrokerClient(this.httpClient, druidNodeDiscoveryProvider);
        Request request = brokerClient.makeRequest(HttpMethod.POST, "/simple/flakey");
        request.setContent("hello".getBytes(StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"hello", (Object)brokerClient.sendQuery(request));
    }

    @Test
    public void testNonRetryableError() throws Exception {
        DruidNodeDiscovery druidNodeDiscovery = (DruidNodeDiscovery)EasyMock.createMock(DruidNodeDiscovery.class);
        EasyMock.expect((Object)druidNodeDiscovery.getAllNodes()).andReturn((Object)ImmutableList.of((Object)this.discoveryDruidNode)).anyTimes();
        DruidNodeDiscoveryProvider druidNodeDiscoveryProvider = (DruidNodeDiscoveryProvider)EasyMock.createMock(DruidNodeDiscoveryProvider.class);
        EasyMock.expect((Object)druidNodeDiscoveryProvider.getForNodeRole(NodeRole.BROKER)).andReturn((Object)druidNodeDiscovery);
        EasyMock.replay((Object[])new Object[]{druidNodeDiscovery, druidNodeDiscoveryProvider});
        BrokerClient brokerClient = new BrokerClient(this.httpClient, druidNodeDiscoveryProvider);
        Request request = brokerClient.makeRequest(HttpMethod.POST, "/simple/error");
        Assert.assertEquals((Object)"", (Object)brokerClient.sendQuery(request));
    }

    @Path(value="/simple")
    public static class SimpleResource {
        private static int attempt = 0;

        @POST
        @Path(value="/direct")
        @Produces(value={"application/json"})
        public Response direct(String input) {
            if ("hello".equals(input)) {
                return Response.ok((Object)"hello").build();
            }
            return Response.serverError().build();
        }

        @POST
        @Path(value="/flakey")
        @Produces(value={"application/json"})
        public Response redirecting() {
            if (attempt > 2) {
                return Response.ok((Object)"hello").build();
            }
            ++attempt;
            return Response.status((int)504).build();
        }

        @POST
        @Path(value="/error")
        @Produces(value={"application/json"})
        public Response error() {
            return Response.status((int)404).build();
        }
    }
}

