/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.druid.indexing.overlord.DataSourceMetadata;
import org.apache.druid.indexing.overlord.ObjectMetadata;
import org.apache.druid.indexing.overlord.supervisor.NoopSupervisorSpec;
import org.apache.druid.indexing.overlord.supervisor.Supervisor;
import org.apache.druid.indexing.overlord.supervisor.SupervisorStateManager;
import org.apache.druid.indexing.overlord.supervisor.autoscaler.LagStats;
import org.apache.druid.indexing.overlord.supervisor.autoscaler.SupervisorTaskAutoScaler;
import org.junit.Assert;
import org.junit.Test;

public class NoopSupervisorSpecTest {
    @Test
    public void testNoopSupervisorSpecWithAutoscaler() {
        Exception e = null;
        try {
            NoopSupervisorSpec noopSupervisorSpec = new NoopSupervisorSpec(null, Collections.singletonList("datasource1"));
            Supervisor supervisor = noopSupervisorSpec.createSupervisor();
            SupervisorTaskAutoScaler autoscaler = noopSupervisorSpec.createAutoscaler(supervisor);
            Assert.assertNull((Object)autoscaler);
            Callable<Integer> noop = new Callable<Integer>(){

                @Override
                public Integer call() {
                    return -1;
                }
            };
            int count = supervisor.getActiveTaskGroupsCount();
            Assert.assertEquals((long)count, (long)-1L);
            LagStats lagStats = supervisor.computeLagStats();
            long totalLag = lagStats.getTotalLag();
            long avgLag = lagStats.getAvgLag();
            long maxLag = lagStats.getMaxLag();
            Assert.assertEquals((long)totalLag, (long)0L);
            Assert.assertEquals((long)avgLag, (long)0L);
            Assert.assertEquals((long)maxLag, (long)0L);
        }
        catch (Exception ex) {
            e = ex;
        }
        Assert.assertNull((Object)e);
    }

    @Test
    public void testInputSourceResources() {
        NoopSupervisorSpec noopSupervisorSpec = new NoopSupervisorSpec(null, Collections.singletonList("datasource1"));
        Assert.assertTrue((boolean)noopSupervisorSpec.getInputSourceResources().isEmpty());
    }

    @Test
    public void testNoppSupervisorResetOffsetsDoNothing() {
        NoopSupervisorSpec expectedSpec = new NoopSupervisorSpec(null, null);
        Supervisor noOpSupervisor = expectedSpec.createSupervisor();
        Assert.assertEquals((long)-1L, (long)noOpSupervisor.getActiveTaskGroupsCount());
        noOpSupervisor.resetOffsets(null);
        Assert.assertEquals((long)-1L, (long)noOpSupervisor.getActiveTaskGroupsCount());
        Assert.assertEquals((Object)SupervisorStateManager.BasicState.RUNNING, (Object)noOpSupervisor.getState());
        Assert.assertEquals((long)-1L, (long)noOpSupervisor.getActiveTaskGroupsCount());
        noOpSupervisor.resetOffsets((DataSourceMetadata)new ObjectMetadata((Object)"someObject"));
        Assert.assertEquals((long)-1L, (long)noOpSupervisor.getActiveTaskGroupsCount());
        Assert.assertEquals((Object)SupervisorStateManager.BasicState.RUNNING, (Object)noOpSupervisor.getState());
    }

    @Test
    public void testNoppSupervisorStopTaskEarlyDoNothing() {
        NoopSupervisorSpec expectedSpec = new NoopSupervisorSpec(null, null);
        Supervisor noOpSupervisor = expectedSpec.createSupervisor();
        Assert.assertThrows(UnsupportedOperationException.class, () -> noOpSupervisor.handoffTaskGroupsEarly((List)ImmutableList.of()));
    }
}

