/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata.input;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import org.apache.commons.io.IOUtils;
import org.apache.druid.data.input.InputEntity;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.MapBasedInputRow;
import org.apache.druid.metadata.SQLInputSourceDatabaseConnector;
import org.apache.druid.metadata.TestDerbyConnector;
import org.apache.druid.metadata.input.InputSourceModule;
import org.apache.druid.metadata.input.SqlEntity;
import org.apache.druid.metadata.input.SqlTestUtils;
import org.apache.druid.segment.TestHelper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class SqlEntityTest {
    @Rule
    public final TestDerbyConnector.DerbyConnectorRule derbyConnectorRule = new TestDerbyConnector.DerbyConnectorRule();
    private final ObjectMapper mapper = TestHelper.makeSmileMapper();
    private TestDerbyConnector derbyConnector;
    String TABLE_NAME_1 = "FOOS_TABLE";
    String VALID_SQL = "SELECT timestamp,a,b FROM FOOS_TABLE";
    String INVALID_SQL = "DONT SELECT timestamp,a,b FROM FOOS_TABLE";

    @Before
    public void setUp() {
        for (Module jacksonModule : new InputSourceModule().getJacksonModules()) {
            this.mapper.registerModule(jacksonModule);
        }
    }

    @Test
    public void testExecuteQuery() throws IOException {
        this.derbyConnector = this.derbyConnectorRule.getConnector();
        SqlTestUtils testUtils = new SqlTestUtils(this.derbyConnector);
        InputRow expectedRow = testUtils.createTableWithRows(this.TABLE_NAME_1, 1).get(0);
        File tmpFile = File.createTempFile("testQueryResults", "");
        InputEntity.CleanableFile queryResult = SqlEntity.openCleanableFile((String)this.VALID_SQL, (SQLInputSourceDatabaseConnector)testUtils.getDerbyInputSourceConnector(), (ObjectMapper)this.mapper, (boolean)true, (File)tmpFile);
        FileInputStream queryInputStream = new FileInputStream(queryResult.file());
        String actualJson = IOUtils.toString((InputStream)queryInputStream, (Charset)StandardCharsets.UTF_8);
        String expectedJson = this.mapper.writeValueAsString(Collections.singletonList(((MapBasedInputRow)expectedRow).getEvent()));
        Assert.assertEquals((Object)actualJson, (Object)expectedJson);
        testUtils.dropTable(this.TABLE_NAME_1);
    }

    @Test
    public void testFileDeleteOnInvalidQuery() throws IOException {
        this.derbyConnector = this.derbyConnectorRule.getConnector();
        SqlTestUtils testUtils = new SqlTestUtils(this.derbyConnector);
        testUtils.createTableWithRows(this.TABLE_NAME_1, 1);
        File tmpFile = File.createTempFile("testQueryResults", "");
        Assert.assertTrue((boolean)tmpFile.exists());
        Assert.assertThrows(IOException.class, () -> SqlEntity.openCleanableFile((String)this.INVALID_SQL, (SQLInputSourceDatabaseConnector)testUtils.getDerbyInputSourceConnector(), (ObjectMapper)this.mapper, (boolean)true, (File)tmpFile));
        Assert.assertFalse((boolean)tmpFile.exists());
    }
}

