/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.rpc;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.io.ByteStreams;
import java.io.InputStream;
import java.net.URI;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.http.client.Request;
import org.apache.druid.rpc.RequestBuilder;
import org.apache.druid.rpc.ServiceLocation;
import org.apache.druid.segment.TestHelper;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jboss.netty.buffer.ChannelBufferInputStream;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.joda.time.Duration;
import org.junit.Assert;
import org.junit.Test;
import org.junit.internal.matchers.ThrowableMessageMatcher;

public class RequestBuilderTest {
    @Test
    public void test_constructor_noLeadingSlash() {
        IllegalArgumentException e = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> new RequestBuilder(HttpMethod.GET, "q"));
        MatcherAssert.assertThat((Object)e, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"Path must start with '/'")));
    }

    @Test
    public void test_build_getPlaintext() throws Exception {
        Request request = new RequestBuilder(HttpMethod.GET, "/q").header("x-test-header", "abc").header("x-test-header-2", "def").build(new ServiceLocation("example.com", 8888, -1, ""));
        Assert.assertEquals((Object)HttpMethod.GET, (Object)request.getMethod());
        Assert.assertEquals((Object)new URI("http://example.com:8888/q").toURL(), (Object)request.getUrl());
        Assert.assertEquals((Object)"abc", (Object)Iterables.getOnlyElement((Iterable)request.getHeaders().get((Object)"x-test-header")));
        Assert.assertEquals((Object)"def", (Object)Iterables.getOnlyElement((Iterable)request.getHeaders().get((Object)"x-test-header-2")));
        Assert.assertFalse((boolean)request.hasContent());
    }

    @Test
    public void test_build_getTls() throws Exception {
        Request request = new RequestBuilder(HttpMethod.GET, "/q").header("x-test-header", "abc").header("x-test-header-2", "def").build(new ServiceLocation("example.com", 9999, 8888, ""));
        Assert.assertEquals((Object)HttpMethod.GET, (Object)request.getMethod());
        Assert.assertEquals((Object)new URI("https://example.com:8888/q").toURL(), (Object)request.getUrl());
        Assert.assertEquals((Object)"abc", (Object)Iterables.getOnlyElement((Iterable)request.getHeaders().get((Object)"x-test-header")));
        Assert.assertEquals((Object)"def", (Object)Iterables.getOnlyElement((Iterable)request.getHeaders().get((Object)"x-test-header-2")));
        Assert.assertFalse((boolean)request.hasContent());
    }

    @Test
    public void test_build_getTlsWithBasePath() throws Exception {
        Request request = new RequestBuilder(HttpMethod.GET, "/q").header("x-test-header", "abc").header("x-test-header-2", "def").build(new ServiceLocation("example.com", 9999, 8888, "/base"));
        Assert.assertEquals((Object)HttpMethod.GET, (Object)request.getMethod());
        Assert.assertEquals((Object)new URI("https://example.com:8888/base/q").toURL(), (Object)request.getUrl());
        Assert.assertEquals((Object)"abc", (Object)Iterables.getOnlyElement((Iterable)request.getHeaders().get((Object)"x-test-header")));
        Assert.assertEquals((Object)"def", (Object)Iterables.getOnlyElement((Iterable)request.getHeaders().get((Object)"x-test-header-2")));
        Assert.assertFalse((boolean)request.hasContent());
    }

    @Test
    public void test_build_postTlsNoContent() throws Exception {
        Request request = new RequestBuilder(HttpMethod.POST, "/q").header("x-test-header", "abc").header("x-test-header-2", "def").build(new ServiceLocation("example.com", 9999, 8888, ""));
        Assert.assertEquals((Object)HttpMethod.POST, (Object)request.getMethod());
        Assert.assertEquals((Object)new URI("https://example.com:8888/q").toURL(), (Object)request.getUrl());
        Assert.assertEquals((Object)"abc", (Object)Iterables.getOnlyElement((Iterable)request.getHeaders().get((Object)"x-test-header")));
        Assert.assertEquals((Object)"def", (Object)Iterables.getOnlyElement((Iterable)request.getHeaders().get((Object)"x-test-header-2")));
        Assert.assertFalse((boolean)request.hasContent());
    }

    @Test
    public void test_build_postTlsWithContent() throws Exception {
        String json = "{\"foo\": 3}";
        Request request = new RequestBuilder(HttpMethod.POST, "/q").header("x-test-header", "abc").header("x-test-header-2", "def").content("application/json", StringUtils.toUtf8((String)"{\"foo\": 3}")).build(new ServiceLocation("example.com", 9999, 8888, ""));
        Assert.assertEquals((Object)HttpMethod.POST, (Object)request.getMethod());
        Assert.assertEquals((Object)new URI("https://example.com:8888/q").toURL(), (Object)request.getUrl());
        Assert.assertEquals((Object)"abc", (Object)Iterables.getOnlyElement((Iterable)request.getHeaders().get((Object)"x-test-header")));
        Assert.assertEquals((Object)"def", (Object)Iterables.getOnlyElement((Iterable)request.getHeaders().get((Object)"x-test-header-2")));
        Assert.assertTrue((boolean)request.hasContent());
        Assert.assertEquals((Object)"{\"foo\": 3}", (Object)StringUtils.fromUtf8((byte[])ByteStreams.toByteArray((InputStream)new ChannelBufferInputStream(request.getContent()))));
    }

    @Test
    public void test_build_postTlsWithJsonContent() throws Exception {
        Request request = new RequestBuilder(HttpMethod.POST, "/q").header("x-test-header", "abc").header("x-test-header-2", "def").jsonContent(TestHelper.makeJsonMapper(), (Object)ImmutableMap.of((Object)"foo", (Object)3)).build(new ServiceLocation("example.com", 9999, 8888, ""));
        Assert.assertEquals((Object)HttpMethod.POST, (Object)request.getMethod());
        Assert.assertEquals((Object)new URI("https://example.com:8888/q").toURL(), (Object)request.getUrl());
        Assert.assertEquals((Object)"abc", (Object)Iterables.getOnlyElement((Iterable)request.getHeaders().get((Object)"x-test-header")));
        Assert.assertEquals((Object)"def", (Object)Iterables.getOnlyElement((Iterable)request.getHeaders().get((Object)"x-test-header-2")));
        Assert.assertTrue((boolean)request.hasContent());
        Assert.assertEquals((Object)"{\"foo\":3}", (Object)StringUtils.fromUtf8((byte[])ByteStreams.toByteArray((InputStream)new ChannelBufferInputStream(request.getContent()))));
    }

    @Test
    public void test_timeout() {
        Assert.assertEquals((Object)RequestBuilder.DEFAULT_TIMEOUT, (Object)new RequestBuilder(HttpMethod.GET, "/q").getTimeout());
        Assert.assertEquals((Object)Duration.standardSeconds((long)1L), (Object)new RequestBuilder(HttpMethod.GET, "/q").timeout(Duration.standardSeconds((long)1L)).getTimeout());
        Assert.assertEquals((Object)Duration.ZERO, (Object)new RequestBuilder(HttpMethod.GET, "/q").timeout(Duration.ZERO).getTimeout());
    }
}

