/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.loading;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.multibindings.MapBinder;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.guice.Binders;
import org.apache.druid.guice.GuiceInjectors;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.segment.loading.DataSegmentMover;
import org.apache.druid.segment.loading.OmniDataSegmentMover;
import org.apache.druid.segment.loading.SegmentLoadingException;
import org.apache.druid.timeline.DataSegment;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class OmniDataSegmentMoverTest {
    @Test
    public void testMoveSegmentWithType() throws SegmentLoadingException {
        DataSegmentMover mover = (DataSegmentMover)Mockito.mock(DataSegmentMover.class);
        DataSegment segment = (DataSegment)Mockito.mock(DataSegment.class);
        Mockito.when((Object)segment.getLoadSpec()).thenReturn((Object)ImmutableMap.of((Object)"type", (Object)"sane"));
        Injector injector = OmniDataSegmentMoverTest.createInjector(mover);
        OmniDataSegmentMover segmentMover = (OmniDataSegmentMover)injector.getInstance(OmniDataSegmentMover.class);
        segmentMover.move(segment, (Map)ImmutableMap.of());
        ((DataSegmentMover)Mockito.verify((Object)mover, (VerificationMode)Mockito.times((int)1))).move(segment, (Map)ImmutableMap.of());
    }

    @Test
    public void testMoveSegmentUnknownType() {
        DataSegment segment = (DataSegment)Mockito.mock(DataSegment.class);
        Mockito.when((Object)segment.getLoadSpec()).thenReturn((Object)ImmutableMap.of((Object)"type", (Object)"unknown-type"));
        Injector injector = OmniDataSegmentMoverTest.createInjector(null);
        OmniDataSegmentMover segmentMover = (OmniDataSegmentMover)injector.getInstance(OmniDataSegmentMover.class);
        Assert.assertThrows((String)"Unknown loader type[unknown-type]. Known types are [explode]", SegmentLoadingException.class, () -> segmentMover.move(segment, (Map)ImmutableMap.of()));
    }

    @Test
    public void testBadSegmentMoverAccessException() {
        DataSegment segment = (DataSegment)Mockito.mock(DataSegment.class);
        Mockito.when((Object)segment.getLoadSpec()).thenReturn((Object)ImmutableMap.of((Object)"type", (Object)"bad"));
        Injector injector = OmniDataSegmentMoverTest.createInjector(null);
        OmniDataSegmentMover segmentMover = (OmniDataSegmentMover)injector.getInstance(OmniDataSegmentMover.class);
        Assert.assertThrows((String)"BadSegmentMover must not have been initialized", RuntimeException.class, () -> segmentMover.move(segment, null));
    }

    private static Injector createInjector(@Nullable DataSegmentMover mover) {
        return GuiceInjectors.makeStartupInjectorWithModules((Iterable)ImmutableList.of(binder -> {
            MapBinder mapBinder = Binders.dataSegmentMoverBinder((Binder)binder);
            if (mover != null) {
                mapBinder.addBinding((Object)"sane").toInstance((Object)mover);
            }
        }, binder -> {
            MapBinder mapBinder = Binders.dataSegmentMoverBinder((Binder)binder);
            mapBinder.addBinding((Object)"bad").to(BadSegmentMover.class);
        }));
    }

    @LazySingleton
    private static class BadSegmentMover
    implements DataSegmentMover {
        @Inject
        BadSegmentMover() {
            throw new RuntimeException("BadSegmentMover must not have been initialized");
        }

        public DataSegment move(DataSegment segment, Map<String, Object> targetLoadSpec) {
            return null;
        }
    }
}

