/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Ordering;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.MapUtils;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.segment.ReferenceCountingSegment;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.SegmentLazyLoadFailCallback;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.TestIndex;
import org.apache.druid.segment.loading.LeastBytesUsedStorageLocationSelectorStrategy;
import org.apache.druid.segment.loading.SegmentCacheManager;
import org.apache.druid.segment.loading.SegmentLoaderConfig;
import org.apache.druid.segment.loading.SegmentLoadingException;
import org.apache.druid.segment.loading.SegmentLocalCacheManager;
import org.apache.druid.segment.loading.StorageLocationConfig;
import org.apache.druid.segment.loading.StorageLocationSelectorStrategy;
import org.apache.druid.server.SegmentManager;
import org.apache.druid.server.TestSegmentUtils;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.VersionedIntervalTimeline;
import org.apache.druid.timeline.partition.NumberedOverwriteShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.joda.time.Interval;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class SegmentManagerTest {
    private static final List<DataSegment> SEGMENTS = ImmutableList.of((Object)TestSegmentUtils.makeSegment("small_source", "0", Intervals.of((String)"0/1000")), (Object)TestSegmentUtils.makeSegment("small_source", "0", Intervals.of((String)"1000/2000")), (Object)TestSegmentUtils.makeSegment("large_source", "0", Intervals.of((String)"0/1000")), (Object)TestSegmentUtils.makeSegment("large_source", "0", Intervals.of((String)"1000/2000")), (Object)TestSegmentUtils.makeSegment("large_source", "1", Intervals.of((String)"1000/2000")));
    private ExecutorService executor;
    private SegmentManager segmentManager;
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Before
    public void setup() throws IOException {
        final File segmentCacheDir = this.temporaryFolder.newFolder();
        SegmentLoaderConfig loaderConfig = new SegmentLoaderConfig(){

            public File getInfoDir() {
                return segmentCacheDir;
            }

            public List<StorageLocationConfig> getLocations() {
                return Collections.singletonList(new StorageLocationConfig(segmentCacheDir, null, null));
            }
        };
        ObjectMapper objectMapper = TestHelper.makeJsonMapper();
        objectMapper.registerSubtypes(new Class[]{TestSegmentUtils.TestLoadSpec.class});
        objectMapper.registerSubtypes(new Class[]{TestSegmentUtils.TestSegmentizerFactory.class});
        List storageLocations = loaderConfig.toStorageLocations();
        SegmentLocalCacheManager cacheManager = new SegmentLocalCacheManager(storageLocations, loaderConfig, (StorageLocationSelectorStrategy)new LeastBytesUsedStorageLocationSelectorStrategy(storageLocations), TestIndex.INDEX_IO, objectMapper);
        this.segmentManager = new SegmentManager((SegmentCacheManager)cacheManager);
        this.executor = Execs.multiThreaded((int)SEGMENTS.size(), (String)"SegmentManagerTest-%d");
    }

    @After
    public void tearDown() {
        this.executor.shutdownNow();
    }

    @Test
    public void testLoadSegment() throws ExecutionException, InterruptedException {
        List loadFutures = SEGMENTS.stream().map(segment -> this.executor.submit(() -> this.loadSegmentOrFail((DataSegment)segment))).collect(Collectors.toList());
        for (Future loadFuture : loadFutures) {
            loadFuture.get();
        }
        this.assertResult(SEGMENTS);
    }

    @Test
    public void testLoadBootstrapSegment() throws ExecutionException, InterruptedException {
        List loadFutures = SEGMENTS.stream().map(segment -> this.executor.submit(() -> {
            try {
                this.segmentManager.loadSegmentOnBootstrap(segment, SegmentLazyLoadFailCallback.NOOP);
            }
            catch (IOException | SegmentLoadingException e) {
                throw new RuntimeException(e);
            }
            return null;
        })).collect(Collectors.toList());
        for (Future loadFuture : loadFutures) {
            loadFuture.get();
        }
        this.assertResult(SEGMENTS);
    }

    @Test
    public void testDropSegment() throws SegmentLoadingException, ExecutionException, InterruptedException, IOException {
        for (DataSegment eachSegment : SEGMENTS) {
            this.segmentManager.loadSegment(eachSegment);
        }
        List futures = ImmutableList.of((Object)SEGMENTS.get(0), (Object)SEGMENTS.get(2)).stream().map(segment -> this.executor.submit(() -> {
            this.segmentManager.dropSegment(segment);
            return null;
        })).collect(Collectors.toList());
        for (Future eachFuture : futures) {
            eachFuture.get();
        }
        this.assertResult((List<DataSegment>)ImmutableList.of((Object)SEGMENTS.get(1), (Object)SEGMENTS.get(3), (Object)SEGMENTS.get(4)));
    }

    private Void loadSegmentOrFail(DataSegment segment) {
        try {
            this.segmentManager.loadSegment(segment);
        }
        catch (IOException | SegmentLoadingException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    @Test
    public void testLoadDropSegment() throws SegmentLoadingException, ExecutionException, InterruptedException, IOException {
        this.segmentManager.loadSegment(SEGMENTS.get(0));
        this.segmentManager.loadSegment(SEGMENTS.get(2));
        List loadFutures = ImmutableList.of((Object)SEGMENTS.get(1), (Object)SEGMENTS.get(3), (Object)SEGMENTS.get(4)).stream().map(segment -> this.executor.submit(() -> this.loadSegmentOrFail((DataSegment)segment))).collect(Collectors.toList());
        List dropFutures = ImmutableList.of((Object)SEGMENTS.get(0), (Object)SEGMENTS.get(2)).stream().map(segment -> this.executor.submit(() -> {
            this.segmentManager.dropSegment(segment);
            return null;
        })).collect(Collectors.toList());
        for (Future loadFuture : loadFutures) {
            loadFuture.get();
        }
        for (Future dropFuture : dropFutures) {
            dropFuture.get();
        }
        this.assertResult((List<DataSegment>)ImmutableList.of((Object)SEGMENTS.get(1), (Object)SEGMENTS.get(3), (Object)SEGMENTS.get(4)));
    }

    @Test
    public void testLoadDuplicatedSegmentsSequentially() throws SegmentLoadingException, IOException {
        for (DataSegment segment : SEGMENTS) {
            this.segmentManager.loadSegment(segment);
        }
        this.segmentManager.loadSegment(SEGMENTS.get(0));
        this.assertResult(SEGMENTS);
    }

    @Test
    public void testLoadDuplicatedSegmentsInParallel() throws ExecutionException, InterruptedException {
        List loadFutures = ImmutableList.of((Object)SEGMENTS.get(0), (Object)SEGMENTS.get(0), (Object)SEGMENTS.get(0)).stream().map(segment -> this.executor.submit(() -> this.loadSegmentOrFail((DataSegment)segment))).collect(Collectors.toList());
        for (Future loadFuture : loadFutures) {
            loadFuture.get();
        }
        this.assertResult((List<DataSegment>)ImmutableList.of((Object)SEGMENTS.get(0)));
    }

    @Test
    public void testNonExistingSegmentsSequentially() throws SegmentLoadingException, IOException {
        this.segmentManager.loadSegment(SEGMENTS.get(0));
        this.segmentManager.dropSegment(SEGMENTS.get(2));
        this.assertResult((List<DataSegment>)ImmutableList.of((Object)SEGMENTS.get(0)));
    }

    @Test
    public void testNonExistingSegmentsInParallel() throws SegmentLoadingException, ExecutionException, InterruptedException, IOException {
        this.segmentManager.loadSegment(SEGMENTS.get(0));
        List futures = ImmutableList.of((Object)SEGMENTS.get(1), (Object)SEGMENTS.get(2)).stream().map(segment -> this.executor.submit(() -> {
            this.segmentManager.dropSegment(segment);
            return null;
        })).collect(Collectors.toList());
        for (Future future : futures) {
            future.get();
        }
        this.assertResult((List<DataSegment>)ImmutableList.of((Object)SEGMENTS.get(0)));
    }

    @Test
    public void testRemoveEmptyTimeline() throws SegmentLoadingException, IOException {
        this.segmentManager.loadSegment(SEGMENTS.get(0));
        this.assertResult((List<DataSegment>)ImmutableList.of((Object)SEGMENTS.get(0)));
        Assert.assertEquals((long)1L, (long)this.segmentManager.getDataSources().size());
        this.segmentManager.dropSegment(SEGMENTS.get(0));
        Assert.assertEquals((long)0L, (long)this.segmentManager.getDataSources().size());
    }

    @Test
    public void testGetNonExistingTimeline() {
        Assert.assertEquals(Optional.empty(), (Object)this.segmentManager.getTimeline(new TableDataSource("nonExisting").getAnalysis()));
    }

    @Test
    public void testLoadAndDropNonRootGenerationSegment() throws SegmentLoadingException, IOException {
        DataSegment segment = new DataSegment("small_source", Intervals.of((String)"0/1000"), "0", (Map)ImmutableMap.of((Object)"type", (Object)"test", (Object)"interval", (Object)Intervals.of((String)"0/1000"), (Object)"version", (Object)0), new ArrayList(), new ArrayList(), (ShardSpec)new NumberedOverwriteShardSpec(32778, 10, 20, 1, 1), Integer.valueOf(0), 10L);
        this.segmentManager.loadSegment(segment);
        this.assertResult((List<DataSegment>)ImmutableList.of((Object)segment));
        this.segmentManager.dropSegment(segment);
        this.assertResult((List<DataSegment>)ImmutableList.of());
    }

    private void assertResult(List<DataSegment> expectedExistingSegments) {
        Map<String, Long> expectedDataSourceSizes = expectedExistingSegments.stream().collect(Collectors.toMap(DataSegment::getDataSource, DataSegment::getSize, Long::sum));
        Map<String, Long> expectedDataSourceCounts = expectedExistingSegments.stream().collect(Collectors.toMap(DataSegment::getDataSource, segment -> 1L, Long::sum));
        Set expectedDataSourceNames = expectedExistingSegments.stream().map(DataSegment::getDataSource).collect(Collectors.toSet());
        HashMap<String, VersionedIntervalTimeline> expectedTimelines = new HashMap<String, VersionedIntervalTimeline>();
        for (DataSegment segment2 : expectedExistingSegments) {
            VersionedIntervalTimeline expectedTimeline = expectedTimelines.computeIfAbsent(segment2.getDataSource(), k -> new VersionedIntervalTimeline((Comparator)Ordering.natural()));
            expectedTimeline.add(segment2.getInterval(), (Object)segment2.getVersion(), segment2.getShardSpec().createChunk((Object)ReferenceCountingSegment.wrapSegment((Segment)ReferenceCountingSegment.wrapSegment((Segment)new TestSegmentUtils.SegmentForTesting(segment2.getDataSource(), (Interval)segment2.getLoadSpec().get("interval"), MapUtils.getString((Map)segment2.getLoadSpec(), (String)"version")), (ShardSpec)segment2.getShardSpec()), (ShardSpec)segment2.getShardSpec())));
        }
        Assert.assertEquals(expectedDataSourceNames, (Object)this.segmentManager.getDataSourceNames());
        Assert.assertEquals(expectedDataSourceCounts, (Object)this.segmentManager.getDataSourceCounts());
        Assert.assertEquals(expectedDataSourceSizes, (Object)this.segmentManager.getDataSourceSizes());
        Map dataSources = this.segmentManager.getDataSources();
        Assert.assertEquals((long)expectedTimelines.size(), (long)dataSources.size());
        dataSources.forEach((sourceName, dataSourceState) -> {
            Assert.assertEquals((long)((Long)expectedDataSourceCounts.get(sourceName)), (long)dataSourceState.getNumSegments());
            Assert.assertEquals((long)((Long)expectedDataSourceSizes.get(sourceName)), (long)dataSourceState.getTotalSegmentSize());
            Assert.assertEquals((Object)((VersionedIntervalTimeline)expectedTimelines.get(sourceName)).getAllTimelineEntries(), (Object)dataSourceState.getTimeline().getAllTimelineEntries());
        });
    }
}

