/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordination;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.concurrent.ScheduledExecutorFactory;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.metrics.StubServiceEmitter;
import org.apache.druid.segment.loading.SegmentCacheManager;
import org.apache.druid.segment.loading.SegmentLoaderConfig;
import org.apache.druid.segment.loading.StorageLocationConfig;
import org.apache.druid.server.SegmentManager;
import org.apache.druid.server.TestSegmentUtils;
import org.apache.druid.server.coordination.DataSegmentAnnouncer;
import org.apache.druid.server.coordination.DataSegmentChangeCallback;
import org.apache.druid.server.coordination.DataSegmentChangeRequest;
import org.apache.druid.server.coordination.DataSegmentChangeResponse;
import org.apache.druid.server.coordination.SegmentChangeRequestDrop;
import org.apache.druid.server.coordination.SegmentChangeRequestLoad;
import org.apache.druid.server.coordination.SegmentChangeStatus;
import org.apache.druid.server.coordination.SegmentLoadDropHandler;
import org.apache.druid.server.coordination.TestDataSegmentAnnouncer;
import org.apache.druid.server.coordination.TestSegmentCacheManager;
import org.apache.druid.timeline.DataSegment;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class SegmentLoadDropHandlerTest {
    private TestDataSegmentAnnouncer segmentAnnouncer;
    private List<Runnable> scheduledRunnable;
    private SegmentLoaderConfig segmentLoaderConfig;
    private ScheduledExecutorFactory scheduledExecutorFactory;
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Before
    public void setUp() throws IOException {
        final File segmentCacheDir = this.temporaryFolder.newFolder();
        this.scheduledRunnable = new ArrayList<Runnable>();
        this.segmentAnnouncer = new TestDataSegmentAnnouncer();
        this.segmentLoaderConfig = new SegmentLoaderConfig(){

            public File getInfoDir() {
                return segmentCacheDir;
            }

            public int getNumLoadingThreads() {
                return 5;
            }

            public int getAnnounceIntervalMillis() {
                return 50;
            }

            public List<StorageLocationConfig> getLocations() {
                return Collections.singletonList(new StorageLocationConfig(segmentCacheDir, null, null));
            }

            public int getDropSegmentDelayMillis() {
                return 0;
            }
        };
        this.scheduledExecutorFactory = (corePoolSize, nameFormat) -> new ScheduledThreadPoolExecutor(corePoolSize, Execs.makeThreadFactory((String)nameFormat)){

            @Override
            public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
                SegmentLoadDropHandlerTest.this.scheduledRunnable.add(command);
                return null;
            }
        };
        EmittingLogger.registerEmitter((ServiceEmitter)new StubServiceEmitter());
    }

    @Test
    public void testSegmentLoading1() {
        TestSegmentCacheManager cacheManager = new TestSegmentCacheManager();
        SegmentManager segmentManager = new SegmentManager((SegmentCacheManager)cacheManager);
        SegmentLoadDropHandler handler = this.initSegmentLoadDropHandler(segmentManager);
        DataSegment segment = TestSegmentUtils.makeSegment("test", "1", Intervals.of((String)"P1d/2011-04-01"));
        handler.removeSegment(segment, DataSegmentChangeCallback.NOOP);
        Assert.assertFalse((boolean)this.segmentAnnouncer.getObservedSegments().contains(segment));
        handler.addSegment(segment, DataSegmentChangeCallback.NOOP);
        for (Runnable runnable : this.scheduledRunnable) {
            runnable.run();
        }
        Assert.assertEquals((Object)ImmutableList.of((Object)segment), cacheManager.getObservedSegments());
        Assert.assertEquals((Object)ImmutableList.of((Object)segment), cacheManager.getObservedSegmentsLoadedIntoPageCache());
        Assert.assertEquals((Object)ImmutableList.of(), cacheManager.getObservedBootstrapSegments());
        Assert.assertEquals((Object)ImmutableList.of(), cacheManager.getObservedBootstrapSegmentsLoadedIntoPageCache());
        Assert.assertEquals((Object)ImmutableList.of((Object)segment), this.segmentAnnouncer.getObservedSegments());
        Assert.assertFalse((String)"segment files shouldn't be deleted", (boolean)cacheManager.getObservedSegmentsRemovedFromCache().contains(segment));
    }

    @Test
    public void testSegmentLoading2() {
        TestSegmentCacheManager cacheManager = new TestSegmentCacheManager();
        SegmentManager segmentManager = new SegmentManager((SegmentCacheManager)cacheManager);
        SegmentLoadDropHandler handler = this.initSegmentLoadDropHandler(segmentManager);
        DataSegment segment = TestSegmentUtils.makeSegment("test", "1", Intervals.of((String)"P1d/2011-04-01"));
        handler.addSegment(segment, DataSegmentChangeCallback.NOOP);
        Assert.assertTrue((boolean)this.segmentAnnouncer.getObservedSegments().contains(segment));
        handler.removeSegment(segment, DataSegmentChangeCallback.NOOP);
        Assert.assertFalse((boolean)this.segmentAnnouncer.getObservedSegments().contains(segment));
        handler.addSegment(segment, DataSegmentChangeCallback.NOOP);
        for (Runnable runnable : this.scheduledRunnable) {
            runnable.run();
        }
        Assert.assertEquals((Object)ImmutableList.of((Object)segment, (Object)segment), cacheManager.getObservedSegments());
        Assert.assertEquals((Object)ImmutableList.of((Object)segment), cacheManager.getObservedSegmentsLoadedIntoPageCache());
        Assert.assertEquals((Object)ImmutableList.of(), cacheManager.getObservedBootstrapSegments());
        Assert.assertEquals((Object)ImmutableList.of(), cacheManager.getObservedBootstrapSegmentsLoadedIntoPageCache());
        Assert.assertTrue((boolean)this.segmentAnnouncer.getObservedSegments().contains(segment));
        Assert.assertFalse((String)"segment files shouldn't be deleted", (boolean)cacheManager.getObservedSegmentsRemovedFromCache().contains(segment));
    }

    @Test(timeout=60000L)
    public void testProcessBatch() throws Exception {
        TestSegmentCacheManager cacheManager = new TestSegmentCacheManager();
        SegmentManager segmentManager = new SegmentManager((SegmentCacheManager)cacheManager);
        SegmentLoadDropHandler handler = this.initSegmentLoadDropHandler(segmentManager);
        DataSegment segment1 = TestSegmentUtils.makeSegment("batchtest1", "1", Intervals.of((String)"P1d/2011-04-01"));
        DataSegment segment2 = TestSegmentUtils.makeSegment("batchtest2", "1", Intervals.of((String)"P1d/2011-04-01"));
        ImmutableList batch = ImmutableList.of((Object)new SegmentChangeRequestLoad(segment1), (Object)new SegmentChangeRequestDrop(segment2));
        ListenableFuture future = handler.processBatch((List)batch);
        HashMap<DataSegmentChangeRequest, SegmentChangeStatus> expectedStatusMap = new HashMap<DataSegmentChangeRequest, SegmentChangeStatus>();
        expectedStatusMap.put((DataSegmentChangeRequest)batch.get(0), SegmentChangeStatus.PENDING);
        expectedStatusMap.put((DataSegmentChangeRequest)batch.get(1), SegmentChangeStatus.SUCCESS);
        List result = (List)future.get();
        for (DataSegmentChangeResponse requestAndStatus : result) {
            Assert.assertEquals(expectedStatusMap.get(requestAndStatus.getRequest()), (Object)requestAndStatus.getStatus());
        }
        for (Runnable runnable : this.scheduledRunnable) {
            runnable.run();
        }
        result = (List)handler.processBatch((List)ImmutableList.of((Object)new SegmentChangeRequestLoad(segment1))).get();
        Assert.assertEquals((Object)SegmentChangeStatus.SUCCESS, (Object)((DataSegmentChangeResponse)result.get(0)).getStatus());
        Assert.assertEquals((Object)ImmutableList.of((Object)segment1), this.segmentAnnouncer.getObservedSegments());
        ImmutableList expectedSegments = ImmutableList.of((Object)segment1);
        Assert.assertEquals((Object)expectedSegments, cacheManager.getObservedSegments());
        Assert.assertEquals((Object)expectedSegments, cacheManager.getObservedSegmentsLoadedIntoPageCache());
        Assert.assertEquals((Object)ImmutableList.of(), cacheManager.getObservedBootstrapSegments());
        Assert.assertEquals((Object)ImmutableList.of(), cacheManager.getObservedBootstrapSegmentsLoadedIntoPageCache());
    }

    @Test(timeout=60000L)
    public void testProcessBatchDuplicateLoadRequestsWhenFirstRequestFailsSecondRequestShouldSucceed() throws Exception {
        SegmentManager segmentManager = (SegmentManager)Mockito.mock(SegmentManager.class);
        ((SegmentManager)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("segment loading failure test")}).doNothing().when((Object)segmentManager)).loadSegment((DataSegment)ArgumentMatchers.any());
        SegmentLoadDropHandler handler = this.initSegmentLoadDropHandler(segmentManager);
        DataSegment segment1 = TestSegmentUtils.makeSegment("batchtest1", "1", Intervals.of((String)"P1d/2011-04-01"));
        ImmutableList batch = ImmutableList.of((Object)new SegmentChangeRequestLoad(segment1));
        ListenableFuture future = handler.processBatch((List)batch);
        for (Runnable runnable : this.scheduledRunnable) {
            runnable.run();
        }
        List result = (List)future.get();
        Assert.assertEquals((Object)SegmentChangeStatus.State.FAILED, (Object)((DataSegmentChangeResponse)result.get(0)).getStatus().getState());
        Assert.assertEquals((Object)ImmutableList.of(), this.segmentAnnouncer.getObservedSegments());
        future = handler.processBatch((List)batch);
        for (Runnable runnable : this.scheduledRunnable) {
            runnable.run();
        }
        result = (List)future.get();
        Assert.assertEquals((Object)SegmentChangeStatus.State.SUCCESS, (Object)((DataSegmentChangeResponse)result.get(0)).getStatus().getState());
        Assert.assertEquals((Object)ImmutableList.of((Object)segment1, (Object)segment1), this.segmentAnnouncer.getObservedSegments());
    }

    @Test(timeout=60000L)
    public void testProcessBatchLoadDropLoadSequenceForSameSegment() throws Exception {
        SegmentManager segmentManager = (SegmentManager)Mockito.mock(SegmentManager.class);
        ((SegmentManager)Mockito.doNothing().when((Object)segmentManager)).loadSegment((DataSegment)ArgumentMatchers.any());
        ((SegmentManager)Mockito.doNothing().when((Object)segmentManager)).dropSegment((DataSegment)ArgumentMatchers.any());
        final File storageDir = this.temporaryFolder.newFolder();
        SegmentLoaderConfig noAnnouncerSegmentLoaderConfig = new SegmentLoaderConfig(){

            public File getInfoDir() {
                return storageDir;
            }

            public int getNumLoadingThreads() {
                return 5;
            }

            public int getAnnounceIntervalMillis() {
                return 0;
            }

            public List<StorageLocationConfig> getLocations() {
                return Collections.singletonList(new StorageLocationConfig(storageDir, null, null));
            }

            public int getDropSegmentDelayMillis() {
                return 0;
            }
        };
        SegmentLoadDropHandler handler = this.initSegmentLoadDropHandler(noAnnouncerSegmentLoaderConfig, segmentManager);
        DataSegment segment1 = TestSegmentUtils.makeSegment("batchtest1", "1", Intervals.of((String)"P1d/2011-04-01"));
        ImmutableList batch = ImmutableList.of((Object)new SegmentChangeRequestLoad(segment1));
        ListenableFuture future = handler.processBatch((List)batch);
        for (Runnable runnable : this.scheduledRunnable) {
            runnable.run();
        }
        List result = (List)future.get();
        Assert.assertEquals((Object)SegmentChangeStatus.State.SUCCESS, (Object)((DataSegmentChangeResponse)result.get(0)).getStatus().getState());
        Assert.assertEquals((Object)ImmutableList.of((Object)segment1), this.segmentAnnouncer.getObservedSegments());
        this.scheduledRunnable.clear();
        batch = ImmutableList.of((Object)new SegmentChangeRequestDrop(segment1));
        future = handler.processBatch((List)batch);
        for (Runnable runnable : this.scheduledRunnable) {
            runnable.run();
        }
        result = (List)future.get();
        Assert.assertEquals((Object)SegmentChangeStatus.State.SUCCESS, (Object)((DataSegmentChangeResponse)result.get(0)).getStatus().getState());
        Assert.assertEquals((Object)ImmutableList.of(), this.segmentAnnouncer.getObservedSegments());
        Assert.assertFalse((boolean)this.segmentAnnouncer.getObservedSegments().contains(segment1));
        this.scheduledRunnable.clear();
        ((SegmentManager)Mockito.verify((Object)segmentManager, (VerificationMode)Mockito.times((int)1))).loadSegment((DataSegment)ArgumentMatchers.any());
        ((SegmentManager)Mockito.verify((Object)segmentManager, (VerificationMode)Mockito.times((int)1))).dropSegment((DataSegment)ArgumentMatchers.any());
        batch = ImmutableList.of((Object)new SegmentChangeRequestLoad(segment1));
        future = handler.processBatch((List)batch);
        for (Runnable runnable : this.scheduledRunnable) {
            runnable.run();
        }
        result = (List)future.get();
        Assert.assertEquals((Object)SegmentChangeStatus.State.SUCCESS, (Object)((DataSegmentChangeResponse)result.get(0)).getStatus().getState());
        Assert.assertEquals((Object)ImmutableList.of((Object)segment1), this.segmentAnnouncer.getObservedSegments());
        this.scheduledRunnable.clear();
        ((SegmentManager)Mockito.verify((Object)segmentManager, (VerificationMode)Mockito.times((int)2))).loadSegment((DataSegment)ArgumentMatchers.any());
        ((SegmentManager)Mockito.verify((Object)segmentManager, (VerificationMode)Mockito.times((int)1))).dropSegment((DataSegment)ArgumentMatchers.any());
        batch = ImmutableList.of((Object)new SegmentChangeRequestLoad(segment1));
        future = handler.processBatch((List)batch);
        for (Runnable runnable : this.scheduledRunnable) {
            runnable.run();
        }
        result = (List)future.get();
        Assert.assertEquals((Object)SegmentChangeStatus.State.SUCCESS, (Object)((DataSegmentChangeResponse)result.get(0)).getStatus().getState());
        Assert.assertEquals((Object)ImmutableList.of((Object)segment1, (Object)segment1), this.segmentAnnouncer.getObservedSegments());
        this.scheduledRunnable.clear();
        ((SegmentManager)Mockito.verify((Object)segmentManager, (VerificationMode)Mockito.times((int)3))).loadSegment((DataSegment)ArgumentMatchers.any());
        ((SegmentManager)Mockito.verify((Object)segmentManager, (VerificationMode)Mockito.times((int)1))).dropSegment((DataSegment)ArgumentMatchers.any());
    }

    private SegmentLoadDropHandler initSegmentLoadDropHandler(SegmentManager segmentManager) {
        return this.initSegmentLoadDropHandler(this.segmentLoaderConfig, segmentManager);
    }

    private SegmentLoadDropHandler initSegmentLoadDropHandler(SegmentLoaderConfig config, SegmentManager segmentManager) {
        return new SegmentLoadDropHandler(config, (DataSegmentAnnouncer)this.segmentAnnouncer, segmentManager, this.scheduledExecutorFactory.create(5, "SegmentLoadDropHandlerTest-[%d]"));
    }
}

