/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.balancer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.druid.client.DruidServer;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.server.coordination.ServerType;
import org.apache.druid.server.coordinator.CreateDataSegments;
import org.apache.druid.server.coordinator.ServerHolder;
import org.apache.druid.server.coordinator.balancer.SegmentToMoveCalculator;
import org.apache.druid.server.coordinator.loading.LoadQueuePeon;
import org.apache.druid.server.coordinator.loading.TestLoadQueuePeon;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.Duration;
import org.junit.Assert;
import org.junit.Test;

public class SegmentToMoveCalculatorTest {
    private static final Duration DEFAULT_COORDINATOR_PERIOD = Duration.standardMinutes((long)1L);
    private static final List<DataSegment> WIKI_SEGMENTS = CreateDataSegments.ofDatasource("wiki").forIntervals(100, Granularities.DAY).withNumPartitions(100).eachOfSizeInMb(500L);
    private static final List<DataSegment> KOALA_SEGMENTS = CreateDataSegments.ofDatasource("koala").forIntervals(10, Granularities.DAY).eachOfSizeInMb(500L);
    private static final String TIER = "tier1";

    @Test
    public void testMaxSegmentsToMove1Thread() {
        Assert.assertEquals((long)0L, (long)SegmentToMoveCalculatorTest.computeMaxSegmentsToMove(0, 1));
        Assert.assertEquals((long)50L, (long)SegmentToMoveCalculatorTest.computeMaxSegmentsToMove(50, 1));
        Assert.assertEquals((long)100L, (long)SegmentToMoveCalculatorTest.computeMaxSegmentsToMove(100, 1));
        Assert.assertEquals((long)100L, (long)SegmentToMoveCalculatorTest.computeMaxSegmentsToMove(512, 1));
        Assert.assertEquals((long)200L, (long)SegmentToMoveCalculatorTest.computeMaxSegmentsToMove(1024, 1));
        Assert.assertEquals((long)300L, (long)SegmentToMoveCalculatorTest.computeMaxSegmentsToMove(1536, 1));
        Assert.assertEquals((long)1900L, (long)SegmentToMoveCalculatorTest.computeMaxSegmentsToMove(10000, 1));
        Assert.assertEquals((long)9700L, (long)SegmentToMoveCalculatorTest.computeMaxSegmentsToMove(50000, 1));
        Assert.assertEquals((long)19500L, (long)SegmentToMoveCalculatorTest.computeMaxSegmentsToMove(100000, 1));
        Assert.assertEquals((long)10000L, (long)SegmentToMoveCalculatorTest.computeMaxSegmentsToMove(200000, 1));
        Assert.assertEquals((long)4000L, (long)SegmentToMoveCalculatorTest.computeMaxSegmentsToMove(500000, 1));
        Assert.assertEquals((long)2000L, (long)SegmentToMoveCalculatorTest.computeMaxSegmentsToMove(1000000, 1));
    }

    @Test
    public void testMaxSegmentsToMoveIncreasesWithCoordinatorPeriod() {
        Assert.assertEquals((long)100L, (long)SegmentToMoveCalculatorTest.computeMaxSegmentsToMoveInPeriod(200000, Duration.millis((long)0L)));
        Assert.assertEquals((long)100L, (long)SegmentToMoveCalculatorTest.computeMaxSegmentsToMoveInPeriod(200000, Duration.millis((long)10000L)));
        Assert.assertEquals((long)100L, (long)SegmentToMoveCalculatorTest.computeMaxSegmentsToMoveInPeriod(200000, Duration.millis((long)20000L)));
        Assert.assertEquals((long)5000L, (long)SegmentToMoveCalculatorTest.computeMaxSegmentsToMoveInPeriod(200000, Duration.millis((long)30000L)));
        Assert.assertEquals((long)10000L, (long)SegmentToMoveCalculatorTest.computeMaxSegmentsToMoveInPeriod(200000, Duration.millis((long)60000L)));
        Assert.assertEquals((long)15000L, (long)SegmentToMoveCalculatorTest.computeMaxSegmentsToMoveInPeriod(200000, Duration.millis((long)90000L)));
        Assert.assertEquals((long)20000L, (long)SegmentToMoveCalculatorTest.computeMaxSegmentsToMoveInPeriod(200000, Duration.millis((long)120000L)));
        Assert.assertEquals((long)2000L, (long)SegmentToMoveCalculatorTest.computeMaxSegmentsToMoveInPeriod(500000, Duration.millis((long)30000L)));
        Assert.assertEquals((long)4000L, (long)SegmentToMoveCalculatorTest.computeMaxSegmentsToMoveInPeriod(500000, Duration.millis((long)60000L)));
        Assert.assertEquals((long)6000L, (long)SegmentToMoveCalculatorTest.computeMaxSegmentsToMoveInPeriod(500000, Duration.millis((long)90000L)));
        Assert.assertEquals((long)8000L, (long)SegmentToMoveCalculatorTest.computeMaxSegmentsToMoveInPeriod(500000, Duration.millis((long)120000L)));
    }

    @Test
    public void testMaxSegmentsToMove8Threads() {
        Assert.assertEquals((long)0L, (long)SegmentToMoveCalculatorTest.computeMaxSegmentsToMove(0, 8));
        Assert.assertEquals((long)50L, (long)SegmentToMoveCalculatorTest.computeMaxSegmentsToMove(50, 8));
        Assert.assertEquals((long)100L, (long)SegmentToMoveCalculatorTest.computeMaxSegmentsToMove(100, 8));
        Assert.assertEquals((long)100L, (long)SegmentToMoveCalculatorTest.computeMaxSegmentsToMove(512, 8));
        Assert.assertEquals((long)200L, (long)SegmentToMoveCalculatorTest.computeMaxSegmentsToMove(1024, 8));
        Assert.assertEquals((long)300L, (long)SegmentToMoveCalculatorTest.computeMaxSegmentsToMove(1536, 8));
        Assert.assertEquals((long)33000L, (long)SegmentToMoveCalculatorTest.computeMaxSegmentsToMove(500000, 8));
        Assert.assertEquals((long)16000L, (long)SegmentToMoveCalculatorTest.computeMaxSegmentsToMove(1000000, 8));
        Assert.assertEquals((long)8000L, (long)SegmentToMoveCalculatorTest.computeMaxSegmentsToMove(2000000, 8));
        Assert.assertEquals((long)3000L, (long)SegmentToMoveCalculatorTest.computeMaxSegmentsToMove(5000000, 8));
        Assert.assertEquals((long)1000L, (long)SegmentToMoveCalculatorTest.computeMaxSegmentsToMove(10000000, 8));
    }

    @Test
    public void testMinSegmentsToMove() {
        Assert.assertEquals((long)0L, (long)SegmentToMoveCalculatorTest.computeMinSegmentsToMove(0));
        Assert.assertEquals((long)50L, (long)SegmentToMoveCalculatorTest.computeMinSegmentsToMove(50));
        Assert.assertEquals((long)100L, (long)SegmentToMoveCalculatorTest.computeMinSegmentsToMove(100));
        Assert.assertEquals((long)100L, (long)SegmentToMoveCalculatorTest.computeMinSegmentsToMove(1000));
        Assert.assertEquals((long)100L, (long)SegmentToMoveCalculatorTest.computeMinSegmentsToMove(20000));
        Assert.assertEquals((long)100L, (long)SegmentToMoveCalculatorTest.computeMinSegmentsToMove(50000));
        Assert.assertEquals((long)100L, (long)SegmentToMoveCalculatorTest.computeMinSegmentsToMove(100000));
        Assert.assertEquals((long)300L, (long)SegmentToMoveCalculatorTest.computeMinSegmentsToMove(200000));
        Assert.assertEquals((long)700L, (long)SegmentToMoveCalculatorTest.computeMinSegmentsToMove(500000));
        Assert.assertEquals((long)1500L, (long)SegmentToMoveCalculatorTest.computeMinSegmentsToMove(1000000));
        Assert.assertEquals((long)15200L, (long)SegmentToMoveCalculatorTest.computeMinSegmentsToMove(10000000));
    }

    @Test
    public void testMinSegmentsToMoveIncreasesInSteps() {
        Assert.assertEquals((long)100L, (long)SegmentToMoveCalculatorTest.computeMinSegmentsToMove(131071));
        Assert.assertEquals((long)200L, (long)SegmentToMoveCalculatorTest.computeMinSegmentsToMove(131072));
        Assert.assertEquals((long)500L, (long)SegmentToMoveCalculatorTest.computeMinSegmentsToMove(393215));
        Assert.assertEquals((long)600L, (long)SegmentToMoveCalculatorTest.computeMinSegmentsToMove(393216));
        Assert.assertEquals((long)900L, (long)SegmentToMoveCalculatorTest.computeMinSegmentsToMove(655359));
        Assert.assertEquals((long)1000L, (long)SegmentToMoveCalculatorTest.computeMinSegmentsToMove(655360));
        Assert.assertEquals((long)9900L, (long)SegmentToMoveCalculatorTest.computeMinSegmentsToMove(0x63FFFF));
        Assert.assertEquals((long)10000L, (long)SegmentToMoveCalculatorTest.computeMinSegmentsToMove(0x640000));
    }

    @Test
    public void testMinSegmentsArePickedForMoveWhenNoSkew() {
        List<ServerHolder> historicals = Arrays.asList(SegmentToMoveCalculatorTest.createServer("A", WIKI_SEGMENTS), SegmentToMoveCalculatorTest.createServer("B", WIKI_SEGMENTS));
        int minSegmentsToMove = SegmentToMoveCalculator.computeMinSegmentsToMoveInTier((int)20000);
        Assert.assertEquals((long)100L, (long)minSegmentsToMove);
        int segmentsToMoveToFixSkew = SegmentToMoveCalculator.computeNumSegmentsToMoveToBalanceTier((String)TIER, historicals);
        Assert.assertEquals((long)0L, (long)segmentsToMoveToFixSkew);
        int segmentsToMove = SegmentToMoveCalculator.computeNumSegmentsToMoveInTier((String)TIER, historicals, (int)Integer.MAX_VALUE);
        Assert.assertEquals((long)minSegmentsToMove, (long)segmentsToMove);
    }

    @Test
    public void testHalfSegmentsArePickedForMoveWhenFullSkew() {
        List<ServerHolder> historicals = Arrays.asList(SegmentToMoveCalculatorTest.createServer("A", WIKI_SEGMENTS), SegmentToMoveCalculatorTest.createServer("B", Collections.emptyList()));
        int minSegmentsToMove = SegmentToMoveCalculator.computeMinSegmentsToMoveInTier((int)10000);
        Assert.assertEquals((long)100L, (long)minSegmentsToMove);
        int segmentsToMoveToFixSkew = SegmentToMoveCalculator.computeNumSegmentsToMoveToBalanceTier((String)TIER, historicals);
        Assert.assertEquals((long)5000L, (long)segmentsToMoveToFixSkew);
        int segmentsToMove = SegmentToMoveCalculator.computeNumSegmentsToMoveInTier((String)TIER, historicals, (int)Integer.MAX_VALUE);
        Assert.assertEquals((long)segmentsToMoveToFixSkew, (long)segmentsToMove);
    }

    @Test
    public void testDatasourceWithLargestGapDeterminesNumToBalanceCounts() {
        ArrayList<DataSegment> segmentsForServerA = new ArrayList<DataSegment>(WIKI_SEGMENTS);
        segmentsForServerA.addAll(KOALA_SEGMENTS);
        List<ServerHolder> historicals = Arrays.asList(SegmentToMoveCalculatorTest.createServer("A", segmentsForServerA), SegmentToMoveCalculatorTest.createServer("B", KOALA_SEGMENTS));
        int numToMoveToBalanceCount = SegmentToMoveCalculator.computeSegmentsToMoveToBalanceCountsPerDatasource((String)TIER, historicals);
        Assert.assertEquals((long)(WIKI_SEGMENTS.size() / 2), (long)numToMoveToBalanceCount);
    }

    private static int computeMaxSegmentsToMove(int totalSegments, int numThreads) {
        return SegmentToMoveCalculator.computeMaxSegmentsToMovePerTier((int)totalSegments, (int)numThreads, (Duration)DEFAULT_COORDINATOR_PERIOD);
    }

    private static int computeMaxSegmentsToMoveInPeriod(int totalSegments, Duration coordinatorPeriod) {
        return SegmentToMoveCalculator.computeMaxSegmentsToMovePerTier((int)totalSegments, (int)1, (Duration)coordinatorPeriod);
    }

    private static int computeMinSegmentsToMove(int totalSegmentsInTier) {
        return SegmentToMoveCalculator.computeMinSegmentsToMoveInTier((int)totalSegmentsInTier);
    }

    private static ServerHolder createServer(String name, List<DataSegment> segments) {
        DruidServer server = new DruidServer(name, name, null, 0x280000000L, ServerType.HISTORICAL, TIER, 1);
        segments.forEach(arg_0 -> ((DruidServer)server).addDataSegment(arg_0));
        return new ServerHolder(server.toImmutableDruidServer(), (LoadQueuePeon)new TestLoadQueuePeon());
    }
}

