/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.duty;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.apache.druid.client.DruidServer;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.core.EventMap;
import org.apache.druid.java.util.emitter.service.AlertEvent;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.metrics.StubServiceEmitter;
import org.apache.druid.metadata.MetadataRuleManager;
import org.apache.druid.server.coordination.ServerType;
import org.apache.druid.server.coordinator.CoordinatorDynamicConfig;
import org.apache.druid.server.coordinator.CreateDataSegments;
import org.apache.druid.server.coordinator.DruidCluster;
import org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.druid.server.coordinator.ServerHolder;
import org.apache.druid.server.coordinator.balancer.BalancerStrategy;
import org.apache.druid.server.coordinator.balancer.CostBalancerStrategy;
import org.apache.druid.server.coordinator.balancer.RandomBalancerStrategy;
import org.apache.druid.server.coordinator.duty.RunRules;
import org.apache.druid.server.coordinator.loading.LoadPeonCallback;
import org.apache.druid.server.coordinator.loading.LoadQueuePeon;
import org.apache.druid.server.coordinator.loading.SegmentAction;
import org.apache.druid.server.coordinator.loading.SegmentLoadQueueManager;
import org.apache.druid.server.coordinator.loading.SegmentReplicaCount;
import org.apache.druid.server.coordinator.loading.SegmentReplicationStatus;
import org.apache.druid.server.coordinator.loading.TestLoadQueuePeon;
import org.apache.druid.server.coordinator.rules.ForeverLoadRule;
import org.apache.druid.server.coordinator.rules.IntervalDropRule;
import org.apache.druid.server.coordinator.rules.IntervalLoadRule;
import org.apache.druid.server.coordinator.rules.Rule;
import org.apache.druid.server.coordinator.stats.CoordinatorRunStats;
import org.apache.druid.server.coordinator.stats.Dimension;
import org.apache.druid.server.coordinator.stats.RowKey;
import org.apache.druid.server.coordinator.stats.Stats;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.NoneShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RunRulesTest {
    private static final long SERVER_SIZE_10GB = 0x280000000L;
    private static final String DATASOURCE = "test";
    private static final RowKey DATASOURCE_STAT_KEY = RowKey.of((Dimension)Dimension.DATASOURCE, (String)"test");
    private LoadQueuePeon mockPeon;
    private RunRules ruleRunner;
    private StubServiceEmitter emitter;
    private MetadataRuleManager databaseRuleManager;
    private SegmentLoadQueueManager loadQueueManager;
    private final List<DataSegment> usedSegments = CreateDataSegments.ofDatasource("test").forIntervals(24, Granularities.HOUR).startingAt("2012-01-01").withNumPartitions(1).eachOfSizeInMb(1L);
    private ListeningExecutorService balancerExecutor;

    @Before
    public void setUp() {
        this.mockPeon = (LoadQueuePeon)EasyMock.createMock(LoadQueuePeon.class);
        this.emitter = new StubServiceEmitter("coordinator", "host");
        EmittingLogger.registerEmitter((ServiceEmitter)this.emitter);
        this.databaseRuleManager = (MetadataRuleManager)EasyMock.createMock(MetadataRuleManager.class);
        this.ruleRunner = new RunRules(Set::size, arg_0 -> ((MetadataRuleManager)this.databaseRuleManager).getRulesWithDefault(arg_0));
        this.loadQueueManager = new SegmentLoadQueueManager(null, null);
        this.balancerExecutor = MoreExecutors.listeningDecorator((ExecutorService)Execs.multiThreaded((int)1, (String)"RunRulesTest-%d"));
    }

    @After
    public void tearDown() {
        this.balancerExecutor.shutdown();
        EasyMock.verify((Object[])new Object[]{this.databaseRuleManager});
    }

    @Test
    public void testOneTierTwoReplicantsWithStrictReplicantLimit() {
        this.mockPeon.loadSegment((DataSegment)EasyMock.anyObject(), (SegmentAction)EasyMock.anyObject(), (LoadPeonCallback)EasyMock.anyObject());
        EasyMock.expectLastCall().atLeastOnce();
        this.mockEmptyPeon();
        EasyMock.expect((Object)this.databaseRuleManager.getRulesWithDefault((String)EasyMock.anyObject())).andReturn(Collections.singletonList(new IntervalLoadRule(Intervals.of((String)"2012-01-01/2012-01-02"), (Map)ImmutableMap.of((Object)"normal", (Object)2), null))).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.databaseRuleManager});
        DruidServer server1 = this.createHistorical("server1", "normal");
        this.usedSegments.forEach(arg_0 -> ((DruidServer)server1).addDataSegment(arg_0));
        DruidServer server2 = this.createHistorical("server2", "normal");
        DruidCluster druidCluster = DruidCluster.builder().addTier("normal", new ServerHolder[]{new ServerHolder(server1.toImmutableDruidServer(), this.mockPeon), new ServerHolder(server2.toImmutableDruidServer(), this.mockPeon)}).build();
        DruidCoordinatorRuntimeParams params = this.createCoordinatorRuntimeParams(druidCluster).withBalancerStrategy((BalancerStrategy)new CostBalancerStrategy(this.balancerExecutor)).withDynamicConfigs(CoordinatorDynamicConfig.builder().withReplicationThrottleLimit(10).withSmartSegmentLoading(false).build()).withSegmentAssignerUsing(this.loadQueueManager).build();
        CoordinatorRunStats stats = this.runDutyAndGetStats(params);
        Assert.assertEquals((long)10L, (long)stats.getSegmentStat(Stats.Segments.ASSIGNED, "normal", DATASOURCE));
        EasyMock.verify((Object[])new Object[]{this.mockPeon});
    }

    @Test
    public void testTwoTiersTwoReplicantsWithStrictReplicantLimit() {
        this.mockPeon.loadSegment((DataSegment)EasyMock.anyObject(), (SegmentAction)EasyMock.anyObject(), (LoadPeonCallback)EasyMock.anyObject());
        EasyMock.expectLastCall().atLeastOnce();
        this.mockEmptyPeon();
        EasyMock.expect((Object)this.databaseRuleManager.getRulesWithDefault((String)EasyMock.anyObject())).andReturn(Collections.singletonList(new IntervalLoadRule(Intervals.of((String)"2012-01-01T00:00:00.000Z/2012-01-02T00:00:00.000Z"), (Map)ImmutableMap.of((Object)"hot", (Object)2, (Object)"normal", (Object)2), null))).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.databaseRuleManager});
        DruidServer serverHot1 = this.createHistorical("serverHot", "hot");
        DruidServer serverHot2 = this.createHistorical("serverHot2", "hot");
        this.usedSegments.forEach(arg_0 -> ((DruidServer)serverHot1).addDataSegment(arg_0));
        DruidServer serverNorm1 = this.createHistorical("serverNorm", "normal");
        DruidServer serverNorm2 = this.createHistorical("serverNorm2", "normal");
        DruidCluster druidCluster = DruidCluster.builder().addTier("hot", new ServerHolder[]{new ServerHolder(serverHot1.toImmutableDruidServer(), this.mockPeon), new ServerHolder(serverHot2.toImmutableDruidServer(), this.mockPeon)}).addTier("normal", new ServerHolder[]{new ServerHolder(serverNorm1.toImmutableDruidServer(), this.mockPeon), new ServerHolder(serverNorm2.toImmutableDruidServer(), this.mockPeon)}).build();
        DruidCoordinatorRuntimeParams params = this.createCoordinatorRuntimeParams(druidCluster).withBalancerStrategy((BalancerStrategy)new CostBalancerStrategy(this.balancerExecutor)).withDynamicConfigs(CoordinatorDynamicConfig.builder().withReplicationThrottleLimit(10).withSmartSegmentLoading(false).build()).withSegmentAssignerUsing(this.loadQueueManager).build();
        CoordinatorRunStats stats = this.runDutyAndGetStats(params);
        Assert.assertEquals((long)10L, (long)stats.getSegmentStat(Stats.Segments.ASSIGNED, "hot", DATASOURCE));
        Assert.assertEquals((long)48L, (long)stats.getSegmentStat(Stats.Segments.ASSIGNED, "normal", DATASOURCE));
        EasyMock.verify((Object[])new Object[]{this.mockPeon});
    }

    @Test
    public void testRunThreeTiersOneReplicant() {
        this.mockPeon.loadSegment((DataSegment)EasyMock.anyObject(), (SegmentAction)EasyMock.anyObject(), (LoadPeonCallback)EasyMock.anyObject());
        EasyMock.expectLastCall().atLeastOnce();
        this.mockEmptyPeon();
        EasyMock.expect((Object)this.databaseRuleManager.getRulesWithDefault((String)EasyMock.anyObject())).andReturn((Object)Lists.newArrayList((Object[])new Rule[]{new IntervalLoadRule(Intervals.of((String)"2012-01-01T00:00:00.000Z/2012-01-01T06:00:00.000Z"), (Map)ImmutableMap.of((Object)"hot", (Object)1), null), new IntervalLoadRule(Intervals.of((String)"2012-01-01T00:00:00.000Z/2012-01-01T12:00:00.000Z"), (Map)ImmutableMap.of((Object)"normal", (Object)1), null), new IntervalLoadRule(Intervals.of((String)"2012-01-01T00:00:00.000Z/2012-01-02T00:00:00.000Z"), (Map)ImmutableMap.of((Object)"cold", (Object)1), null)})).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.databaseRuleManager});
        DruidCluster druidCluster = DruidCluster.builder().addTier("hot", new ServerHolder[]{new ServerHolder(this.createHistorical("serverHot", "hot").toImmutableDruidServer(), this.mockPeon)}).addTier("normal", new ServerHolder[]{new ServerHolder(this.createHistorical("serverNorm", "normal").toImmutableDruidServer(), this.mockPeon)}).addTier("cold", new ServerHolder[]{new ServerHolder(this.createHistorical("serverCold", "cold").toImmutableDruidServer(), this.mockPeon)}).build();
        DruidCoordinatorRuntimeParams params = this.createCoordinatorRuntimeParams(druidCluster).withBalancerStrategy((BalancerStrategy)new CostBalancerStrategy(this.balancerExecutor)).withDynamicConfigs(CoordinatorDynamicConfig.builder().withMaxSegmentsToMove(5).build()).withSegmentAssignerUsing(this.loadQueueManager).build();
        CoordinatorRunStats stats = this.runDutyAndGetStats(params);
        Assert.assertEquals((long)6L, (long)stats.getSegmentStat(Stats.Segments.ASSIGNED, "hot", DATASOURCE));
        Assert.assertEquals((long)6L, (long)stats.getSegmentStat(Stats.Segments.ASSIGNED, "normal", DATASOURCE));
        Assert.assertEquals((long)12L, (long)stats.getSegmentStat(Stats.Segments.ASSIGNED, "cold", DATASOURCE));
        Assert.assertFalse((boolean)stats.hasStat(Stats.Segments.DROPPED));
        EasyMock.verify((Object[])new Object[]{this.mockPeon});
    }

    private DruidServer createHistorical(String name, String tier) {
        return new DruidServer(name, name, null, 0x280000000L, ServerType.HISTORICAL, tier, 0);
    }

    private ServerHolder createServerHolder(String name, String tier, LoadQueuePeon peon) {
        return new ServerHolder(this.createHistorical(name, tier).toImmutableDruidServer(), peon);
    }

    private DruidCoordinatorRuntimeParams.Builder createCoordinatorRuntimeParams(DruidCluster druidCluster, DataSegment segment) {
        return this.createCoordinatorRuntimeParams(druidCluster, Collections.singletonList(segment));
    }

    private DruidCoordinatorRuntimeParams.Builder createCoordinatorRuntimeParams(DruidCluster druidCluster) {
        return this.createCoordinatorRuntimeParams(druidCluster, this.usedSegments);
    }

    private DruidCoordinatorRuntimeParams.Builder createCoordinatorRuntimeParams(DruidCluster druidCluster, List<DataSegment> dataSegments) {
        return DruidCoordinatorRuntimeParams.builder().withDruidCluster(druidCluster).withUsedSegments(dataSegments);
    }

    @Test
    public void testRunTwoTiersTwoReplicants() {
        this.mockPeon.loadSegment((DataSegment)EasyMock.anyObject(), (SegmentAction)EasyMock.anyObject(), (LoadPeonCallback)EasyMock.anyObject());
        EasyMock.expectLastCall().atLeastOnce();
        this.mockEmptyPeon();
        EasyMock.expect((Object)this.databaseRuleManager.getRulesWithDefault((String)EasyMock.anyObject())).andReturn((Object)Lists.newArrayList((Object[])new Rule[]{new IntervalLoadRule(Intervals.of((String)"2012-01-01T00:00:00.000Z/2012-01-01T06:00:00.000Z"), (Map)ImmutableMap.of((Object)"hot", (Object)2), null), new IntervalLoadRule(Intervals.of((String)"2012-01-01T00:00:00.000Z/2012-01-02T00:00:00.000Z"), (Map)ImmutableMap.of((Object)"cold", (Object)1), null)})).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.databaseRuleManager});
        DruidCluster druidCluster = DruidCluster.builder().add(this.createServerHolder("serverHot", "hot", this.mockPeon)).add(this.createServerHolder("serverHot2", "hot", this.mockPeon)).add(this.createServerHolder("serverCold", "cold", this.mockPeon)).build();
        DruidCoordinatorRuntimeParams params = this.createCoordinatorRuntimeParams(druidCluster).withBalancerStrategy((BalancerStrategy)new CostBalancerStrategy(this.balancerExecutor)).withSegmentAssignerUsing(this.loadQueueManager).build();
        CoordinatorRunStats stats = this.runDutyAndGetStats(params);
        Assert.assertEquals((long)12L, (long)stats.getSegmentStat(Stats.Segments.ASSIGNED, "hot", DATASOURCE));
        Assert.assertEquals((long)18L, (long)stats.getSegmentStat(Stats.Segments.ASSIGNED, "cold", DATASOURCE));
        Assert.assertFalse((boolean)stats.hasStat(Stats.Segments.DROPPED));
        EasyMock.verify((Object[])new Object[]{this.mockPeon});
    }

    @Test
    public void testRunTwoTiersWithExistingSegments() {
        this.mockPeon.loadSegment((DataSegment)EasyMock.anyObject(), (SegmentAction)EasyMock.anyObject(), (LoadPeonCallback)EasyMock.anyObject());
        EasyMock.expectLastCall().atLeastOnce();
        this.mockEmptyPeon();
        EasyMock.expect((Object)this.databaseRuleManager.getRulesWithDefault((String)EasyMock.anyObject())).andReturn((Object)Lists.newArrayList((Object[])new Rule[]{new IntervalLoadRule(Intervals.of((String)"2012-01-01T00:00:00.000Z/2012-01-01T12:00:00.000Z"), (Map)ImmutableMap.of((Object)"hot", (Object)1), null), new IntervalLoadRule(Intervals.of((String)"2012-01-01T00:00:00.000Z/2012-01-02T00:00:00.000Z"), (Map)ImmutableMap.of((Object)"normal", (Object)1), null)})).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.databaseRuleManager});
        DruidServer normServer = this.createHistorical("serverNorm", "normal");
        for (DataSegment segment : this.usedSegments) {
            normServer.addDataSegment(segment);
        }
        DruidCluster druidCluster = DruidCluster.builder().add(this.createServerHolder("serverHot", "hot", this.mockPeon)).add(new ServerHolder(normServer.toImmutableDruidServer(), this.mockPeon)).build();
        DruidCoordinatorRuntimeParams params = this.createCoordinatorRuntimeParams(druidCluster).withBalancerStrategy((BalancerStrategy)new CostBalancerStrategy(this.balancerExecutor)).withSegmentAssignerUsing(this.loadQueueManager).build();
        CoordinatorRunStats stats = this.runDutyAndGetStats(params);
        Assert.assertEquals((long)12L, (long)stats.getSegmentStat(Stats.Segments.ASSIGNED, "hot", DATASOURCE));
        Assert.assertEquals((long)0L, (long)stats.getSegmentStat(Stats.Segments.ASSIGNED, "normal", DATASOURCE));
        Assert.assertFalse((boolean)stats.hasStat(Stats.Segments.DROPPED));
        EasyMock.verify((Object[])new Object[]{this.mockPeon});
    }

    @Test
    public void testRunTwoTiersTierDoesNotExist() {
        this.mockPeon.loadSegment((DataSegment)EasyMock.anyObject(), (SegmentAction)EasyMock.anyObject(), (LoadPeonCallback)EasyMock.anyObject());
        EasyMock.expectLastCall().atLeastOnce();
        this.mockEmptyPeon();
        EasyMock.expect((Object)this.databaseRuleManager.getRulesWithDefault((String)EasyMock.anyObject())).andReturn((Object)Lists.newArrayList((Object[])new Rule[]{new IntervalLoadRule(Intervals.of((String)"2012-01-01T00:00:00.000Z/2012-01-01T12:00:00.000Z"), (Map)ImmutableMap.of((Object)"hot", (Object)1), null), new IntervalLoadRule(Intervals.of((String)"2012-01-01T00:00:00.000Z/2012-01-02T00:00:00.000Z"), (Map)ImmutableMap.of((Object)"normal", (Object)1), null)})).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.databaseRuleManager});
        DruidCluster druidCluster = DruidCluster.builder().add(this.createServerHolder("serverNorm", "normal", this.mockPeon)).build();
        DruidCoordinatorRuntimeParams params = this.createCoordinatorRuntimeParams(druidCluster).withBalancerStrategy((BalancerStrategy)new CostBalancerStrategy(this.balancerExecutor)).withSegmentAssignerUsing(this.loadQueueManager).build();
        this.runDutyAndGetStats(params);
        EasyMock.verify((Object[])new Object[]{this.mockPeon});
    }

    @Test
    public void testRunRuleDoesNotExist() {
        EasyMock.expect((Object)this.databaseRuleManager.getRulesWithDefault((String)EasyMock.anyObject())).andReturn(Collections.singletonList(new IntervalLoadRule(Intervals.of((String)"2012-01-02T00:00:00.000Z/2012-01-03T00:00:00.000Z"), (Map)ImmutableMap.of((Object)"normal", (Object)1), null))).atLeastOnce();
        EasyMock.expect((Object)this.mockPeon.getSegmentsInQueue()).andReturn(Collections.emptySet()).anyTimes();
        EasyMock.expect((Object)this.mockPeon.getSegmentsMarkedToDrop()).andReturn(Collections.emptySet()).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.databaseRuleManager, this.mockPeon});
        DruidCluster druidCluster = DruidCluster.builder().add(this.createServerHolder("serverNorm", "normal", this.mockPeon)).build();
        DruidCoordinatorRuntimeParams params = this.createCoordinatorRuntimeParams(druidCluster).withBalancerStrategy((BalancerStrategy)new CostBalancerStrategy(this.balancerExecutor)).withSegmentAssignerUsing(this.loadQueueManager).build();
        this.runDutyAndGetStats(params);
        List events = this.emitter.getAlerts();
        Assert.assertEquals((long)1L, (long)events.size());
        AlertEvent alertEvent = (AlertEvent)events.get(0);
        EventMap eventMap = alertEvent.toMap();
        Assert.assertEquals((Object)"No matching retention rule for [24] segments in datasource[test]", (Object)eventMap.get((Object)"description"));
        EasyMock.verify((Object[])new Object[]{this.mockPeon});
    }

    @Test
    public void testDropRemove() {
        this.mockPeon.dropSegment((DataSegment)EasyMock.anyObject(), (LoadPeonCallback)EasyMock.anyObject());
        EasyMock.expectLastCall().atLeastOnce();
        this.mockEmptyPeon();
        EasyMock.expect((Object)this.databaseRuleManager.getRulesWithDefault((String)EasyMock.anyObject())).andReturn((Object)Lists.newArrayList((Object[])new Rule[]{new IntervalLoadRule(Intervals.of((String)"2012-01-01T00:00:00.000Z/2012-01-01T12:00:00.000Z"), (Map)ImmutableMap.of((Object)"normal", (Object)1), null), new IntervalDropRule(Intervals.of((String)"2012-01-01T00:00:00.000Z/2012-01-02T00:00:00.000Z"))})).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.databaseRuleManager});
        DruidServer server = this.createHistorical("serverNorm", "normal");
        for (DataSegment segment : this.usedSegments) {
            server.addDataSegment(segment);
        }
        DruidCluster druidCluster = DruidCluster.builder().addTier("normal", new ServerHolder[]{new ServerHolder(server.toImmutableDruidServer(), this.mockPeon)}).build();
        DruidCoordinatorRuntimeParams params = this.createCoordinatorRuntimeParams(druidCluster).withBalancerStrategy((BalancerStrategy)new CostBalancerStrategy(this.balancerExecutor)).withSegmentAssignerUsing(this.loadQueueManager).build();
        CoordinatorRunStats stats = this.runDutyAndGetStats(params);
        Assert.assertEquals((long)12L, (long)stats.get(Stats.Segments.DELETED, DATASOURCE_STAT_KEY));
    }

    @Test
    public void testDropTooManyInSameTier() {
        this.mockPeon.dropSegment((DataSegment)EasyMock.anyObject(), (LoadPeonCallback)EasyMock.anyObject());
        EasyMock.expectLastCall().atLeastOnce();
        this.mockEmptyPeon();
        EasyMock.expect((Object)this.databaseRuleManager.getRulesWithDefault((String)EasyMock.anyObject())).andReturn((Object)Lists.newArrayList((Object[])new Rule[]{new IntervalLoadRule(Intervals.of((String)"2012-01-01T00:00:00.000Z/2012-01-01T12:00:00.000Z"), (Map)ImmutableMap.of((Object)"normal", (Object)1), null), new IntervalDropRule(Intervals.of((String)"2012-01-01T00:00:00.000Z/2012-01-02T00:00:00.000Z"))})).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.databaseRuleManager});
        DruidServer server1 = this.createHistorical("serverNorm", "normal");
        server1.addDataSegment(this.usedSegments.get(0));
        DruidServer server2 = this.createHistorical("serverNorm2", "normal");
        for (DataSegment segment : this.usedSegments) {
            server2.addDataSegment(segment);
        }
        DruidCluster druidCluster = DruidCluster.builder().addTier("normal", new ServerHolder[]{new ServerHolder(server1.toImmutableDruidServer(), this.mockPeon), new ServerHolder(server2.toImmutableDruidServer(), this.mockPeon)}).build();
        DruidCoordinatorRuntimeParams params = this.createCoordinatorRuntimeParams(druidCluster).withDynamicConfigs(CoordinatorDynamicConfig.builder().withMarkSegmentAsUnusedDelayMillis(0L).build()).withBalancerStrategy((BalancerStrategy)new CostBalancerStrategy(this.balancerExecutor)).withSegmentAssignerUsing(this.loadQueueManager).build();
        CoordinatorRunStats stats = this.runDutyAndGetStats(params);
        Assert.assertEquals((long)1L, (long)stats.getSegmentStat(Stats.Segments.DROPPED, "normal", DATASOURCE));
        Assert.assertEquals((long)12L, (long)stats.get(Stats.Segments.DELETED, DATASOURCE_STAT_KEY));
        EasyMock.verify((Object[])new Object[]{this.mockPeon});
    }

    @Test
    public void testDropTooManyInDifferentTiers() {
        this.mockPeon.loadSegment((DataSegment)EasyMock.anyObject(), (SegmentAction)EasyMock.anyObject(), (LoadPeonCallback)EasyMock.anyObject());
        EasyMock.expectLastCall().atLeastOnce();
        this.mockPeon.dropSegment((DataSegment)EasyMock.anyObject(), (LoadPeonCallback)EasyMock.anyObject());
        EasyMock.expectLastCall().atLeastOnce();
        this.mockEmptyPeon();
        EasyMock.expect((Object)this.databaseRuleManager.getRulesWithDefault((String)EasyMock.anyObject())).andReturn((Object)Lists.newArrayList((Object[])new Rule[]{new IntervalLoadRule(Intervals.of((String)"2012-01-01T00:00:00.000Z/2012-01-01T12:00:00.000Z"), (Map)ImmutableMap.of((Object)"hot", (Object)1), null), new IntervalDropRule(Intervals.of((String)"2012-01-01T00:00:00.000Z/2012-01-02T00:00:00.000Z"))})).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.databaseRuleManager});
        DruidServer server1 = this.createHistorical("server1", "hot");
        server1.addDataSegment(this.usedSegments.get(0));
        DruidServer server2 = this.createHistorical("serverNorm2", "normal");
        for (DataSegment segment : this.usedSegments) {
            server2.addDataSegment(segment);
        }
        DruidCluster druidCluster = DruidCluster.builder().addTier("hot", new ServerHolder[]{new ServerHolder(server1.toImmutableDruidServer(), this.mockPeon)}).addTier("normal", new ServerHolder[]{new ServerHolder(server2.toImmutableDruidServer(), this.mockPeon)}).build();
        DruidCoordinatorRuntimeParams params = this.createCoordinatorRuntimeParams(druidCluster).withBalancerStrategy((BalancerStrategy)new CostBalancerStrategy(this.balancerExecutor)).withSegmentAssignerUsing(this.loadQueueManager).build();
        CoordinatorRunStats stats = this.runDutyAndGetStats(params);
        Assert.assertEquals((long)1L, (long)stats.getSegmentStat(Stats.Segments.DROPPED, "normal", DATASOURCE));
        Assert.assertEquals((long)12L, (long)stats.get(Stats.Segments.DELETED, DATASOURCE_STAT_KEY));
        EasyMock.verify((Object[])new Object[]{this.mockPeon});
    }

    @Test
    public void testDontDropInDifferentTiers() {
        this.mockPeon.loadSegment((DataSegment)EasyMock.anyObject(), (SegmentAction)EasyMock.anyObject(), (LoadPeonCallback)EasyMock.anyObject());
        EasyMock.expectLastCall().atLeastOnce();
        this.mockEmptyPeon();
        EasyMock.expect((Object)this.databaseRuleManager.getRulesWithDefault((String)EasyMock.anyObject())).andReturn((Object)Lists.newArrayList((Object[])new Rule[]{new IntervalLoadRule(Intervals.of((String)"2012-01-01T00:00:00.000Z/2012-01-01T12:00:00.000Z"), (Map)ImmutableMap.of((Object)"hot", (Object)1), null), new IntervalDropRule(Intervals.of((String)"2012-01-01T00:00:00.000Z/2012-01-02T00:00:00.000Z"))})).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.databaseRuleManager});
        DruidServer server1 = this.createHistorical("server1", "hot");
        DruidServer server2 = this.createHistorical("serverNorm2", "normal");
        for (DataSegment segment : this.usedSegments) {
            server2.addDataSegment(segment);
        }
        DruidCluster druidCluster = DruidCluster.builder().add(new ServerHolder(server1.toImmutableDruidServer(), this.mockPeon)).add(new ServerHolder(server2.toImmutableDruidServer(), this.mockPeon)).build();
        DruidCoordinatorRuntimeParams params = this.createCoordinatorRuntimeParams(druidCluster).withBalancerStrategy((BalancerStrategy)new CostBalancerStrategy(this.balancerExecutor)).withSegmentAssignerUsing(this.loadQueueManager).build();
        CoordinatorRunStats stats = this.runDutyAndGetStats(params);
        Assert.assertFalse((boolean)stats.hasStat(Stats.Segments.DROPPED));
        Assert.assertEquals((long)12L, (long)stats.get(Stats.Segments.DELETED, DATASOURCE_STAT_KEY));
        EasyMock.verify((Object[])new Object[]{this.mockPeon});
    }

    @Test
    public void testDropServerActuallyServesSegment() {
        EasyMock.expect((Object)this.databaseRuleManager.getRulesWithDefault((String)EasyMock.anyObject())).andReturn(Collections.singletonList(new IntervalLoadRule(Intervals.of((String)"2012-01-01T00:00:00.000Z/2012-01-01T01:00:00.000Z"), (Map)ImmutableMap.of((Object)"normal", (Object)0), null))).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.databaseRuleManager});
        DruidServer server1 = this.createHistorical("server1", "normal");
        server1.addDataSegment(this.usedSegments.get(0));
        DruidServer server2 = this.createHistorical("serverNorm2", "normal");
        server2.addDataSegment(this.usedSegments.get(1));
        DruidServer server3 = this.createHistorical("serverNorm3", "normal");
        server3.addDataSegment(this.usedSegments.get(1));
        server3.addDataSegment(this.usedSegments.get(2));
        this.mockPeon.dropSegment((DataSegment)EasyMock.anyObject(), (LoadPeonCallback)EasyMock.anyObject());
        EasyMock.expectLastCall().atLeastOnce();
        this.mockEmptyPeon();
        LoadQueuePeon anotherMockPeon = (LoadQueuePeon)EasyMock.createMock(LoadQueuePeon.class);
        EasyMock.expect((Object)anotherMockPeon.getSegmentsMarkedToDrop()).andReturn(Collections.emptySet()).anyTimes();
        EasyMock.expect((Object)anotherMockPeon.getSegmentsInQueue()).andReturn(Collections.emptySet()).anyTimes();
        EasyMock.expect((Object)anotherMockPeon.getSegmentsToLoad()).andReturn(Collections.emptySet()).anyTimes();
        EasyMock.replay((Object[])new Object[]{anotherMockPeon});
        DruidCluster druidCluster = DruidCluster.builder().addTier("normal", new ServerHolder[]{new ServerHolder(server1.toImmutableDruidServer(), this.mockPeon, false), new ServerHolder(server2.toImmutableDruidServer(), anotherMockPeon, false), new ServerHolder(server3.toImmutableDruidServer(), anotherMockPeon, false)}).build();
        DruidCoordinatorRuntimeParams params = this.createCoordinatorRuntimeParams(druidCluster).withBalancerStrategy((BalancerStrategy)new CostBalancerStrategy(this.balancerExecutor)).withSegmentAssignerUsing(this.loadQueueManager).build();
        CoordinatorRunStats stats = this.runDutyAndGetStats(params);
        Assert.assertEquals((long)1L, (long)stats.getSegmentStat(Stats.Segments.DROPPED, "normal", DATASOURCE));
        EasyMock.verify((Object[])new Object[]{this.mockPeon});
        EasyMock.verify((Object[])new Object[]{anotherMockPeon});
    }

    @Test
    public void testNoThrottleWhenSegmentNotLoadedInTier() {
        this.mockPeon.loadSegment((DataSegment)EasyMock.anyObject(), (SegmentAction)EasyMock.anyObject(), (LoadPeonCallback)EasyMock.anyObject());
        EasyMock.expectLastCall().atLeastOnce();
        this.mockEmptyPeon();
        EasyMock.expect((Object)this.databaseRuleManager.getRulesWithDefault((String)EasyMock.anyObject())).andReturn(Collections.singletonList(new IntervalLoadRule(Intervals.of((String)"2012-01-01T00:00:00.000Z/2013-01-01T00:00:00.000Z"), (Map)ImmutableMap.of((Object)"hot", (Object)2), null))).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.databaseRuleManager});
        DruidCluster druidCluster = DruidCluster.builder().addTier("hot", new ServerHolder[]{new ServerHolder(this.createHistorical("serverHot", "hot").toImmutableDruidServer(), this.mockPeon), new ServerHolder(this.createHistorical("serverHot2", "hot").toImmutableDruidServer(), this.mockPeon)}).build();
        CostBalancerStrategy balancerStrategy = new CostBalancerStrategy(this.balancerExecutor);
        DruidCoordinatorRuntimeParams params = this.createCoordinatorRuntimeParams(druidCluster).withBalancerStrategy((BalancerStrategy)balancerStrategy).withSegmentAssignerUsing(this.loadQueueManager).build();
        CoordinatorRunStats stats = this.runDutyAndGetStats(params);
        Assert.assertEquals((long)48L, (long)stats.getSegmentStat(Stats.Segments.ASSIGNED, "hot", DATASOURCE));
        Assert.assertFalse((boolean)stats.hasStat(Stats.Segments.DROPPED));
        DataSegment overFlowSegment = new DataSegment(DATASOURCE, Intervals.of((String)"2012-02-01/2012-02-02"), DateTimes.nowUtc().toString(), new HashMap(), new ArrayList(), new ArrayList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(1), 0L);
        stats = this.runDutyAndGetStats(this.createCoordinatorRuntimeParams(druidCluster).withUsedSegments(new DataSegment[]{overFlowSegment}).withBalancerStrategy((BalancerStrategy)balancerStrategy).withSegmentAssignerUsing(this.loadQueueManager).build());
        Assert.assertEquals((long)2L, (long)stats.getSegmentStat(Stats.Segments.ASSIGNED, "hot", DATASOURCE));
        EasyMock.verify((Object[])new Object[]{this.mockPeon});
    }

    @Test
    public void testReplicantThrottleAcrossTiers() {
        this.mockPeon.loadSegment((DataSegment)EasyMock.anyObject(), (SegmentAction)EasyMock.anyObject(), (LoadPeonCallback)EasyMock.anyObject());
        EasyMock.expectLastCall().atLeastOnce();
        this.mockEmptyPeon();
        EasyMock.expect((Object)this.databaseRuleManager.getRulesWithDefault((String)EasyMock.anyObject())).andReturn(Collections.singletonList(new IntervalLoadRule(Intervals.of((String)"2012-01-01/2013-01-01"), (Map)ImmutableMap.of((Object)"hot", (Object)1, (Object)"_default_tier", (Object)1), null))).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.databaseRuleManager});
        DruidCluster druidCluster = DruidCluster.builder().addTier("hot", new ServerHolder[]{new ServerHolder(this.createHistorical("serverHot", "hot").toImmutableDruidServer(), this.mockPeon)}).addTier("_default_tier", new ServerHolder[]{new ServerHolder(this.createHistorical("serverNorm", "normal").toImmutableDruidServer(), this.mockPeon)}).build();
        DruidCoordinatorRuntimeParams params = this.createCoordinatorRuntimeParams(druidCluster).withBalancerStrategy((BalancerStrategy)new CostBalancerStrategy(this.balancerExecutor)).withDynamicConfigs(CoordinatorDynamicConfig.builder().withReplicationThrottleLimit(7).build()).withSegmentAssignerUsing(this.loadQueueManager).build();
        CoordinatorRunStats stats = this.runDutyAndGetStats(params);
        Assert.assertEquals((long)24L, (long)stats.getSegmentStat(Stats.Segments.ASSIGNED, "hot", DATASOURCE));
        Assert.assertEquals((long)24L, (long)stats.getSegmentStat(Stats.Segments.ASSIGNED, "_default_tier", DATASOURCE));
        Assert.assertFalse((boolean)stats.hasStat(Stats.Segments.DROPPED));
        EasyMock.verify((Object[])new Object[]{this.mockPeon});
    }

    @Test
    public void testDropReplicantThrottle() {
        this.mockPeon.dropSegment((DataSegment)EasyMock.anyObject(), (LoadPeonCallback)EasyMock.anyObject());
        EasyMock.expectLastCall().atLeastOnce();
        this.mockEmptyPeon();
        EasyMock.expect((Object)this.databaseRuleManager.getRulesWithDefault((String)EasyMock.anyObject())).andReturn(Collections.singletonList(new IntervalLoadRule(Intervals.of((String)"2012-01-01/2013-01-02"), (Map)ImmutableMap.of((Object)"normal", (Object)1), null))).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.databaseRuleManager});
        DataSegment overFlowSegment = new DataSegment(DATASOURCE, Intervals.of((String)"2012-02-01/2012-02-02"), DateTimes.nowUtc().toString(), Collections.emptyMap(), Collections.emptyList(), Collections.emptyList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(1), 0L);
        ArrayList longerUsedSegments = Lists.newArrayList(this.usedSegments);
        longerUsedSegments.add(overFlowSegment);
        DruidServer server1 = this.createHistorical("serverNorm1", "normal");
        for (Object segment : longerUsedSegments) {
            server1.addDataSegment((DataSegment)segment);
        }
        DruidServer server2 = this.createHistorical("serverNorm2", "normal");
        for (DataSegment segment : longerUsedSegments) {
            server2.addDataSegment(segment);
        }
        DruidCluster druidCluster = DruidCluster.builder().add(new ServerHolder(server1.toImmutableDruidServer(), this.mockPeon)).add(new ServerHolder(server2.toImmutableDruidServer(), this.mockPeon)).build();
        DruidCoordinatorRuntimeParams params = this.createCoordinatorRuntimeParams(druidCluster).withUsedSegments((Collection)longerUsedSegments).withBalancerStrategy((BalancerStrategy)new CostBalancerStrategy(this.balancerExecutor)).withSegmentAssignerUsing(this.loadQueueManager).build();
        CoordinatorRunStats stats = this.runDutyAndGetStats(params);
        Assert.assertEquals((long)25L, (long)stats.getSegmentStat(Stats.Segments.DROPPED, "normal", DATASOURCE));
        EasyMock.verify((Object[])new Object[]{this.mockPeon});
    }

    @Test
    public void testRulesRunOnNonOvershadowedSegmentsOnly() {
        HashSet<DataSegment> usedSegments = new HashSet<DataSegment>();
        DataSegment v1 = new DataSegment(DATASOURCE, Intervals.of((String)"2012-01-01/2012-01-02"), "1", Collections.emptyMap(), Collections.emptyList(), Collections.emptyList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(9), 1L);
        DataSegment v2 = new DataSegment(DATASOURCE, Intervals.of((String)"2012-01-01/2012-01-02"), "2", Collections.emptyMap(), Collections.emptyList(), Collections.emptyList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(9), 1L);
        usedSegments.add(v1);
        usedSegments.add(v2);
        this.mockPeon.loadSegment((DataSegment)EasyMock.eq((Object)v2), (SegmentAction)EasyMock.anyObject(), (LoadPeonCallback)EasyMock.anyObject());
        EasyMock.expectLastCall().once();
        this.mockEmptyPeon();
        EasyMock.expect((Object)this.databaseRuleManager.getRulesWithDefault((String)EasyMock.anyObject())).andReturn(Collections.singletonList(new ForeverLoadRule((Map)ImmutableMap.of((Object)"_default_tier", (Object)1), null))).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.databaseRuleManager});
        DruidCluster druidCluster = DruidCluster.builder().add(this.createServerHolder("serverHot", "_default_tier", this.mockPeon)).build();
        DruidCoordinatorRuntimeParams params = this.createCoordinatorRuntimeParams(druidCluster).withUsedSegments(usedSegments).withBalancerStrategy((BalancerStrategy)new CostBalancerStrategy(this.balancerExecutor)).withDynamicConfigs(CoordinatorDynamicConfig.builder().withMaxSegmentsToMove(5).build()).withSegmentAssignerUsing(this.loadQueueManager).build();
        CoordinatorRunStats stats = this.runDutyAndGetStats(params);
        Assert.assertEquals((long)1L, (long)stats.getSegmentStat(Stats.Segments.ASSIGNED, "_default_tier", DATASOURCE));
        Assert.assertFalse((boolean)stats.hasStat(Stats.Segments.DROPPED));
        Assert.assertEquals((long)2L, (long)usedSegments.size());
        Assert.assertEquals(usedSegments, (Object)params.getUsedSegmentsNewestFirst());
        EasyMock.verify((Object[])new Object[]{this.mockPeon});
    }

    @Test(timeout=5000L)
    public void testTwoNodesOneTierThreeReplicantsRandomStrategyNotEnoughNodes() {
        this.mockEmptyPeon();
        EasyMock.expect((Object)this.databaseRuleManager.getRulesWithDefault((String)EasyMock.anyObject())).andReturn(Collections.singletonList(new ForeverLoadRule((Map)ImmutableMap.of((Object)"_default_tier", (Object)3), null))).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.databaseRuleManager});
        DataSegment dataSegment = new DataSegment(DATASOURCE, Intervals.utc((long)0L, (long)1L), DateTimes.nowUtc().toString(), Collections.emptyMap(), Collections.emptyList(), Collections.emptyList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(9), 1L);
        DruidCluster druidCluster = DruidCluster.builder().addTier("_default_tier", new ServerHolder[]{new ServerHolder(this.createHistorical("server1", "_default_tier").addDataSegment(dataSegment).toImmutableDruidServer(), this.mockPeon), new ServerHolder(this.createHistorical("server2", "_default_tier").addDataSegment(dataSegment).toImmutableDruidServer(), this.mockPeon)}).build();
        DruidCoordinatorRuntimeParams params = this.createCoordinatorRuntimeParams(druidCluster, dataSegment).withBalancerStrategy((BalancerStrategy)new RandomBalancerStrategy()).withDynamicConfigs(CoordinatorDynamicConfig.builder().withMaxSegmentsToMove(5).build()).withSegmentAssignerUsing(this.loadQueueManager).build();
        CoordinatorRunStats stats = this.runDutyAndGetStats(params);
        Assert.assertEquals((long)0L, (long)stats.getSegmentStat(Stats.Segments.ASSIGNED, "_default_tier", DATASOURCE));
        Assert.assertFalse((boolean)stats.hasStat(Stats.Segments.DROPPED));
        EasyMock.verify((Object[])new Object[]{this.mockPeon});
    }

    @Test(timeout=5000L)
    public void testOneNodesOneTierOneReplicantRandomStrategyEnoughSpace() {
        this.mockPeon.loadSegment((DataSegment)EasyMock.anyObject(), (SegmentAction)EasyMock.anyObject(), (LoadPeonCallback)EasyMock.anyObject());
        EasyMock.expectLastCall().atLeastOnce();
        this.mockEmptyPeon();
        EasyMock.expect((Object)this.databaseRuleManager.getRulesWithDefault((String)EasyMock.anyObject())).andReturn(Collections.singletonList(new ForeverLoadRule((Map)ImmutableMap.of((Object)"_default_tier", (Object)1), null))).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.databaseRuleManager});
        DataSegment dataSegment = new DataSegment(DATASOURCE, Intervals.utc((long)0L, (long)1L), DateTimes.nowUtc().toString(), Collections.emptyMap(), Collections.emptyList(), Collections.emptyList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(9), 1L);
        DruidCluster druidCluster = DruidCluster.builder().addTier("_default_tier", new ServerHolder[]{new ServerHolder(this.createHistorical("server1", "_default_tier").toImmutableDruidServer(), this.mockPeon)}).build();
        DruidCoordinatorRuntimeParams params = this.createCoordinatorRuntimeParams(druidCluster, dataSegment).withBalancerStrategy((BalancerStrategy)new RandomBalancerStrategy()).withDynamicConfigs(CoordinatorDynamicConfig.builder().withMaxSegmentsToMove(5).build()).withSegmentAssignerUsing(this.loadQueueManager).build();
        CoordinatorRunStats stats = this.runDutyAndGetStats(params);
        Assert.assertEquals((long)1L, (long)stats.getSegmentStat(Stats.Segments.ASSIGNED, "_default_tier", DATASOURCE));
        Assert.assertFalse((boolean)stats.hasStat(Stats.Segments.DROPPED));
        EasyMock.verify((Object[])new Object[]{this.mockPeon});
    }

    @Test(timeout=5000L)
    public void testOneNodesOneTierOneReplicantRandomStrategyNotEnoughSpace() {
        this.mockEmptyPeon();
        int numReplicants = 1;
        EasyMock.expect((Object)this.databaseRuleManager.getRulesWithDefault((String)EasyMock.anyObject())).andReturn(Collections.singletonList(new ForeverLoadRule((Map)ImmutableMap.of((Object)"_default_tier", (Object)numReplicants), null))).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.databaseRuleManager});
        DataSegment dataSegment = new DataSegment(DATASOURCE, Intervals.utc((long)0L, (long)1L), DateTimes.nowUtc().toString(), Collections.emptyMap(), Collections.emptyList(), Collections.emptyList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(9), 11L);
        DruidCluster druidCluster = DruidCluster.builder().addTier("_default_tier", new ServerHolder[]{new ServerHolder(new DruidServer("server1", "host1", null, 10L, ServerType.HISTORICAL, "_default_tier", 0).toImmutableDruidServer(), this.mockPeon)}).build();
        DruidCoordinatorRuntimeParams params = this.createCoordinatorRuntimeParams(druidCluster, dataSegment).withBalancerStrategy((BalancerStrategy)new RandomBalancerStrategy()).withDynamicConfigs(CoordinatorDynamicConfig.builder().withMaxSegmentsToMove(5).build()).withSegmentAssignerUsing(this.loadQueueManager).build();
        CoordinatorRunStats stats = this.runDutyAndGetStats(params);
        RowKey tierRowKey = RowKey.of((Dimension)Dimension.TIER, (String)"_default_tier");
        Assert.assertEquals((long)(dataSegment.getSize() * (long)numReplicants), (long)stats.get(Stats.Tier.REQUIRED_CAPACITY, tierRowKey));
        Assert.assertEquals((long)0L, (long)stats.getSegmentStat(Stats.Segments.ASSIGNED, "_default_tier", DATASOURCE));
        Assert.assertFalse((boolean)stats.hasStat(Stats.Segments.DROPPED));
        EasyMock.verify((Object[])new Object[]{this.mockPeon});
    }

    @Test
    public void testOneNodesOneTierOneReplicantCostBalancerStrategyNotEnoughSpace() {
        this.mockEmptyPeon();
        int numReplicants = 1;
        EasyMock.expect((Object)this.databaseRuleManager.getRulesWithDefault((String)EasyMock.anyObject())).andReturn(Collections.singletonList(new ForeverLoadRule((Map)ImmutableMap.of((Object)"_default_tier", (Object)numReplicants), null))).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.databaseRuleManager});
        DataSegment dataSegment = new DataSegment(DATASOURCE, Intervals.utc((long)0L, (long)1L), DateTimes.nowUtc().toString(), Collections.emptyMap(), Collections.emptyList(), Collections.emptyList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(9), 11L);
        DruidCluster druidCluster = DruidCluster.builder().addTier("_default_tier", new ServerHolder[]{new ServerHolder(new DruidServer("server1", "host1", null, 10L, ServerType.HISTORICAL, "_default_tier", 0).toImmutableDruidServer(), this.mockPeon)}).build();
        DruidCoordinatorRuntimeParams params = this.createCoordinatorRuntimeParams(druidCluster, dataSegment).withBalancerStrategy((BalancerStrategy)new CostBalancerStrategy(this.balancerExecutor)).withDynamicConfigs(CoordinatorDynamicConfig.builder().withMaxSegmentsToMove(5).build()).withSegmentAssignerUsing(this.loadQueueManager).build();
        CoordinatorRunStats stats = this.runDutyAndGetStats(params);
        RowKey tierRowKey = RowKey.of((Dimension)Dimension.TIER, (String)"_default_tier");
        Assert.assertEquals((long)(dataSegment.getSize() * (long)numReplicants), (long)stats.get(Stats.Tier.REQUIRED_CAPACITY, tierRowKey));
        Assert.assertEquals((long)0L, (long)stats.getSegmentStat(Stats.Segments.ASSIGNED, "_default_tier", DATASOURCE));
        Assert.assertFalse((boolean)stats.hasStat(Stats.Segments.DROPPED));
        EasyMock.verify((Object[])new Object[]{this.mockPeon});
    }

    @Test
    public void testSegmentWithZeroRequiredReplicasHasZeroReplicationFactor() {
        EasyMock.expect((Object)this.databaseRuleManager.getRulesWithDefault((String)EasyMock.anyObject())).andReturn(Collections.singletonList(new ForeverLoadRule(Collections.emptyMap(), Boolean.valueOf(false)))).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.databaseRuleManager});
        DruidCluster cluster = DruidCluster.builder().add(this.createServerHolder("server", "normal", new TestLoadQueuePeon())).build();
        DataSegment segment = this.usedSegments.get(0);
        DruidCoordinatorRuntimeParams params = this.createCoordinatorRuntimeParams(cluster, segment).withBalancerStrategy((BalancerStrategy)new RandomBalancerStrategy()).withSegmentAssignerUsing(this.loadQueueManager).build();
        params = this.ruleRunner.run(params);
        Assert.assertNotNull((Object)params);
        SegmentReplicationStatus replicationStatus = params.getSegmentReplicationStatus();
        Assert.assertNotNull((Object)replicationStatus);
        SegmentReplicaCount replicaCounts = replicationStatus.getReplicaCountsInCluster(segment.getId());
        Assert.assertNotNull((Object)replicaCounts);
        Assert.assertEquals((long)0L, (long)replicaCounts.required());
        Assert.assertEquals((long)0L, (long)replicaCounts.totalLoaded());
        Assert.assertEquals((long)0L, (long)replicaCounts.requiredAndLoadable());
    }

    private CoordinatorRunStats runDutyAndGetStats(DruidCoordinatorRuntimeParams params) {
        params = this.ruleRunner.run(params);
        return params.getCoordinatorStats();
    }

    private void mockEmptyPeon() {
        EasyMock.expect((Object)this.mockPeon.getSegmentsToLoad()).andReturn(Collections.emptySet()).anyTimes();
        EasyMock.expect((Object)this.mockPeon.getSegmentsMarkedToDrop()).andReturn(Collections.emptySet()).anyTimes();
        EasyMock.expect((Object)this.mockPeon.getSegmentsInQueue()).andReturn(Collections.emptySet()).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockPeon});
    }
}

