/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.simulate;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.client.DataSourcesSnapshot;
import org.apache.druid.client.ImmutableDruidDataSource;
import org.apache.druid.metadata.SegmentsMetadataManager;
import org.apache.druid.metadata.SortOrder;
import org.apache.druid.server.http.DataSegmentPlus;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.Partitions;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.VersionedIntervalTimeline;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class TestSegmentsMetadataManager
implements SegmentsMetadataManager {
    private final ConcurrentMap<String, DataSegment> allSegments = new ConcurrentHashMap<String, DataSegment>();
    private final ConcurrentMap<String, DataSegment> usedSegments = new ConcurrentHashMap<String, DataSegment>();
    private volatile DataSourcesSnapshot snapshot;
    private volatile boolean pollingStarted;

    public void addSegment(DataSegment segment) {
        this.allSegments.put(segment.getId().toString(), segment);
        this.usedSegments.put(segment.getId().toString(), segment);
        this.snapshot = null;
    }

    public void removeSegment(DataSegment segment) {
        this.allSegments.remove(segment.getId().toString());
        this.usedSegments.remove(segment.getId().toString());
        this.snapshot = null;
    }

    public void startPollingDatabasePeriodically() {
        this.pollingStarted = true;
    }

    public void stopPollingDatabasePeriodically() {
        this.pollingStarted = false;
    }

    public boolean isPollingDatabasePeriodically() {
        return this.pollingStarted;
    }

    public int markAsUsedAllNonOvershadowedSegmentsInDataSource(String dataSource) {
        return 0;
    }

    public int markAsUsedNonOvershadowedSegmentsInInterval(String dataSource, Interval interval, @Nullable List<String> versions) {
        return 0;
    }

    public int markAsUsedNonOvershadowedSegments(String dataSource, Set<String> segmentIds) {
        return 0;
    }

    public boolean markSegmentAsUsed(String segmentId) {
        if (!this.allSegments.containsKey(segmentId)) {
            return false;
        }
        this.usedSegments.put(segmentId, (DataSegment)this.allSegments.get(segmentId));
        return true;
    }

    public int markAsUnusedAllSegmentsInDataSource(String dataSource) {
        return 0;
    }

    public int markAsUnusedSegmentsInInterval(String dataSource, Interval interval, @Nullable List<String> versions) {
        return 0;
    }

    public int markSegmentsAsUnused(Set<SegmentId> segmentIds) {
        int numModifiedSegments = 0;
        for (SegmentId segmentId : segmentIds) {
            if (!this.allSegments.containsKey(segmentId.toString())) continue;
            this.usedSegments.remove(segmentId.toString());
            ++numModifiedSegments;
        }
        if (numModifiedSegments > 0) {
            this.snapshot = null;
        }
        return numModifiedSegments;
    }

    public boolean markSegmentAsUnused(SegmentId segmentId) {
        boolean updated;
        boolean bl = updated = this.usedSegments.remove(segmentId.toString()) != null;
        if (updated) {
            this.snapshot = null;
        }
        return updated;
    }

    @Nullable
    public ImmutableDruidDataSource getImmutableDataSourceWithUsedSegments(String dataSource) {
        if (this.snapshot == null) {
            this.getSnapshotOfDataSourcesWithAllUsedSegments();
        }
        return this.snapshot.getDataSource(dataSource);
    }

    public Collection<ImmutableDruidDataSource> getImmutableDataSourcesWithAllUsedSegments() {
        return this.getSnapshotOfDataSourcesWithAllUsedSegments().getDataSourcesWithAllUsedSegments();
    }

    public DataSourcesSnapshot getSnapshotOfDataSourcesWithAllUsedSegments() {
        if (this.snapshot == null) {
            this.snapshot = DataSourcesSnapshot.fromUsedSegments(this.usedSegments.values(), (ImmutableMap)ImmutableMap.of());
        }
        return this.snapshot;
    }

    public Iterable<DataSegment> iterateAllUsedSegments() {
        return this.usedSegments.values();
    }

    public Optional<Iterable<DataSegment>> iterateAllUsedNonOvershadowedSegmentsForDatasourceInterval(String datasource, Interval interval, boolean requiresLatest) {
        VersionedIntervalTimeline usedSegmentsTimeline = (VersionedIntervalTimeline)this.getSnapshotOfDataSourcesWithAllUsedSegments().getUsedSegmentsTimelinesPerDataSource().get(datasource);
        return Optional.fromNullable((Object)usedSegmentsTimeline).transform(timeline -> timeline.findNonOvershadowedObjectsInInterval(interval, Partitions.ONLY_COMPLETE));
    }

    public Iterable<DataSegmentPlus> iterateAllUnusedSegmentsForDatasource(String datasource, @Nullable Interval interval, @Nullable Integer limit, @Nullable String lastSegmentId, @Nullable SortOrder sortOrder) {
        return null;
    }

    public Set<String> retrieveAllDataSourceNames() {
        return this.allSegments.values().stream().map(DataSegment::getDataSource).collect(Collectors.toSet());
    }

    public List<Interval> getUnusedSegmentIntervals(String dataSource, @Nullable DateTime minStartTime, DateTime maxEndTime, int limit, DateTime maxUsedStatusLastUpdatedTime) {
        return null;
    }

    public void populateUsedFlagLastUpdatedAsync() {
    }

    public void stopAsyncUsedFlagLastUpdatedUpdate() {
    }
}

