/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.http;

import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collections;
import javax.annotation.Nullable;
import javax.ws.rs.core.Response;
import org.apache.druid.client.indexing.NoopOverlordClient;
import org.apache.druid.error.DruidExceptionMatcher;
import org.apache.druid.error.ErrorResponse;
import org.apache.druid.rpc.indexing.OverlordClient;
import org.apache.druid.server.compaction.CompactionStatistics;
import org.apache.druid.server.compaction.CompactionStatusResponse;
import org.apache.druid.server.coordinator.AutoCompactionSnapshot;
import org.apache.druid.server.coordinator.DruidCoordinator;
import org.apache.druid.server.http.CoordinatorCompactionResource;
import org.easymock.EasyMock;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CoordinatorCompactionResourceTest {
    private DruidCoordinator mock;
    private OverlordClient overlordClient;
    private final String dataSourceName = "datasource_1";
    private final AutoCompactionSnapshot expectedSnapshot = new AutoCompactionSnapshot("datasource_1", AutoCompactionSnapshot.AutoCompactionScheduleStatus.RUNNING, null, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L);

    @Before
    public void setUp() {
        this.mock = (DruidCoordinator)EasyMock.createStrictMock(DruidCoordinator.class);
        this.overlordClient = new NoopOverlordClient(){

            @Override
            public ListenableFuture<Boolean> isCompactionSupervisorEnabled() {
                return Futures.immediateFuture((Object)false);
            }
        };
    }

    @After
    public void tearDown() {
        EasyMock.verify((Object[])new Object[]{this.mock});
    }

    @Test
    public void testGetCompactionSnapshotForDataSourceWithEmptyQueryParameter() {
        ImmutableMap expected = ImmutableMap.of((Object)"datasource_1", (Object)this.expectedSnapshot);
        EasyMock.expect((Object)this.mock.getAutoCompactionSnapshot()).andReturn((Object)expected).once();
        EasyMock.replay((Object[])new Object[]{this.mock});
        Response response = new CoordinatorCompactionResource(this.mock, this.overlordClient).getCompactionSnapshotForDataSource("");
        Assert.assertEquals((Object)new CompactionStatusResponse(expected.values()), (Object)response.getEntity());
        Assert.assertEquals((long)200L, (long)response.getStatus());
    }

    @Test
    public void testGetCompactionSnapshotForDataSourceWithNullQueryParameter() {
        String dataSourceName = "datasource_1";
        ImmutableMap expected = ImmutableMap.of((Object)dataSourceName, (Object)this.expectedSnapshot);
        EasyMock.expect((Object)this.mock.getAutoCompactionSnapshot()).andReturn((Object)expected).once();
        EasyMock.replay((Object[])new Object[]{this.mock});
        Response response = new CoordinatorCompactionResource(this.mock, this.overlordClient).getCompactionSnapshotForDataSource(null);
        Assert.assertEquals((Object)new CompactionStatusResponse(expected.values()), (Object)response.getEntity());
        Assert.assertEquals((long)200L, (long)response.getStatus());
    }

    @Test
    public void testGetCompactionSnapshotForDataSourceWithValidQueryParameter() {
        String dataSourceName = "datasource_1";
        EasyMock.expect((Object)this.mock.getAutoCompactionSnapshotForDataSource(dataSourceName)).andReturn((Object)this.expectedSnapshot).once();
        EasyMock.replay((Object[])new Object[]{this.mock});
        Response response = new CoordinatorCompactionResource(this.mock, this.overlordClient).getCompactionSnapshotForDataSource(dataSourceName);
        Assert.assertEquals((Object)new CompactionStatusResponse(Collections.singletonList(this.expectedSnapshot)), (Object)response.getEntity());
        Assert.assertEquals((long)200L, (long)response.getStatus());
    }

    @Test
    public void testGetCompactionSnapshotForDataSourceWithInvalidQueryParameter() {
        String dataSourceName = "invalid_datasource";
        EasyMock.expect((Object)this.mock.getAutoCompactionSnapshotForDataSource(dataSourceName)).andReturn(null).once();
        EasyMock.replay((Object[])new Object[]{this.mock});
        Response response = new CoordinatorCompactionResource(this.mock, this.overlordClient).getCompactionSnapshotForDataSource(dataSourceName);
        Assert.assertEquals((long)404L, (long)response.getStatus());
    }

    @Test
    public void testGetProgressForNullDatasourceReturnsBadRequest() {
        EasyMock.replay((Object[])new Object[]{this.mock});
        Response response = new CoordinatorCompactionResource(this.mock, this.overlordClient).getCompactionProgress(null);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
        Object responseEntity = response.getEntity();
        Assert.assertTrue((boolean)(responseEntity instanceof ErrorResponse));
        MatcherAssert.assertThat((Object)((ErrorResponse)responseEntity).getUnderlyingException(), (Matcher)DruidExceptionMatcher.invalidInput().expectMessageIs("No DataSource specified"));
    }

    @Test
    public void testGetSnapshotRedirectsToOverlordWhenSupervisorIsEnabled() {
        EasyMock.replay((Object[])new Object[]{this.mock});
        AutoCompactionSnapshot.Builder snapshotBuilder = AutoCompactionSnapshot.builder((String)"datasource_1");
        snapshotBuilder.incrementCompactedStats(CompactionStatistics.create((long)100L, (long)10L, (long)1L));
        final AutoCompactionSnapshot snapshotFromOverlord = snapshotBuilder.build();
        this.overlordClient = new NoopOverlordClient(){

            @Override
            public ListenableFuture<Boolean> isCompactionSupervisorEnabled() {
                return Futures.immediateFuture((Object)true);
            }

            @Override
            public ListenableFuture<CompactionStatusResponse> getCompactionSnapshots(@Nullable String dataSource) {
                return Futures.immediateFuture((Object)new CompactionStatusResponse(Collections.singletonList(snapshotFromOverlord)));
            }
        };
        Response response = new CoordinatorCompactionResource(this.mock, this.overlordClient).getCompactionSnapshotForDataSource("datasource_1");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)new CompactionStatusResponse(Collections.singletonList(snapshotFromOverlord)), (Object)response.getEntity());
    }
}

