/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.security;

import java.util.function.Function;
import org.apache.druid.server.security.Access;
import org.apache.druid.server.security.ForbiddenException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ForbiddenExceptionTest {
    private static final String ERROR_MESSAGE_ORIGINAL = "aaaa";
    private static final String ERROR_MESSAGE_TRANSFORMED = "bbbb";
    @Mock
    private Function<String, String> trasformFunction;

    @Test
    public void testSanitizeWithTransformFunctionReturningNull() {
        Mockito.when((Object)this.trasformFunction.apply((String)ArgumentMatchers.eq((Object)ERROR_MESSAGE_ORIGINAL))).thenReturn(null);
        ForbiddenException forbiddenException = new ForbiddenException(ERROR_MESSAGE_ORIGINAL);
        ForbiddenException actual = forbiddenException.sanitize(this.trasformFunction);
        Assert.assertNotNull((Object)((Object)actual));
        Assert.assertEquals((Object)actual.getMessage(), (Object)"Unauthorized");
        ((Function)Mockito.verify(this.trasformFunction)).apply((String)ArgumentMatchers.eq((Object)ERROR_MESSAGE_ORIGINAL));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.trasformFunction});
    }

    @Test
    public void testSanitizeWithTransformFunctionReturningNewString() {
        Mockito.when((Object)this.trasformFunction.apply((String)ArgumentMatchers.eq((Object)ERROR_MESSAGE_ORIGINAL))).thenReturn((Object)ERROR_MESSAGE_TRANSFORMED);
        ForbiddenException forbiddenException = new ForbiddenException(ERROR_MESSAGE_ORIGINAL);
        ForbiddenException actual = forbiddenException.sanitize(this.trasformFunction);
        Assert.assertNotNull((Object)((Object)actual));
        Assert.assertEquals((Object)actual.getMessage(), (Object)ERROR_MESSAGE_TRANSFORMED);
        ((Function)Mockito.verify(this.trasformFunction)).apply((String)ArgumentMatchers.eq((Object)ERROR_MESSAGE_ORIGINAL));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.trasformFunction});
    }

    @Test
    public void testAccess() {
        Access access = new Access(false);
        Assert.assertFalse((boolean)access.isAllowed());
        Assert.assertEquals((Object)"", (Object)access.getMessage());
        Assert.assertEquals((Object)"Allowed:false, Message:", (Object)access.toString());
        Assert.assertEquals((Object)"Unauthorized", (Object)access.toMessage());
        access = new Access(true);
        Assert.assertTrue((boolean)access.isAllowed());
        Assert.assertEquals((Object)"", (Object)access.getMessage());
        Assert.assertEquals((Object)"Allowed:true, Message:", (Object)access.toString());
        Assert.assertEquals((Object)"Authorized", (Object)access.toMessage());
        access = new Access(false, "oops");
        Assert.assertFalse((boolean)access.isAllowed());
        Assert.assertEquals((Object)"oops", (Object)access.getMessage());
        Assert.assertEquals((Object)"Allowed:false, Message:oops", (Object)access.toString());
        Assert.assertEquals((Object)"Allowed:false, Message:oops", (Object)access.toMessage());
    }
}

