/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import org.apache.druid.client.CachingClusteredClient;
import org.apache.druid.client.DruidServer;
import org.apache.druid.client.QueryableDruidServer;
import org.apache.druid.client.TimelineServerView;
import org.apache.druid.client.cache.CacheConfig;
import org.apache.druid.client.cache.CachePopulator;
import org.apache.druid.client.cache.MapCache;
import org.apache.druid.client.selector.HighestPriorityTierSelectorStrategy;
import org.apache.druid.client.selector.RandomServerSelectorStrategy;
import org.apache.druid.client.selector.ServerSelector;
import org.apache.druid.client.selector.ServerSelectorStrategy;
import org.apache.druid.client.selector.TierSelectorStrategy;
import org.apache.druid.guice.http.DruidHttpClientConfig;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.TestSequence;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.query.BaseQuery;
import org.apache.druid.query.BrokerParallelMergeConfig;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryLogic;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryRunnerFactory;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.planning.DataSourceAnalysis;
import org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.druid.query.spec.MultipleSpecificSegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.server.QueryScheduler;
import org.apache.druid.server.coordination.ServerManagerTest;
import org.apache.druid.server.coordination.ServerType;
import org.apache.druid.server.metrics.NoopServiceEmitter;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.VersionedIntervalTimeline;
import org.apache.druid.timeline.partition.LinearShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class CachingClusteredClientPerfTest {
    @Test(timeout=10000L)
    public void testGetQueryRunnerForSegments_singleIntervalLargeSegments() {
        int segmentCount = 30000;
        Interval interval = Intervals.of((String)"2021-02-13/2021-02-14");
        ArrayList<SegmentDescriptor> segmentDescriptors = new ArrayList<SegmentDescriptor>(30000);
        ArrayList<DataSegment> dataSegments = new ArrayList<DataSegment>(30000);
        VersionedIntervalTimeline timeline = new VersionedIntervalTimeline((Comparator)Ordering.natural());
        DruidServer server = new DruidServer("server", "localhost:9000", null, Long.MAX_VALUE, ServerType.HISTORICAL, "_default_tier", 0);
        for (int ii = 0; ii < 30000; ++ii) {
            segmentDescriptors.add(new SegmentDescriptor(interval, "1", ii));
            DataSegment segment2 = this.makeDataSegment("test", interval, "1", ii);
            dataSegments.add(segment2);
        }
        timeline.addAll(Iterators.transform(dataSegments.iterator(), segment -> {
            ServerSelector ss = new ServerSelector(segment, (TierSelectorStrategy)new HighestPriorityTierSelectorStrategy((ServerSelectorStrategy)new RandomServerSelectorStrategy()));
            ss.addServerAndUpdateSegment(new QueryableDruidServer(server, (QueryRunner)new MockQueryRunner()), segment);
            return new VersionedIntervalTimeline.PartitionChunkEntry(segment.getInterval(), (Object)segment.getVersion(), segment.getShardSpec().createChunk((Object)ss));
        }));
        TimelineServerView serverView = (TimelineServerView)Mockito.mock(TimelineServerView.class);
        QueryScheduler queryScheduler = (QueryScheduler)Mockito.mock(QueryScheduler.class);
        Mockito.when((Object)queryScheduler.run((Query)ArgumentMatchers.any(), (Sequence)ArgumentMatchers.any())).thenAnswer(i -> i.getArgument(1));
        Mockito.when((Object)queryScheduler.prioritizeAndLaneQuery((QueryPlus)ArgumentMatchers.any(), (Set)ArgumentMatchers.any())).thenAnswer(i -> ((QueryPlus)i.getArgument(0)).getQuery());
        ((TimelineServerView)Mockito.doReturn(Optional.of(timeline)).when((Object)serverView)).getTimeline((DataSourceAnalysis)ArgumentMatchers.any());
        ((TimelineServerView)Mockito.doReturn((Object)new MockQueryRunner()).when((Object)serverView)).getQueryRunner((DruidServer)ArgumentMatchers.any());
        CachingClusteredClient cachingClusteredClient = new CachingClusteredClient((QueryRunnerFactoryConglomerate)new MockQueryRunnerFactoryConglomerate(), serverView, MapCache.create((long)1024L), TestHelper.makeJsonMapper(), (CachePopulator)Mockito.mock(CachePopulator.class), new CacheConfig(), (DruidHttpClientConfig)Mockito.mock(DruidHttpClientConfig.class), (BrokerParallelMergeConfig)Mockito.mock(BrokerParallelMergeConfig.class), ForkJoinPool.commonPool(), queryScheduler, (ServiceEmitter)new NoopServiceEmitter());
        Query<SegmentDescriptor> fakeQuery = this.makeFakeQuery(interval);
        QueryRunner queryRunner = cachingClusteredClient.getQueryRunnerForSegments(fakeQuery, segmentDescriptors);
        Sequence sequence = queryRunner.run(QueryPlus.wrap(fakeQuery));
        Assert.assertEquals(segmentDescriptors, (Object)sequence.toList());
    }

    private Query<SegmentDescriptor> makeFakeQuery(Interval interval) {
        return new TestQuery((DataSource)new TableDataSource("test"), (QuerySegmentSpec)new MultipleIntervalSegmentSpec(Collections.singletonList(interval)), (Map<String, Object>)ImmutableMap.of((Object)"queryId", (Object)"testQuery"));
    }

    private DataSegment makeDataSegment(String dataSource, Interval interval, String version, int partition) {
        return DataSegment.builder().dataSource(dataSource).interval(interval).version(version).shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(partition))).size(1L).build();
    }

    private static class TestQuery
    extends BaseQuery<SegmentDescriptor> {
        private QuerySegmentSpec spec;

        public TestQuery(DataSource dataSource, QuerySegmentSpec querySegmentSpec, Map<String, Object> context) {
            super(dataSource, querySegmentSpec, context);
        }

        public boolean hasFilters() {
            return false;
        }

        public DimFilter getFilter() {
            return null;
        }

        public String getType() {
            return "string";
        }

        public Query<SegmentDescriptor> withOverriddenContext(Map<String, Object> contextOverride) {
            return this;
        }

        public Query<SegmentDescriptor> withQuerySegmentSpec(QuerySegmentSpec spec) {
            this.spec = spec;
            return this;
        }

        public Query<SegmentDescriptor> withDataSource(DataSource dataSource) {
            return this;
        }

        public QuerySegmentSpec getSpec() {
            return this.spec;
        }
    }

    private static class MockQueryRunner
    implements QueryRunner<SegmentDescriptor> {
        private MockQueryRunner() {
        }

        public Sequence<SegmentDescriptor> run(QueryPlus<SegmentDescriptor> queryPlus, ResponseContext responseContext) {
            TestQuery query = (TestQuery)queryPlus.getQuery();
            return TestSequence.create((Iterable)((MultipleSpecificSegmentSpec)query.getSpec()).getDescriptors());
        }
    }

    private static class MockQueryRunnerFactoryConglomerate
    implements QueryRunnerFactoryConglomerate {
        private MockQueryRunnerFactoryConglomerate() {
        }

        public <T, QueryType extends Query<T>> QueryToolChest<T, QueryType> getToolChest(QueryType query) {
            return new ServerManagerTest.NoopQueryToolChest();
        }

        public <T, QueryType extends Query<T>> QueryRunnerFactory<T, QueryType> findFactory(QueryType query) {
            return null;
        }

        public <T, QueryType extends Query<T>> QueryLogic getQueryLogic(QueryType query) {
            return null;
        }
    }
}

