/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client.selector;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.apache.druid.client.DirectDruidClient;
import org.apache.druid.client.DruidServer;
import org.apache.druid.client.QueryableDruidServer;
import org.apache.druid.client.selector.HighestPriorityTierSelectorStrategy;
import org.apache.druid.client.selector.RandomServerSelectorStrategy;
import org.apache.druid.client.selector.ServerSelector;
import org.apache.druid.client.selector.ServerSelectorStrategy;
import org.apache.druid.client.selector.TierSelectorStrategy;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.server.coordination.ServerType;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.NoneShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.druid.timeline.partition.TombstoneShardSpec;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ServerSelectorTest {
    @Before
    public void setUp() {
        TierSelectorStrategy tierSelectorStrategy = (TierSelectorStrategy)EasyMock.createMock(TierSelectorStrategy.class);
        EasyMock.expect((Object)tierSelectorStrategy.getComparator()).andReturn(Integer::compare).anyTimes();
    }

    @Test
    public void testSegmentUpdate() {
        ServerSelector selector = new ServerSelector(DataSegment.builder().dataSource("test_broker_server_view").interval(Intervals.of((String)"2012/2013")).loadSpec((Map)ImmutableMap.of((Object)"type", (Object)"local", (Object)"path", (Object)"somewhere")).version("v1").dimensions((List)ImmutableList.of()).metrics((List)ImmutableList.of()).shardSpec((ShardSpec)NoneShardSpec.instance()).binaryVersion(Integer.valueOf(9)).size(0L).build(), (TierSelectorStrategy)new HighestPriorityTierSelectorStrategy((ServerSelectorStrategy)new RandomServerSelectorStrategy()));
        selector.addServerAndUpdateSegment(new QueryableDruidServer(new DruidServer("test1", "localhost", null, 0L, ServerType.HISTORICAL, "_default_tier", 1), (QueryRunner)EasyMock.createMock(DirectDruidClient.class)), DataSegment.builder().dataSource("test_broker_server_view").interval(Intervals.of((String)"2012/2013")).loadSpec((Map)ImmutableMap.of((Object)"type", (Object)"local", (Object)"path", (Object)"somewhere")).version("v1").dimensions((List)ImmutableList.of((Object)"a", (Object)"b", (Object)"c")).metrics((List)ImmutableList.of()).shardSpec((ShardSpec)NoneShardSpec.instance()).binaryVersion(Integer.valueOf(9)).size(0L).build());
        Assert.assertEquals((Object)ImmutableList.of((Object)"a", (Object)"b", (Object)"c"), (Object)selector.getSegment().getDimensions());
    }

    @Test(expected=NullPointerException.class)
    public void testSegmentCannotBeNull() {
        ServerSelector selector = new ServerSelector(null, (TierSelectorStrategy)new HighestPriorityTierSelectorStrategy((ServerSelectorStrategy)new RandomServerSelectorStrategy()));
    }

    @Test
    public void testSegmentWithNoData() {
        ServerSelector selector = new ServerSelector(DataSegment.builder().dataSource("test_broker_server_view").interval(Intervals.of((String)"2012/2013")).loadSpec((Map)ImmutableMap.of((Object)"type", (Object)"tombstone")).version("v1").dimensions((List)ImmutableList.of()).metrics((List)ImmutableList.of()).shardSpec((ShardSpec)new TombstoneShardSpec()).binaryVersion(Integer.valueOf(9)).size(0L).build(), (TierSelectorStrategy)new HighestPriorityTierSelectorStrategy((ServerSelectorStrategy)new RandomServerSelectorStrategy()));
        Assert.assertFalse((boolean)selector.hasData());
    }

    @Test
    public void testSegmentWithData() {
        ServerSelector selector = new ServerSelector(DataSegment.builder().dataSource("another segment").interval(Intervals.of((String)"2012/2013")).loadSpec((Map)ImmutableMap.of((Object)"type", (Object)"local", (Object)"path", (Object)"somewhere")).version("v1").dimensions((List)ImmutableList.of()).metrics((List)ImmutableList.of()).shardSpec((ShardSpec)NoneShardSpec.instance()).binaryVersion(Integer.valueOf(9)).size(0L).build(), (TierSelectorStrategy)new HighestPriorityTierSelectorStrategy((ServerSelectorStrategy)new RandomServerSelectorStrategy()));
        Assert.assertTrue((boolean)selector.hasData());
    }
}

