/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import java.io.IOException;
import java.util.List;
import org.apache.druid.client.CachingClusteredClient;
import org.apache.druid.client.SimpleServerView;
import org.apache.druid.client.cache.Cache;
import org.apache.druid.client.cache.CacheConfig;
import org.apache.druid.client.cache.MapCache;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryRunnerBasedOnClusteredClientTestBase;
import org.apache.druid.query.Result;
import org.apache.druid.query.ResultLevelCachingQueryRunner;
import org.apache.druid.query.RetryQueryRunner;
import org.apache.druid.query.RetryQueryRunnerConfig;
import org.apache.druid.query.timeseries.TimeseriesResultValue;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.Interval;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ResultLevelCachingQueryRunnerTest
extends QueryRunnerBasedOnClusteredClientTestBase {
    private Cache cache;

    @Before
    public void setup() {
        this.cache = MapCache.create((long)1024L);
    }

    @After
    public void tearDown() throws IOException {
        this.cache.close();
    }

    @Test
    public void testNotPopulateAndNotUse() {
        this.prepareCluster(10);
        Query<Result<TimeseriesResultValue>> query = ResultLevelCachingQueryRunnerTest.timeseriesQuery(BASE_SCHEMA_INFO.getDataInterval());
        ResultLevelCachingQueryRunner<Result<TimeseriesResultValue>> queryRunner1 = this.createQueryRunner(this.newCacheConfig(false, false), query);
        Sequence sequence1 = queryRunner1.run(QueryPlus.wrap(query), ResultLevelCachingQueryRunnerTest.responseContext());
        List results1 = sequence1.toList();
        Assert.assertEquals((long)0L, (long)this.cache.getStats().getNumHits());
        Assert.assertEquals((long)0L, (long)this.cache.getStats().getNumEntries());
        Assert.assertEquals((long)0L, (long)this.cache.getStats().getNumMisses());
        ResultLevelCachingQueryRunner<Result<TimeseriesResultValue>> queryRunner2 = this.createQueryRunner(this.newCacheConfig(false, false), query);
        Sequence sequence2 = queryRunner2.run(QueryPlus.wrap(query), ResultLevelCachingQueryRunnerTest.responseContext());
        List results2 = sequence2.toList();
        Assert.assertEquals((Object)results1, (Object)results2);
        Assert.assertEquals((long)0L, (long)this.cache.getStats().getNumHits());
        Assert.assertEquals((long)0L, (long)this.cache.getStats().getNumEntries());
        Assert.assertEquals((long)0L, (long)this.cache.getStats().getNumMisses());
    }

    @Test
    public void testPopulateAndNotUse() {
        this.prepareCluster(10);
        Query<Result<TimeseriesResultValue>> query = ResultLevelCachingQueryRunnerTest.timeseriesQuery(BASE_SCHEMA_INFO.getDataInterval());
        ResultLevelCachingQueryRunner<Result<TimeseriesResultValue>> queryRunner1 = this.createQueryRunner(this.newCacheConfig(true, false), query);
        Sequence sequence1 = queryRunner1.run(QueryPlus.wrap(query), ResultLevelCachingQueryRunnerTest.responseContext());
        List results1 = sequence1.toList();
        Assert.assertEquals((long)0L, (long)this.cache.getStats().getNumHits());
        Assert.assertEquals((long)1L, (long)this.cache.getStats().getNumEntries());
        Assert.assertEquals((long)0L, (long)this.cache.getStats().getNumMisses());
        ResultLevelCachingQueryRunner<Result<TimeseriesResultValue>> queryRunner2 = this.createQueryRunner(this.newCacheConfig(true, false), query);
        Sequence sequence2 = queryRunner2.run(QueryPlus.wrap(query), ResultLevelCachingQueryRunnerTest.responseContext());
        List results2 = sequence2.toList();
        Assert.assertEquals((Object)results1, (Object)results2);
        Assert.assertEquals((long)0L, (long)this.cache.getStats().getNumHits());
        Assert.assertEquals((long)1L, (long)this.cache.getStats().getNumEntries());
        Assert.assertEquals((long)0L, (long)this.cache.getStats().getNumMisses());
    }

    @Test
    public void testNotPopulateAndUse() {
        this.prepareCluster(10);
        Query<Result<TimeseriesResultValue>> query = ResultLevelCachingQueryRunnerTest.timeseriesQuery(BASE_SCHEMA_INFO.getDataInterval());
        ResultLevelCachingQueryRunner<Result<TimeseriesResultValue>> queryRunner1 = this.createQueryRunner(this.newCacheConfig(false, false), query);
        Sequence sequence1 = queryRunner1.run(QueryPlus.wrap(query), ResultLevelCachingQueryRunnerTest.responseContext());
        List results1 = sequence1.toList();
        Assert.assertEquals((long)0L, (long)this.cache.getStats().getNumHits());
        Assert.assertEquals((long)0L, (long)this.cache.getStats().getNumEntries());
        Assert.assertEquals((long)0L, (long)this.cache.getStats().getNumMisses());
        ResultLevelCachingQueryRunner<Result<TimeseriesResultValue>> queryRunner2 = this.createQueryRunner(this.newCacheConfig(false, true), query);
        Sequence sequence2 = queryRunner2.run(QueryPlus.wrap(query), ResultLevelCachingQueryRunnerTest.responseContext());
        List results2 = sequence2.toList();
        Assert.assertEquals((Object)results1, (Object)results2);
        Assert.assertEquals((long)0L, (long)this.cache.getStats().getNumHits());
        Assert.assertEquals((long)0L, (long)this.cache.getStats().getNumEntries());
        Assert.assertEquals((long)1L, (long)this.cache.getStats().getNumMisses());
    }

    @Test
    public void testPopulateAndUse() {
        this.prepareCluster(10);
        Query<Result<TimeseriesResultValue>> query = ResultLevelCachingQueryRunnerTest.timeseriesQuery(BASE_SCHEMA_INFO.getDataInterval());
        ResultLevelCachingQueryRunner<Result<TimeseriesResultValue>> queryRunner1 = this.createQueryRunner(this.newCacheConfig(true, true), query);
        Sequence sequence1 = queryRunner1.run(QueryPlus.wrap(query), ResultLevelCachingQueryRunnerTest.responseContext());
        List results1 = sequence1.toList();
        Assert.assertEquals((long)0L, (long)this.cache.getStats().getNumHits());
        Assert.assertEquals((long)1L, (long)this.cache.getStats().getNumEntries());
        Assert.assertEquals((long)1L, (long)this.cache.getStats().getNumMisses());
        ResultLevelCachingQueryRunner<Result<TimeseriesResultValue>> queryRunner2 = this.createQueryRunner(this.newCacheConfig(true, true), query);
        Sequence sequence2 = queryRunner2.run(QueryPlus.wrap(query), ResultLevelCachingQueryRunnerTest.responseContext());
        List results2 = sequence2.toList();
        Assert.assertEquals((Object)results1, (Object)results2);
        Assert.assertEquals((long)1L, (long)this.cache.getStats().getNumHits());
        Assert.assertEquals((long)1L, (long)this.cache.getStats().getNumEntries());
        Assert.assertEquals((long)1L, (long)this.cache.getStats().getNumMisses());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPopulateCacheWhenQueryThrowExceptionShouldNotCache() {
        Interval interval = Intervals.of((String)"2000-01-01/PT1H");
        DataSegment segment = ResultLevelCachingQueryRunnerTest.newSegment(interval, 0, 1);
        this.addServer(SimpleServerView.createServer(0), segment, this.generateSegment(segment), true);
        Query<Result<TimeseriesResultValue>> query = ResultLevelCachingQueryRunnerTest.timeseriesQuery(BASE_SCHEMA_INFO.getDataInterval());
        ResultLevelCachingQueryRunner<Result<TimeseriesResultValue>> queryRunner = this.createQueryRunner(this.newCacheConfig(true, false), query);
        Sequence sequence = queryRunner.run(QueryPlus.wrap(query), ResultLevelCachingQueryRunnerTest.responseContext());
        try {
            sequence.toList();
            Assert.fail((String)"Expected to throw an exception");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)"Exception for testing", (Object)e.getMessage());
        }
        finally {
            Assert.assertEquals((long)0L, (long)this.cache.getStats().getNumHits());
            Assert.assertEquals((long)0L, (long)this.cache.getStats().getNumEntries());
            Assert.assertEquals((long)0L, (long)this.cache.getStats().getNumMisses());
        }
    }

    private <T> ResultLevelCachingQueryRunner<T> createQueryRunner(CacheConfig cacheConfig, Query<T> query) {
        QueryRunner baseRunner = this.cachingClusteredClient.getQueryRunnerForIntervals(query, (Iterable)query.getIntervals());
        return new ResultLevelCachingQueryRunner((QueryRunner)new RetryQueryRunner(baseRunner, (arg_0, arg_1) -> ((CachingClusteredClient)this.cachingClusteredClient).getQueryRunnerForSegments(arg_0, arg_1), new RetryQueryRunnerConfig(), this.objectMapper), this.conglomerate.getToolChest(query), query, this.objectMapper, this.cache, cacheConfig);
    }

    private CacheConfig newCacheConfig(final boolean populateResultLevelCache, final boolean useResultLevelCache) {
        return new CacheConfig(){

            public boolean isPopulateResultLevelCache() {
                return populateResultLevelCache;
            }

            public boolean isUseResultLevelCache() {
                return useResultLevelCache;
            }
        };
    }
}

