/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.client.cache.Cache;
import org.apache.druid.client.cache.CacheConfig;
import org.apache.druid.collections.NonBlockingPool;
import org.apache.druid.guice.DruidInjectorBuilder;
import org.apache.druid.guice.ExpressionModule;
import org.apache.druid.guice.SegmentWranglerModule;
import org.apache.druid.guice.StartupInjectorBuilder;
import org.apache.druid.initialization.CoreInjectorBuilder;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.query.BrokerParallelMergeConfig;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.DefaultGenericQueryMetricsFactory;
import org.apache.druid.query.DefaultQueryRunnerFactoryConglomerate;
import org.apache.druid.query.DruidProcessingConfig;
import org.apache.druid.query.FrameBasedInlineDataSource;
import org.apache.druid.query.InlineDataSource;
import org.apache.druid.query.LookupDataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryRunnerFactory;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.query.QueryRunnerTestHelper;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.query.RetryQueryRunnerConfig;
import org.apache.druid.query.TestBufferPool;
import org.apache.druid.query.expression.LookupEnabledTestExprMacroTable;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.GroupByQueryConfig;
import org.apache.druid.query.groupby.GroupByQueryRunnerFactory;
import org.apache.druid.query.groupby.GroupByQueryRunnerTest;
import org.apache.druid.query.groupby.TestGroupByBuffers;
import org.apache.druid.query.lookup.LookupExtractorFactoryContainerProvider;
import org.apache.druid.query.metadata.SegmentMetadataQueryConfig;
import org.apache.druid.query.metadata.SegmentMetadataQueryQueryToolChest;
import org.apache.druid.query.metadata.SegmentMetadataQueryRunnerFactory;
import org.apache.druid.query.metadata.metadata.SegmentMetadataQuery;
import org.apache.druid.query.operator.WindowOperatorQuery;
import org.apache.druid.query.operator.WindowOperatorQueryQueryRunnerFactory;
import org.apache.druid.query.scan.ScanQuery;
import org.apache.druid.query.scan.ScanQueryConfig;
import org.apache.druid.query.scan.ScanQueryEngine;
import org.apache.druid.query.scan.ScanQueryQueryToolChest;
import org.apache.druid.query.scan.ScanQueryRunnerFactory;
import org.apache.druid.query.search.SearchQuery;
import org.apache.druid.query.search.SearchQueryConfig;
import org.apache.druid.query.search.SearchQueryQueryToolChest;
import org.apache.druid.query.search.SearchQueryRunnerFactory;
import org.apache.druid.query.search.SearchStrategySelector;
import org.apache.druid.query.timeboundary.TimeBoundaryQuery;
import org.apache.druid.query.timeboundary.TimeBoundaryQueryRunnerFactory;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.query.timeseries.TimeseriesQueryEngine;
import org.apache.druid.query.timeseries.TimeseriesQueryQueryToolChest;
import org.apache.druid.query.timeseries.TimeseriesQueryRunnerFactory;
import org.apache.druid.query.topn.TopNQuery;
import org.apache.druid.query.topn.TopNQueryConfig;
import org.apache.druid.query.topn.TopNQueryQueryToolChest;
import org.apache.druid.query.topn.TopNQueryRunnerFactory;
import org.apache.druid.query.union.UnionQuery;
import org.apache.druid.query.union.UnionQueryLogic;
import org.apache.druid.segment.ReferenceCountingSegment;
import org.apache.druid.segment.SegmentWrangler;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.join.FrameBasedInlineJoinableFactory;
import org.apache.druid.segment.join.InlineJoinableFactory;
import org.apache.druid.segment.join.JoinableFactory;
import org.apache.druid.segment.join.JoinableFactoryWrapper;
import org.apache.druid.segment.join.LookupJoinableFactory;
import org.apache.druid.segment.join.MapJoinableFactory;
import org.apache.druid.server.ClientQuerySegmentWalker;
import org.apache.druid.server.EtagProvider;
import org.apache.druid.server.LocalQuerySegmentWalker;
import org.apache.druid.server.QueryLaningStrategy;
import org.apache.druid.server.QueryScheduler;
import org.apache.druid.server.SubqueryGuardrailHelper;
import org.apache.druid.server.TestClusterQuerySegmentWalker;
import org.apache.druid.server.initialization.ServerConfig;
import org.apache.druid.server.metrics.SubqueryCountStatsProvider;
import org.apache.druid.server.scheduling.ManualQueryPrioritizationStrategy;
import org.apache.druid.server.scheduling.NoQueryLaningStrategy;
import org.apache.druid.sql.calcite.util.CacheTestHelperModule;
import org.apache.druid.timeline.VersionedIntervalTimeline;
import org.apache.druid.utils.JvmUtils;
import org.junit.Assert;
import org.junit.rules.ExternalResource;

public class QueryStackTests {
    public static final QueryScheduler DEFAULT_NOOP_SCHEDULER = new QueryScheduler(0, ManualQueryPrioritizationStrategy.INSTANCE, (QueryLaningStrategy)NoQueryLaningStrategy.INSTANCE, new ServerConfig());
    public static final int DEFAULT_NUM_MERGE_BUFFERS = -1;
    private static final int COMPUTE_BUFFER_SIZE = 0xA00000;

    private QueryStackTests() {
    }

    public static ClientQuerySegmentWalker createClientQuerySegmentWalker(Injector injector, QuerySegmentWalker clusterWalker, QuerySegmentWalker localWalker, QueryRunnerFactoryConglomerate conglomerate, JoinableFactory joinableFactory, ServerConfig serverConfig, ServiceEmitter emitter) {
        return new ClientQuerySegmentWalker(emitter, clusterWalker, localWalker, conglomerate, joinableFactory, new RetryQueryRunnerConfig(), (ObjectMapper)injector.getInstance(ObjectMapper.class), serverConfig, (Cache)injector.getInstance(Cache.class), (CacheConfig)injector.getInstance(CacheConfig.class), new SubqueryGuardrailHelper(null, JvmUtils.getRuntimeInfo().getMaxHeapSizeBytes(), 1), new SubqueryCountStatsProvider());
    }

    public static TestClusterQuerySegmentWalker createClusterQuerySegmentWalker(Map<String, VersionedIntervalTimeline<String, ReferenceCountingSegment>> timelines, QueryRunnerFactoryConglomerate conglomerate, @Nullable QueryScheduler scheduler, GroupByQueryConfig groupByQueryConfig, Injector injector) {
        return new TestClusterQuerySegmentWalker(timelines, conglomerate, scheduler, groupByQueryConfig, (EtagProvider)injector.getInstance(EtagProvider.KEY));
    }

    public static LocalQuerySegmentWalker createLocalQuerySegmentWalker(QueryRunnerFactoryConglomerate conglomerate, SegmentWrangler segmentWrangler, JoinableFactoryWrapper joinableFactoryWrapper, QueryScheduler scheduler, ServiceEmitter emitter) {
        return new LocalQuerySegmentWalker(conglomerate, segmentWrangler, joinableFactoryWrapper, scheduler, emitter);
    }

    public static BrokerParallelMergeConfig getParallelMergeConfig(final boolean useParallelMergePoolConfigured) {
        return new BrokerParallelMergeConfig(){

            public boolean useParallelMergePool() {
                return useParallelMergePoolConfigured;
            }
        };
    }

    public static DruidProcessingConfig getProcessingConfig(final int mergeBuffers) {
        return new DruidProcessingConfig(){

            public String getFormatString() {
                return null;
            }

            public int intermediateComputeSizeBytes() {
                return 0xA00000;
            }

            public int getNumThreads() {
                return 1;
            }

            public int getNumMergeBuffers() {
                if (mergeBuffers == -1) {
                    return 2;
                }
                return mergeBuffers;
            }
        };
    }

    public static QueryRunnerFactoryConglomerate createQueryRunnerFactoryConglomerate(Closer closer) {
        return QueryStackTests.createQueryRunnerFactoryConglomerate(closer, 1000);
    }

    public static QueryRunnerFactoryConglomerate createQueryRunnerFactoryConglomerate(Closer closer, Integer minTopNThreshold) {
        return QueryStackTests.createQueryRunnerFactoryConglomerate(closer, QueryStackTests.getProcessingConfig(-1), minTopNThreshold, TestHelper.makeJsonMapper());
    }

    public static QueryRunnerFactoryConglomerate createQueryRunnerFactoryConglomerate(Closer closer, DruidProcessingConfig processingConfig) {
        return QueryStackTests.createQueryRunnerFactoryConglomerate(closer, processingConfig, 1000, TestHelper.makeJsonMapper());
    }

    public static TestBufferPool makeTestBufferPool(Closer closer) {
        TestBufferPool testBufferPool = TestBufferPool.offHeap((int)0xA00000, (int)Integer.MAX_VALUE);
        closer.register(() -> Assert.assertEquals((long)0L, (long)testBufferPool.getOutstandingObjectCount()));
        return testBufferPool;
    }

    public static TestGroupByBuffers makeGroupByBuffers(Closer closer, DruidProcessingConfig processingConfig) {
        TestGroupByBuffers groupByBuffers = (TestGroupByBuffers)closer.register((Closeable)TestGroupByBuffers.createFromProcessingConfig((DruidProcessingConfig)processingConfig));
        return groupByBuffers;
    }

    public static QueryRunnerFactoryConglomerate createQueryRunnerFactoryConglomerate(Closer closer, DruidProcessingConfig processingConfig, Integer minTopNThreshold, ObjectMapper jsonMapper) {
        TestBufferPool testBufferPool = QueryStackTests.makeTestBufferPool(closer);
        TestGroupByBuffers groupByBuffers = QueryStackTests.makeGroupByBuffers(closer, processingConfig);
        return QueryStackTests.createQueryRunnerFactoryConglomerate(processingConfig, minTopNThreshold, jsonMapper, testBufferPool, groupByBuffers);
    }

    public static QueryRunnerFactoryConglomerate createQueryRunnerFactoryConglomerate(DruidProcessingConfig processingConfig, Integer minTopNThreshold, ObjectMapper jsonMapper, TestBufferPool testBufferPool, TestGroupByBuffers groupByBuffers) {
        ImmutableMap<Class<? extends Query>, QueryRunnerFactory> factories = QueryStackTests.makeDefaultQueryRunnerFactories(processingConfig, minTopNThreshold, jsonMapper, testBufferPool, groupByBuffers);
        UnionQueryLogic unionQueryLogic = new UnionQueryLogic();
        DefaultQueryRunnerFactoryConglomerate conglomerate = new DefaultQueryRunnerFactoryConglomerate(factories, Maps.transformValues(factories, f -> f.getToolchest()), (Map)ImmutableMap.of(UnionQuery.class, (Object)unionQueryLogic));
        unionQueryLogic.initialize((QueryRunnerFactoryConglomerate)conglomerate);
        return conglomerate;
    }

    public static ImmutableMap<Class<? extends Query>, QueryRunnerFactory> makeDefaultQueryRunnerFactories(DruidProcessingConfig processingConfig, final Integer minTopNThreshold, ObjectMapper jsonMapper, TestBufferPool testBufferPool, TestGroupByBuffers groupByBuffers) {
        GroupByQueryRunnerFactory groupByQueryRunnerFactory = GroupByQueryRunnerTest.makeQueryRunnerFactory((ObjectMapper)jsonMapper, (GroupByQueryConfig)new GroupByQueryConfig(){}, (TestGroupByBuffers)groupByBuffers, (DruidProcessingConfig)processingConfig);
        return ImmutableMap.builder().put(SegmentMetadataQuery.class, (Object)new SegmentMetadataQueryRunnerFactory(new SegmentMetadataQueryQueryToolChest(new SegmentMetadataQueryConfig("P1W")), QueryRunnerTestHelper.NOOP_QUERYWATCHER)).put(SearchQuery.class, (Object)new SearchQueryRunnerFactory(new SearchStrategySelector(Suppliers.ofInstance((Object)new SearchQueryConfig())), new SearchQueryQueryToolChest(new SearchQueryConfig()), QueryRunnerTestHelper.NOOP_QUERYWATCHER)).put(ScanQuery.class, (Object)new ScanQueryRunnerFactory(new ScanQueryQueryToolChest(DefaultGenericQueryMetricsFactory.instance()), new ScanQueryEngine(), new ScanQueryConfig())).put(TimeseriesQuery.class, (Object)new TimeseriesQueryRunnerFactory(new TimeseriesQueryQueryToolChest(), new TimeseriesQueryEngine(), QueryRunnerTestHelper.NOOP_QUERYWATCHER)).put(TopNQuery.class, (Object)new TopNQueryRunnerFactory((NonBlockingPool)testBufferPool, new TopNQueryQueryToolChest(new TopNQueryConfig(){

            public int getMinTopNThreshold() {
                return minTopNThreshold;
            }
        }), QueryRunnerTestHelper.NOOP_QUERYWATCHER)).put(GroupByQuery.class, (Object)groupByQueryRunnerFactory).put(TimeBoundaryQuery.class, (Object)new TimeBoundaryQueryRunnerFactory(QueryRunnerTestHelper.NOOP_QUERYWATCHER)).put(WindowOperatorQuery.class, (Object)new WindowOperatorQueryQueryRunnerFactory()).build();
    }

    public static JoinableFactory makeJoinableFactoryForLookup(LookupExtractorFactoryContainerProvider lookupProvider) {
        return QueryStackTests.makeJoinableFactoryFromDefault(lookupProvider, null, null);
    }

    public static JoinableFactory makeJoinableFactoryFromDefault(@Nullable LookupExtractorFactoryContainerProvider lookupProvider, @Nullable Set<JoinableFactory> customFactories, @Nullable Map<Class<? extends JoinableFactory>, Class<? extends DataSource>> customMappings) {
        ImmutableSet.Builder setBuilder = ImmutableSet.builder();
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        setBuilder.add((Object[])new JoinableFactory[]{new InlineJoinableFactory(), new FrameBasedInlineJoinableFactory()});
        mapBuilder.put(InlineJoinableFactory.class, InlineDataSource.class);
        mapBuilder.put(FrameBasedInlineJoinableFactory.class, FrameBasedInlineDataSource.class);
        if (lookupProvider != null) {
            setBuilder.add((Object)new LookupJoinableFactory(lookupProvider));
            mapBuilder.put(LookupJoinableFactory.class, LookupDataSource.class);
        }
        if (customFactories != null) {
            setBuilder.addAll(customFactories);
        }
        if (customMappings != null) {
            mapBuilder.putAll(customMappings);
        }
        return new MapJoinableFactory((Set)setBuilder.build(), (Map)mapBuilder.build());
    }

    public static DruidInjectorBuilder defaultInjectorBuilder() {
        Injector startupInjector = new StartupInjectorBuilder().build();
        DruidInjectorBuilder injectorBuilder = new CoreInjectorBuilder(startupInjector).ignoreLoadScopes().addModule((Module)new ExpressionModule()).addModule((Module)new SegmentWranglerModule()).addModule((Module)new CacheTestHelperModule(CacheTestHelperModule.ResultCacheMode.DISABLED));
        return injectorBuilder;
    }

    public static Injector injectorWithLookup() {
        LookupExtractorFactoryContainerProvider lookupProvider = LookupEnabledTestExprMacroTable.createTestLookupProvider(Collections.emptyMap());
        return QueryStackTests.defaultInjectorBuilder().addModule(binder -> binder.bind(LookupExtractorFactoryContainerProvider.class).toInstance((Object)lookupProvider)).build();
    }

    public static class Junit4ConglomerateRule
    extends ExternalResource {
        private Closer closer;
        private QueryRunnerFactoryConglomerate conglomerate;

        protected void before() {
            this.closer = Closer.create();
            this.conglomerate = QueryStackTests.createQueryRunnerFactoryConglomerate(this.closer);
        }

        protected void after() {
            try {
                this.closer.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.conglomerate = null;
            this.closer = null;
        }

        public QueryRunnerFactoryConglomerate getConglomerate() {
            return this.conglomerate;
        }
    }
}

