/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordination;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import junitparams.JUnitParamsRunner;
import junitparams.Parameters;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.server.coordination.BroadcastDatasourceLoadingSpec;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JUnitParamsRunner.class)
public class BroadcastDatasourceLoadingSpecTest {
    @Test
    public void testLoadingAllBroadcastDatasources() {
        BroadcastDatasourceLoadingSpec spec = BroadcastDatasourceLoadingSpec.ALL;
        Assert.assertEquals((Object)BroadcastDatasourceLoadingSpec.Mode.ALL, (Object)spec.getMode());
        Assert.assertNull((Object)spec.getBroadcastDatasourcesToLoad());
    }

    @Test
    public void testLoadingNoLookups() {
        BroadcastDatasourceLoadingSpec spec = BroadcastDatasourceLoadingSpec.NONE;
        Assert.assertEquals((Object)BroadcastDatasourceLoadingSpec.Mode.NONE, (Object)spec.getMode());
        Assert.assertNull((Object)spec.getBroadcastDatasourcesToLoad());
    }

    @Test
    public void testLoadingOnlyRequiredLookups() {
        ImmutableSet broadcastDatasourcesToLoad = ImmutableSet.of((Object)"ds1", (Object)"ds2");
        BroadcastDatasourceLoadingSpec spec = BroadcastDatasourceLoadingSpec.loadOnly((Set)ImmutableSet.of((Object)"ds1", (Object)"ds2"));
        Assert.assertEquals((Object)BroadcastDatasourceLoadingSpec.Mode.ONLY_REQUIRED, (Object)spec.getMode());
        Assert.assertEquals((Object)broadcastDatasourcesToLoad, (Object)spec.getBroadcastDatasourcesToLoad());
    }

    @Test
    public void testLoadingOnlyRequiredLookupsWithNullList() {
        DruidException exception = (DruidException)Assert.assertThrows(DruidException.class, () -> BroadcastDatasourceLoadingSpec.loadOnly(null));
        Assert.assertEquals((Object)"Expected non-null set of broadcast datasources to load.", (Object)exception.getMessage());
    }

    @Test
    public void testCreateBroadcastLoadingSpecFromNullContext() {
        Assert.assertEquals((Object)BroadcastDatasourceLoadingSpec.NONE, (Object)BroadcastDatasourceLoadingSpec.createFromContext(null, (BroadcastDatasourceLoadingSpec)BroadcastDatasourceLoadingSpec.NONE));
        Assert.assertEquals((Object)BroadcastDatasourceLoadingSpec.ALL, (Object)BroadcastDatasourceLoadingSpec.createFromContext(null, (BroadcastDatasourceLoadingSpec)BroadcastDatasourceLoadingSpec.ALL));
    }

    @Test
    public void testCreateBroadcastLoadingSpecFromContext() {
        Assert.assertEquals((Object)BroadcastDatasourceLoadingSpec.loadOnly((Set)ImmutableSet.of((Object)"ds1", (Object)"ds2")), (Object)BroadcastDatasourceLoadingSpec.createFromContext((Map)ImmutableMap.of((Object)"broadcastDatasourcesToLoad", Arrays.asList("ds1", "ds2"), (Object)"broadcastDatasourceLoadingMode", (Object)BroadcastDatasourceLoadingSpec.Mode.ONLY_REQUIRED), (BroadcastDatasourceLoadingSpec)BroadcastDatasourceLoadingSpec.ALL));
        Assert.assertEquals((Object)BroadcastDatasourceLoadingSpec.NONE, (Object)BroadcastDatasourceLoadingSpec.createFromContext((Map)ImmutableMap.of((Object)"broadcastDatasourceLoadingMode", (Object)BroadcastDatasourceLoadingSpec.Mode.NONE), (BroadcastDatasourceLoadingSpec)BroadcastDatasourceLoadingSpec.ALL));
        Assert.assertEquals((Object)BroadcastDatasourceLoadingSpec.ALL, (Object)BroadcastDatasourceLoadingSpec.createFromContext((Map)ImmutableMap.of((Object)"broadcastDatasourceLoadingMode", (Object)BroadcastDatasourceLoadingSpec.Mode.ALL), (BroadcastDatasourceLoadingSpec)BroadcastDatasourceLoadingSpec.NONE));
    }

    @Test
    @Parameters(value={"NONE1", "A", "Random mode", "all", "only required", "none"})
    public void testSpecFromInvalidModeInContext(String mode) {
        DruidException exception = (DruidException)Assert.assertThrows(DruidException.class, () -> BroadcastDatasourceLoadingSpec.createFromContext((Map)ImmutableMap.of((Object)"broadcastDatasourceLoadingMode", (Object)mode), (BroadcastDatasourceLoadingSpec)BroadcastDatasourceLoadingSpec.ALL));
        Assert.assertEquals((Object)StringUtils.format((String)"Invalid value of %s[%s]. Allowed values are [ALL, NONE, ONLY_REQUIRED]", (Object[])new Object[]{"broadcastDatasourceLoadingMode", mode}), (Object)exception.getMessage());
    }

    @Test
    @Parameters(value={"foo bar", "foo]"})
    public void testSpecFromInvalidBroadcastDatasourcesInContext(Object lookupsToLoad) {
        DruidException exception = (DruidException)Assert.assertThrows(DruidException.class, () -> BroadcastDatasourceLoadingSpec.createFromContext((Map)ImmutableMap.of((Object)"broadcastDatasourcesToLoad", (Object)lookupsToLoad, (Object)"broadcastDatasourceLoadingMode", (Object)BroadcastDatasourceLoadingSpec.Mode.ONLY_REQUIRED), (BroadcastDatasourceLoadingSpec)BroadcastDatasourceLoadingSpec.ALL));
        Assert.assertEquals((Object)StringUtils.format((String)"Invalid value of %s[%s]. Please provide a comma-separated list of broadcast datasource names. For example: [\"datasourceName1\", \"datasourceName2\"]", (Object[])new Object[]{"broadcastDatasourcesToLoad", lookupsToLoad}), (Object)exception.getMessage());
    }
}

