/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.druid.client.ImmutableDruidDataSource;
import org.apache.druid.client.ImmutableDruidServer;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.server.coordination.DruidServerMetadata;
import org.apache.druid.server.coordination.ServerType;
import org.apache.druid.server.coordinator.ServerHolder;
import org.apache.druid.server.coordinator.loading.LoadQueuePeon;
import org.apache.druid.server.coordinator.loading.TestLoadQueuePeon;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.NoneShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.junit.Assert;
import org.junit.Test;

public class ServerHolderTest {
    private static final List<DataSegment> SEGMENTS = ImmutableList.of((Object)new DataSegment("src1", Intervals.of((String)"2015-04-12/2015-04-13"), "1", (Map)ImmutableMap.of((Object)"containerName", (Object)"container1", (Object)"blobPath", (Object)"blobPath1"), null, null, (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(0), 1L), (Object)new DataSegment("src2", Intervals.of((String)"2015-04-12/2015-04-13"), "1", (Map)ImmutableMap.of((Object)"containerName", (Object)"container2", (Object)"blobPath", (Object)"blobPath2"), null, null, (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(0), 1L));
    private static final Map<String, ImmutableDruidDataSource> DATA_SOURCES = ImmutableMap.of((Object)"src1", (Object)new ImmutableDruidDataSource("src1", Collections.emptyMap(), Collections.singletonList(SEGMENTS.get(0))), (Object)"src2", (Object)new ImmutableDruidDataSource("src2", Collections.emptyMap(), Collections.singletonList(SEGMENTS.get(1))));

    @Test
    public void testCompareTo() {
        ServerHolder h1 = new ServerHolder(new ImmutableDruidServer(new DruidServerMetadata("name1", "host1", null, 100L, ServerType.HISTORICAL, "tier1", 0), 0L, ImmutableMap.of((Object)"src1", (Object)DATA_SOURCES.get("src1")), 1), (LoadQueuePeon)new TestLoadQueuePeon());
        ServerHolder h2 = new ServerHolder(new ImmutableDruidServer(new DruidServerMetadata("name1", "host1", null, 200L, ServerType.HISTORICAL, "tier1", 0), 100L, ImmutableMap.of((Object)"src1", (Object)DATA_SOURCES.get("src1")), 1), (LoadQueuePeon)new TestLoadQueuePeon());
        ServerHolder h3 = new ServerHolder(new ImmutableDruidServer(new DruidServerMetadata("name1", "host1", null, 1000L, ServerType.HISTORICAL, "tier1", 0), 990L, ImmutableMap.of((Object)"src1", (Object)DATA_SOURCES.get("src1")), 1), (LoadQueuePeon)new TestLoadQueuePeon());
        ServerHolder h4 = new ServerHolder(new ImmutableDruidServer(new DruidServerMetadata("name1", "host1", null, 50L, ServerType.HISTORICAL, "tier1", 0), 0L, ImmutableMap.of((Object)"src1", (Object)DATA_SOURCES.get("src1")), 1), (LoadQueuePeon)new TestLoadQueuePeon());
        Assert.assertEquals((long)0L, (long)h1.compareTo(h2));
        Assert.assertEquals((long)1L, (long)h3.compareTo(h1));
        Assert.assertEquals((long)1L, (long)h3.compareTo(h4));
    }

    @Test
    public void testEquals() {
        ServerHolder h1 = new ServerHolder(new ImmutableDruidServer(new DruidServerMetadata("name1", "host1", null, 100L, ServerType.HISTORICAL, "tier1", 0), 0L, ImmutableMap.of((Object)"src1", (Object)DATA_SOURCES.get("src1")), 1), (LoadQueuePeon)new TestLoadQueuePeon());
        ServerHolder h2 = new ServerHolder(new ImmutableDruidServer(new DruidServerMetadata("name2", "host1", null, 200L, ServerType.HISTORICAL, "tier1", 0), 100L, ImmutableMap.of((Object)"src1", (Object)DATA_SOURCES.get("src1")), 1), (LoadQueuePeon)new TestLoadQueuePeon());
        ServerHolder h3 = new ServerHolder(new ImmutableDruidServer(new DruidServerMetadata("name1", "host2", null, 200L, ServerType.HISTORICAL, "tier1", 0), 100L, ImmutableMap.of((Object)"src1", (Object)DATA_SOURCES.get("src1")), 1), (LoadQueuePeon)new TestLoadQueuePeon());
        ServerHolder h4 = new ServerHolder(new ImmutableDruidServer(new DruidServerMetadata("name1", "host1", null, 200L, ServerType.HISTORICAL, "tier2", 0), 100L, ImmutableMap.of((Object)"src1", (Object)DATA_SOURCES.get("src1")), 1), (LoadQueuePeon)new TestLoadQueuePeon());
        ServerHolder h5 = new ServerHolder(new ImmutableDruidServer(new DruidServerMetadata("name1", "host1", null, 100L, ServerType.REALTIME, "tier1", 0), 0L, ImmutableMap.of((Object)"src1", (Object)DATA_SOURCES.get("src1")), 1), (LoadQueuePeon)new TestLoadQueuePeon());
        Assert.assertEquals((Object)h1, (Object)h2);
        Assert.assertNotEquals((Object)h1, (Object)h3);
        Assert.assertNotEquals((Object)h1, (Object)h4);
        Assert.assertNotEquals((Object)h1, (Object)h5);
    }

    @Test
    public void testIsServingSegment() {
        ServerHolder h1 = new ServerHolder(new ImmutableDruidServer(new DruidServerMetadata("name1", "host1", null, 100L, ServerType.HISTORICAL, "tier1", 0), 0L, ImmutableMap.of((Object)"src1", (Object)DATA_SOURCES.get("src1")), 1), (LoadQueuePeon)new TestLoadQueuePeon());
        Assert.assertTrue((boolean)h1.isServingSegment(SEGMENTS.get(0)));
        Assert.assertFalse((boolean)h1.isServingSegment(SEGMENTS.get(1)));
        Assert.assertFalse((boolean)h1.isLoadQueueFull());
    }
}

