/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.simulate;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.apache.druid.discovery.DruidLeaderSelector;

public class TestDruidLeaderSelector
implements DruidLeaderSelector {
    private final AtomicBoolean isLeader = new AtomicBoolean(false);
    private volatile DruidLeaderSelector.Listener listener;

    public void becomeLeader() {
        if (this.isLeader.compareAndSet(false, true) && this.listener != null) {
            this.listener.becomeLeader();
        }
    }

    public void stopBeingLeader() {
        if (this.isLeader.compareAndSet(true, false) && this.listener != null) {
            this.listener.stopBeingLeader();
        }
    }

    @Nullable
    public String getCurrentLeader() {
        return "me";
    }

    public boolean isLeader() {
        return this.isLeader.get();
    }

    public int localTerm() {
        return 0;
    }

    public void registerListener(DruidLeaderSelector.Listener listener) {
        this.listener = listener;
        if (this.isLeader()) {
            listener.becomeLeader();
        }
    }

    public void unregisterListener() {
        this.listener = null;
    }
}

