/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.server.coordinator.CoordinatorDynamicConfig;
import org.apache.druid.utils.JvmUtils;
import org.junit.Assert;
import org.junit.Test;

public class CoordinatorDynamicConfigTest {
    private static final int EXPECTED_DEFAULT_MAX_SEGMENTS_IN_NODE_LOADING_QUEUE = 500;
    private final ObjectMapper mapper = TestHelper.makeJsonMapper();

    @Test
    public void testSerde() throws Exception {
        String jsonStr = "{\n  \"millisToWaitBeforeDeleting\": 1,\n  \"maxSegmentsToMove\": 1,\n  \"replicantLifetime\": 1,\n  \"replicationThrottleLimit\": 1,\n  \"balancerComputeThreads\": 2, \n  \"killDataSourceWhitelist\": [\"test1\",\"test2\"],\n  \"killTaskSlotRatio\": 0.15,\n  \"maxKillTaskSlots\": 2,\n  \"maxSegmentsInNodeLoadingQueue\": 1,\n  \"decommissioningNodes\": [\"host1\", \"host2\"],\n  \"pauseCoordination\": false,\n  \"replicateAfterLoadTimeout\": false\n}\n";
        CoordinatorDynamicConfig actual = (CoordinatorDynamicConfig)this.mapper.readValue(this.mapper.writeValueAsString(this.mapper.readValue(jsonStr, CoordinatorDynamicConfig.class)), CoordinatorDynamicConfig.class);
        ImmutableSet decommissioning = ImmutableSet.of((Object)"host1", (Object)"host2");
        ImmutableSet whitelist = ImmutableSet.of((Object)"test1", (Object)"test2");
        this.assertConfig(actual, 1L, 1, 1, 1, 2, (Set<String>)whitelist, 0.15, 2, 1, (Set<String>)decommissioning, false, false);
        actual = CoordinatorDynamicConfig.builder().withDecommissioningNodes((Set)ImmutableSet.of((Object)"host1")).build(actual);
        this.assertConfig(actual, 1L, 1, 1, 1, 2, (Set<String>)whitelist, 0.15, 2, 1, (Set<String>)ImmutableSet.of((Object)"host1"), false, false);
        actual = CoordinatorDynamicConfig.builder().build(actual);
        this.assertConfig(actual, 1L, 1, 1, 1, 2, (Set<String>)whitelist, 0.15, 2, 1, (Set<String>)ImmutableSet.of((Object)"host1"), false, false);
        actual = CoordinatorDynamicConfig.builder().withPauseCoordination(true).build(actual);
        this.assertConfig(actual, 1L, 1, 1, 1, 2, (Set<String>)whitelist, 0.15, 2, 1, (Set<String>)ImmutableSet.of((Object)"host1"), true, false);
        actual = CoordinatorDynamicConfig.builder().withReplicateAfterLoadTimeout(true).build(actual);
        this.assertConfig(actual, 1L, 1, 1, 1, 2, (Set<String>)whitelist, 0.15, 2, 1, (Set<String>)ImmutableSet.of((Object)"host1"), true, true);
        actual = CoordinatorDynamicConfig.builder().build(actual);
        this.assertConfig(actual, 1L, 1, 1, 1, 2, (Set<String>)whitelist, 0.15, 2, 1, (Set<String>)ImmutableSet.of((Object)"host1"), true, true);
        actual = CoordinatorDynamicConfig.builder().withKillTaskSlotRatio(Double.valueOf(0.1)).build(actual);
        this.assertConfig(actual, 1L, 1, 1, 1, 2, (Set<String>)whitelist, 0.1, 2, 1, (Set<String>)ImmutableSet.of((Object)"host1"), true, true);
        actual = CoordinatorDynamicConfig.builder().withMaxKillTaskSlots(Integer.valueOf(5)).build(actual);
        this.assertConfig(actual, 1L, 1, 1, 1, 2, (Set<String>)whitelist, 0.1, 5, 1, (Set<String>)ImmutableSet.of((Object)"host1"), true, true);
    }

    @Test
    public void testDeserializationWithUnknownProperties() throws Exception {
        String jsonStr = "{\n  \"unknownProperty\": 2, \n  \"maxSegmentsInNodeLoadingQueue\": 15\n}\n";
        CoordinatorDynamicConfig dynamicConfig = (CoordinatorDynamicConfig)this.mapper.readValue(jsonStr, CoordinatorDynamicConfig.class);
        Assert.assertEquals((long)15L, (long)dynamicConfig.getMaxSegmentsInNodeLoadingQueue());
    }

    @Test
    public void testConstructorWithNullsShouldKillUnusedSegmentsInAllDataSources() {
        CoordinatorDynamicConfig config = new CoordinatorDynamicConfig(1L, 1, 1, 2, 10, null, null, null, null, null, (Object)ImmutableSet.of((Object)"host1"), true, true, Boolean.valueOf(false), Boolean.valueOf(false), null);
        Assert.assertTrue((boolean)config.getSpecificDataSourcesToKillUnusedSegmentsIn().isEmpty());
    }

    @Test
    public void testConstructorWithSpecificDataSourcesToKillShouldNotKillUnusedSegmentsInAllDatasources() {
        CoordinatorDynamicConfig config = new CoordinatorDynamicConfig(1L, 1, 1, 2, 10, (Object)ImmutableSet.of((Object)"test1"), null, null, null, null, (Object)ImmutableSet.of((Object)"host1"), true, true, Boolean.valueOf(false), Boolean.valueOf(false), null);
        Assert.assertEquals((Object)ImmutableSet.of((Object)"test1"), (Object)config.getSpecificDataSourcesToKillUnusedSegmentsIn());
    }

    @Test
    public void testDecommissioningParametersBackwardCompatibility() throws Exception {
        String jsonStr = "{\n  \"millisToWaitBeforeDeleting\": 1,\n  \"maxSegmentsToMove\": 1,\n  \"replicantLifetime\": 1,\n  \"replicationThrottleLimit\": 1,\n  \"balancerComputeThreads\": 2, \n  \"killDataSourceWhitelist\": [\"test1\",\"test2\"],\n  \"maxSegmentsInNodeLoadingQueue\": 1\n}\n";
        CoordinatorDynamicConfig actual = (CoordinatorDynamicConfig)this.mapper.readValue(this.mapper.writeValueAsString(this.mapper.readValue(jsonStr, CoordinatorDynamicConfig.class)), CoordinatorDynamicConfig.class);
        ImmutableSet decommissioning = ImmutableSet.of();
        ImmutableSet whitelist = ImmutableSet.of((Object)"test1", (Object)"test2");
        this.assertConfig(actual, 1L, 1, 1, 1, 2, (Set<String>)whitelist, 0.1, Integer.MAX_VALUE, 1, (Set<String>)decommissioning, false, false);
        actual = CoordinatorDynamicConfig.builder().withDecommissioningNodes((Set)ImmutableSet.of((Object)"host1")).build(actual);
        this.assertConfig(actual, 1L, 1, 1, 1, 2, (Set<String>)whitelist, 0.1, Integer.MAX_VALUE, 1, (Set<String>)ImmutableSet.of((Object)"host1"), false, false);
        actual = CoordinatorDynamicConfig.builder().build(actual);
        this.assertConfig(actual, 1L, 1, 1, 1, 2, (Set<String>)whitelist, 0.1, Integer.MAX_VALUE, 1, (Set<String>)ImmutableSet.of((Object)"host1"), false, false);
    }

    @Test
    public void testSerdeWithStringInKillDataSourceWhitelist() throws Exception {
        String jsonStr = "{\n  \"millisToWaitBeforeDeleting\": 1,\n  \"maxSegmentsToMove\": 1,\n  \"replicantLifetime\": 1,\n  \"replicationThrottleLimit\": 1,\n  \"balancerComputeThreads\": 2, \n  \"killDataSourceWhitelist\": \"test1, test2\", \n  \"maxSegmentsInNodeLoadingQueue\": 1\n}\n";
        CoordinatorDynamicConfig actual = (CoordinatorDynamicConfig)this.mapper.readValue(this.mapper.writeValueAsString(this.mapper.readValue(jsonStr, CoordinatorDynamicConfig.class)), CoordinatorDynamicConfig.class);
        this.assertConfig(actual, 1L, 1, 1, 1, 2, (Set<String>)ImmutableSet.of((Object)"test1", (Object)"test2"), 0.1, Integer.MAX_VALUE, 1, (Set<String>)ImmutableSet.of(), false, false);
    }

    @Test
    public void testHandleMissingPercentOfSegmentsToConsiderPerMove() throws Exception {
        String jsonStr = "{\n  \"millisToWaitBeforeDeleting\": 1,\n  \"maxSegmentsToMove\": 1,\n  \"replicantLifetime\": 1,\n  \"replicationThrottleLimit\": 1,\n  \"balancerComputeThreads\": 2, \n  \"killDataSourceWhitelist\": [\"test1\",\"test2\"],\n  \"maxSegmentsInNodeLoadingQueue\": 1,\n  \"decommissioningNodes\": [\"host1\", \"host2\"],\n  \"pauseCoordination\": false\n}\n";
        CoordinatorDynamicConfig actual = (CoordinatorDynamicConfig)this.mapper.readValue(this.mapper.writeValueAsString(this.mapper.readValue(jsonStr, CoordinatorDynamicConfig.class)), CoordinatorDynamicConfig.class);
        ImmutableSet decommissioning = ImmutableSet.of((Object)"host1", (Object)"host2");
        ImmutableSet whitelist = ImmutableSet.of((Object)"test1", (Object)"test2");
        this.assertConfig(actual, 1L, 1, 1, 1, 2, (Set<String>)whitelist, 0.1, Integer.MAX_VALUE, 1, (Set<String>)decommissioning, false, false);
    }

    @Test
    public void testDeserializeWithoutMaxSegmentsInNodeLoadingQueue() throws Exception {
        String jsonStr = "{\n  \"millisToWaitBeforeDeleting\": 1,\n  \"maxSegmentsToMove\": 1,\n  \"replicantLifetime\": 1,\n  \"replicationThrottleLimit\": 1,\n  \"balancerComputeThreads\": 2\n}\n";
        CoordinatorDynamicConfig actual = (CoordinatorDynamicConfig)this.mapper.readValue(this.mapper.writeValueAsString(this.mapper.readValue(jsonStr, CoordinatorDynamicConfig.class)), CoordinatorDynamicConfig.class);
        this.assertConfig(actual, 1L, 1, 1, 1, 2, (Set<String>)ImmutableSet.of(), 0.1, Integer.MAX_VALUE, 500, (Set<String>)ImmutableSet.of(), false, false);
    }

    @Test
    public void testBuilderDefaults() {
        CoordinatorDynamicConfig defaultConfig = CoordinatorDynamicConfig.builder().build();
        ImmutableSet emptyList = ImmutableSet.of();
        this.assertConfig(defaultConfig, 900000L, 100, 15, 500, CoordinatorDynamicConfigTest.getDefaultNumBalancerThreads(), (Set<String>)emptyList, 0.1, Integer.MAX_VALUE, 500, (Set<String>)emptyList, false, false);
    }

    @Test
    public void testBuilderWithDefaultSpecificDataSourcesToKillUnusedSegmentsInSpecified() {
        CoordinatorDynamicConfig defaultConfig = CoordinatorDynamicConfig.builder().withSpecificDataSourcesToKillUnusedSegmentsIn((Set)ImmutableSet.of((Object)"DATASOURCE")).build();
        CoordinatorDynamicConfig config = CoordinatorDynamicConfig.builder().build(defaultConfig);
        this.assertConfig(config, 900000L, 100, 15, 500, CoordinatorDynamicConfigTest.getDefaultNumBalancerThreads(), (Set<String>)ImmutableSet.of((Object)"DATASOURCE"), 0.1, Integer.MAX_VALUE, 500, (Set<String>)ImmutableSet.of(), false, false);
    }

    @Test
    public void testUpdate() {
        CoordinatorDynamicConfig current = CoordinatorDynamicConfig.builder().withSpecificDataSourcesToKillUnusedSegmentsIn((Set)ImmutableSet.of((Object)"x")).build();
        Assert.assertEquals((Object)current, (Object)CoordinatorDynamicConfig.builder().build(current));
    }

    @Test
    public void testEqualsAndHashCode() {
        CoordinatorDynamicConfig config1 = CoordinatorDynamicConfig.builder().build();
        CoordinatorDynamicConfig config2 = CoordinatorDynamicConfig.builder().build();
        Assert.assertEquals((Object)config1, (Object)config2);
        Assert.assertEquals((long)config1.hashCode(), (long)config2.hashCode());
    }

    private void assertConfig(CoordinatorDynamicConfig config, long expectedLeadingTimeMillisBeforeCanMarkAsUnusedOvershadowedSegments, int expectedMaxSegmentsToMove, int expectedReplicantLifetime, int expectedReplicationThrottleLimit, int expectedBalancerComputeThreads, Set<String> expectedSpecificDataSourcesToKillUnusedSegmentsIn, Double expectedKillTaskSlotRatio, @Nullable Integer expectedMaxKillTaskSlots, int expectedMaxSegmentsInNodeLoadingQueue, Set<String> decommissioningNodes, boolean pauseCoordination, boolean replicateAfterLoadTimeout) {
        Assert.assertEquals((long)expectedLeadingTimeMillisBeforeCanMarkAsUnusedOvershadowedSegments, (long)config.getMarkSegmentAsUnusedDelayMillis());
        Assert.assertEquals((long)expectedMaxSegmentsToMove, (long)config.getMaxSegmentsToMove());
        Assert.assertEquals((long)expectedReplicantLifetime, (long)config.getReplicantLifetime());
        Assert.assertEquals((long)expectedReplicationThrottleLimit, (long)config.getReplicationThrottleLimit());
        Assert.assertEquals((long)expectedBalancerComputeThreads, (long)config.getBalancerComputeThreads());
        Assert.assertEquals(expectedSpecificDataSourcesToKillUnusedSegmentsIn, (Object)config.getSpecificDataSourcesToKillUnusedSegmentsIn());
        Assert.assertEquals((double)expectedKillTaskSlotRatio, (double)config.getKillTaskSlotRatio(), (double)0.001);
        Assert.assertEquals((long)expectedMaxKillTaskSlots.intValue(), (long)config.getMaxKillTaskSlots());
        Assert.assertEquals((long)expectedMaxSegmentsInNodeLoadingQueue, (long)config.getMaxSegmentsInNodeLoadingQueue());
        Assert.assertEquals(decommissioningNodes, (Object)config.getDecommissioningNodes());
        Assert.assertEquals((Object)pauseCoordination, (Object)config.getPauseCoordination());
        Assert.assertEquals((Object)replicateAfterLoadTimeout, (Object)config.getReplicateAfterLoadTimeout());
    }

    private static int getDefaultNumBalancerThreads() {
        return Math.max(1, JvmUtils.getRuntimeInfo().getAvailableProcessors() / 2);
    }
}

