/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.http;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.apache.druid.client.DataSourcesSnapshot;
import org.apache.druid.client.ImmutableDruidDataSource;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.ErrorResponse;
import org.apache.druid.indexing.overlord.IndexerMetadataStorageCoordinator;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.metadata.SegmentsMetadataManager;
import org.apache.druid.metadata.SortOrder;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.metadata.AvailableSegmentMetadata;
import org.apache.druid.segment.metadata.CoordinatorSegmentMetadataCache;
import org.apache.druid.segment.metadata.DataSourceInformation;
import org.apache.druid.server.coordinator.CreateDataSegments;
import org.apache.druid.server.coordinator.DruidCoordinator;
import org.apache.druid.server.http.DataSegmentPlus;
import org.apache.druid.server.http.MetadataResource;
import org.apache.druid.server.security.AuthTestUtils;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.SegmentStatusInCluster;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class MetadataResourceTest {
    private static final String DATASOURCE1 = "datasource1";
    private static final String SEGMENT_START_INTERVAL = "2012-10-24";
    private static final int NUM_PARTITIONS = 2;
    private final DataSegment[] segments = CreateDataSegments.ofDatasource("datasource1").startingAt("2012-10-24").forIntervals(3, Granularities.DAY).withNumPartitions(2).eachOfSizeInMb(500L).toArray(new DataSegment[0]);
    private final List<DataSegmentPlus> segmentsPlus = Arrays.stream(this.segments).map(s -> new DataSegmentPlus(s, DateTimes.nowUtc(), DateTimes.nowUtc(), null, null, null, null)).collect(Collectors.toList());
    private HttpServletRequest request;
    private SegmentsMetadataManager segmentsMetadataManager;
    private IndexerMetadataStorageCoordinator storageCoordinator;
    private DruidCoordinator coordinator;
    private MetadataResource metadataResource;

    @Before
    public void setUp() {
        this.request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        ((HttpServletRequest)Mockito.doReturn((Object)Mockito.mock(AuthenticationResult.class)).when((Object)this.request)).getAttribute("Druid-Authentication-Result");
        this.segmentsMetadataManager = (SegmentsMetadataManager)Mockito.mock(SegmentsMetadataManager.class);
        ImmutableDruidDataSource druidDataSource1 = new ImmutableDruidDataSource(DATASOURCE1, (Map)ImmutableMap.of(), (Collection)ImmutableList.of((Object)this.segments[0], (Object)this.segments[1], (Object)this.segments[2], (Object)this.segments[3]));
        DataSourcesSnapshot dataSourcesSnapshot = (DataSourcesSnapshot)Mockito.mock(DataSourcesSnapshot.class);
        ((SegmentsMetadataManager)Mockito.doReturn((Object)dataSourcesSnapshot).when((Object)this.segmentsMetadataManager)).getSnapshotOfDataSourcesWithAllUsedSegments();
        ((DataSourcesSnapshot)Mockito.doReturn((Object)ImmutableList.of((Object)druidDataSource1)).when((Object)dataSourcesSnapshot)).getDataSourcesWithAllUsedSegments();
        ((SegmentsMetadataManager)Mockito.doReturn((Object)druidDataSource1).when((Object)this.segmentsMetadataManager)).getImmutableDataSourceWithUsedSegments(DATASOURCE1);
        this.coordinator = (DruidCoordinator)Mockito.mock(DruidCoordinator.class);
        ((DruidCoordinator)Mockito.doReturn((Object)2).when((Object)this.coordinator)).getReplicationFactor(this.segments[0].getId());
        ((DruidCoordinator)Mockito.doReturn(null).when((Object)this.coordinator)).getReplicationFactor(this.segments[1].getId());
        ((DruidCoordinator)Mockito.doReturn((Object)1).when((Object)this.coordinator)).getReplicationFactor(this.segments[2].getId());
        ((DruidCoordinator)Mockito.doReturn((Object)1).when((Object)this.coordinator)).getReplicationFactor(this.segments[3].getId());
        ((DataSourcesSnapshot)Mockito.doReturn((Object)ImmutableSet.of((Object)this.segments[3])).when((Object)dataSourcesSnapshot)).getOvershadowedSegments();
        this.storageCoordinator = (IndexerMetadataStorageCoordinator)Mockito.mock(IndexerMetadataStorageCoordinator.class);
        ((IndexerMetadataStorageCoordinator)Mockito.doReturn((Object)this.segments[4]).when((Object)this.storageCoordinator)).retrieveSegmentForId(this.segments[4].getId().toString(), false);
        ((IndexerMetadataStorageCoordinator)Mockito.doReturn(null).when((Object)this.storageCoordinator)).retrieveSegmentForId(this.segments[5].getId().toString(), false);
        ((IndexerMetadataStorageCoordinator)Mockito.doReturn((Object)this.segments[5]).when((Object)this.storageCoordinator)).retrieveSegmentForId(this.segments[5].getId().toString(), true);
        ((SegmentsMetadataManager)Mockito.doAnswer(this.mockIterateAllUnusedSegmentsForDatasource()).when((Object)this.segmentsMetadataManager)).iterateAllUnusedSegmentsForDatasource((String)ArgumentMatchers.any(), (Interval)ArgumentMatchers.any(), (Integer)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (SortOrder)ArgumentMatchers.any());
        this.metadataResource = new MetadataResource(this.segmentsMetadataManager, this.storageCoordinator, AuthTestUtils.TEST_AUTHORIZER_MAPPER, this.coordinator, null);
    }

    @Test
    public void testGetAllSegmentsWithOvershadowedStatus() {
        Response response = this.metadataResource.getAllUsedSegments(this.request, null, "includeOvershadowedStatus", null);
        List resultList = this.extractResponseList(response);
        Assert.assertEquals((long)resultList.size(), (long)4L);
        Assert.assertEquals((Object)new SegmentStatusInCluster(this.segments[0], false, Integer.valueOf(2), null, false), resultList.get(0));
        Assert.assertEquals((Object)new SegmentStatusInCluster(this.segments[1], false, null, null, false), resultList.get(1));
        Assert.assertEquals((Object)new SegmentStatusInCluster(this.segments[2], false, Integer.valueOf(1), null, false), resultList.get(2));
        Assert.assertEquals((Object)new SegmentStatusInCluster(this.segments[3], true, Integer.valueOf(0), null, false), resultList.get(3));
    }

    @Test
    public void testGetAllSegmentsIncludingRealtime() {
        CoordinatorSegmentMetadataCache coordinatorSegmentMetadataCache = (CoordinatorSegmentMetadataCache)Mockito.mock(CoordinatorSegmentMetadataCache.class);
        String dataSource2 = "datasource2";
        DataSegment[] realTimeSegments = CreateDataSegments.ofDatasource(dataSource2).forIntervals(3, Granularities.DAY).withNumPartitions(2).eachOfSizeInMb(500L).toArray(new DataSegment[0]);
        ((DruidCoordinator)Mockito.doReturn(null).when((Object)this.coordinator)).getReplicationFactor(realTimeSegments[0].getId());
        ((DruidCoordinator)Mockito.doReturn(null).when((Object)this.coordinator)).getReplicationFactor(realTimeSegments[1].getId());
        HashMap<SegmentId, AvailableSegmentMetadata> availableSegments = new HashMap<SegmentId, AvailableSegmentMetadata>();
        availableSegments.put(this.segments[0].getId(), AvailableSegmentMetadata.builder((DataSegment)this.segments[0], (long)0L, Collections.emptySet(), null, (long)20L).build());
        availableSegments.put(this.segments[1].getId(), AvailableSegmentMetadata.builder((DataSegment)this.segments[1], (long)0L, Collections.emptySet(), null, (long)30L).build());
        availableSegments.put(this.segments[1].getId(), AvailableSegmentMetadata.builder((DataSegment)this.segments[1], (long)0L, Collections.emptySet(), null, (long)30L).build());
        availableSegments.put(realTimeSegments[0].getId(), AvailableSegmentMetadata.builder((DataSegment)realTimeSegments[0], (long)1L, Collections.emptySet(), null, (long)10L).build());
        availableSegments.put(realTimeSegments[1].getId(), AvailableSegmentMetadata.builder((DataSegment)realTimeSegments[1], (long)1L, Collections.emptySet(), null, (long)40L).build());
        ((CoordinatorSegmentMetadataCache)Mockito.doReturn(availableSegments).when((Object)coordinatorSegmentMetadataCache)).getSegmentMetadataSnapshot();
        ((CoordinatorSegmentMetadataCache)Mockito.doReturn(availableSegments.get(this.segments[0].getId())).when((Object)coordinatorSegmentMetadataCache)).getAvailableSegmentMetadata(DATASOURCE1, this.segments[0].getId());
        ((CoordinatorSegmentMetadataCache)Mockito.doReturn(availableSegments.get(this.segments[1].getId())).when((Object)coordinatorSegmentMetadataCache)).getAvailableSegmentMetadata(DATASOURCE1, this.segments[1].getId());
        this.metadataResource = new MetadataResource(this.segmentsMetadataManager, this.storageCoordinator, AuthTestUtils.TEST_AUTHORIZER_MAPPER, this.coordinator, coordinatorSegmentMetadataCache);
        Response response = this.metadataResource.getAllUsedSegments(this.request, null, "includeOvershadowedStatus", "includeRealtimeSegments");
        List resultList = this.extractResponseList(response);
        Assert.assertEquals((long)resultList.size(), (long)6L);
        Assert.assertEquals((Object)new SegmentStatusInCluster(this.segments[0], false, Integer.valueOf(2), Long.valueOf(20L), false), resultList.get(0));
        Assert.assertEquals((Object)new SegmentStatusInCluster(this.segments[1], false, null, Long.valueOf(30L), false), resultList.get(1));
        Assert.assertEquals((Object)new SegmentStatusInCluster(this.segments[2], false, Integer.valueOf(1), null, false), resultList.get(2));
        Assert.assertEquals((Object)new SegmentStatusInCluster(this.segments[3], true, Integer.valueOf(0), null, false), resultList.get(3));
        Assert.assertEquals((Object)new SegmentStatusInCluster(realTimeSegments[0], false, null, Long.valueOf(10L), true), resultList.get(4));
        Assert.assertEquals((Object)new SegmentStatusInCluster(realTimeSegments[1], false, null, Long.valueOf(40L), true), resultList.get(5));
    }

    @Test
    public void testGetUnusedSegmentsInDataSource() {
        Response response = this.metadataResource.getUnusedSegmentsInDataSource(this.request, DATASOURCE1, null, null, null, null);
        List observedSegments = this.extractResponseList(response);
        Assert.assertEquals(this.segmentsPlus, observedSegments);
    }

    @Test
    public void testGetUnusedSegmentsInDataSourceWithIntervalFilter() {
        String interval = "2012-10-24_P2D";
        int expectedLimit = 4;
        Response response = this.metadataResource.getUnusedSegmentsInDataSource(this.request, DATASOURCE1, "2012-10-24_P2D", null, null, null);
        List observedSegments = this.extractResponseList(response);
        Assert.assertEquals((long)4L, (long)observedSegments.size());
        Assert.assertEquals(this.segmentsPlus.stream().limit(4L).collect(Collectors.toList()), observedSegments);
    }

    @Test
    public void testGetUnusedSegmentsInDataSourceWithLimitFilter() {
        int limit = 3;
        String interval = "2012-10-24_P2D";
        Response response = this.metadataResource.getUnusedSegmentsInDataSource(this.request, DATASOURCE1, "2012-10-24_P2D", Integer.valueOf(3), null, null);
        List observedSegments = this.extractResponseList(response);
        Assert.assertEquals((long)3L, (long)observedSegments.size());
        Assert.assertEquals(this.segmentsPlus.stream().limit(3L).collect(Collectors.toList()), observedSegments);
    }

    @Test
    public void testGetUnusedSegmentsInDataSourceWithLimitAndLastSegmentIdFilter() {
        int limit = 3;
        String interval = "2012-10-24_P2D";
        String lastSegmentId = this.segments[2].getId().toString();
        Response response = this.metadataResource.getUnusedSegmentsInDataSource(this.request, DATASOURCE1, "2012-10-24_P2D", Integer.valueOf(3), lastSegmentId, null);
        List observedSegments = this.extractResponseList(response);
        Assert.assertEquals(Collections.singletonList(this.segmentsPlus.get(3)), observedSegments);
    }

    @Test
    public void testGetUnusedSegmentsInDataSourceWithNonExistentDataSource() {
        Response response = this.metadataResource.getUnusedSegmentsInDataSource(this.request, "non-existent", null, null, null, null);
        List observedSegments = this.extractResponseList(response);
        Assert.assertTrue((boolean)observedSegments.isEmpty());
    }

    @Test
    public void testGetUnusedSegmentsWithNoDataSource() {
        Response response = this.metadataResource.getUnusedSegmentsInDataSource(this.request, null, null, null, null, null);
        Assert.assertEquals((long)400L, (long)response.getStatus());
        Assert.assertEquals((Object)"dataSourceName must be non-empty.", (Object)MetadataResourceTest.getExceptionMessage(response));
    }

    @Test
    public void testGetUnusedSegmentsWithEmptyDatasourceName() {
        Response response = this.metadataResource.getUnusedSegmentsInDataSource(this.request, "", null, null, null, null);
        Assert.assertEquals((long)400L, (long)response.getStatus());
        Assert.assertEquals((Object)"dataSourceName must be non-empty.", (Object)MetadataResourceTest.getExceptionMessage(response));
    }

    @Test
    public void testGetUnusedSegmentsWithInvalidLimit() {
        Response response = this.metadataResource.getUnusedSegmentsInDataSource(this.request, DATASOURCE1, null, Integer.valueOf(-1), null, null);
        Assert.assertEquals((long)400L, (long)response.getStatus());
        Assert.assertEquals((Object)"Invalid limit[-1] specified. Limit must be > 0.", (Object)MetadataResourceTest.getExceptionMessage(response));
    }

    @Test
    public void testGetUnusedSegmentsWithInvalidLastSegmentId() {
        Response response = this.metadataResource.getUnusedSegmentsInDataSource(this.request, DATASOURCE1, null, null, "invalid", null);
        Assert.assertEquals((long)400L, (long)response.getStatus());
        Assert.assertEquals((Object)"Invalid lastSegmentId[invalid] specified.", (Object)MetadataResourceTest.getExceptionMessage(response));
    }

    @Test
    public void testGetUnusedSegmentsWithInvalidInterval() {
        Response response = this.metadataResource.getUnusedSegmentsInDataSource(this.request, DATASOURCE1, "2015/2014", null, null, null);
        Assert.assertEquals((long)400L, (long)response.getStatus());
        Assert.assertEquals((Object)"Invalid interval[2015/2014]: [The end instant must be greater than the start instant]", (Object)MetadataResourceTest.getExceptionMessage(response));
    }

    @Test
    public void testGetUnusedSegmentsWithInvalidSortOrder() {
        Response response = this.metadataResource.getUnusedSegmentsInDataSource(this.request, DATASOURCE1, null, null, null, "Ascd");
        Assert.assertEquals((long)400L, (long)response.getStatus());
        Assert.assertEquals((Object)"Unexpected value[Ascd] for SortOrder. Possible values are: [ASC, DESC]", (Object)MetadataResourceTest.getExceptionMessage(response));
    }

    private Answer<Iterable<DataSegmentPlus>> mockIterateAllUnusedSegmentsForDatasource() {
        return invocationOnMock -> {
            String dataSourceName = (String)invocationOnMock.getArgument(0);
            Interval interval = (Interval)invocationOnMock.getArgument(1);
            Integer limit = (Integer)invocationOnMock.getArgument(2);
            String lastSegmentId = (String)invocationOnMock.getArgument(3);
            SortOrder sortOrder = (SortOrder)invocationOnMock.getArgument(4);
            if (!DATASOURCE1.equals(dataSourceName)) {
                return ImmutableList.of();
            }
            return this.segmentsPlus.stream().filter(d -> d.getDataSegment().getDataSource().equals(dataSourceName) && (interval == null || d.getDataSegment().getInterval().getStartMillis() >= interval.getStartMillis() && d.getDataSegment().getInterval().getEndMillis() <= interval.getEndMillis()) && (lastSegmentId == null || sortOrder == null && d.getDataSegment().getId().toString().compareTo(lastSegmentId) > 0 || sortOrder == SortOrder.ASC && d.getDataSegment().getId().toString().compareTo(lastSegmentId) > 0 || sortOrder == SortOrder.DESC && d.getDataSegment().getId().toString().compareTo(lastSegmentId) < 0)).sorted((o1, o2) -> Comparators.intervalsByStartThenEnd().compare(o1.getDataSegment().getInterval(), o2.getDataSegment().getInterval())).limit(limit != null ? (long)limit.intValue() : (long)this.segments.length).collect(Collectors.toList());
        };
    }

    private static String getExceptionMessage(Response response) {
        if (response.getEntity() instanceof DruidException) {
            return ((DruidException)response.getEntity()).getMessage();
        }
        return ((ErrorResponse)response.getEntity()).getUnderlyingException().getMessage();
    }

    @Test
    public void testGetDataSourceInformation() {
        CoordinatorSegmentMetadataCache coordinatorSegmentMetadataCache = (CoordinatorSegmentMetadataCache)Mockito.mock(CoordinatorSegmentMetadataCache.class);
        HashMap<String, DataSourceInformation> dataSourceInformationMap = new HashMap<String, DataSourceInformation>();
        dataSourceInformationMap.put(DATASOURCE1, new DataSourceInformation(DATASOURCE1, RowSignature.builder().add("c1", ColumnType.FLOAT).add("c2", ColumnType.DOUBLE).build()));
        dataSourceInformationMap.put("datasource2", new DataSourceInformation("datasource2", RowSignature.builder().add("d1", ColumnType.FLOAT).add("d2", ColumnType.DOUBLE).build()));
        ((CoordinatorSegmentMetadataCache)Mockito.doReturn(dataSourceInformationMap).when((Object)coordinatorSegmentMetadataCache)).getDataSourceInformationMap();
        this.metadataResource = new MetadataResource(this.segmentsMetadataManager, this.storageCoordinator, AuthTestUtils.TEST_AUTHORIZER_MAPPER, this.coordinator, coordinatorSegmentMetadataCache);
        Response response = this.metadataResource.getDataSourceInformation(this.request, Collections.singletonList(DATASOURCE1));
        List dataSourceInformations = this.extractResponseList(response);
        Assert.assertEquals((long)dataSourceInformations.size(), (long)1L);
        Assert.assertEquals(dataSourceInformations.get(0), dataSourceInformationMap.get(DATASOURCE1));
    }

    @Test
    public void testGetSegment() {
        Assert.assertEquals((Object)this.segments[0], (Object)this.metadataResource.getSegment(this.segments[0].getDataSource(), this.segments[0].getId().toString(), null).getEntity());
        Assert.assertEquals((Object)this.segments[4], (Object)this.metadataResource.getSegment(this.segments[4].getDataSource(), this.segments[4].getId().toString(), null).getEntity());
        Assert.assertNull((Object)this.metadataResource.getSegment(this.segments[5].getDataSource(), this.segments[5].getId().toString(), null).getEntity());
        Assert.assertEquals((Object)this.segments[5], (Object)this.metadataResource.getSegment(this.segments[5].getDataSource(), this.segments[5].getId().toString(), Boolean.valueOf(true)).getEntity());
    }

    @Test
    public void testGetBootstrapSegments() {
        ((DruidCoordinator)Mockito.doReturn((Object)ImmutableSet.of((Object)this.segments[0], (Object)this.segments[1])).when((Object)this.coordinator)).getBroadcastSegments();
        Response response = this.metadataResource.getBootstrapSegments();
        List observedSegments = this.extractResponseList(response);
        Assert.assertEquals((long)2L, (long)observedSegments.size());
    }

    @Test
    public void testEmptyGetBootstrapSegments() {
        ((DruidCoordinator)Mockito.doReturn((Object)ImmutableSet.of()).when((Object)this.coordinator)).getBroadcastSegments();
        Response response = this.metadataResource.getBootstrapSegments();
        List observedSegments = this.extractResponseList(response);
        Assert.assertEquals((long)0L, (long)observedSegments.size());
    }

    @Test
    public void testNullGetBootstrapSegments() {
        ((DruidCoordinator)Mockito.doReturn(null).when((Object)this.coordinator)).getBroadcastSegments();
        Response response = this.metadataResource.getBootstrapSegments();
        Assert.assertEquals((long)503L, (long)response.getStatus());
    }

    private <T> List<T> extractResponseList(Response response) {
        return Lists.newArrayList((Iterable)((Iterable)response.getEntity()));
    }
}

