/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.lookup.cache;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Map;
import org.apache.druid.discovery.DiscoveryDruidNode;
import org.apache.druid.discovery.DruidNodeDiscovery;
import org.apache.druid.discovery.DruidNodeDiscoveryProvider;
import org.apache.druid.discovery.LookupNodeService;
import org.apache.druid.discovery.NodeRole;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.http.HostAndPortWithScheme;
import org.apache.druid.server.lookup.cache.LookupNodeDiscovery;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LookupNodeDiscoveryTest {
    private DruidNodeDiscoveryProvider druidNodeDiscoveryProvider;
    private DruidNodeDiscovery druidNodeDiscovery;
    private LookupNodeDiscovery lookupNodeDiscovery;

    @Before
    public void setup() {
        this.druidNodeDiscoveryProvider = (DruidNodeDiscoveryProvider)EasyMock.createStrictMock(DruidNodeDiscoveryProvider.class);
        this.druidNodeDiscovery = (DruidNodeDiscovery)EasyMock.createStrictMock(DruidNodeDiscovery.class);
        EasyMock.expect((Object)this.druidNodeDiscoveryProvider.getForService("lookupNodeService")).andReturn((Object)this.druidNodeDiscovery);
        DiscoveryDruidNode node1 = new DiscoveryDruidNode(new DruidNode("s1", "h1", false, Integer.valueOf(8080), null, true, false), NodeRole.HISTORICAL, (Map)ImmutableMap.of((Object)"lookupNodeService", (Object)new LookupNodeService("tier1")));
        DiscoveryDruidNode node2 = new DiscoveryDruidNode(new DruidNode("s2", "h2", false, Integer.valueOf(8080), null, true, false), NodeRole.PEON, (Map)ImmutableMap.of((Object)"lookupNodeService", (Object)new LookupNodeService("tier1")));
        DiscoveryDruidNode node3 = new DiscoveryDruidNode(new DruidNode("s3", "h3", false, Integer.valueOf(8080), null, true, false), NodeRole.PEON, (Map)ImmutableMap.of((Object)"lookupNodeService", (Object)new LookupNodeService("tier2")));
        EasyMock.expect((Object)this.druidNodeDiscovery.getAllNodes()).andReturn((Object)ImmutableSet.of((Object)node1, (Object)node2, (Object)node3)).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.druidNodeDiscoveryProvider, this.druidNodeDiscovery});
        this.lookupNodeDiscovery = new LookupNodeDiscovery(this.druidNodeDiscoveryProvider);
    }

    @Test
    public void testGetNodesInTier() {
        Assert.assertEquals((Object)ImmutableList.of((Object)HostAndPortWithScheme.fromParts((String)"http", (String)"h1", (int)8080), (Object)HostAndPortWithScheme.fromParts((String)"http", (String)"h2", (int)8080)), (Object)ImmutableList.copyOf((Collection)this.lookupNodeDiscovery.getNodesInTier("tier1")));
        Assert.assertEquals((Object)ImmutableList.of((Object)HostAndPortWithScheme.fromParts((String)"http", (String)"h3", (int)8080)), (Object)ImmutableList.copyOf((Collection)this.lookupNodeDiscovery.getNodesInTier("tier2")));
        Assert.assertEquals((Object)ImmutableList.of(), (Object)ImmutableList.copyOf((Collection)this.lookupNodeDiscovery.getNodesInTier("tier3")));
        EasyMock.verify((Object[])new Object[]{this.druidNodeDiscoveryProvider, this.druidNodeDiscovery});
    }

    @Test
    public void testGetAllTiers() {
        Assert.assertEquals((Object)ImmutableSet.of((Object)"tier1", (Object)"tier2"), (Object)this.lookupNodeDiscovery.getAllTiers());
        EasyMock.verify((Object[])new Object[]{this.druidNodeDiscoveryProvider, this.druidNodeDiscovery});
    }
}

