/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.lookup;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import java.util.Map;
import javax.annotation.Nullable;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.druid.query.extraction.MapLookupExtractor;
import org.apache.druid.query.lookup.LookupExtractor;
import org.apache.druid.query.lookup.LookupExtractorFactory;
import org.apache.druid.query.lookup.LookupIntrospectHandler;

@JsonTypeName(value="map")
public class MapLookupExtractorFactory
implements LookupExtractorFactory {
    @JsonProperty
    private final Map<String, String> map;
    @JsonProperty
    private final boolean isOneToOne;
    private final MapLookupExtractor lookupExtractor;
    private final LookupIntrospectHandler lookupIntrospectHandler;

    @JsonCreator
    public MapLookupExtractorFactory(@JsonProperty(value="map") Map<String, String> map, @JsonProperty(value="isOneToOne") boolean isOneToOne) {
        this.map = (Map)Preconditions.checkNotNull(map, (Object)"map cannot be null");
        this.isOneToOne = isOneToOne;
        this.lookupExtractor = new MapLookupExtractor(map, isOneToOne);
        this.lookupIntrospectHandler = new MapLookupIntrospectionHandler(this.map);
    }

    public boolean start() {
        return true;
    }

    public boolean close() {
        return true;
    }

    public boolean replaces(@Nullable LookupExtractorFactory other) {
        return !this.equals(other);
    }

    @Nullable
    public LookupIntrospectHandler getIntrospectHandler() {
        return this.lookupIntrospectHandler;
    }

    public void awaitInitialization() {
    }

    public boolean isInitialized() {
        return true;
    }

    public LookupExtractor get() {
        return this.lookupExtractor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapLookupExtractorFactory that = (MapLookupExtractorFactory)o;
        if (this.isOneToOne != that.isOneToOne) {
            return false;
        }
        return this.map.equals(that.map);
    }

    public int hashCode() {
        int result = this.map.hashCode();
        result = 31 * result + (this.isOneToOne ? 1 : 0);
        return result;
    }

    public static class MapLookupIntrospectionHandler
    implements LookupIntrospectHandler {
        private final Map<String, String> map;

        public MapLookupIntrospectionHandler(Map<String, String> map) {
            this.map = map;
        }

        @GET
        @Path(value="/keys")
        @Produces(value={"application/json"})
        public Response getKeys() {
            return Response.ok(this.map.keySet()).build();
        }

        @GET
        @Path(value="/values")
        @Produces(value={"application/json"})
        public Response getValues() {
            return Response.ok(this.map.values()).build();
        }

        @GET
        @Produces(value={"application/json"})
        public Response getMap() {
            return Response.ok(this.map).build();
        }
    }
}

