/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.indexing.granularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collection;
import java.util.List;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.granularity.IntervalsByGranularity;
import org.apache.druid.segment.indexing.granularity.BaseGranularitySpec;
import org.apache.druid.segment.indexing.granularity.GranularitySpec;
import org.joda.time.Interval;

public class UniformGranularitySpec
extends BaseGranularitySpec {
    private final Granularity segmentGranularity;
    private final Granularity queryGranularity;
    private final IntervalsByGranularity intervalsByGranularity;
    protected BaseGranularitySpec.LookupIntervalBuckets lookupTableBucketByDateTime;

    @JsonCreator
    public UniformGranularitySpec(@JsonProperty(value="segmentGranularity") Granularity segmentGranularity, @JsonProperty(value="queryGranularity") Granularity queryGranularity, @JsonProperty(value="rollup") Boolean rollup, @JsonProperty(value="intervals") List<Interval> inputIntervals) {
        super(inputIntervals, rollup);
        this.queryGranularity = queryGranularity == null ? DEFAULT_QUERY_GRANULARITY : queryGranularity;
        this.segmentGranularity = segmentGranularity == null ? DEFAULT_SEGMENT_GRANULARITY : segmentGranularity;
        this.intervalsByGranularity = new IntervalsByGranularity((Collection)this.inputIntervals, segmentGranularity);
        this.lookupTableBucketByDateTime = new BaseGranularitySpec.LookupIntervalBuckets(this.sortedBucketIntervals());
    }

    public UniformGranularitySpec(Granularity segmentGranularity, Granularity queryGranularity, List<Interval> inputIntervals) {
        this(segmentGranularity, queryGranularity, true, inputIntervals);
    }

    @Override
    public Iterable<Interval> sortedBucketIntervals() {
        return () -> this.intervalsByGranularity.granularityIntervalsIterator();
    }

    @Override
    @JsonProperty(value="segmentGranularity")
    public Granularity getSegmentGranularity() {
        return this.segmentGranularity;
    }

    @Override
    @JsonProperty(value="queryGranularity")
    public Granularity getQueryGranularity() {
        return this.queryGranularity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UniformGranularitySpec that = (UniformGranularitySpec)o;
        if (!this.segmentGranularity.equals(that.segmentGranularity)) {
            return false;
        }
        if (!this.queryGranularity.equals(that.queryGranularity)) {
            return false;
        }
        if (this.isRollup() != that.isRollup()) {
            return false;
        }
        return !(this.inputIntervals != null ? !this.inputIntervals.equals(that.inputIntervals) : that.inputIntervals != null);
    }

    public int hashCode() {
        int result = this.segmentGranularity.hashCode();
        result = 31 * result + this.queryGranularity.hashCode();
        result = 31 * result + this.rollup.hashCode();
        result = 31 * result + (this.inputIntervals != null ? this.inputIntervals.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "UniformGranularitySpec{segmentGranularity=" + this.segmentGranularity + ", queryGranularity=" + this.queryGranularity + ", rollup=" + this.rollup + ", inputIntervals=" + this.inputIntervals + "}";
    }

    @Override
    public GranularitySpec withIntervals(List<Interval> inputIntervals) {
        return new UniformGranularitySpec(this.segmentGranularity, this.queryGranularity, this.rollup, inputIntervals);
    }

    @Override
    protected BaseGranularitySpec.LookupIntervalBuckets getLookupTableBuckets() {
        return this.lookupTableBucketByDateTime;
    }
}

