/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.loading;

import com.google.common.base.Predicate;
import com.google.common.io.ByteSource;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.CancellationException;
import javax.tools.FileObject;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.MapUtils;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.segment.loading.SegmentLoadingException;
import org.apache.druid.segment.loading.URIDataPuller;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.utils.CompressionUtils;

public class LocalDataSegmentPuller
implements URIDataPuller {
    public static final int DEFAULT_RETRY_COUNT = 3;
    private static final Logger log = new Logger(LocalDataSegmentPuller.class);

    public static FileObject buildFileObject(final URI uri) {
        final Path path = Paths.get(uri);
        final File file = path.toFile();
        return new FileObject(){

            @Override
            public URI toUri() {
                return uri;
            }

            @Override
            public String getName() {
                return path.getFileName().toString();
            }

            @Override
            public InputStream openInputStream() throws IOException {
                return new FileInputStream(file);
            }

            @Override
            public OutputStream openOutputStream() throws IOException {
                return new FileOutputStream(file);
            }

            @Override
            public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
                return Files.newReader((File)file, (Charset)Charset.defaultCharset());
            }

            @Override
            public CharSequence getCharContent(boolean ignoreEncodingErrors) {
                throw new UOE("CharSequence not supported", new Object[0]);
            }

            @Override
            public Writer openWriter() throws IOException {
                return Files.newWriter((File)file, (Charset)Charset.defaultCharset());
            }

            @Override
            public long getLastModified() {
                return file.lastModified();
            }

            @Override
            public boolean delete() {
                return file.delete();
            }
        };
    }

    public FileUtils.FileCopyResult getSegmentFiles(File sourceFile, File dir) throws SegmentLoadingException {
        if (sourceFile.isDirectory()) {
            try {
                File[] files = sourceFile.listFiles();
                if (files == null) {
                    throw new SegmentLoadingException("No files found in [%s]", new Object[]{sourceFile.getAbsolutePath()});
                }
                if (sourceFile.equals(dir)) {
                    log.info("Asked to load [%s] into itself, done!", new Object[]{dir});
                    return new FileUtils.FileCopyResult(Arrays.asList(files));
                }
                FileUtils.FileCopyResult result = new FileUtils.FileCopyResult(new File[0]);
                boolean link = true;
                for (File oldFile : files) {
                    if (oldFile.isDirectory()) {
                        log.info("[%s] is a child directory, skipping", new Object[]{oldFile.getAbsolutePath()});
                        continue;
                    }
                    File newFile = new File(dir, oldFile.getName());
                    FileUtils.LinkOrCopyResult linkOrCopyResult = FileUtils.linkOrCopy((File)oldFile, (File)newFile);
                    link = link && linkOrCopyResult == FileUtils.LinkOrCopyResult.LINK;
                    result.addFile(newFile);
                }
                log.info("%s %d bytes from [%s] to [%s]", new Object[]{link ? "Linked" : "Copied", result.size(), sourceFile.getAbsolutePath(), dir.getAbsolutePath()});
                return result;
            }
            catch (IOException e) {
                throw new SegmentLoadingException((Throwable)e, "Unable to load from local directory [%s]", new Object[]{sourceFile.getAbsolutePath()});
            }
        }
        if (CompressionUtils.isZip((String)sourceFile.getName())) {
            try {
                FileUtils.FileCopyResult result = CompressionUtils.unzip((ByteSource)Files.asByteSource((File)sourceFile), (File)dir, this.shouldRetryPredicate(), (boolean)false);
                log.info("Unzipped %d bytes from [%s] to [%s]", new Object[]{result.size(), sourceFile.getAbsolutePath(), dir.getAbsolutePath()});
                return result;
            }
            catch (IOException e) {
                throw new SegmentLoadingException((Throwable)e, "Unable to unzip file [%s]", new Object[]{sourceFile.getAbsolutePath()});
            }
        }
        if (CompressionUtils.isGz((String)sourceFile.getName())) {
            File outFile = new File(dir, CompressionUtils.getGzBaseName((String)sourceFile.getName()));
            FileUtils.FileCopyResult result = CompressionUtils.gunzip((ByteSource)Files.asByteSource((File)sourceFile), (File)outFile, this.shouldRetryPredicate());
            log.info("Gunzipped %d bytes from [%s] to [%s]", new Object[]{result.size(), sourceFile.getAbsolutePath(), outFile.getAbsolutePath()});
            return result;
        }
        throw new SegmentLoadingException("Do not know how to handle source [%s]", new Object[]{sourceFile.getAbsolutePath()});
    }

    public InputStream getInputStream(URI uri) throws IOException {
        return LocalDataSegmentPuller.buildFileObject(uri).openInputStream();
    }

    public String getVersion(URI uri) {
        return StringUtils.format((String)"%d", (Object[])new Object[]{LocalDataSegmentPuller.buildFileObject(uri).getLastModified()});
    }

    public Predicate<Throwable> shouldRetryPredicate() {
        return new Predicate<Throwable>(){

            public boolean apply(Throwable input) {
                return !(input instanceof InterruptedException) && !(input instanceof CancellationException) && input instanceof Exception;
            }
        };
    }

    private File getFile(DataSegment segment) throws SegmentLoadingException {
        Map loadSpec = segment.getLoadSpec();
        File path = new File(MapUtils.getString((Map)loadSpec, (String)"path"));
        if (!path.exists()) {
            throw new SegmentLoadingException("Asked to load path[%s], but it doesn't exist.", new Object[]{path});
        }
        return path;
    }
}

