/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.realtime.appenderator;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import org.apache.druid.client.cache.Cache;
import org.apache.druid.client.cache.CacheConfig;
import org.apache.druid.client.cache.CachePopulatorStats;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.query.QueryProcessingPool;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.IndexMerger;
import org.apache.druid.segment.incremental.ParseExceptionHandler;
import org.apache.druid.segment.incremental.RowIngestionMeters;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.segment.loading.DataSegmentPusher;
import org.apache.druid.segment.loading.SegmentLoaderConfig;
import org.apache.druid.segment.metadata.CentralizedDatasourceSchemaConfig;
import org.apache.druid.segment.realtime.SegmentGenerationMetrics;
import org.apache.druid.segment.realtime.appenderator.Appenderator;
import org.apache.druid.segment.realtime.appenderator.AppenderatorConfig;
import org.apache.druid.segment.realtime.appenderator.BatchAppenderator;
import org.apache.druid.segment.realtime.appenderator.SinkQuerySegmentWalker;
import org.apache.druid.segment.realtime.appenderator.StreamAppenderator;
import org.apache.druid.server.coordination.DataSegmentAnnouncer;
import org.apache.druid.timeline.VersionedIntervalTimeline;

public class Appenderators {
    public static Appenderator createRealtime(SegmentLoaderConfig segmentLoaderConfig, String id, DataSchema schema, AppenderatorConfig config, SegmentGenerationMetrics metrics, DataSegmentPusher dataSegmentPusher, ObjectMapper objectMapper, IndexIO indexIO, IndexMerger indexMerger, QueryRunnerFactoryConglomerate conglomerate, DataSegmentAnnouncer segmentAnnouncer, ServiceEmitter emitter, QueryProcessingPool queryProcessingPool, Cache cache, CacheConfig cacheConfig, CachePopulatorStats cachePopulatorStats, RowIngestionMeters rowIngestionMeters, ParseExceptionHandler parseExceptionHandler, boolean useMaxMemoryEstimates, CentralizedDatasourceSchemaConfig centralizedDatasourceSchemaConfig) {
        return new StreamAppenderator(segmentLoaderConfig, id, schema, config, metrics, dataSegmentPusher, objectMapper, segmentAnnouncer, new SinkQuerySegmentWalker(schema.getDataSource(), (VersionedIntervalTimeline<String, SinkQuerySegmentWalker.SinkHolder>)new VersionedIntervalTimeline(String.CASE_INSENSITIVE_ORDER), objectMapper, emitter, conglomerate, queryProcessingPool, (Cache)Preconditions.checkNotNull((Object)cache, (Object)"cache"), cacheConfig, cachePopulatorStats), indexIO, indexMerger, cache, rowIngestionMeters, parseExceptionHandler, useMaxMemoryEstimates, centralizedDatasourceSchemaConfig);
    }

    public static Appenderator createBatch(String id, DataSchema schema, AppenderatorConfig config, SegmentGenerationMetrics metrics, DataSegmentPusher dataSegmentPusher, ObjectMapper objectMapper, IndexIO indexIO, IndexMerger indexMerger, RowIngestionMeters rowIngestionMeters, ParseExceptionHandler parseExceptionHandler, boolean useMaxMemoryEstimates, CentralizedDatasourceSchemaConfig centralizedDatasourceSchemaConfig) {
        return new BatchAppenderator(id, schema, config, metrics, dataSegmentPusher, objectMapper, indexIO, indexMerger, rowIngestionMeters, parseExceptionHandler, useMaxMemoryEstimates, centralizedDatasourceSchemaConfig);
    }
}

