/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.compaction;

import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.error.InvalidInput;
import org.apache.druid.java.util.common.JodaUtils;
import org.apache.druid.segment.SegmentUtils;
import org.apache.druid.server.compaction.CompactionStatistics;
import org.apache.druid.server.compaction.CompactionStatus;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.Interval;

public class CompactionCandidate {
    private final List<DataSegment> segments;
    private final Interval umbrellaInterval;
    private final String dataSource;
    private final long totalBytes;
    private final int numIntervals;
    private final CompactionStatus currentStatus;

    public static CompactionCandidate from(List<DataSegment> segments) {
        if (segments == null || segments.isEmpty()) {
            throw InvalidInput.exception((String)"Segments to compact must be non-empty", (Object[])new Object[0]);
        }
        return new CompactionCandidate(segments, null);
    }

    private CompactionCandidate(List<DataSegment> segments, @Nullable CompactionStatus currentStatus) {
        this.segments = segments;
        this.totalBytes = segments.stream().mapToLong(DataSegment::getSize).sum();
        this.umbrellaInterval = JodaUtils.umbrellaInterval((Iterable)segments.stream().map(DataSegment::getInterval).collect(Collectors.toList()));
        this.numIntervals = (int)segments.stream().map(DataSegment::getInterval).distinct().count();
        this.dataSource = segments.get(0).getDataSource();
        this.currentStatus = currentStatus;
    }

    public List<DataSegment> getSegments() {
        return this.segments;
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public int numSegments() {
        return this.segments.size();
    }

    public Interval getUmbrellaInterval() {
        return this.umbrellaInterval;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public CompactionStatistics getStats() {
        return CompactionStatistics.create(this.totalBytes, this.numSegments(), this.numIntervals);
    }

    @Nullable
    public CompactionStatus getCurrentStatus() {
        return this.currentStatus;
    }

    public CompactionCandidate withCurrentStatus(CompactionStatus status) {
        return new CompactionCandidate(this.segments, status);
    }

    public String toString() {
        return "SegmentsToCompact{datasource=" + this.dataSource + ", segments=" + SegmentUtils.commaSeparatedIdentifiers(this.segments) + ", totalSize=" + this.totalBytes + ", currentStatus=" + this.currentStatus + "}";
    }
}

