/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordination;

import com.google.common.base.Throwables;
import com.google.inject.Inject;
import java.io.IOException;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.utils.ZKPaths;
import org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.server.coordination.DruidServerMetadata;
import org.apache.druid.server.initialization.BatchDataSegmentAnnouncerConfig;
import org.apache.druid.server.initialization.ZkPathsConfig;

@Deprecated
public class ZkCoordinator {
    private static final EmittingLogger log = new EmittingLogger(ZkCoordinator.class);
    private final Object lock = new Object();
    private final ZkPathsConfig zkPaths;
    private final DruidServerMetadata me;
    private final CuratorFramework curator;
    private final BatchDataSegmentAnnouncerConfig announcerConfig;
    private volatile boolean started = false;

    @Inject
    public ZkCoordinator(ZkPathsConfig zkPaths, DruidServerMetadata me, CuratorFramework curator, BatchDataSegmentAnnouncerConfig announcerConfig) {
        this.zkPaths = zkPaths;
        this.me = me;
        this.curator = curator;
        this.announcerConfig = announcerConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStart
    public void start() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.started) {
                return;
            }
            log.info("Starting zkCoordinator for server[%s]", new Object[]{this.me.getName()});
            if (this.announcerConfig.isSkipSegmentAnnouncementOnZk()) {
                log.info("Skipping zkPath creation as segment announcement on ZK is disabled.", new Object[0]);
                this.started = true;
                return;
            }
            String liveSegmentsLocation = ZKPaths.makePath((String)this.zkPaths.getLiveSegmentsPath(), (String)this.me.getName());
            log.info("Creating zkPath[%s] for announcing live segments.", new Object[]{liveSegmentsLocation});
            try {
                this.curator.newNamespaceAwareEnsurePath(liveSegmentsLocation).ensure(this.curator.getZookeeperClient());
            }
            catch (Exception e) {
                Throwables.propagateIfPossible((Throwable)e, IOException.class);
                throw new RuntimeException(e);
            }
            this.started = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStop
    public void stop() {
        log.info("Stopping ZkCoordinator for [%s]", new Object[]{this.me});
        Object object = this.lock;
        synchronized (object) {
            if (!this.started) {
                return;
            }
            this.started = false;
        }
    }
}

