/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import java.util.function.UnaryOperator;
import org.apache.druid.audit.AuditInfo;
import org.apache.druid.common.config.ConfigManager;
import org.apache.druid.common.config.JacksonConfigManager;
import org.apache.druid.metadata.MetadataStorageConnector;
import org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.druid.server.coordinator.CoordinatorDynamicConfig;
import org.apache.druid.server.coordinator.DruidCompactionConfig;

public class CoordinatorConfigManager {
    private final JacksonConfigManager jacksonConfigManager;
    private final MetadataStorageConnector metadataStorageConnector;
    private final MetadataStorageTablesConfig tablesConfig;

    @Inject
    public CoordinatorConfigManager(JacksonConfigManager jacksonConfigManager, MetadataStorageConnector metadataStorageConnector, MetadataStorageTablesConfig tablesConfig) {
        this.jacksonConfigManager = jacksonConfigManager;
        this.metadataStorageConnector = metadataStorageConnector;
        this.tablesConfig = tablesConfig;
    }

    public CoordinatorDynamicConfig getCurrentDynamicConfig() {
        CoordinatorDynamicConfig dynamicConfig = (CoordinatorDynamicConfig)this.jacksonConfigManager.watch("coordinator.config", CoordinatorDynamicConfig.class, (Object)CoordinatorDynamicConfig.builder().build()).get();
        return (CoordinatorDynamicConfig)Preconditions.checkNotNull((Object)dynamicConfig, (Object)"Got null config from watcher?!");
    }

    public ConfigManager.SetResult setDynamicConfig(CoordinatorDynamicConfig config, AuditInfo auditInfo) {
        return this.jacksonConfigManager.set("coordinator.config", (Object)config, auditInfo);
    }

    public DruidCompactionConfig getCurrentCompactionConfig() {
        DruidCompactionConfig config = (DruidCompactionConfig)this.jacksonConfigManager.watch("coordinator.compaction.config", DruidCompactionConfig.class, (Object)DruidCompactionConfig.empty()).get();
        return (DruidCompactionConfig)Preconditions.checkNotNull((Object)config, (Object)"Got null config from watcher?!");
    }

    public ConfigManager.SetResult getAndUpdateCompactionConfig(UnaryOperator<DruidCompactionConfig> operator, AuditInfo auditInfo) {
        DruidCompactionConfig updated;
        byte[] currentBytes = this.metadataStorageConnector.lookup(this.tablesConfig.getConfigTable(), "name", "payload", "coordinator.compaction.config");
        DruidCompactionConfig current = this.convertBytesToCompactionConfig(currentBytes);
        if (current.equals(updated = (DruidCompactionConfig)operator.apply(current))) {
            return ConfigManager.SetResult.ok();
        }
        return this.jacksonConfigManager.set("coordinator.compaction.config", currentBytes, (Object)updated, auditInfo);
    }

    public DruidCompactionConfig convertBytesToCompactionConfig(byte[] bytes) {
        return (DruidCompactionConfig)this.jacksonConfigManager.convertByteToConfig(bytes, DruidCompactionConfig.class, (Object)DruidCompactionConfig.empty());
    }
}

