/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.smile.SmileFactory;
import com.fasterxml.jackson.dataformat.smile.SmileGenerator;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.druid.client.BatchServerInventoryView;
import org.apache.druid.client.BrokerSegmentWatcherConfig;
import org.apache.druid.client.BrokerServerView;
import org.apache.druid.client.DirectDruidClientFactory;
import org.apache.druid.client.DruidServer;
import org.apache.druid.client.FilteredServerInventoryView;
import org.apache.druid.client.QueryableDruidServer;
import org.apache.druid.client.ServerView;
import org.apache.druid.client.selector.HighestPriorityTierSelectorStrategy;
import org.apache.druid.client.selector.RandomServerSelectorStrategy;
import org.apache.druid.client.selector.ServerSelector;
import org.apache.druid.client.selector.ServerSelectorStrategy;
import org.apache.druid.client.selector.TierSelectorStrategy;
import org.apache.druid.curator.CuratorTestBase;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.query.QueryWatcher;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.realtime.appenderator.SegmentSchemas;
import org.apache.druid.server.coordination.DruidServerMetadata;
import org.apache.druid.server.coordination.ServerType;
import org.apache.druid.server.initialization.ZkPathsConfig;
import org.apache.druid.server.metrics.NoopServiceEmitter;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.TimelineLookup;
import org.apache.druid.timeline.TimelineObjectHolder;
import org.apache.druid.timeline.partition.NoneShardSpec;
import org.apache.druid.timeline.partition.PartitionChunk;
import org.apache.druid.timeline.partition.PartitionHolder;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.druid.timeline.partition.SingleElementPartitionChunk;
import org.easymock.EasyMock;
import org.joda.time.Interval;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BrokerServerViewTest
extends CuratorTestBase {
    private final ObjectMapper jsonMapper = TestHelper.makeJsonMapper();
    private final ZkPathsConfig zkPathsConfig = new ZkPathsConfig();
    private CountDownLatch segmentViewInitLatch;
    private CountDownLatch segmentAddedLatch;
    private CountDownLatch segmentRemovedLatch;
    private BatchServerInventoryView baseView;
    private BrokerServerView brokerServerView;

    @Before
    public void setUp() throws Exception {
        this.setupServerAndCurator();
        this.curator.start();
        this.curator.blockUntilConnected();
    }

    @Test
    public void testSingleServerAddedRemovedSegment() throws Exception {
        this.segmentViewInitLatch = new CountDownLatch(1);
        this.segmentAddedLatch = new CountDownLatch(1);
        this.segmentRemovedLatch = new CountDownLatch(1);
        this.setupViews();
        DruidServer druidServer = this.setupHistoricalServer("default_tier", "localhost:1234", 0);
        DataSegment segment = this.dataSegmentWithIntervalAndVersion("2014-10-20T00:00:00Z/P1D", "v1");
        int partition = segment.getShardSpec().getPartitionNum();
        Interval intervals = Intervals.of((String)"2014-10-20T00:00:00Z/P1D");
        this.announceSegmentForServer(druidServer, segment, this.zkPathsConfig, this.jsonMapper);
        Assert.assertTrue((boolean)this.timing.forWaiting().awaitLatch(this.segmentViewInitLatch));
        Assert.assertTrue((boolean)this.timing.forWaiting().awaitLatch(this.segmentAddedLatch));
        TimelineLookup timeline = (TimelineLookup)this.brokerServerView.getTimeline(new TableDataSource("test_broker_server_view")).get();
        List serverLookupRes = timeline.lookup(intervals);
        Assert.assertEquals((long)1L, (long)serverLookupRes.size());
        TimelineObjectHolder actualTimelineObjectHolder = (TimelineObjectHolder)serverLookupRes.get(0);
        Assert.assertEquals((Object)intervals, (Object)actualTimelineObjectHolder.getInterval());
        Assert.assertEquals((Object)"v1", (Object)actualTimelineObjectHolder.getVersion());
        PartitionHolder actualPartitionHolder = actualTimelineObjectHolder.getObject();
        Assert.assertTrue((boolean)actualPartitionHolder.isComplete());
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)actualPartitionHolder));
        ServerSelector selector = (ServerSelector)((PartitionChunk)actualPartitionHolder.iterator().next()).getObject();
        Assert.assertFalse((boolean)selector.isEmpty());
        Assert.assertEquals((Object)segment, (Object)selector.getSegment());
        Assert.assertEquals((Object)druidServer, (Object)selector.pick(null).getServer());
        Assert.assertNotNull((Object)timeline.findChunk(intervals, (Object)"v1", partition));
        this.unannounceSegmentForServer(druidServer, segment, this.zkPathsConfig);
        Assert.assertTrue((boolean)this.timing.forWaiting().awaitLatch(this.segmentRemovedLatch));
        Assert.assertEquals((long)0L, (long)timeline.lookup(intervals).size());
        Assert.assertNull((Object)timeline.findChunk(intervals, (Object)"v1", partition));
    }

    @Test
    public void testMultipleServerAddedRemovedSegment() throws Exception {
        this.segmentViewInitLatch = new CountDownLatch(1);
        this.segmentAddedLatch = new CountDownLatch(5);
        this.segmentRemovedLatch = new CountDownLatch(1);
        this.setupViews();
        List druidServers = Lists.transform((List)ImmutableList.of((Object)"locahost:0", (Object)"localhost:1", (Object)"localhost:2", (Object)"localhost:3", (Object)"localhost:4"), hostname -> this.setupHistoricalServer("default_tier", (String)hostname, 0));
        List segments = Lists.transform((List)ImmutableList.of((Object)Pair.of((Object)"2011-04-01/2011-04-03", (Object)"v1"), (Object)Pair.of((Object)"2011-04-03/2011-04-06", (Object)"v1"), (Object)Pair.of((Object)"2011-04-01/2011-04-09", (Object)"v2"), (Object)Pair.of((Object)"2011-04-06/2011-04-09", (Object)"v3"), (Object)Pair.of((Object)"2011-04-01/2011-04-02", (Object)"v3")), input -> this.dataSegmentWithIntervalAndVersion((String)input.lhs, (String)input.rhs));
        for (int i = 0; i < 5; ++i) {
            this.announceSegmentForServer((DruidServer)druidServers.get(i), (DataSegment)segments.get(i), this.zkPathsConfig, this.jsonMapper);
        }
        Assert.assertTrue((boolean)this.timing.forWaiting().awaitLatch(this.segmentViewInitLatch));
        Assert.assertTrue((boolean)this.timing.forWaiting().awaitLatch(this.segmentAddedLatch));
        TimelineLookup timeline = (TimelineLookup)this.brokerServerView.getTimeline(new TableDataSource("test_broker_server_view")).get();
        this.assertValues(Arrays.asList(this.createExpected("2011-04-01/2011-04-02", "v3", (DruidServer)druidServers.get(4), (DataSegment)segments.get(4)), this.createExpected("2011-04-02/2011-04-06", "v2", (DruidServer)druidServers.get(2), (DataSegment)segments.get(2)), this.createExpected("2011-04-06/2011-04-09", "v3", (DruidServer)druidServers.get(3), (DataSegment)segments.get(3))), timeline.lookup(Intervals.of((String)"2011-04-01/2011-04-09")));
        this.unannounceSegmentForServer((DruidServer)druidServers.get(2), (DataSegment)segments.get(2), this.zkPathsConfig);
        Assert.assertTrue((boolean)this.timing.forWaiting().awaitLatch(this.segmentRemovedLatch));
        this.segmentRemovedLatch = new CountDownLatch(4);
        timeline = (TimelineLookup)this.brokerServerView.getTimeline(new TableDataSource("test_broker_server_view")).get();
        this.assertValues(Arrays.asList(this.createExpected("2011-04-01/2011-04-02", "v3", (DruidServer)druidServers.get(4), (DataSegment)segments.get(4)), this.createExpected("2011-04-02/2011-04-03", "v1", (DruidServer)druidServers.get(0), (DataSegment)segments.get(0)), this.createExpected("2011-04-03/2011-04-06", "v1", (DruidServer)druidServers.get(1), (DataSegment)segments.get(1)), this.createExpected("2011-04-06/2011-04-09", "v3", (DruidServer)druidServers.get(3), (DataSegment)segments.get(3))), timeline.lookup(Intervals.of((String)"2011-04-01/2011-04-09")));
        for (int i = 0; i < 5; ++i) {
            if (i == 2) continue;
            this.unannounceSegmentForServer((DruidServer)druidServers.get(i), (DataSegment)segments.get(i), this.zkPathsConfig);
        }
        Assert.assertTrue((boolean)this.timing.forWaiting().awaitLatch(this.segmentRemovedLatch));
        Assert.assertEquals((long)0L, (long)timeline.lookup(Intervals.of((String)"2011-04-01/2011-04-09")).size());
    }

    @Test
    public void testMultipleServerAndBroker() throws Exception {
        this.segmentViewInitLatch = new CountDownLatch(1);
        this.segmentAddedLatch = new CountDownLatch(6);
        this.segmentRemovedLatch = new CountDownLatch(1);
        this.setupViews();
        DruidServer druidBroker = new DruidServer("localhost:5", "localhost:5", null, 10000000L, ServerType.BROKER, "default_tier", 0);
        List druidServers = Lists.transform((List)ImmutableList.of((Object)"locahost:0", (Object)"localhost:1", (Object)"localhost:2", (Object)"localhost:3", (Object)"localhost:4"), hostname -> this.setupHistoricalServer("default_tier", (String)hostname, 0));
        this.setupZNodeForServer(druidBroker, this.zkPathsConfig, this.jsonMapper);
        List segments = Lists.transform((List)ImmutableList.of((Object)Pair.of((Object)"2011-04-01/2011-04-03", (Object)"v1"), (Object)Pair.of((Object)"2011-04-03/2011-04-06", (Object)"v1"), (Object)Pair.of((Object)"2011-04-01/2011-04-09", (Object)"v2"), (Object)Pair.of((Object)"2011-04-06/2011-04-09", (Object)"v3"), (Object)Pair.of((Object)"2011-04-01/2011-04-02", (Object)"v3")), input -> this.dataSegmentWithIntervalAndVersion((String)input.lhs, (String)input.rhs));
        DataSegment brokerSegment = this.dataSegmentWithIntervalAndVersion("2011-04-01/2011-04-11", "v4");
        this.announceSegmentForServer(druidBroker, brokerSegment, this.zkPathsConfig, this.jsonMapper);
        for (int i = 0; i < 5; ++i) {
            this.announceSegmentForServer((DruidServer)druidServers.get(i), (DataSegment)segments.get(i), this.zkPathsConfig, this.jsonMapper);
        }
        Assert.assertTrue((boolean)this.timing.forWaiting().awaitLatch(this.segmentViewInitLatch));
        Assert.assertTrue((boolean)this.timing.forWaiting().awaitLatch(this.segmentAddedLatch));
        TimelineLookup timeline = (TimelineLookup)this.brokerServerView.getTimeline(new TableDataSource("test_broker_server_view")).get();
        this.assertValues(Arrays.asList(this.createExpected("2011-04-01/2011-04-02", "v3", (DruidServer)druidServers.get(4), (DataSegment)segments.get(4)), this.createExpected("2011-04-02/2011-04-06", "v2", (DruidServer)druidServers.get(2), (DataSegment)segments.get(2)), this.createExpected("2011-04-06/2011-04-09", "v3", (DruidServer)druidServers.get(3), (DataSegment)segments.get(3))), timeline.lookup(Intervals.of((String)"2011-04-01/2011-04-09")));
        Assert.assertEquals(druidServers.stream().map(DruidServer::getMetadata).collect(Collectors.toSet()), (Object)ImmutableSet.copyOf((Collection)this.brokerServerView.getDruidServerMetadatas()));
        this.unannounceSegmentForServer(druidBroker, brokerSegment, this.zkPathsConfig);
        Assert.assertTrue((boolean)this.timing.forWaiting().awaitLatch(this.segmentRemovedLatch));
        this.segmentRemovedLatch = new CountDownLatch(5);
        timeline = (TimelineLookup)this.brokerServerView.getTimeline(new TableDataSource("test_broker_server_view")).get();
        this.assertValues(Arrays.asList(this.createExpected("2011-04-01/2011-04-02", "v3", (DruidServer)druidServers.get(4), (DataSegment)segments.get(4)), this.createExpected("2011-04-02/2011-04-06", "v2", (DruidServer)druidServers.get(2), (DataSegment)segments.get(2)), this.createExpected("2011-04-06/2011-04-09", "v3", (DruidServer)druidServers.get(3), (DataSegment)segments.get(3))), timeline.lookup(Intervals.of((String)"2011-04-01/2011-04-09")));
        for (int i = 0; i < 5; ++i) {
            this.unannounceSegmentForServer((DruidServer)druidServers.get(i), (DataSegment)segments.get(i), this.zkPathsConfig);
        }
        Assert.assertTrue((boolean)this.timing.forWaiting().awaitLatch(this.segmentRemovedLatch));
    }

    @Test
    public void testMultipleTiers() throws Exception {
        this.segmentViewInitLatch = new CountDownLatch(1);
        this.segmentAddedLatch = new CountDownLatch(4);
        this.segmentRemovedLatch = new CountDownLatch(0);
        String tier1 = "tier1";
        String tier2 = "tier2";
        this.setupViews(Sets.newHashSet((Object[])new String[]{"tier2"}), null, true);
        DruidServer server11 = this.setupHistoricalServer("tier1", "localhost:1", 1);
        DruidServer server21 = this.setupHistoricalServer("tier2", "localhost:2", 1);
        DataSegment segment1 = this.dataSegmentWithIntervalAndVersion("2020-01-01/P1D", "v1");
        this.announceSegmentForServer(server11, segment1, this.zkPathsConfig, this.jsonMapper);
        DataSegment segment2 = this.dataSegmentWithIntervalAndVersion("2020-01-02/P1D", "v1");
        this.announceSegmentForServer(server11, segment2, this.zkPathsConfig, this.jsonMapper);
        this.announceSegmentForServer(server21, segment2, this.zkPathsConfig, this.jsonMapper);
        DataSegment segment3 = this.dataSegmentWithIntervalAndVersion("2020-01-03/P1D", "v1");
        this.announceSegmentForServer(server21, segment3, this.zkPathsConfig, this.jsonMapper);
        Assert.assertTrue((boolean)this.timing.forWaiting().awaitLatch(this.segmentViewInitLatch));
        Assert.assertTrue((boolean)this.timing.forWaiting().awaitLatch(this.segmentAddedLatch));
        TimelineLookup timeline = (TimelineLookup)this.brokerServerView.getTimeline(new TableDataSource(segment1.getDataSource())).get();
        Assert.assertTrue((boolean)timeline.lookup(segment1.getInterval()).isEmpty());
        List timelineHolders = timeline.lookup(segment2.getInterval());
        Assert.assertEquals((long)1L, (long)timelineHolders.size());
        TimelineObjectHolder timelineHolder = (TimelineObjectHolder)timelineHolders.get(0);
        Assert.assertEquals((Object)segment2.getInterval(), (Object)timelineHolder.getInterval());
        Assert.assertEquals((Object)segment2.getVersion(), (Object)timelineHolder.getVersion());
        PartitionHolder partitionHolder = timelineHolder.getObject();
        Assert.assertTrue((boolean)partitionHolder.isComplete());
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)partitionHolder));
        ServerSelector selector = (ServerSelector)((PartitionChunk)partitionHolder.iterator().next()).getObject();
        Assert.assertFalse((boolean)selector.isEmpty());
        Assert.assertEquals((Object)segment2, (Object)selector.getSegment());
        for (int i = 0; i < 5; ++i) {
            Assert.assertEquals((Object)server21, (Object)selector.pick(null).getServer());
        }
        Assert.assertEquals(Collections.singletonList(server21.getMetadata()), (Object)selector.getCandidates(2));
    }

    @Test
    public void testRealtimeTasksNotWatched() throws Exception {
        this.segmentViewInitLatch = new CountDownLatch(1);
        this.segmentAddedLatch = new CountDownLatch(4);
        this.segmentRemovedLatch = new CountDownLatch(0);
        this.setupViews(null, null, false);
        DruidServer realtimeServer = this.setupDruidServer(ServerType.INDEXER_EXECUTOR, null, "realtime:1", 1);
        DruidServer historicalServer = this.setupHistoricalServer("tier1", "historical:2", 1);
        DataSegment segment1 = this.dataSegmentWithIntervalAndVersion("2020-01-01/P1D", "v1");
        this.announceSegmentForServer(realtimeServer, segment1, this.zkPathsConfig, this.jsonMapper);
        DataSegment segment2 = this.dataSegmentWithIntervalAndVersion("2020-01-02/P1D", "v1");
        this.announceSegmentForServer(realtimeServer, segment2, this.zkPathsConfig, this.jsonMapper);
        this.announceSegmentForServer(historicalServer, segment2, this.zkPathsConfig, this.jsonMapper);
        DataSegment segment3 = this.dataSegmentWithIntervalAndVersion("2020-01-03/P1D", "v1");
        this.announceSegmentForServer(historicalServer, segment3, this.zkPathsConfig, this.jsonMapper);
        Assert.assertTrue((boolean)this.timing.forWaiting().awaitLatch(this.segmentViewInitLatch));
        Assert.assertTrue((boolean)this.timing.forWaiting().awaitLatch(this.segmentAddedLatch));
        TimelineLookup timeline = (TimelineLookup)this.brokerServerView.getTimeline(new TableDataSource(segment1.getDataSource())).get();
        Assert.assertTrue((boolean)timeline.lookup(segment1.getInterval()).isEmpty());
        List timelineHolders = timeline.lookup(segment2.getInterval());
        Assert.assertEquals((long)1L, (long)timelineHolders.size());
        TimelineObjectHolder timelineHolder = (TimelineObjectHolder)timelineHolders.get(0);
        Assert.assertEquals((Object)segment2.getInterval(), (Object)timelineHolder.getInterval());
        Assert.assertEquals((Object)segment2.getVersion(), (Object)timelineHolder.getVersion());
        PartitionHolder partitionHolder = timelineHolder.getObject();
        Assert.assertTrue((boolean)partitionHolder.isComplete());
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)partitionHolder));
        ServerSelector selector = (ServerSelector)((PartitionChunk)partitionHolder.iterator().next()).getObject();
        Assert.assertFalse((boolean)selector.isEmpty());
        Assert.assertEquals((Object)segment2, (Object)selector.getSegment());
        for (int i = 0; i < 5; ++i) {
            Assert.assertEquals((Object)historicalServer, (Object)selector.pick(null).getServer());
        }
        Assert.assertEquals(Collections.singletonList(historicalServer.getMetadata()), (Object)selector.getCandidates(2));
    }

    @Test
    public void testIgnoredTiers() throws Exception {
        this.segmentViewInitLatch = new CountDownLatch(1);
        this.segmentAddedLatch = new CountDownLatch(4);
        this.segmentRemovedLatch = new CountDownLatch(0);
        String tier1 = "tier1";
        String tier2 = "tier2";
        this.setupViews(null, Sets.newHashSet((Object[])new String[]{"tier1"}), false);
        DruidServer server11 = this.setupHistoricalServer("tier1", "localhost:1", 1);
        DruidServer server21 = this.setupHistoricalServer("tier2", "localhost:2", 1);
        DataSegment segment1 = this.dataSegmentWithIntervalAndVersion("2020-01-01/P1D", "v1");
        this.announceSegmentForServer(server11, segment1, this.zkPathsConfig, this.jsonMapper);
        DataSegment segment2 = this.dataSegmentWithIntervalAndVersion("2020-01-02/P1D", "v1");
        this.announceSegmentForServer(server11, segment2, this.zkPathsConfig, this.jsonMapper);
        this.announceSegmentForServer(server21, segment2, this.zkPathsConfig, this.jsonMapper);
        DataSegment segment3 = this.dataSegmentWithIntervalAndVersion("2020-01-03/P1D", "v1");
        this.announceSegmentForServer(server21, segment3, this.zkPathsConfig, this.jsonMapper);
        Assert.assertTrue((boolean)this.timing.forWaiting().awaitLatch(this.segmentViewInitLatch));
        Assert.assertTrue((boolean)this.timing.forWaiting().awaitLatch(this.segmentAddedLatch));
        TimelineLookup timeline = (TimelineLookup)this.brokerServerView.getTimeline(new TableDataSource(segment1.getDataSource())).get();
        Assert.assertTrue((boolean)timeline.lookup(segment1.getInterval()).isEmpty());
        List timelineHolders = timeline.lookup(segment2.getInterval());
        Assert.assertEquals((long)1L, (long)timelineHolders.size());
        TimelineObjectHolder timelineHolder = (TimelineObjectHolder)timelineHolders.get(0);
        Assert.assertEquals((Object)segment2.getInterval(), (Object)timelineHolder.getInterval());
        Assert.assertEquals((Object)segment2.getVersion(), (Object)timelineHolder.getVersion());
        PartitionHolder partitionHolder = timelineHolder.getObject();
        Assert.assertTrue((boolean)partitionHolder.isComplete());
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)partitionHolder));
        ServerSelector selector = (ServerSelector)((PartitionChunk)partitionHolder.iterator().next()).getObject();
        Assert.assertFalse((boolean)selector.isEmpty());
        Assert.assertEquals((Object)segment2, (Object)selector.getSegment());
        for (int i = 0; i < 5; ++i) {
            Assert.assertEquals((Object)server21, (Object)selector.pick(null).getServer());
        }
        Assert.assertEquals(Collections.singletonList(server21.getMetadata()), (Object)selector.getCandidates(2));
    }

    @Test(expected=ISE.class)
    public void testInvalidWatchedTiersConfig() throws Exception {
        String tier1 = "tier1";
        String tier2 = "tier2";
        this.setupViews(Sets.newHashSet((Object[])new String[]{"tier2"}), Sets.newHashSet((Object[])new String[]{"tier1"}), true);
    }

    @Test(expected=ISE.class)
    public void testEmptyWatchedTiersConfig() throws Exception {
        this.setupViews(Collections.emptySet(), null, true);
    }

    @Test(expected=ISE.class)
    public void testEmptyIgnoredTiersConfig() throws Exception {
        this.setupViews(null, Collections.emptySet(), true);
    }

    private DruidServer setupHistoricalServer(String tier, String name, int priority) {
        return this.setupDruidServer(ServerType.HISTORICAL, tier, name, priority);
    }

    private DruidServer setupDruidServer(ServerType serverType, String tier, String name, int priority) {
        DruidServer druidServer = new DruidServer(name, name, null, 1000000L, serverType, tier, priority);
        this.setupZNodeForServer(druidServer, this.zkPathsConfig, this.jsonMapper);
        return druidServer;
    }

    private Pair<Interval, Pair<String, Pair<DruidServer, DataSegment>>> createExpected(String intervalStr, String version, DruidServer druidServer, DataSegment segment) {
        return Pair.of((Object)Intervals.of((String)intervalStr), (Object)Pair.of((Object)version, (Object)Pair.of((Object)druidServer, (Object)segment)));
    }

    private void assertValues(List<Pair<Interval, Pair<String, Pair<DruidServer, DataSegment>>>> expected, List<TimelineObjectHolder> actual) {
        Assert.assertEquals((long)expected.size(), (long)actual.size());
        for (int i = 0; i < expected.size(); ++i) {
            Pair<Interval, Pair<String, Pair<DruidServer, DataSegment>>> expectedPair = expected.get(i);
            TimelineObjectHolder actualTimelineObjectHolder = actual.get(i);
            Assert.assertEquals((Object)expectedPair.lhs, (Object)actualTimelineObjectHolder.getInterval());
            Assert.assertEquals((Object)((Pair)expectedPair.rhs).lhs, (Object)actualTimelineObjectHolder.getVersion());
            PartitionHolder actualPartitionHolder = actualTimelineObjectHolder.getObject();
            Assert.assertTrue((boolean)actualPartitionHolder.isComplete());
            Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)actualPartitionHolder));
            ServerSelector selector = (ServerSelector)((SingleElementPartitionChunk)actualPartitionHolder.iterator().next()).getObject();
            Assert.assertFalse((boolean)selector.isEmpty());
            Assert.assertEquals((Object)((Pair)((Pair)expectedPair.rhs).rhs).lhs, (Object)selector.pick(null).getServer());
            Assert.assertEquals((Object)((Pair)((Pair)expectedPair.rhs).rhs).rhs, (Object)selector.getSegment());
        }
    }

    private void setupViews() throws Exception {
        this.setupViews(null, null, true);
    }

    private void setupViews(final Set<String> watchedTiers, final Set<String> ignoredTiers, final boolean watchRealtimeTasks) throws Exception {
        this.baseView = new BatchServerInventoryView(this.zkPathsConfig, this.curator, this.jsonMapper, Predicates.alwaysTrue(), "test"){

            public void registerSegmentCallback(Executor exec, final ServerView.SegmentCallback callback) {
                super.registerSegmentCallback(exec, new ServerView.SegmentCallback(){

                    public ServerView.CallbackAction segmentAdded(DruidServerMetadata server, DataSegment segment) {
                        ServerView.CallbackAction res = callback.segmentAdded(server, segment);
                        BrokerServerViewTest.this.segmentAddedLatch.countDown();
                        return res;
                    }

                    public ServerView.CallbackAction segmentRemoved(DruidServerMetadata server, DataSegment segment) {
                        ServerView.CallbackAction res = callback.segmentRemoved(server, segment);
                        BrokerServerViewTest.this.segmentRemovedLatch.countDown();
                        return res;
                    }

                    public ServerView.CallbackAction segmentViewInitialized() {
                        ServerView.CallbackAction res = callback.segmentViewInitialized();
                        BrokerServerViewTest.this.segmentViewInitLatch.countDown();
                        return res;
                    }

                    public ServerView.CallbackAction segmentSchemasAnnounced(SegmentSchemas segmentSchemas) {
                        return ServerView.CallbackAction.CONTINUE;
                    }
                });
            }
        };
        DirectDruidClientFactory druidClientFactory = new DirectDruidClientFactory((ServiceEmitter)new NoopServiceEmitter(), (QueryRunnerFactoryConglomerate)EasyMock.createMock(QueryRunnerFactoryConglomerate.class), (QueryWatcher)EasyMock.createMock(QueryWatcher.class), this.getSmileMapper(), (HttpClient)EasyMock.createMock(HttpClient.class));
        this.brokerServerView = new BrokerServerView((QueryableDruidServer.Maker)druidClientFactory, (FilteredServerInventoryView)this.baseView, (TierSelectorStrategy)new HighestPriorityTierSelectorStrategy((ServerSelectorStrategy)new RandomServerSelectorStrategy()), (ServiceEmitter)new NoopServiceEmitter(), new BrokerSegmentWatcherConfig(){

            public Set<String> getWatchedTiers() {
                return watchedTiers;
            }

            public boolean isWatchRealtimeTasks() {
                return watchRealtimeTasks;
            }

            public Set<String> getIgnoredTiers() {
                return ignoredTiers;
            }
        });
        this.baseView.start();
        this.brokerServerView.start();
    }

    private DataSegment dataSegmentWithIntervalAndVersion(String intervalStr, String version) {
        return DataSegment.builder().dataSource("test_broker_server_view").interval(Intervals.of((String)intervalStr)).loadSpec((Map)ImmutableMap.of((Object)"type", (Object)"local", (Object)"path", (Object)"somewhere")).version(version).dimensions((List)ImmutableList.of()).metrics((List)ImmutableList.of()).shardSpec((ShardSpec)NoneShardSpec.instance()).binaryVersion(Integer.valueOf(9)).size(0L).build();
    }

    public ObjectMapper getSmileMapper() {
        SmileFactory smileFactory = new SmileFactory();
        smileFactory.configure(SmileGenerator.Feature.ENCODE_BINARY_AS_7BIT, false);
        smileFactory.delegateToTextual(true);
        DefaultObjectMapper retVal = new DefaultObjectMapper((JsonFactory)smileFactory, "broker");
        retVal.getFactory().setCodec((ObjectCodec)retVal);
        return retVal;
    }

    @After
    public void tearDown() throws Exception {
        this.baseView.stop();
        this.tearDownServerAndCurator();
    }
}

