/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.guice;

import com.google.common.collect.ImmutableList;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.ProvisionException;
import com.google.inject.name.Names;
import com.google.inject.util.Modules;
import java.lang.annotation.Annotation;
import java.util.Properties;
import org.apache.druid.client.cache.CacheConfig;
import org.apache.druid.client.cache.CachePopulator;
import org.apache.druid.client.cache.CachePopulatorStats;
import org.apache.druid.guice.BrokerProcessingModule;
import org.apache.druid.guice.GuiceInjectors;
import org.apache.druid.initialization.Initialization;
import org.apache.druid.query.BrokerParallelMergeConfig;
import org.apache.druid.query.DruidProcessingConfig;
import org.apache.druid.utils.JvmUtils;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class BrokerProcessingModuleTest {
    private Injector injector;
    private BrokerProcessingModule target;
    @Mock
    private CacheConfig cacheConfig;
    @Mock
    private CachePopulatorStats cachePopulatorStats;

    @Before
    public void setUp() {
        this.target = new BrokerProcessingModule();
        this.injector = this.makeInjector(new Properties());
    }

    @Test
    public void testIntermediateResultsPool() {
        DruidProcessingConfig druidProcessingConfig = (DruidProcessingConfig)this.injector.getInstance(DruidProcessingConfig.class);
        this.target.getIntermediateResultsPool(druidProcessingConfig);
    }

    @Test
    public void testMergeBufferPool() {
        DruidProcessingConfig druidProcessingConfig = (DruidProcessingConfig)this.injector.getInstance(DruidProcessingConfig.class);
        this.target.getMergeBufferPool(druidProcessingConfig);
    }

    @Test
    public void testMergeProcessingPool() {
        BrokerParallelMergeConfig config = (BrokerParallelMergeConfig)this.injector.getInstance(BrokerParallelMergeConfig.class);
        BrokerProcessingModule module = new BrokerProcessingModule();
        module.getMergeProcessingPoolProvider(config);
    }

    @Test
    public void testCachePopulatorAsSingleton() {
        CachePopulator cachePopulator = (CachePopulator)this.injector.getInstance(CachePopulator.class);
        Assert.assertNotNull((Object)cachePopulator);
    }

    @Test(expected=ProvisionException.class)
    public void testMemoryCheckThrowsException() {
        try {
            JvmUtils.getRuntimeInfo().getDirectMemorySizeBytes();
        }
        catch (UnsupportedOperationException e) {
            Assume.assumeNoException((Throwable)e);
        }
        Properties props = new Properties();
        props.setProperty("druid.processing.buffer.sizeBytes", "3GiB");
        Injector injector1 = this.makeInjector(props);
        DruidProcessingConfig processingBufferConfig = (DruidProcessingConfig)injector1.getInstance(DruidProcessingConfig.class);
        BrokerProcessingModule module = new BrokerProcessingModule();
        module.getMergeBufferPool(processingBufferConfig);
    }

    private Injector makeInjector(Properties props) {
        Injector injector = Initialization.makeInjectorWithModules((Injector)GuiceInjectors.makeStartupInjector(), (Iterable)ImmutableList.of((Object)Modules.override((Module[])new Module[]{binder -> {
            binder.bindConstant().annotatedWith((Annotation)Names.named((String)"serviceName")).to("test");
            binder.bindConstant().annotatedWith((Annotation)Names.named((String)"servicePort")).to(0);
            binder.bindConstant().annotatedWith((Annotation)Names.named((String)"tlsServicePort")).to(-1);
            binder.bind(Properties.class).toInstance((Object)props);
        }, this.target}).with(new Module[]{binder -> {
            binder.bind(CachePopulatorStats.class).toInstance((Object)this.cachePopulatorStats);
            binder.bind(CacheConfig.class).toInstance((Object)this.cacheConfig);
        }})));
        return injector;
    }
}

