/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.guice;

import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.druid.guice.DruidBinders;
import org.apache.druid.guice.JoinableFactoryModule;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.GlobalTableDataSource;
import org.apache.druid.query.InlineDataSource;
import org.apache.druid.query.LookupDataSource;
import org.apache.druid.query.expression.LookupEnabledTestExprMacroTable;
import org.apache.druid.query.lookup.LookupExtractorFactoryContainerProvider;
import org.apache.druid.segment.join.BroadcastTableJoinableFactory;
import org.apache.druid.segment.join.InlineJoinableFactory;
import org.apache.druid.segment.join.JoinableFactory;
import org.apache.druid.segment.join.LookupJoinableFactory;
import org.apache.druid.segment.join.MapJoinableFactory;
import org.apache.druid.segment.join.NoopDataSource;
import org.apache.druid.segment.join.NoopJoinableFactory;
import org.apache.druid.server.SegmentManager;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JoinableFactoryModuleTest {
    private Injector injector;

    @Before
    public void setUp() {
        this.injector = this.makeInjectorWithProperties(new Module[0]);
    }

    @Test
    public void testInjectJoinableFactoryIsSingleton() {
        JoinableFactory factory = (JoinableFactory)this.injector.getInstance(JoinableFactory.class);
        Assert.assertEquals(MapJoinableFactory.class, factory.getClass());
        JoinableFactory otherFactory = (JoinableFactory)this.injector.getInstance(JoinableFactory.class);
        Assert.assertSame((Object)factory, (Object)otherFactory);
    }

    @Test
    public void testInjectDefaultBindingsShouldBeInjected() {
        Set factories = (Set)this.injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Set<JoinableFactory>>(){}));
        Assert.assertEquals((long)JoinableFactoryModule.FACTORY_MAPPINGS.size(), (long)factories.size());
        Map joinableFactoriesMappings = (Map)this.injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Map<Class<? extends JoinableFactory>, Class<? extends DataSource>>>(){}));
        this.assertDefaultFactories(joinableFactoriesMappings);
    }

    @Test
    public void testJoinableFactoryCanBind() {
        this.injector = this.makeInjectorWithProperties(binder -> {
            DruidBinders.joinableFactoryMultiBinder((Binder)binder).addBinding().toInstance((Object)NoopJoinableFactory.INSTANCE);
            DruidBinders.joinableMappingBinder((Binder)binder).addBinding(NoopJoinableFactory.class).toInstance(NoopDataSource.class);
        });
        Map joinableFactoriesMappings = (Map)this.injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Map<Class<? extends JoinableFactory>, Class<? extends DataSource>>>(){}));
        Set factories = (Set)this.injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Set<JoinableFactory>>(){}));
        Assert.assertEquals((long)(JoinableFactoryModule.FACTORY_MAPPINGS.size() + 1), (long)factories.size());
        Assert.assertEquals(NoopDataSource.class, joinableFactoriesMappings.get(NoopJoinableFactory.class));
        this.assertDefaultFactories(joinableFactoriesMappings);
    }

    private void assertDefaultFactories(Map<Class<? extends JoinableFactory>, Class<? extends DataSource>> joinableFactoriesMappings) {
        Assert.assertEquals(LookupDataSource.class, joinableFactoriesMappings.get(LookupJoinableFactory.class));
        Assert.assertEquals(InlineDataSource.class, joinableFactoriesMappings.get(InlineJoinableFactory.class));
        Assert.assertEquals(GlobalTableDataSource.class, joinableFactoriesMappings.get(BroadcastTableJoinableFactory.class));
    }

    private Injector makeInjectorWithProperties(Module ... otherModules) {
        LookupExtractorFactoryContainerProvider lookupProvider = LookupEnabledTestExprMacroTable.createTestLookupProvider(Collections.emptyMap());
        ImmutableList.Builder modulesBuilder = ImmutableList.builder().add((Object)new JoinableFactoryModule()).add(binder -> binder.bind(LookupExtractorFactoryContainerProvider.class).toInstance((Object)lookupProvider)).add(binder -> binder.bind(SegmentManager.class).toInstance((Object)((SegmentManager)EasyMock.createMock(SegmentManager.class)))).add(binder -> binder.bindScope(LazySingleton.class, Scopes.SINGLETON));
        for (Module otherModule : otherModules) {
            modulesBuilder.add((Object)otherModule);
        }
        return Guice.createInjector((Iterable)modulesBuilder.build());
    }
}

