/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.druid.data.input.StringTuple;
import org.apache.druid.indexing.overlord.DataSourceMetadata;
import org.apache.druid.indexing.overlord.ObjectMetadata;
import org.apache.druid.indexing.overlord.SegmentCreateRequest;
import org.apache.druid.indexing.overlord.SegmentPublishResult;
import org.apache.druid.indexing.overlord.Segments;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.metrics.StubServiceEmitter;
import org.apache.druid.metadata.IndexerSQLMetadataStorageCoordinator;
import org.apache.druid.metadata.IndexerSqlMetadataStorageCoordinatorTestBase;
import org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.druid.metadata.PendingSegmentRecord;
import org.apache.druid.metadata.ReplaceTaskLock;
import org.apache.druid.metadata.SQLMetadataConnector;
import org.apache.druid.metadata.SegmentsMetadataManagerConfig;
import org.apache.druid.metadata.SortOrder;
import org.apache.druid.metadata.TestDerbyConnector;
import org.apache.druid.metadata.segment.SegmentMetadataTransaction;
import org.apache.druid.metadata.segment.SegmentMetadataTransactionFactory;
import org.apache.druid.metadata.segment.SqlSegmentMetadataTransactionFactory;
import org.apache.druid.metadata.segment.cache.HeapMemorySegmentMetadataCache;
import org.apache.druid.metadata.segment.cache.SegmentMetadataCache;
import org.apache.druid.segment.SegmentSchemaMapping;
import org.apache.druid.segment.metadata.CentralizedDatasourceSchemaConfig;
import org.apache.druid.segment.metadata.FingerprintGenerator;
import org.apache.druid.segment.metadata.SegmentSchemaManager;
import org.apache.druid.segment.metadata.SegmentSchemaTestUtils;
import org.apache.druid.segment.realtime.appenderator.SegmentIdWithShardSpec;
import org.apache.druid.server.coordinator.CreateDataSegments;
import org.apache.druid.server.coordinator.simulate.BlockingExecutorService;
import org.apache.druid.server.coordinator.simulate.TestDruidLeaderSelector;
import org.apache.druid.server.coordinator.simulate.WrappingScheduledExecutorService;
import org.apache.druid.server.http.DataSegmentPlus;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.SegmentTimeline;
import org.apache.druid.timeline.TimelineObjectHolder;
import org.apache.druid.timeline.partition.DimensionRangeShardSpec;
import org.apache.druid.timeline.partition.HashBasedNumberedPartialShardSpec;
import org.apache.druid.timeline.partition.HashBasedNumberedShardSpec;
import org.apache.druid.timeline.partition.LinearShardSpec;
import org.apache.druid.timeline.partition.NumberedOverwritePartialShardSpec;
import org.apache.druid.timeline.partition.NumberedOverwriteShardSpec;
import org.apache.druid.timeline.partition.NumberedPartialShardSpec;
import org.apache.druid.timeline.partition.NumberedShardSpec;
import org.apache.druid.timeline.partition.PartialShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.druid.timeline.partition.SingleDimensionShardSpec;
import org.apache.druid.timeline.partition.TombstoneShardSpec;
import org.assertj.core.api.Assertions;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class IndexerSQLMetadataStorageCoordinatorTest
extends IndexerSqlMetadataStorageCoordinatorTestBase {
    @Rule
    public final TestDerbyConnector.DerbyConnectorRule derbyConnectorRule = new TestDerbyConnector.DerbyConnectorRule();
    private TestDruidLeaderSelector leaderSelector;
    private SegmentMetadataCache segmentMetadataCache;
    private StubServiceEmitter emitter;
    private SqlSegmentMetadataTransactionFactory transactionFactory;
    private BlockingExecutorService cachePollExecutor;
    private final SegmentMetadataCache.UsageMode cacheMode;

    @Parameterized.Parameters(name="cacheMode = {0}")
    public static Object[][] testParameters() {
        return new Object[][]{{SegmentMetadataCache.UsageMode.ALWAYS}, {SegmentMetadataCache.UsageMode.NEVER}, {SegmentMetadataCache.UsageMode.IF_SYNCED}};
    }

    public IndexerSQLMetadataStorageCoordinatorTest(SegmentMetadataCache.UsageMode cacheMode) {
        this.cacheMode = cacheMode;
    }

    @Before
    public void setUp() {
        this.derbyConnector = this.derbyConnectorRule.getConnector();
        this.segmentsTable = this.derbyConnectorRule.segments();
        this.mapper.registerSubtypes(new Class[]{LinearShardSpec.class, NumberedShardSpec.class, HashBasedNumberedShardSpec.class});
        this.derbyConnector.createDataSourceTable();
        this.derbyConnector.createTaskTables();
        this.derbyConnector.createSegmentTable();
        this.derbyConnector.createUpgradeSegmentsTable();
        this.derbyConnector.createPendingSegmentsTable();
        this.metadataUpdateCounter.set(0L);
        this.segmentTableDropUpdateCounter.set(0L);
        this.fingerprintGenerator = new FingerprintGenerator(this.mapper);
        this.segmentSchemaManager = new SegmentSchemaManager((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get(), this.mapper, (SQLMetadataConnector)this.derbyConnector);
        this.segmentSchemaTestUtils = new SegmentSchemaTestUtils(this.derbyConnectorRule, this.derbyConnector, this.mapper);
        this.emitter = new StubServiceEmitter();
        this.leaderSelector = new TestDruidLeaderSelector();
        this.cachePollExecutor = new BlockingExecutorService("test-cache-poll-exec");
        this.segmentMetadataCache = new HeapMemorySegmentMetadataCache(this.mapper, () -> new SegmentsMetadataManagerConfig(null, this.cacheMode), this.derbyConnectorRule.metadataTablesConfigSupplier(), (SQLMetadataConnector)this.derbyConnector, (corePoolSize, nameFormat) -> new WrappingScheduledExecutorService(nameFormat, this.cachePollExecutor, false), (ServiceEmitter)this.emitter);
        this.leaderSelector.becomeLeader();
        if (this.isCacheEnabled()) {
            this.segmentMetadataCache.start();
            this.segmentMetadataCache.becomeLeader();
            this.refreshCache();
            this.refreshCache();
        }
        this.transactionFactory = new SqlSegmentMetadataTransactionFactory(this.mapper, (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get(), (SQLMetadataConnector)this.derbyConnector, this.leaderSelector, this.segmentMetadataCache, (ServiceEmitter)this.emitter){

            public int getMaxRetries() {
                return 2;
            }
        };
        this.coordinator = new IndexerSQLMetadataStorageCoordinator((SegmentMetadataTransactionFactory)this.transactionFactory, this.mapper, (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get(), (SQLMetadataConnector)this.derbyConnector, this.segmentSchemaManager, CentralizedDatasourceSchemaConfig.create()){

            protected SegmentPublishResult updateDataSourceMetadataWithHandle(SegmentMetadataTransaction transaction, String dataSource, DataSourceMetadata startMetadata, DataSourceMetadata endMetadata) throws IOException {
                IndexerSQLMetadataStorageCoordinatorTest.this.metadataUpdateCounter.getAndIncrement();
                return super.updateDataSourceMetadataWithHandle(transaction, dataSource, startMetadata, endMetadata);
            }
        };
    }

    @After
    public void tearDown() {
        this.segmentMetadataCache.stopBeingLeader();
        this.segmentMetadataCache.stop();
        this.leaderSelector.stopBeingLeader();
    }

    private void refreshCache() {
        if (this.isCacheEnabled()) {
            this.cachePollExecutor.finishNextPendingTasks(2);
        }
    }

    private boolean isCacheEnabled() {
        return this.cacheMode != SegmentMetadataCache.UsageMode.NEVER;
    }

    @Test
    public void testCommitAppendSegments() {
        DataSegment segment;
        int i;
        String v1 = "2023-01-01";
        String v2 = "2023-01-02";
        String v3 = "2023-01-03";
        String alreadyUpgradedVersion = "2023-02-01";
        String lockVersion = "2024-01-01";
        String taskAllocatorId = "appendTask";
        String replaceTaskId = "replaceTask1";
        ReplaceTaskLock replaceLock = new ReplaceTaskLock("replaceTask1", Intervals.of((String)"2023-01-01/2023-01-03"), "2024-01-01");
        HashSet<DataSegment> appendSegments = new HashSet<DataSegment>();
        ArrayList<PendingSegmentRecord> pendingSegmentsForTask = new ArrayList<PendingSegmentRecord>();
        HashSet<DataSegment> expectedSegmentsToUpgrade = new HashSet<DataSegment>();
        for (i = 0; i < 10; ++i) {
            segment = this.createSegment(Intervals.of((String)"2023-01-01/2023-01-02"), "2023-01-01", (ShardSpec)new LinearShardSpec(Integer.valueOf(i)));
            appendSegments.add(segment);
            expectedSegmentsToUpgrade.add(segment);
            pendingSegmentsForTask.add(PendingSegmentRecord.create((SegmentIdWithShardSpec)SegmentIdWithShardSpec.fromDataSegment((DataSegment)segment), (String)"2023-01-01", (String)segment.getId().toString(), null, (String)"appendTask"));
            pendingSegmentsForTask.add(PendingSegmentRecord.create((SegmentIdWithShardSpec)new SegmentIdWithShardSpec("wiki", Intervals.of((String)"2023-01-01/2023-02-01"), "2023-02-01", (ShardSpec)new NumberedShardSpec(i, 0)), (String)"2023-02-01", (String)segment.getId().toString(), (String)segment.getId().toString(), (String)"appendTask"));
        }
        for (i = 0; i < 10; ++i) {
            segment = this.createSegment(Intervals.of((String)"2023-01-02/2023-01-03"), "2023-01-02", (ShardSpec)new LinearShardSpec(Integer.valueOf(i)));
            appendSegments.add(segment);
            expectedSegmentsToUpgrade.add(segment);
            pendingSegmentsForTask.add(PendingSegmentRecord.create((SegmentIdWithShardSpec)SegmentIdWithShardSpec.fromDataSegment((DataSegment)segment), (String)"2023-01-02", (String)segment.getId().toString(), null, (String)"appendTask"));
            pendingSegmentsForTask.add(PendingSegmentRecord.create((SegmentIdWithShardSpec)new SegmentIdWithShardSpec("wiki", Intervals.of((String)"2023-01-01/2023-02-01"), "2023-02-01", (ShardSpec)new NumberedShardSpec(10 + i, 0)), (String)"2023-02-01", (String)segment.getId().toString(), (String)segment.getId().toString(), (String)"appendTask"));
        }
        for (i = 0; i < 10; ++i) {
            segment = this.createSegment(Intervals.of((String)"2023-01-03/2023-01-04"), "2023-01-03", (ShardSpec)new LinearShardSpec(Integer.valueOf(i)));
            appendSegments.add(segment);
            pendingSegmentsForTask.add(PendingSegmentRecord.create((SegmentIdWithShardSpec)SegmentIdWithShardSpec.fromDataSegment((DataSegment)segment), (String)"2023-01-03", (String)segment.getId().toString(), null, (String)"appendTask"));
            pendingSegmentsForTask.add(PendingSegmentRecord.create((SegmentIdWithShardSpec)new SegmentIdWithShardSpec("wiki", Intervals.of((String)"2023-01-01/2023-02-01"), "2023-02-01", (ShardSpec)new NumberedShardSpec(20 + i, 0)), (String)"2023-02-01", (String)segment.getId().toString(), (String)segment.getId().toString(), (String)"appendTask"));
        }
        this.insertPendingSegments("wiki", pendingSegmentsForTask, false);
        Map<DataSegment, ReplaceTaskLock> segmentToReplaceLock = expectedSegmentsToUpgrade.stream().collect(Collectors.toMap(s -> s, s -> replaceLock));
        SegmentPublishResult commitResult = this.coordinator.commitAppendSegments(appendSegments, segmentToReplaceLock, "appendTask", null);
        Assert.assertTrue((boolean)commitResult.isSuccess());
        HashSet<DataSegment> allCommittedSegments = new HashSet<DataSegment>(this.retrieveUsedSegments((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()));
        Map upgradedFromSegmentIdMap = this.coordinator.retrieveUpgradedFromSegmentIds("wiki", allCommittedSegments.stream().map(DataSegment::getId).map(SegmentId::toString).collect(Collectors.toSet()));
        Assert.assertTrue((boolean)allCommittedSegments.containsAll(appendSegments));
        for (DataSegment dataSegment : appendSegments) {
            Assert.assertNull(upgradedFromSegmentIdMap.get(dataSegment.getId().toString()));
        }
        allCommittedSegments.removeAll(appendSegments);
        Assert.assertEquals((long)appendSegments.size(), (long)allCommittedSegments.size());
        HashMap<String, DataSegment> segmentMap = new HashMap<String, DataSegment>();
        for (DataSegment segment3 : appendSegments) {
            segmentMap.put(segment3.getId().toString(), segment3);
        }
        for (DataSegment segment2 : allCommittedSegments) {
            for (PendingSegmentRecord pendingSegmentRecord : pendingSegmentsForTask) {
                if (!pendingSegmentRecord.getId().asSegmentId().toString().equals(segment2.getId().toString())) continue;
                DataSegment upgradedFromSegment = (DataSegment)segmentMap.get(pendingSegmentRecord.getUpgradedFromSegmentId());
                Assert.assertNotNull((Object)upgradedFromSegment);
                Assert.assertEquals((Object)segment2.getLoadSpec(), (Object)upgradedFromSegment.getLoadSpec());
                Assert.assertEquals((Object)pendingSegmentRecord.getUpgradedFromSegmentId(), upgradedFromSegmentIdMap.get(segment2.getId().toString()));
            }
        }
        Set set = expectedSegmentsToUpgrade.stream().map(s -> s.getId().toString()).collect(Collectors.toSet());
        Map<String, String> observedSegmentToLock = this.getSegmentsCommittedDuringReplaceTask("replaceTask1", (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get());
        Assert.assertEquals(set, observedSegmentToLock.keySet());
        HashSet<String> observedLockVersions = new HashSet<String>(observedSegmentToLock.values());
        Assert.assertEquals((long)1L, (long)observedLockVersions.size());
        Assert.assertEquals((Object)replaceLock.getVersion(), (Object)Iterables.getOnlyElement(observedLockVersions));
    }

    @Test
    public void testCommitReplaceSegments_partiallyOverlappingPendingSegmentUnsupported() {
        ReplaceTaskLock replaceLock = new ReplaceTaskLock("g1", Intervals.of((String)"2023-01-01/2023-02-01"), "2023-02-01");
        HashSet<DataSegment> segmentsAppendedWithReplaceLock = new HashSet<DataSegment>();
        HashMap<DataSegment, ReplaceTaskLock> appendedSegmentToReplaceLockMap = new HashMap<DataSegment, ReplaceTaskLock>();
        PendingSegmentRecord pendingSegmentForInterval = PendingSegmentRecord.create((SegmentIdWithShardSpec)new SegmentIdWithShardSpec("foo", Intervals.of((String)"2023-01-01/2024-01-01"), "2023-01-02", (ShardSpec)new NumberedShardSpec(100, 0)), (String)"", (String)"", null, (String)"append");
        for (int i = 1; i < 9; ++i) {
            DataSegment segment = new DataSegment("foo", Intervals.of((String)("2023-01-0" + i + "/2023-01-0" + (i + 1))), "2023-01-0" + i, (Map)ImmutableMap.of((Object)"path", (Object)("a-" + i)), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new LinearShardSpec(Integer.valueOf(0)), Integer.valueOf(9), 100L);
            segmentsAppendedWithReplaceLock.add(segment);
            appendedSegmentToReplaceLockMap.put(segment, replaceLock);
        }
        this.segmentSchemaTestUtils.insertUsedSegments(segmentsAppendedWithReplaceLock, Collections.emptyMap());
        this.insertPendingSegments("foo", List.of(pendingSegmentForInterval), true);
        this.insertIntoUpgradeSegmentsTable(appendedSegmentToReplaceLockMap, (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get());
        HashSet<DataSegment> replacingSegments = new HashSet<DataSegment>();
        for (int i = 1; i < 9; ++i) {
            DataSegment segment = new DataSegment("foo", Intervals.of((String)"2023-01-01/2023-02-01"), "2023-02-01", (Map)ImmutableMap.of((Object)"path", (Object)("b-" + i)), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new NumberedShardSpec(i, 9), Integer.valueOf(9), 100L);
            replacingSegments.add(segment);
        }
        Assert.assertFalse((boolean)this.coordinator.commitReplaceSegments(replacingSegments, (Set)ImmutableSet.of((Object)replaceLock), null).isSuccess());
    }

    @Test
    public void testCommitReplaceSegments() {
        ReplaceTaskLock replaceLock = new ReplaceTaskLock("g1", Intervals.of((String)"2023-01-01/2023-02-01"), "2023-02-01");
        HashSet<DataSegment> segmentsAppendedWithReplaceLock = new HashSet<DataSegment>();
        HashMap<DataSegment, ReplaceTaskLock> appendedSegmentToReplaceLockMap = new HashMap<DataSegment, ReplaceTaskLock>();
        PendingSegmentRecord pendingSegmentInInterval = PendingSegmentRecord.create((SegmentIdWithShardSpec)new SegmentIdWithShardSpec("foo", Intervals.of((String)"2023-01-01/2023-01-02"), "2023-01-02", (ShardSpec)new NumberedShardSpec(100, 0)), (String)"", (String)"", null, (String)"append");
        PendingSegmentRecord pendingSegmentOutsideInterval = PendingSegmentRecord.create((SegmentIdWithShardSpec)new SegmentIdWithShardSpec("foo", Intervals.of((String)"2023-04-01/2023-04-02"), "2023-01-02", (ShardSpec)new NumberedShardSpec(100, 0)), (String)"", (String)"", null, (String)"append");
        for (int i = 1; i < 9; ++i) {
            DataSegment segment = new DataSegment("foo", Intervals.of((String)("2023-01-0" + i + "/2023-01-0" + (i + 1))), "2023-01-0" + i, (Map)ImmutableMap.of((Object)"path", (Object)("a-" + i)), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new LinearShardSpec(Integer.valueOf(0)), Integer.valueOf(9), 100L);
            segmentsAppendedWithReplaceLock.add(segment);
            appendedSegmentToReplaceLockMap.put(segment, replaceLock);
        }
        this.segmentSchemaTestUtils.insertUsedSegments(segmentsAppendedWithReplaceLock, Collections.emptyMap());
        this.insertPendingSegments("foo", List.of(pendingSegmentInInterval, pendingSegmentOutsideInterval), true);
        this.insertIntoUpgradeSegmentsTable(appendedSegmentToReplaceLockMap, (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get());
        HashSet<DataSegment> replacingSegments = new HashSet<DataSegment>();
        for (int i = 1; i < 9; ++i) {
            DataSegment segment = new DataSegment("foo", Intervals.of((String)"2023-01-01/2023-02-01"), "2023-02-01", (Map)ImmutableMap.of((Object)"path", (Object)("b-" + i)), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new NumberedShardSpec(i, 9), Integer.valueOf(9), 100L);
            replacingSegments.add(segment);
        }
        this.coordinator.commitReplaceSegments(replacingSegments, (Set)ImmutableSet.of((Object)replaceLock), null);
        Assert.assertEquals((long)(2L * (long)segmentsAppendedWithReplaceLock.size() + (long)replacingSegments.size()), (long)this.retrieveUsedSegmentIds((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()).size());
        HashSet<DataSegment> usedSegments = new HashSet<DataSegment>(this.retrieveUsedSegments((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()));
        Map upgradedFromSegmentIdMap = this.coordinator.retrieveUpgradedFromSegmentIds("foo", usedSegments.stream().map(DataSegment::getId).map(SegmentId::toString).collect(Collectors.toSet()));
        Assert.assertTrue((boolean)usedSegments.containsAll(segmentsAppendedWithReplaceLock));
        for (DataSegment appendSegment : segmentsAppendedWithReplaceLock) {
            Assert.assertNull(upgradedFromSegmentIdMap.get(appendSegment.getId().toString()));
        }
        usedSegments.removeAll(segmentsAppendedWithReplaceLock);
        Assert.assertTrue((boolean)usedSegments.containsAll(replacingSegments));
        for (DataSegment replaceSegment : replacingSegments) {
            Assert.assertNull(upgradedFromSegmentIdMap.get(replaceSegment.getId().toString()));
        }
        usedSegments.removeAll(replacingSegments);
        Assert.assertEquals((long)segmentsAppendedWithReplaceLock.size(), (long)usedSegments.size());
        for (DataSegment segmentReplicaWithNewVersion : usedSegments) {
            boolean hasBeenCarriedForward = false;
            for (DataSegment appendedSegment : segmentsAppendedWithReplaceLock) {
                if (!appendedSegment.getLoadSpec().equals(segmentReplicaWithNewVersion.getLoadSpec())) continue;
                Assert.assertEquals((Object)appendedSegment.getId().toString(), upgradedFromSegmentIdMap.get(segmentReplicaWithNewVersion.getId().toString()));
                hasBeenCarriedForward = true;
                break;
            }
            Assert.assertTrue((boolean)hasBeenCarriedForward);
        }
        List pendingSegmentsInInterval = this.coordinator.getPendingSegments("foo", Intervals.of((String)"2023-01-01/2023-02-01"));
        Assert.assertEquals((long)2L, (long)pendingSegmentsInInterval.size());
        SegmentId rootPendingSegmentId = pendingSegmentInInterval.getId().asSegmentId();
        if (((PendingSegmentRecord)pendingSegmentsInInterval.get(0)).getUpgradedFromSegmentId() == null) {
            Assert.assertEquals((Object)rootPendingSegmentId, (Object)((PendingSegmentRecord)pendingSegmentsInInterval.get(0)).getId().asSegmentId());
            Assert.assertEquals((Object)rootPendingSegmentId.toString(), (Object)((PendingSegmentRecord)pendingSegmentsInInterval.get(1)).getUpgradedFromSegmentId());
        } else {
            Assert.assertEquals((Object)rootPendingSegmentId, (Object)((PendingSegmentRecord)pendingSegmentsInInterval.get(1)).getId().asSegmentId());
            Assert.assertEquals((Object)rootPendingSegmentId.toString(), (Object)((PendingSegmentRecord)pendingSegmentsInInterval.get(0)).getUpgradedFromSegmentId());
        }
        List pendingSegmentsOutsideInterval = this.coordinator.getPendingSegments("foo", Intervals.of((String)"2023-04-01/2023-05-01"));
        Assert.assertEquals((long)1L, (long)pendingSegmentsOutsideInterval.size());
        Assert.assertEquals((Object)pendingSegmentOutsideInterval.getId().asSegmentId(), (Object)((PendingSegmentRecord)pendingSegmentsOutsideInterval.get(0)).getId().asSegmentId());
    }

    @Test
    public void testDuplicatePendingSegmentEntriesAreNotInserted() {
        PendingSegmentRecord pendingSegment0 = PendingSegmentRecord.create((SegmentIdWithShardSpec)new SegmentIdWithShardSpec("foo", Intervals.ETERNITY, "version", (ShardSpec)new NumberedShardSpec(0, 0)), (String)"sequenceName0", (String)"sequencePrevId0", null, (String)"taskAllocatorId");
        PendingSegmentRecord pendingSegment1 = PendingSegmentRecord.create((SegmentIdWithShardSpec)new SegmentIdWithShardSpec("foo", Intervals.ETERNITY, "version", (ShardSpec)new NumberedShardSpec(1, 0)), (String)"sequenceName1", (String)"sequencePrevId1", null, (String)"taskAllocatorId");
        int actualInserted = this.insertPendingSegments("foo", List.of(pendingSegment0, pendingSegment0, pendingSegment1, pendingSegment1, pendingSegment1), true);
        Assert.assertEquals((long)2L, (long)actualInserted);
    }

    @Test
    public void testSimpleAnnounce() throws IOException {
        this.coordinator.commitSegments(this.SEGMENTS, new SegmentSchemaMapping(1));
        for (DataSegment segment : this.SEGMENTS) {
            Assert.assertArrayEquals((byte[])this.mapper.writeValueAsString((Object)segment).getBytes(StandardCharsets.UTF_8), (byte[])this.derbyConnector.lookup(((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getSegmentsTable(), "id", "payload", segment.getId().toString()));
        }
        Assert.assertEquals((Object)ImmutableList.of((Object)this.defaultSegment.getId().toString(), (Object)this.defaultSegment2.getId().toString()), this.retrieveUsedSegmentIds((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()));
        Assert.assertEquals((long)0L, (long)this.metadataUpdateCounter.get());
    }

    @Test
    public void testAnnounceHistoricalSegments() throws IOException {
        HashSet<DataSegment> segments = new HashSet<DataSegment>();
        for (int i = 0; i < 105; ++i) {
            DataSegment segment2 = new DataSegment("fooDataSource", Intervals.of((String)"2015-01-01T00Z/2015-01-02T00Z"), "version", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new LinearShardSpec(Integer.valueOf(i)), Integer.valueOf(9), 100L);
            segments.add(segment2);
        }
        this.coordinator.commitSegments(segments, null);
        for (DataSegment segment2 : segments) {
            Assert.assertArrayEquals((byte[])this.mapper.writeValueAsString((Object)segment2).getBytes(StandardCharsets.UTF_8), (byte[])this.derbyConnector.lookup(((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getSegmentsTable(), "id", "payload", segment2.getId().toString()));
        }
        List segmentIds = segments.stream().map(segment -> segment.getId().toString()).sorted(Comparator.naturalOrder()).collect(Collectors.toList());
        Assert.assertEquals(segmentIds, this.retrieveUsedSegmentIds((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()));
        Assert.assertEquals((long)0L, (long)this.metadataUpdateCounter.get());
    }

    @Test
    public void testOvershadowingAnnounce() throws IOException {
        ImmutableSet segments = ImmutableSet.of((Object)this.defaultSegment, (Object)this.defaultSegment2, (Object)this.defaultSegment4);
        this.coordinator.commitSegments((Set)segments, new SegmentSchemaMapping(1));
        for (DataSegment segment : segments) {
            Assert.assertArrayEquals((byte[])this.mapper.writeValueAsString((Object)segment).getBytes(StandardCharsets.UTF_8), (byte[])this.derbyConnector.lookup(((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getSegmentsTable(), "id", "payload", segment.getId().toString()));
        }
        Assert.assertEquals((Object)ImmutableList.of((Object)this.defaultSegment4.getId().toString()), this.retrieveUsedSegmentIds((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()));
    }

    @Test
    public void testTransactionalAnnounceSuccess() throws IOException {
        SegmentPublishResult result1 = this.coordinator.commitSegmentsAndMetadata((Set)ImmutableSet.of((Object)this.defaultSegment), (DataSourceMetadata)new ObjectMetadata(null), (DataSourceMetadata)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"bar")), new SegmentSchemaMapping(1));
        Assert.assertEquals((Object)SegmentPublishResult.ok((Set)ImmutableSet.of((Object)this.defaultSegment)), (Object)result1);
        Assert.assertArrayEquals((byte[])this.mapper.writeValueAsString((Object)this.defaultSegment).getBytes(StandardCharsets.UTF_8), (byte[])this.derbyConnector.lookup(((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getSegmentsTable(), "id", "payload", this.defaultSegment.getId().toString()));
        SegmentPublishResult result2 = this.coordinator.commitSegmentsAndMetadata((Set)ImmutableSet.of((Object)this.defaultSegment2), (DataSourceMetadata)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"bar")), (DataSourceMetadata)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"baz")), new SegmentSchemaMapping(1));
        Assert.assertEquals((Object)SegmentPublishResult.ok((Set)ImmutableSet.of((Object)this.defaultSegment2)), (Object)result2);
        Assert.assertArrayEquals((byte[])this.mapper.writeValueAsString((Object)this.defaultSegment2).getBytes(StandardCharsets.UTF_8), (byte[])this.derbyConnector.lookup(((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getSegmentsTable(), "id", "payload", this.defaultSegment2.getId().toString()));
        Assert.assertEquals((Object)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"baz")), (Object)this.coordinator.retrieveDataSourceMetadata("fooDataSource"));
        Assert.assertEquals((long)2L, (long)this.metadataUpdateCounter.get());
    }

    @Test
    public void testTransactionalAnnounceRetryAndSuccess() throws IOException {
        final AtomicLong attemptCounter = new AtomicLong();
        IndexerSQLMetadataStorageCoordinator failOnceCoordinator = new IndexerSQLMetadataStorageCoordinator((SegmentMetadataTransactionFactory)this.transactionFactory, this.mapper, (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get(), (SQLMetadataConnector)this.derbyConnector, this.segmentSchemaManager, CentralizedDatasourceSchemaConfig.create()){

            protected SegmentPublishResult updateDataSourceMetadataWithHandle(SegmentMetadataTransaction transaction, String dataSource, DataSourceMetadata startMetadata, DataSourceMetadata endMetadata) throws IOException {
                IndexerSQLMetadataStorageCoordinatorTest.this.metadataUpdateCounter.getAndIncrement();
                if (attemptCounter.getAndIncrement() == 0L) {
                    return SegmentPublishResult.retryableFailure((String)"this failure can be retried", (Object[])new Object[0]);
                }
                return super.updateDataSourceMetadataWithHandle(transaction, dataSource, startMetadata, endMetadata);
            }
        };
        SegmentPublishResult result1 = failOnceCoordinator.commitSegmentsAndMetadata((Set)ImmutableSet.of((Object)this.defaultSegment), (DataSourceMetadata)new ObjectMetadata(null), (DataSourceMetadata)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"bar")), new SegmentSchemaMapping(1));
        Assert.assertEquals((Object)SegmentPublishResult.retryableFailure((String)"this failure can be retried", (Object[])new Object[0]), (Object)result1);
        SegmentPublishResult resultOnRetry = failOnceCoordinator.commitSegmentsAndMetadata((Set)ImmutableSet.of((Object)this.defaultSegment), (DataSourceMetadata)new ObjectMetadata(null), (DataSourceMetadata)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"bar")), new SegmentSchemaMapping(1));
        Assert.assertEquals((Object)SegmentPublishResult.ok((Set)ImmutableSet.of((Object)this.defaultSegment)), (Object)resultOnRetry);
        Assert.assertArrayEquals((byte[])this.mapper.writeValueAsString((Object)this.defaultSegment).getBytes(StandardCharsets.UTF_8), (byte[])this.derbyConnector.lookup(((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getSegmentsTable(), "id", "payload", this.defaultSegment.getId().toString()));
        attemptCounter.set(0L);
        SegmentPublishResult result2 = failOnceCoordinator.commitSegmentsAndMetadata((Set)ImmutableSet.of((Object)this.defaultSegment2), (DataSourceMetadata)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"bar")), (DataSourceMetadata)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"baz")), new SegmentSchemaMapping(1));
        Assert.assertEquals((Object)SegmentPublishResult.retryableFailure((String)"this failure can be retried", (Object[])new Object[0]), (Object)result2);
        SegmentPublishResult resultOnRetry2 = failOnceCoordinator.commitSegmentsAndMetadata((Set)ImmutableSet.of((Object)this.defaultSegment2), (DataSourceMetadata)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"bar")), (DataSourceMetadata)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"baz")), new SegmentSchemaMapping(1));
        Assert.assertEquals((Object)SegmentPublishResult.ok((Set)ImmutableSet.of((Object)this.defaultSegment2)), (Object)resultOnRetry2);
        Assert.assertArrayEquals((byte[])this.mapper.writeValueAsString((Object)this.defaultSegment2).getBytes(StandardCharsets.UTF_8), (byte[])this.derbyConnector.lookup(((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getSegmentsTable(), "id", "payload", this.defaultSegment2.getId().toString()));
        Assert.assertEquals((Object)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"baz")), (Object)failOnceCoordinator.retrieveDataSourceMetadata("fooDataSource"));
        Assert.assertEquals((long)4L, (long)this.metadataUpdateCounter.get());
    }

    @Test
    public void testTransactionalAnnounceFailDbNullWantNotNull() {
        SegmentPublishResult result1 = this.coordinator.commitSegmentsAndMetadata((Set)ImmutableSet.of((Object)this.defaultSegment), (DataSourceMetadata)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"bar")), (DataSourceMetadata)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"baz")), new SegmentSchemaMapping(1));
        Assert.assertEquals((Object)SegmentPublishResult.retryableFailure((String)"The new start metadata state[ObjectMetadata{theObject={foo=bar}}] is ahead of the last committed end state[null]. Try resetting the supervisor.", (Object[])new Object[0]), (Object)result1);
        Assert.assertEquals((long)1L, (long)this.metadataUpdateCounter.get());
    }

    @Test
    public void testTransactionalAnnounceFailDbNotNullWantNull() {
        SegmentPublishResult result1 = this.coordinator.commitSegmentsAndMetadata((Set)ImmutableSet.of((Object)this.defaultSegment), (DataSourceMetadata)new ObjectMetadata(null), (DataSourceMetadata)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"baz")), new SegmentSchemaMapping(1));
        Assert.assertEquals((Object)SegmentPublishResult.ok((Set)ImmutableSet.of((Object)this.defaultSegment)), (Object)result1);
        SegmentPublishResult result2 = this.coordinator.commitSegmentsAndMetadata((Set)ImmutableSet.of((Object)this.defaultSegment2), (DataSourceMetadata)new ObjectMetadata(null), (DataSourceMetadata)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"baz")), new SegmentSchemaMapping(1));
        Assert.assertEquals((Object)SegmentPublishResult.fail((String)"Inconsistency between stored metadata state[ObjectMetadata{theObject={foo=baz}}] and target state[ObjectMetadata{theObject=null}]. Try resetting the supervisor.", (Object[])new Object[0]), (Object)result2);
        Assert.assertEquals((long)2L, (long)this.metadataUpdateCounter.get());
    }

    @Test
    public void testRetrieveUsedSegmentForId() {
        this.coordinator.commitSegments(Set.of(this.defaultSegment), null);
        Assert.assertEquals((Object)this.defaultSegment, (Object)this.coordinator.retrieveUsedSegmentForId(this.defaultSegment.getDataSource(), this.defaultSegment.getId().toString()));
    }

    @Test
    public void testRetrieveSegmentForId() {
        this.coordinator.commitSegments(Set.of(this.defaultSegment), null);
        this.markAllSegmentsUnused((Set<DataSegment>)ImmutableSet.of((Object)this.defaultSegment), DateTimes.nowUtc());
        Assert.assertEquals((Object)this.defaultSegment, (Object)this.coordinator.retrieveSegmentForId(this.defaultSegment.getDataSource(), this.defaultSegment.getId().toString()));
    }

    @Test
    public void testCleanUpgradeSegmentsTableForTask() {
        Assume.assumeFalse((boolean)this.isCacheEnabled());
        String taskToClean = "taskToClean";
        ReplaceTaskLock replaceLockToClean = new ReplaceTaskLock("taskToClean", Intervals.of((String)"2023-01-01/2023-02-01"), "2023-03-01");
        DataSegment segmentToClean0 = this.createSegment(Intervals.of((String)"2023-01-01/2023-02-01"), "2023-02-01", (ShardSpec)new NumberedShardSpec(0, 0));
        DataSegment segmentToClean1 = this.createSegment(Intervals.of((String)"2023-01-01/2023-01-02"), "2023-01-02", (ShardSpec)new NumberedShardSpec(0, 0));
        this.insertIntoUpgradeSegmentsTable((Map<DataSegment, ReplaceTaskLock>)ImmutableMap.of((Object)segmentToClean0, (Object)replaceLockToClean, (Object)segmentToClean1, (Object)replaceLockToClean), (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get());
        Assert.assertEquals((long)0L, (long)this.coordinator.deleteUpgradeSegmentsForTask("someRandomTask"));
        Assert.assertEquals((long)2L, (long)this.coordinator.deleteUpgradeSegmentsForTask("taskToClean"));
        Assert.assertEquals((long)0L, (long)this.coordinator.deleteUpgradeSegmentsForTask("taskToClean"));
    }

    @Test
    public void testTransactionalAnnounceFailDbNotNullWantDifferent() {
        SegmentPublishResult result1 = this.coordinator.commitSegmentsAndMetadata((Set)ImmutableSet.of((Object)this.defaultSegment), (DataSourceMetadata)new ObjectMetadata(null), (DataSourceMetadata)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"baz")), new SegmentSchemaMapping(1));
        Assert.assertEquals((Object)SegmentPublishResult.ok((Set)ImmutableSet.of((Object)this.defaultSegment)), (Object)result1);
        SegmentPublishResult result2 = this.coordinator.commitSegmentsAndMetadata((Set)ImmutableSet.of((Object)this.defaultSegment2), (DataSourceMetadata)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"qux")), (DataSourceMetadata)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"baz")), new SegmentSchemaMapping(1));
        Assert.assertEquals((Object)SegmentPublishResult.fail((String)"Inconsistency between stored metadata state[ObjectMetadata{theObject={foo=baz}}] and target state[ObjectMetadata{theObject={foo=qux}}]. Try resetting the supervisor.", (Object[])new Object[0]), (Object)result2);
        Assert.assertEquals((long)2L, (long)this.metadataUpdateCounter.get());
    }

    @Test
    public void testSimpleUsedList() {
        this.coordinator.commitSegments(this.SEGMENTS, new SegmentSchemaMapping(1));
        Assert.assertEquals((Object)this.SEGMENTS, (Object)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUsedSegmentsForInterval(this.defaultSegment.getDataSource(), this.defaultSegment.getInterval(), Segments.ONLY_VISIBLE)));
    }

    @Test
    public void testMultiIntervalUsedList() {
        this.coordinator.commitSegments(this.SEGMENTS, new SegmentSchemaMapping(1));
        this.coordinator.commitSegments((Set)ImmutableSet.of((Object)this.defaultSegment3), new SegmentSchemaMapping(1));
        Assertions.assertThat((Collection)this.coordinator.retrieveUsedSegmentsForIntervals(this.defaultSegment.getDataSource(), (List)ImmutableList.of((Object)this.defaultSegment.getInterval()), Segments.ONLY_VISIBLE)).containsOnlyOnce((Object[])this.SEGMENTS.toArray(new DataSegment[0]));
        Assertions.assertThat((Collection)this.coordinator.retrieveUsedSegmentsForIntervals(this.defaultSegment.getDataSource(), (List)ImmutableList.of((Object)this.defaultSegment3.getInterval()), Segments.ONLY_VISIBLE)).containsOnlyOnce((Object[])new DataSegment[]{this.defaultSegment3});
        Assertions.assertThat((Collection)this.coordinator.retrieveUsedSegmentsForIntervals(this.defaultSegment.getDataSource(), (List)ImmutableList.of((Object)this.defaultSegment.getInterval(), (Object)this.defaultSegment3.getInterval()), Segments.ONLY_VISIBLE)).containsOnlyOnce((Object[])new DataSegment[]{this.defaultSegment, this.defaultSegment2, this.defaultSegment3});
        Assertions.assertThat((Collection)this.coordinator.retrieveUsedSegmentsForIntervals(this.defaultSegment.getDataSource(), (List)ImmutableList.of((Object)Intervals.of((String)"2015-01-03T00Z/2015-01-03T05Z"), (Object)Intervals.of((String)"2015-01-03T09Z/2015-01-04T00Z")), Segments.ONLY_VISIBLE)).containsOnlyOnce((Object[])new DataSegment[]{this.defaultSegment3});
    }

    @Test
    public void testRetrieveUsedSegmentsUsingMultipleIntervals() {
        List<DataSegment> segments = this.createAndGetUsedYearSegments(1900, 2133);
        List intervals = segments.stream().map(DataSegment::getInterval).collect(Collectors.toList());
        Set actualUsedSegments = this.coordinator.retrieveUsedSegmentsForIntervals("wiki", intervals, Segments.ONLY_VISIBLE);
        Assert.assertEquals((long)segments.size(), (long)actualUsedSegments.size());
        Assert.assertTrue((boolean)actualUsedSegments.containsAll(segments));
    }

    @Test
    public void testRetrieveAllUsedSegmentsUsingIntervalsOutOfRange() {
        List<DataSegment> segments = this.createAndGetUsedYearSegments(1905, 1910);
        Interval outOfRangeInterval = Intervals.of((String)"1700/1800");
        Assert.assertTrue((boolean)segments.stream().anyMatch(segment -> !segment.getInterval().overlaps((ReadableInterval)outOfRangeInterval)));
        Set actualUsedSegments = this.coordinator.retrieveUsedSegmentsForIntervals("wiki", (List)ImmutableList.of((Object)outOfRangeInterval), Segments.ONLY_VISIBLE);
        Assert.assertEquals((long)0L, (long)actualUsedSegments.size());
    }

    @Test
    public void testRetrieveAllUsedSegmentsUsingNoIntervals() {
        List<DataSegment> segments = this.createAndGetUsedYearSegments(1900, 2133);
        Set actualUsedSegments = this.coordinator.retrieveAllUsedSegments("wiki", Segments.ONLY_VISIBLE);
        Assert.assertEquals((long)segments.size(), (long)actualUsedSegments.size());
        Assert.assertTrue((boolean)actualUsedSegments.containsAll(segments));
    }

    @Test
    public void testRetrieveUnusedSegmentsUsingSingleIntervalAndNoLimit() {
        List<DataSegment> segments = this.createAndGetUsedYearSegments(1900, 2133);
        this.markAllSegmentsUnused(new HashSet<DataSegment>(segments), DateTimes.nowUtc());
        List actualUnusedSegments = this.coordinator.retrieveUnusedSegmentsForInterval("wiki", Intervals.of((String)"1900/3000"), null, null);
        Assert.assertEquals((long)segments.size(), (long)actualUnusedSegments.size());
        Assert.assertTrue((boolean)actualUnusedSegments.containsAll(segments));
    }

    @Test
    public void testRetrieveUnusedSegmentsUsingSingleIntervalAndLimitAtRange() {
        List<DataSegment> segments = this.createAndGetUsedYearSegments(1900, 2133);
        this.markAllSegmentsUnused(new HashSet<DataSegment>(segments), DateTimes.nowUtc());
        int requestedLimit = segments.size();
        List actualUnusedSegments = this.coordinator.retrieveUnusedSegmentsForInterval("wiki", Intervals.of((String)"1900/3000"), Integer.valueOf(requestedLimit), null);
        Assert.assertEquals((long)requestedLimit, (long)actualUnusedSegments.size());
        Assert.assertTrue((boolean)actualUnusedSegments.containsAll(segments));
    }

    @Test
    public void testRetrieveUnusedSegmentsUsingSingleIntervalAndLimitInRange() {
        List<DataSegment> segments = this.createAndGetUsedYearSegments(1900, 2133);
        this.markAllSegmentsUnused(new HashSet<DataSegment>(segments), DateTimes.nowUtc());
        int requestedLimit = segments.size() - 1;
        List actualUnusedSegments = this.coordinator.retrieveUnusedSegmentsForInterval("wiki", Intervals.of((String)"1900/3000"), Integer.valueOf(requestedLimit), null);
        Assert.assertEquals((long)requestedLimit, (long)actualUnusedSegments.size());
        Assert.assertTrue((boolean)actualUnusedSegments.containsAll(segments.stream().limit(requestedLimit).collect(Collectors.toList())));
    }

    @Test
    public void testRetrieveUnusedSegmentsUsingSingleIntervalAndLimitOutOfRange() {
        List<DataSegment> segments = this.createAndGetUsedYearSegments(1900, 2133);
        this.markAllSegmentsUnused(new HashSet<DataSegment>(segments), DateTimes.nowUtc());
        int limit = segments.size() + 1;
        List actualUnusedSegments = this.coordinator.retrieveUnusedSegmentsForInterval("wiki", Intervals.of((String)"1900/3000"), Integer.valueOf(limit), null);
        Assert.assertEquals((long)segments.size(), (long)actualUnusedSegments.size());
        Assert.assertTrue((boolean)actualUnusedSegments.containsAll(segments));
    }

    @Test
    public void testRetrieveUnusedSegmentsUsingSingleIntervalOutOfRange() {
        List<DataSegment> segments = this.createAndGetUsedYearSegments(1905, 1910);
        this.markAllSegmentsUnused(new HashSet<DataSegment>(segments), DateTimes.nowUtc());
        Interval outOfRangeInterval = Intervals.of((String)"1700/1800");
        Assert.assertTrue((boolean)segments.stream().anyMatch(segment -> !segment.getInterval().overlaps((ReadableInterval)outOfRangeInterval)));
        int limit = segments.size() + 1;
        List actualUnusedSegments = this.coordinator.retrieveUnusedSegmentsForInterval("wiki", outOfRangeInterval, Integer.valueOf(limit), null);
        Assert.assertEquals((long)0L, (long)actualUnusedSegments.size());
    }

    @Test
    public void testRetrieveUnusedSegmentsUsingMultipleIntervalsAndNoLimit() {
        List<DataSegment> segments = this.createAndGetUsedYearSegments(1900, 2133);
        DateTime usedStatusLastUpdatedTime = DateTimes.nowUtc();
        this.markAllSegmentsUnused(new HashSet<DataSegment>(segments), usedStatusLastUpdatedTime);
        ImmutableList<DataSegment> actualUnusedSegments = this.retrieveUnusedSegments(segments.stream().map(DataSegment::getInterval).collect(Collectors.toList()), null, null, null, null, (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get());
        Assert.assertEquals((long)segments.size(), (long)actualUnusedSegments.size());
        Assert.assertTrue((boolean)segments.containsAll((Collection<?>)actualUnusedSegments));
        ImmutableList<DataSegmentPlus> actualUnusedSegmentsPlus = this.retrieveUnusedSegmentsPlus(segments.stream().map(DataSegment::getInterval).collect(Collectors.toList()), null, null, null, null, (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get());
        Assert.assertEquals((long)segments.size(), (long)actualUnusedSegmentsPlus.size());
        this.verifyContainsAllSegmentsPlus(segments, (List<DataSegmentPlus>)actualUnusedSegmentsPlus, usedStatusLastUpdatedTime);
    }

    @Test
    public void testRetrieveUnusedSegmentsUsingNoIntervalsNoLimitAndNoLastSegmentId() {
        List<DataSegment> segments = this.createAndGetUsedYearSegments(1900, 2133);
        DateTime usedStatusLastUpdatedTime = DateTimes.nowUtc();
        this.markAllSegmentsUnused(new HashSet<DataSegment>(segments), usedStatusLastUpdatedTime);
        ImmutableList<DataSegment> actualUnusedSegments = this.retrieveUnusedSegments((List<Interval>)ImmutableList.of(), null, null, null, null, (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get());
        Assert.assertEquals((long)segments.size(), (long)actualUnusedSegments.size());
        Assert.assertTrue((boolean)segments.containsAll((Collection<?>)actualUnusedSegments));
        ImmutableList<DataSegmentPlus> actualUnusedSegmentsPlus = this.retrieveUnusedSegmentsPlus((List<Interval>)ImmutableList.of(), null, null, null, null, (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get());
        Assert.assertEquals((long)segments.size(), (long)actualUnusedSegmentsPlus.size());
        this.verifyContainsAllSegmentsPlus(segments, (List<DataSegmentPlus>)actualUnusedSegmentsPlus, usedStatusLastUpdatedTime);
    }

    @Test
    public void testRetrieveUnusedSegmentsUsingNoIntervalsAndNoLimitAndNoLastSegmentId() {
        List<DataSegment> segments = this.createAndGetUsedYearSegments(2033, 2133);
        DateTime usedStatusLastUpdatedTime = DateTimes.nowUtc();
        this.markAllSegmentsUnused(new HashSet<DataSegment>(segments), usedStatusLastUpdatedTime);
        String lastSegmentId = segments.get(9).getId().toString();
        List<DataSegment> expectedSegmentsAscOrder = segments.stream().filter(s -> s.getId().toString().compareTo(lastSegmentId) > 0).collect(Collectors.toList());
        ImmutableList<DataSegment> actualUnusedSegments = this.retrieveUnusedSegments((List<Interval>)ImmutableList.of(), null, lastSegmentId, null, null, (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get());
        Assert.assertEquals((long)expectedSegmentsAscOrder.size(), (long)actualUnusedSegments.size());
        Assert.assertTrue((boolean)expectedSegmentsAscOrder.containsAll((Collection<?>)actualUnusedSegments));
        ImmutableList<DataSegmentPlus> actualUnusedSegmentsPlus = this.retrieveUnusedSegmentsPlus((List<Interval>)ImmutableList.of(), null, lastSegmentId, null, null, (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get());
        Assert.assertEquals((long)expectedSegmentsAscOrder.size(), (long)actualUnusedSegmentsPlus.size());
        this.verifyContainsAllSegmentsPlus(expectedSegmentsAscOrder, (List<DataSegmentPlus>)actualUnusedSegmentsPlus, usedStatusLastUpdatedTime);
        actualUnusedSegments = this.retrieveUnusedSegments((List<Interval>)ImmutableList.of(), null, lastSegmentId, SortOrder.ASC, null, (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get());
        Assert.assertEquals((long)expectedSegmentsAscOrder.size(), (long)actualUnusedSegments.size());
        Assert.assertEquals(expectedSegmentsAscOrder, actualUnusedSegments);
        actualUnusedSegmentsPlus = this.retrieveUnusedSegmentsPlus((List<Interval>)ImmutableList.of(), null, lastSegmentId, SortOrder.ASC, null, (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get());
        Assert.assertEquals((long)expectedSegmentsAscOrder.size(), (long)actualUnusedSegmentsPlus.size());
        this.verifyEqualsAllSegmentsPlus(expectedSegmentsAscOrder, (List<DataSegmentPlus>)actualUnusedSegmentsPlus, usedStatusLastUpdatedTime);
        List<DataSegment> expectedSegmentsDescOrder = segments.stream().filter(s -> s.getId().toString().compareTo(lastSegmentId) < 0).collect(Collectors.toList());
        Collections.reverse(expectedSegmentsDescOrder);
        actualUnusedSegments = this.retrieveUnusedSegments((List<Interval>)ImmutableList.of(), null, lastSegmentId, SortOrder.DESC, null, (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get());
        Assert.assertEquals((long)expectedSegmentsDescOrder.size(), (long)actualUnusedSegments.size());
        Assert.assertEquals(expectedSegmentsDescOrder, actualUnusedSegments);
        actualUnusedSegmentsPlus = this.retrieveUnusedSegmentsPlus((List<Interval>)ImmutableList.of(), null, lastSegmentId, SortOrder.DESC, null, (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get());
        Assert.assertEquals((long)expectedSegmentsDescOrder.size(), (long)actualUnusedSegmentsPlus.size());
        this.verifyEqualsAllSegmentsPlus(expectedSegmentsDescOrder, (List<DataSegmentPlus>)actualUnusedSegmentsPlus, usedStatusLastUpdatedTime);
    }

    @Test
    public void testRetrieveUnusedSegmentsUsingMultipleIntervalsAndLimitAtRange() {
        List<DataSegment> segments = this.createAndGetUsedYearSegments(1900, 2133);
        DateTime usedStatusLastUpdatedTime = DateTimes.nowUtc();
        this.markAllSegmentsUnused(new HashSet<DataSegment>(segments), usedStatusLastUpdatedTime);
        ImmutableList<DataSegment> actualUnusedSegments = this.retrieveUnusedSegments(segments.stream().map(DataSegment::getInterval).collect(Collectors.toList()), segments.size(), null, null, null, (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get());
        Assert.assertEquals((long)segments.size(), (long)actualUnusedSegments.size());
        Assert.assertTrue((boolean)segments.containsAll((Collection<?>)actualUnusedSegments));
        ImmutableList<DataSegmentPlus> actualUnusedSegmentsPlus = this.retrieveUnusedSegmentsPlus((List<Interval>)ImmutableList.of(), segments.size(), null, null, null, (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get());
        Assert.assertEquals((long)segments.size(), (long)actualUnusedSegmentsPlus.size());
        this.verifyContainsAllSegmentsPlus(segments, (List<DataSegmentPlus>)actualUnusedSegmentsPlus, usedStatusLastUpdatedTime);
    }

    @Test
    public void testRetrieveUnusedSegmentsUsingMultipleIntervalsAndLimitInRange() {
        List<DataSegment> segments = this.createAndGetUsedYearSegments(1900, 2133);
        DateTime usedStatusLastUpdatedTime = DateTimes.nowUtc();
        this.markAllSegmentsUnused(new HashSet<DataSegment>(segments), usedStatusLastUpdatedTime);
        int requestedLimit = segments.size() - 1;
        ImmutableList<DataSegment> actualUnusedSegments = this.retrieveUnusedSegments(segments.stream().map(DataSegment::getInterval).collect(Collectors.toList()), requestedLimit, null, null, null, (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get());
        List<DataSegment> expectedSegments = segments.stream().limit(requestedLimit).collect(Collectors.toList());
        Assert.assertEquals((long)requestedLimit, (long)actualUnusedSegments.size());
        Assert.assertTrue((boolean)actualUnusedSegments.containsAll(expectedSegments));
        ImmutableList<DataSegmentPlus> actualUnusedSegmentsPlus = this.retrieveUnusedSegmentsPlus((List<Interval>)ImmutableList.of(), requestedLimit, null, null, null, (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get());
        Assert.assertEquals((long)requestedLimit, (long)actualUnusedSegmentsPlus.size());
        this.verifyContainsAllSegmentsPlus(expectedSegments, (List<DataSegmentPlus>)actualUnusedSegmentsPlus, usedStatusLastUpdatedTime);
    }

    @Test
    public void testRetrieveUnusedSegmentsUsingMultipleIntervalsInSingleBatchLimitAndLastSegmentId() {
        List<DataSegment> segments = this.createAndGetUsedYearSegments(2034, 2133);
        DateTime usedStatusLastUpdatedTime = DateTimes.nowUtc();
        this.markAllSegmentsUnused(new HashSet<DataSegment>(segments), usedStatusLastUpdatedTime);
        int requestedLimit = segments.size();
        String lastSegmentId = segments.get(4).getId().toString();
        List<DataSegment> expectedSegments = segments.stream().filter(s -> s.getId().toString().compareTo(lastSegmentId) > 0).limit(requestedLimit).collect(Collectors.toList());
        ImmutableList<DataSegment> actualUnusedSegments = this.retrieveUnusedSegments(segments.stream().map(DataSegment::getInterval).collect(Collectors.toList()), requestedLimit, lastSegmentId, null, null, (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get());
        Assert.assertEquals((long)(segments.size() - 5), (long)actualUnusedSegments.size());
        Assert.assertEquals(actualUnusedSegments, expectedSegments);
        ImmutableList<DataSegmentPlus> actualUnusedSegmentsPlus = this.retrieveUnusedSegmentsPlus((List<Interval>)ImmutableList.of(), requestedLimit, lastSegmentId, null, null, (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get());
        Assert.assertEquals((long)(segments.size() - 5), (long)actualUnusedSegmentsPlus.size());
        this.verifyEqualsAllSegmentsPlus(expectedSegments, (List<DataSegmentPlus>)actualUnusedSegmentsPlus, usedStatusLastUpdatedTime);
    }

    @Test
    public void testRetrieveUnusedSegmentsUsingMultipleIntervalsLimitAndLastSegmentId() {
        List<DataSegment> segments = this.createAndGetUsedYearSegments(1900, 2133);
        DateTime usedStatusLastUpdatedTime = DateTimes.nowUtc();
        this.markAllSegmentsUnused(new HashSet<DataSegment>(segments), usedStatusLastUpdatedTime);
        int requestedLimit = segments.size() - 1;
        String lastSegmentId = segments.get(4).getId().toString();
        List<DataSegment> expectedSegments = segments.stream().filter(s -> s.getId().toString().compareTo(lastSegmentId) > 0).limit(requestedLimit).collect(Collectors.toList());
        ImmutableList<DataSegment> actualUnusedSegments = this.retrieveUnusedSegments(segments.stream().map(DataSegment::getInterval).collect(Collectors.toList()), requestedLimit, lastSegmentId, null, null, (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get());
        Assert.assertEquals((long)(requestedLimit - 4), (long)actualUnusedSegments.size());
        Assert.assertEquals(actualUnusedSegments, expectedSegments);
        ImmutableList<DataSegmentPlus> actualUnusedSegmentsPlus = this.retrieveUnusedSegmentsPlus(segments.stream().map(DataSegment::getInterval).collect(Collectors.toList()), requestedLimit, lastSegmentId, null, null, (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get());
        Assert.assertEquals((long)(requestedLimit - 4), (long)actualUnusedSegmentsPlus.size());
        this.verifyEqualsAllSegmentsPlus(expectedSegments, (List<DataSegmentPlus>)actualUnusedSegmentsPlus, usedStatusLastUpdatedTime);
    }

    @Test
    public void testRetrieveUnusedSegmentsUsingMultipleIntervals() {
        List<DataSegment> segments = this.createAndGetUsedYearSegments(1900, 2133);
        DateTime usedStatusLastUpdatedTime = DateTimes.nowUtc();
        this.markAllSegmentsUnused(new HashSet<DataSegment>(segments), usedStatusLastUpdatedTime);
        ImmutableList<DataSegment> actualUnusedSegments = this.retrieveUnusedSegments(segments.stream().map(DataSegment::getInterval).collect(Collectors.toList()), segments.size() + 1, null, null, null, (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get());
        Assert.assertEquals((long)segments.size(), (long)actualUnusedSegments.size());
        Assert.assertTrue((boolean)actualUnusedSegments.containsAll(segments));
        ImmutableList<DataSegmentPlus> actualUnusedSegmentsPlus = this.retrieveUnusedSegmentsPlus(segments.stream().map(DataSegment::getInterval).collect(Collectors.toList()), segments.size() + 1, null, null, null, (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get());
        Assert.assertEquals((long)segments.size(), (long)actualUnusedSegmentsPlus.size());
        this.verifyContainsAllSegmentsPlus(segments, (List<DataSegmentPlus>)actualUnusedSegmentsPlus, usedStatusLastUpdatedTime);
    }

    @Test
    public void testRetrieveUnusedSegmentsUsingIntervalOutOfRange() {
        List<DataSegment> segments = this.createAndGetUsedYearSegments(1905, 1910);
        this.markAllSegmentsUnused(new HashSet<DataSegment>(segments), DateTimes.nowUtc());
        Interval outOfRangeInterval = Intervals.of((String)"1700/1800");
        Assert.assertTrue((boolean)segments.stream().anyMatch(segment -> !segment.getInterval().overlaps((ReadableInterval)outOfRangeInterval)));
        ImmutableList<DataSegment> actualUnusedSegments = this.retrieveUnusedSegments((List<Interval>)ImmutableList.of((Object)outOfRangeInterval), null, null, null, null, (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get());
        Assert.assertEquals((long)0L, (long)actualUnusedSegments.size());
        ImmutableList<DataSegmentPlus> actualUnusedSegmentsPlus = this.retrieveUnusedSegmentsPlus((List<Interval>)ImmutableList.of((Object)outOfRangeInterval), null, null, null, null, (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get());
        Assert.assertEquals((long)0L, (long)actualUnusedSegmentsPlus.size());
    }

    @Test
    public void testRetrieveUnusedSegmentsWithMaxUsedStatusLastUpdatedTime() {
        List<DataSegment> segments = this.createAndGetUsedYearSegments(1905, 1910);
        DateTime usedStatusLastUpdatedTime = DateTimes.nowUtc();
        this.markAllSegmentsUnused(new HashSet<DataSegment>(segments), usedStatusLastUpdatedTime);
        Interval interval = Intervals.of((String)"1905/1920");
        ImmutableList<DataSegment> actualUnusedSegments1 = this.retrieveUnusedSegments((List<Interval>)ImmutableList.of((Object)interval), null, null, null, DateTimes.nowUtc(), (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get());
        Assert.assertEquals((long)5L, (long)actualUnusedSegments1.size());
        ImmutableList<DataSegmentPlus> actualUnusedSegmentsPlus = this.retrieveUnusedSegmentsPlus((List<Interval>)ImmutableList.of((Object)interval), null, null, null, DateTimes.nowUtc(), (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get());
        Assert.assertEquals((long)5L, (long)actualUnusedSegmentsPlus.size());
        ImmutableList<DataSegment> actualUnusedSegments2 = this.retrieveUnusedSegments((List<Interval>)ImmutableList.of((Object)interval), null, null, null, DateTimes.nowUtc().minusHours(1), (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get());
        Assert.assertEquals((long)0L, (long)actualUnusedSegments2.size());
        actualUnusedSegmentsPlus = this.retrieveUnusedSegmentsPlus((List<Interval>)ImmutableList.of((Object)interval), null, null, null, DateTimes.nowUtc().minusHours(1), (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get());
        Assert.assertEquals((long)0L, (long)actualUnusedSegmentsPlus.size());
    }

    @Test
    public void testRetrieveUnusedSegmentsWithMaxUsedStatusLastUpdatedTime2() {
        List<DataSegment> segments = this.createAndGetUsedYearSegments(1900, 1950);
        ArrayList<DataSegment> evenYearSegments = new ArrayList<DataSegment>();
        ArrayList<DataSegment> oddYearSegments = new ArrayList<DataSegment>();
        for (int i = 0; i < segments.size(); ++i) {
            DataSegment dataSegment = segments.get(i);
            if (i % 2 == 0) {
                evenYearSegments.add(dataSegment);
                continue;
            }
            oddYearSegments.add(dataSegment);
        }
        DateTime maxUsedStatusLastUpdatedTime1 = DateTimes.nowUtc();
        this.markAllSegmentsUnused(new HashSet<DataSegment>(oddYearSegments), maxUsedStatusLastUpdatedTime1);
        DateTime maxUsedStatusLastUpdatedTime2 = DateTimes.nowUtc();
        this.markAllSegmentsUnused(new HashSet<DataSegment>(evenYearSegments), maxUsedStatusLastUpdatedTime2);
        Interval interval = Intervals.of((String)"1900/1950");
        ImmutableList<DataSegment> actualUnusedSegments1 = this.retrieveUnusedSegments((List<Interval>)ImmutableList.of((Object)interval), null, null, null, maxUsedStatusLastUpdatedTime1, (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get());
        Assert.assertEquals((long)oddYearSegments.size(), (long)actualUnusedSegments1.size());
        ImmutableList<DataSegmentPlus> actualUnusedSegmentsPlus1 = this.retrieveUnusedSegmentsPlus((List<Interval>)ImmutableList.of((Object)interval), null, null, null, maxUsedStatusLastUpdatedTime1, (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get());
        Assert.assertEquals((long)oddYearSegments.size(), (long)actualUnusedSegmentsPlus1.size());
        ImmutableList<DataSegment> actualUnusedSegments2 = this.retrieveUnusedSegments((List<Interval>)ImmutableList.of((Object)interval), null, null, null, maxUsedStatusLastUpdatedTime2, (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get());
        Assert.assertEquals((long)segments.size(), (long)actualUnusedSegments2.size());
        ImmutableList<DataSegmentPlus> actualUnusedSegmentsPlus2 = this.retrieveUnusedSegmentsPlus((List<Interval>)ImmutableList.of((Object)interval), null, null, null, maxUsedStatusLastUpdatedTime2, (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get());
        Assert.assertEquals((long)segments.size(), (long)actualUnusedSegmentsPlus2.size());
    }

    @Test
    public void testSimpleUnusedList() {
        this.coordinator.commitSegments(this.SEGMENTS, new SegmentSchemaMapping(1));
        this.markAllSegmentsUnused();
        Assert.assertEquals((Object)this.SEGMENTS, (Object)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUnusedSegmentsForInterval(this.defaultSegment.getDataSource(), this.defaultSegment.getInterval(), null, null)));
    }

    @Test
    public void testRetrieveUnusedSegmentsWithVersions() {
        DateTime now = DateTimes.nowUtc();
        String v1 = now.toString();
        String v2 = now.plusDays(2).toString();
        String v3 = now.plusDays(3).toString();
        String v4 = now.plusDays(4).toString();
        DataSegment segment1 = this.createSegment(Intervals.of((String)"2023-01-01/2023-01-02"), v1, (ShardSpec)new LinearShardSpec(Integer.valueOf(0)));
        DataSegment segment2 = this.createSegment(Intervals.of((String)"2023-01-02/2023-01-03"), v2, (ShardSpec)new LinearShardSpec(Integer.valueOf(0)));
        DataSegment segment3 = this.createSegment(Intervals.of((String)"2023-01-03/2023-01-04"), v3, (ShardSpec)new LinearShardSpec(Integer.valueOf(0)));
        DataSegment segment4 = this.createSegment(Intervals.of((String)"2023-01-03/2023-01-04"), v4, (ShardSpec)new LinearShardSpec(Integer.valueOf(0)));
        ImmutableSet unusedSegments = ImmutableSet.of((Object)segment1, (Object)segment2, (Object)segment3, (Object)segment4);
        Assert.assertEquals((Object)unusedSegments, (Object)this.coordinator.commitSegments((Set)unusedSegments, null));
        this.markAllSegmentsUnused((Set<DataSegment>)unusedSegments, DateTimes.nowUtc());
        for (DataSegment unusedSegment : unusedSegments) {
            Assertions.assertThat((List)this.coordinator.retrieveUnusedSegmentsForInterval("wiki", Intervals.of((String)"2023-01-01/2023-01-04"), (List)ImmutableList.of((Object)unusedSegment.getVersion()), null, null)).contains((Object[])new DataSegment[]{unusedSegment});
        }
        Assertions.assertThat((List)this.coordinator.retrieveUnusedSegmentsForInterval("wiki", Intervals.of((String)"2023-01-01/2023-01-04"), (List)ImmutableList.of((Object)v1, (Object)v2), null, null)).contains((Object[])new DataSegment[]{segment1, segment2});
        Assertions.assertThat((List)this.coordinator.retrieveUnusedSegmentsForInterval("wiki", Intervals.of((String)"2023-01-01/2023-01-04"), null, null, null)).containsAll((Iterable)unusedSegments);
        Assertions.assertThat((List)this.coordinator.retrieveUnusedSegmentsForInterval("wiki", Intervals.of((String)"2023-01-01/2023-01-04"), (List)ImmutableList.of((Object)"some-non-existent-version"), null, null)).containsAll((Iterable)ImmutableSet.of());
    }

    @Test
    public void testSimpleUnusedListWithLimit() {
        this.coordinator.commitSegments(this.SEGMENTS, new SegmentSchemaMapping(1));
        this.markAllSegmentsUnused();
        int limit = this.SEGMENTS.size() - 1;
        ImmutableSet retreivedUnusedSegments = ImmutableSet.copyOf((Collection)this.coordinator.retrieveUnusedSegmentsForInterval(this.defaultSegment.getDataSource(), this.defaultSegment.getInterval(), null, Integer.valueOf(limit), null));
        Assert.assertEquals((long)limit, (long)retreivedUnusedSegments.size());
        Assert.assertTrue((boolean)this.SEGMENTS.containsAll((Collection<?>)retreivedUnusedSegments));
    }

    @Test
    public void testUsedOverlapLow() {
        this.coordinator.commitSegments(this.SEGMENTS, new SegmentSchemaMapping(1));
        ImmutableSet actualSegments = ImmutableSet.copyOf((Collection)this.coordinator.retrieveUsedSegmentsForInterval(this.defaultSegment.getDataSource(), Intervals.of((String)"2014-12-31T23:59:59.999Z/2015-01-01T00:00:00.001Z"), Segments.ONLY_VISIBLE));
        Assert.assertEquals((Object)this.SEGMENTS, (Object)actualSegments);
    }

    @Test
    public void testUsedOverlapHigh() {
        this.coordinator.commitSegments(this.SEGMENTS, new SegmentSchemaMapping(1));
        Assert.assertEquals((Object)this.SEGMENTS, (Object)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUsedSegmentsForInterval(this.defaultSegment.getDataSource(), Intervals.of((String)"2015-1-1T23:59:59.999Z/2015-02-01T00Z"), Segments.ONLY_VISIBLE)));
    }

    @Test
    public void testUsedOutOfBoundsLow() {
        this.coordinator.commitSegments(this.SEGMENTS, new SegmentSchemaMapping(1));
        Assert.assertTrue((boolean)this.coordinator.retrieveUsedSegmentsForInterval(this.defaultSegment.getDataSource(), new Interval((ReadableInstant)this.defaultSegment.getInterval().getStart().minus(1L), (ReadableInstant)this.defaultSegment.getInterval().getStart()), Segments.ONLY_VISIBLE).isEmpty());
    }

    @Test
    public void testUsedOutOfBoundsHigh() {
        this.coordinator.commitSegments(this.SEGMENTS, new SegmentSchemaMapping(1));
        Assert.assertTrue((boolean)this.coordinator.retrieveUsedSegmentsForInterval(this.defaultSegment.getDataSource(), new Interval((ReadableInstant)this.defaultSegment.getInterval().getEnd(), (ReadableInstant)this.defaultSegment.getInterval().getEnd().plusDays(10)), Segments.ONLY_VISIBLE).isEmpty());
    }

    @Test
    public void testUsedWithinBoundsEnd() {
        this.coordinator.commitSegments(this.SEGMENTS, new SegmentSchemaMapping(1));
        Assert.assertEquals((Object)this.SEGMENTS, (Object)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUsedSegmentsForInterval(this.defaultSegment.getDataSource(), this.defaultSegment.getInterval().withEnd((ReadableInstant)this.defaultSegment.getInterval().getEnd().minusMillis(1)), Segments.ONLY_VISIBLE)));
    }

    @Test
    public void testUsedOverlapEnd() {
        this.coordinator.commitSegments(this.SEGMENTS, new SegmentSchemaMapping(1));
        Assert.assertEquals((Object)this.SEGMENTS, (Object)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUsedSegmentsForInterval(this.defaultSegment.getDataSource(), this.defaultSegment.getInterval().withEnd((ReadableInstant)this.defaultSegment.getInterval().getEnd().plusMillis(1)), Segments.ONLY_VISIBLE)));
    }

    @Test
    public void testUnusedOverlapLow() {
        this.coordinator.commitSegments(this.SEGMENTS, new SegmentSchemaMapping(1));
        this.markAllSegmentsUnused();
        Assert.assertTrue((boolean)this.coordinator.retrieveUnusedSegmentsForInterval(this.defaultSegment.getDataSource(), new Interval((ReadableInstant)this.defaultSegment.getInterval().getStart().minus(1L), (ReadableInstant)this.defaultSegment.getInterval().getStart().plus(1L)), null, null).isEmpty());
    }

    @Test
    public void testUnusedUnderlapLow() {
        this.coordinator.commitSegments(this.SEGMENTS, new SegmentSchemaMapping(1));
        this.markAllSegmentsUnused();
        Assert.assertTrue((boolean)this.coordinator.retrieveUnusedSegmentsForInterval(this.defaultSegment.getDataSource(), new Interval((ReadableInstant)this.defaultSegment.getInterval().getStart().plus(1L), (ReadableInstant)this.defaultSegment.getInterval().getEnd()), null, null).isEmpty());
    }

    @Test
    public void testUnusedUnderlapHigh() {
        this.coordinator.commitSegments(this.SEGMENTS, new SegmentSchemaMapping(1));
        this.markAllSegmentsUnused();
        Assert.assertTrue((boolean)this.coordinator.retrieveUnusedSegmentsForInterval(this.defaultSegment.getDataSource(), new Interval((ReadableInstant)this.defaultSegment.getInterval().getStart(), (ReadableInstant)this.defaultSegment.getInterval().getEnd().minus(1L)), null, null).isEmpty());
    }

    @Test
    public void testUnusedOverlapHigh() {
        this.coordinator.commitSegments(this.SEGMENTS, new SegmentSchemaMapping(1));
        this.markAllSegmentsUnused();
        Assert.assertTrue((boolean)this.coordinator.retrieveUnusedSegmentsForInterval(this.defaultSegment.getDataSource(), this.defaultSegment.getInterval().withStart((ReadableInstant)this.defaultSegment.getInterval().getEnd().minus(1L)), null, null).isEmpty());
    }

    @Test
    public void testUnusedBigOverlap() {
        this.coordinator.commitSegments(this.SEGMENTS, new SegmentSchemaMapping(1));
        this.markAllSegmentsUnused();
        Assert.assertEquals((Object)this.SEGMENTS, (Object)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUnusedSegmentsForInterval(this.defaultSegment.getDataSource(), Intervals.of((String)"2000/2999"), null, null)));
    }

    @Test
    public void testUnusedLowRange() {
        this.coordinator.commitSegments(this.SEGMENTS, new SegmentSchemaMapping(1));
        this.markAllSegmentsUnused();
        Assert.assertEquals((Object)this.SEGMENTS, (Object)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUnusedSegmentsForInterval(this.defaultSegment.getDataSource(), this.defaultSegment.getInterval().withStart((ReadableInstant)this.defaultSegment.getInterval().getStart().minus(1L)), null, null)));
        Assert.assertEquals((Object)this.SEGMENTS, (Object)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUnusedSegmentsForInterval(this.defaultSegment.getDataSource(), this.defaultSegment.getInterval().withStart((ReadableInstant)this.defaultSegment.getInterval().getStart().minusYears(1)), null, null)));
    }

    @Test
    public void testUnusedHighRange() {
        this.coordinator.commitSegments(this.SEGMENTS, new SegmentSchemaMapping(1));
        this.markAllSegmentsUnused();
        Assert.assertEquals((Object)this.SEGMENTS, (Object)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUnusedSegmentsForInterval(this.defaultSegment.getDataSource(), this.defaultSegment.getInterval().withEnd((ReadableInstant)this.defaultSegment.getInterval().getEnd().plus(1L)), null, null)));
        Assert.assertEquals((Object)this.SEGMENTS, (Object)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUnusedSegmentsForInterval(this.defaultSegment.getDataSource(), this.defaultSegment.getInterval().withEnd((ReadableInstant)this.defaultSegment.getInterval().getEnd().plusYears(1)), null, null)));
    }

    @Test
    public void testUsedHugeTimeRangeEternityFilter() {
        this.coordinator.commitSegments((Set)ImmutableSet.of((Object)this.hugeTimeRangeSegment1, (Object)this.hugeTimeRangeSegment2, (Object)this.hugeTimeRangeSegment3), new SegmentSchemaMapping(1));
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.hugeTimeRangeSegment1, (Object)this.hugeTimeRangeSegment2, (Object)this.hugeTimeRangeSegment3), (Object)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUsedSegmentsForIntervals(this.hugeTimeRangeSegment1.getDataSource(), (List)Intervals.ONLY_ETERNITY, Segments.ONLY_VISIBLE)));
    }

    @Test
    public void testUsedHugeTimeRangeTrickyFilter1() {
        this.coordinator.commitSegments((Set)ImmutableSet.of((Object)this.hugeTimeRangeSegment1, (Object)this.hugeTimeRangeSegment2, (Object)this.hugeTimeRangeSegment3), new SegmentSchemaMapping(1));
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.hugeTimeRangeSegment2), (Object)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUsedSegmentsForInterval(this.hugeTimeRangeSegment1.getDataSource(), Intervals.of((String)"2900/10000"), Segments.ONLY_VISIBLE)));
    }

    @Test
    public void testUsedHugeTimeRangeTrickyFilter2() {
        this.coordinator.commitSegments((Set)ImmutableSet.of((Object)this.hugeTimeRangeSegment1, (Object)this.hugeTimeRangeSegment2, (Object)this.hugeTimeRangeSegment3), new SegmentSchemaMapping(1));
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.hugeTimeRangeSegment2), (Object)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUsedSegmentsForInterval(this.hugeTimeRangeSegment1.getDataSource(), Intervals.of((String)"2993/2995"), Segments.ONLY_VISIBLE)));
    }

    @Test
    public void testEternitySegmentWithStringComparison() {
        this.coordinator.commitSegments((Set)ImmutableSet.of((Object)this.eternitySegment), new SegmentSchemaMapping(1));
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.eternitySegment), (Object)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUsedSegmentsForInterval(this.eternitySegment.getDataSource(), Intervals.of((String)"2020/2021"), Segments.ONLY_VISIBLE)));
    }

    @Test
    public void testEternityMultipleSegmentWithStringComparison() {
        this.coordinator.commitSegments((Set)ImmutableSet.of((Object)this.numberedSegment0of0, (Object)this.eternitySegment), new SegmentSchemaMapping(1));
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.eternitySegment, (Object)this.numberedSegment0of0), (Object)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUsedSegmentsForInterval(this.eternitySegment.getDataSource(), Intervals.of((String)"2015/2016"), Segments.ONLY_VISIBLE)));
    }

    @Test
    public void testFirstHalfEternitySegmentWithStringComparison() {
        this.coordinator.commitSegments((Set)ImmutableSet.of((Object)this.firstHalfEternityRangeSegment), new SegmentSchemaMapping(1));
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.firstHalfEternityRangeSegment), (Object)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUsedSegmentsForInterval(this.firstHalfEternityRangeSegment.getDataSource(), Intervals.of((String)"2020/2021"), Segments.ONLY_VISIBLE)));
    }

    @Test
    public void testFirstHalfEternityMultipleSegmentWithStringComparison() {
        this.coordinator.commitSegments((Set)ImmutableSet.of((Object)this.numberedSegment0of0, (Object)this.firstHalfEternityRangeSegment), new SegmentSchemaMapping(1));
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.numberedSegment0of0, (Object)this.firstHalfEternityRangeSegment), (Object)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUsedSegmentsForInterval(this.firstHalfEternityRangeSegment.getDataSource(), Intervals.of((String)"2015/2016"), Segments.ONLY_VISIBLE)));
    }

    @Test
    public void testSecondHalfEternitySegmentWithStringComparison() {
        this.coordinator.commitSegments((Set)ImmutableSet.of((Object)this.secondHalfEternityRangeSegment), new SegmentSchemaMapping(1));
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.secondHalfEternityRangeSegment), (Object)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUsedSegmentsForInterval(this.secondHalfEternityRangeSegment.getDataSource(), Intervals.of((String)"2020/2021"), Segments.ONLY_VISIBLE)));
    }

    @Test
    public void testLargeIntervalWithStringComparison() {
        Assume.assumeTrue((boolean)this.isCacheEnabled());
        this.coordinator.commitSegments((Set)ImmutableSet.of((Object)this.hugeTimeRangeSegment4), new SegmentSchemaMapping(1));
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.hugeTimeRangeSegment4), (Object)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUsedSegmentsForInterval(this.hugeTimeRangeSegment4.getDataSource(), Intervals.of((String)"2020/2021"), Segments.ONLY_VISIBLE)));
    }

    @Test
    public void testSecondHalfEternityMultipleSegmentWithStringComparison() {
        this.coordinator.commitSegments((Set)ImmutableSet.of((Object)this.numberedSegment0of0, (Object)this.secondHalfEternityRangeSegment), new SegmentSchemaMapping(1));
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.numberedSegment0of0, (Object)this.secondHalfEternityRangeSegment), (Object)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUsedSegmentsForInterval(this.secondHalfEternityRangeSegment.getDataSource(), Intervals.of((String)"2015/2016"), Segments.ONLY_VISIBLE)));
    }

    @Test
    public void testDeleteDataSourceMetadata() {
        this.coordinator.commitSegmentsAndMetadata((Set)ImmutableSet.of((Object)this.defaultSegment), (DataSourceMetadata)new ObjectMetadata(null), (DataSourceMetadata)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"bar")), new SegmentSchemaMapping(1));
        Assert.assertEquals((Object)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"bar")), (Object)this.coordinator.retrieveDataSourceMetadata("fooDataSource"));
        Assert.assertFalse((String)"deleteInvalidDataSourceMetadata", (boolean)this.coordinator.deleteDataSourceMetadata("nonExistentDS"));
        Assert.assertTrue((String)"deleteValidDataSourceMetadata", (boolean)this.coordinator.deleteDataSourceMetadata("fooDataSource"));
        Assert.assertNull((String)"getDataSourceMetadataNullAfterDelete", (Object)this.coordinator.retrieveDataSourceMetadata("fooDataSource"));
    }

    @Test
    public void testDeleteSegmentsInMetaDataStorage() {
        this.coordinator.commitSegments(this.SEGMENTS, new SegmentSchemaMapping(1));
        Assert.assertEquals((Object)this.SEGMENTS, (Object)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUsedSegmentsForInterval(this.defaultSegment.getDataSource(), this.defaultSegment.getInterval(), Segments.ONLY_VISIBLE)));
        this.coordinator.deleteSegments(this.SEGMENTS);
        Assert.assertEquals((long)0L, (long)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUsedSegmentsForInterval(this.defaultSegment.getDataSource(), this.defaultSegment.getInterval(), Segments.ONLY_VISIBLE)).size());
    }

    @Test
    public void testUpdateSegmentsInMetaDataStorage() {
        Assume.assumeFalse((boolean)this.isCacheEnabled());
        this.coordinator.commitSegments(this.SEGMENTS, new SegmentSchemaMapping(1));
        Assert.assertEquals((Object)this.SEGMENTS, (Object)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUsedSegmentsForInterval(this.defaultSegment.getDataSource(), this.defaultSegment.getInterval(), Segments.ONLY_VISIBLE)));
        this.coordinator.updateSegmentMetadata(Collections.singleton(this.defaultSegment2WithBiggerSize));
        Set updated = this.coordinator.retrieveUsedSegmentsForInterval(this.defaultSegment.getDataSource(), this.defaultSegment.getInterval(), Segments.ONLY_VISIBLE);
        Assert.assertEquals((long)this.SEGMENTS.size(), (long)updated.size());
        DataSegment defaultAfterUpdate = updated.stream().filter(s -> s.equals((Object)this.defaultSegment)).findFirst().get();
        DataSegment default2AfterUpdate = updated.stream().filter(s -> s.equals((Object)this.defaultSegment2)).findFirst().get();
        Assert.assertNotNull((Object)defaultAfterUpdate);
        Assert.assertNotNull((Object)default2AfterUpdate);
        Assert.assertEquals((long)this.defaultSegment.getSize(), (long)defaultAfterUpdate.getSize());
        Assert.assertEquals((long)this.defaultSegment2WithBiggerSize.getSize(), (long)default2AfterUpdate.getSize());
    }

    @Test
    public void testSingleAdditionalNumberedShardWithNoCorePartitions() throws IOException {
        this.additionalNumberedShardTest((Set<DataSegment>)ImmutableSet.of((Object)this.numberedSegment0of0));
    }

    @Test
    public void testMultipleAdditionalNumberedShardsWithNoCorePartitions() throws IOException {
        this.additionalNumberedShardTest((Set<DataSegment>)ImmutableSet.of((Object)this.numberedSegment0of0, (Object)this.numberedSegment1of0, (Object)this.numberedSegment2of0));
    }

    @Test
    public void testSingleAdditionalNumberedShardWithOneCorePartition() throws IOException {
        this.additionalNumberedShardTest((Set<DataSegment>)ImmutableSet.of((Object)this.numberedSegment2of1));
    }

    @Test
    public void testMultipleAdditionalNumberedShardsWithOneCorePartition() throws IOException {
        this.additionalNumberedShardTest((Set<DataSegment>)ImmutableSet.of((Object)this.numberedSegment2of1, (Object)this.numberedSegment3of1));
    }

    private void additionalNumberedShardTest(Set<DataSegment> segments) throws IOException {
        this.coordinator.commitSegments(segments, new SegmentSchemaMapping(1));
        for (DataSegment segment2 : segments) {
            Assert.assertArrayEquals((byte[])this.mapper.writeValueAsString((Object)segment2).getBytes(StandardCharsets.UTF_8), (byte[])this.derbyConnector.lookup(((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getSegmentsTable(), "id", "payload", segment2.getId().toString()));
        }
        Assert.assertEquals(segments.stream().map(segment -> segment.getId().toString()).collect(Collectors.toList()), this.retrieveUsedSegmentIds((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()));
        Assert.assertEquals((long)0L, (long)this.metadataUpdateCounter.get());
    }

    @Test
    public void testAllocatePendingSegment() {
        NumberedPartialShardSpec partialShardSpec = NumberedPartialShardSpec.instance();
        String dataSource = "ds";
        Interval interval = Intervals.of((String)"2017-01-01/2017-02-01");
        SegmentIdWithShardSpec identifier = this.allocatePendingSegment("ds", "seq", null, interval, (PartialShardSpec)partialShardSpec, "version", false, null);
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_version", (Object)identifier.toString());
        SegmentIdWithShardSpec identifier1 = this.allocatePendingSegment("ds", "seq", identifier.toString(), interval, (PartialShardSpec)partialShardSpec, identifier.getVersion(), false, null);
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_version_1", (Object)identifier1.toString());
        SegmentIdWithShardSpec identifier2 = this.allocatePendingSegment("ds", "seq", identifier1.toString(), interval, (PartialShardSpec)partialShardSpec, identifier1.getVersion(), false, null);
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_version_2", (Object)identifier2.toString());
        SegmentIdWithShardSpec identifier3 = this.allocatePendingSegment("ds", "seq", identifier1.toString(), interval, (PartialShardSpec)partialShardSpec, identifier1.getVersion(), false, null);
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_version_2", (Object)identifier3.toString());
        Assert.assertEquals((Object)identifier2, (Object)identifier3);
        SegmentIdWithShardSpec identifier4 = this.allocatePendingSegment("ds", "seq1", null, interval, (PartialShardSpec)partialShardSpec, "version", false, null);
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_version_3", (Object)identifier4.toString());
    }

    @Test
    public void testAllocatePendingSegmentAfterDroppingExistingSegment() {
        String maxVersion = "version_newer_newer";
        NumberedPartialShardSpec partialShardSpec = NumberedPartialShardSpec.instance();
        String dataSource = "ds";
        Interval interval = Intervals.of((String)"2017-01-01/2017-02-01");
        SegmentIdWithShardSpec identifier = this.allocatePendingSegment("ds", "seq", null, interval, (PartialShardSpec)partialShardSpec, "version", true, null);
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_version", (Object)identifier.toString());
        Assert.assertEquals((long)0L, (long)identifier.getShardSpec().getNumCorePartitions());
        SegmentIdWithShardSpec identifier1 = this.allocatePendingSegment("ds", "seq2", identifier.toString(), interval, (PartialShardSpec)partialShardSpec, maxVersion, true, null);
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_version_1", (Object)identifier1.toString());
        Assert.assertEquals((long)0L, (long)identifier1.getShardSpec().getNumCorePartitions());
        SegmentIdWithShardSpec identifier2 = this.allocatePendingSegment("ds", "seq3", identifier1.toString(), interval, (PartialShardSpec)partialShardSpec, maxVersion, true, null);
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_version_2", (Object)identifier2.toString());
        Assert.assertEquals((long)0L, (long)identifier2.getShardSpec().getNumCorePartitions());
        DataSegment segment = new DataSegment("ds", Intervals.of((String)"2017-01-01T00Z/2017-02-01T00Z"), "version_new", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new NumberedShardSpec(0, 1), Integer.valueOf(9), 100L);
        this.coordinator.commitSegments(Set.of(segment), null);
        List<String> ids = this.retrieveUsedSegmentIds((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get());
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_version_new", (Object)ids.get(0));
        SegmentIdWithShardSpec identifier3 = this.allocatePendingSegment("ds", "seq4", identifier1.toString(), interval, (PartialShardSpec)partialShardSpec, maxVersion, true, null);
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_version_new_1", (Object)identifier3.toString());
        Assert.assertEquals((long)1L, (long)identifier3.getShardSpec().getNumCorePartitions());
        this.markAllSegmentsUnused((Set<DataSegment>)ImmutableSet.of((Object)segment), DateTimes.nowUtc());
        this.refreshCache();
        SegmentIdWithShardSpec identifier4 = this.allocatePendingSegment("ds", "seq5", identifier1.toString(), interval, (PartialShardSpec)partialShardSpec, maxVersion, true, null);
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_version_new_2", (Object)identifier4.toString());
        Assert.assertEquals((long)0L, (long)identifier4.getShardSpec().getNumCorePartitions());
    }

    @Test
    public void testAnotherAllocatePendingSegmentAfterRevertingCompaction() {
        String maxVersion = "Z";
        NumberedPartialShardSpec partialShardSpec = NumberedPartialShardSpec.instance();
        String dataSource = "ds";
        Interval interval = Intervals.of((String)"2017-01-01/2017-02-01");
        SegmentIdWithShardSpec identifier = this.allocatePendingSegment("ds", "seq", null, interval, (PartialShardSpec)partialShardSpec, "A", true, null);
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_A", (Object)identifier.toString());
        DataSegment segment = new DataSegment("ds", Intervals.of((String)"2017-01-01T00Z/2017-02-01T00Z"), "A", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new LinearShardSpec(Integer.valueOf(0)), Integer.valueOf(9), 100L);
        this.coordinator.commitSegments(Set.of(segment), null);
        List<String> ids = this.retrieveUsedSegmentIds((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get());
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_A", (Object)ids.get(0));
        SegmentIdWithShardSpec identifier1 = this.allocatePendingSegment("ds", "seq2", identifier.toString(), interval, (PartialShardSpec)partialShardSpec, maxVersion, true, null);
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_A_1", (Object)identifier1.toString());
        segment = new DataSegment("ds", Intervals.of((String)"2017-01-01T00Z/2017-02-01T00Z"), "A", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new LinearShardSpec(Integer.valueOf(1)), Integer.valueOf(9), 100L);
        this.coordinator.commitSegments(Set.of(segment), null);
        ids = this.retrieveUsedSegmentIds((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get());
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_A_1", (Object)ids.get(1));
        SegmentIdWithShardSpec identifier2 = this.allocatePendingSegment("ds", "seq3", identifier1.toString(), interval, (PartialShardSpec)partialShardSpec, maxVersion, true, null);
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_A_2", (Object)identifier2.toString());
        segment = new DataSegment("ds", Intervals.of((String)"2017-01-01T00Z/2017-02-01T00Z"), "A", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new LinearShardSpec(Integer.valueOf(2)), Integer.valueOf(9), 100L);
        this.coordinator.commitSegments(Set.of(segment), null);
        ids = this.retrieveUsedSegmentIds((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get());
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_A_2", (Object)ids.get(2));
        DataSegment compactedSegment = new DataSegment("ds", Intervals.of((String)"2017-01-01T00Z/2017-02-01T00Z"), "B", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new LinearShardSpec(Integer.valueOf(0)), Integer.valueOf(9), 100L);
        this.coordinator.commitSegments(Set.of(compactedSegment), null);
        ids = this.retrieveUsedSegmentIds((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get());
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_B", (Object)ids.get(3));
        SegmentIdWithShardSpec identifier3 = this.allocatePendingSegment("ds", "seq4", identifier2.toString(), interval, (PartialShardSpec)partialShardSpec, maxVersion, true, null);
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_B_1", (Object)identifier3.toString());
        this.markAllSegmentsUnused((Set<DataSegment>)ImmutableSet.of((Object)compactedSegment), DateTimes.nowUtc());
        this.refreshCache();
        List<String> pendings = this.retrievePendingSegmentIds((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get());
        Assert.assertEquals((long)4L, (long)pendings.size());
        List<String> used = this.retrieveUsedSegmentIds((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get());
        Assert.assertEquals((long)3L, (long)used.size());
        List<String> unused = this.retrieveUnusedSegmentIds((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get());
        Assert.assertEquals((long)1L, (long)unused.size());
        SegmentIdWithShardSpec identifier4 = this.allocatePendingSegment("ds", "seq5", identifier1.toString(), interval, (PartialShardSpec)partialShardSpec, maxVersion, true, null);
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_A_3", (Object)identifier4.toString());
        segment = new DataSegment("ds", Intervals.of((String)"2017-01-01T00Z/2017-02-01T00Z"), "A", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new LinearShardSpec(Integer.valueOf(3)), Integer.valueOf(9), 100L);
        this.coordinator.commitSegments(Set.of(segment), null);
        ids = this.retrieveUsedSegmentIds((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get());
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_A_3", (Object)ids.get(3));
    }

    @Test
    public void testAllocatePendingSegmentsSkipSegmentPayloadFetch() {
        NumberedPartialShardSpec partialShardSpec = NumberedPartialShardSpec.instance();
        String dataSource = "ds";
        Interval interval = Intervals.of((String)"2017-01-01/2017-02-01");
        String sequenceName = "seq";
        SegmentCreateRequest request = new SegmentCreateRequest("seq", null, "v1", (PartialShardSpec)partialShardSpec, null);
        SegmentIdWithShardSpec segmentId0 = (SegmentIdWithShardSpec)this.coordinator.allocatePendingSegments("ds", interval, false, Collections.singletonList(request), true).get(request);
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_v1", (Object)segmentId0.toString());
        SegmentCreateRequest request1 = new SegmentCreateRequest("seq", segmentId0.toString(), segmentId0.getVersion(), (PartialShardSpec)partialShardSpec, null);
        SegmentIdWithShardSpec segmentId1 = (SegmentIdWithShardSpec)this.coordinator.allocatePendingSegments("ds", interval, false, Collections.singletonList(request1), true).get(request1);
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_v1_1", (Object)segmentId1.toString());
        SegmentCreateRequest request2 = new SegmentCreateRequest("seq", segmentId1.toString(), segmentId1.getVersion(), (PartialShardSpec)partialShardSpec, null);
        SegmentIdWithShardSpec segmentId2 = (SegmentIdWithShardSpec)this.coordinator.allocatePendingSegments("ds", interval, false, Collections.singletonList(request2), true).get(request2);
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_v1_2", (Object)segmentId2.toString());
        SegmentCreateRequest request3 = new SegmentCreateRequest("seq", segmentId1.toString(), segmentId1.getVersion(), (PartialShardSpec)partialShardSpec, null);
        SegmentIdWithShardSpec segmentId3 = (SegmentIdWithShardSpec)this.coordinator.allocatePendingSegments("ds", interval, false, Collections.singletonList(request3), true).get(request3);
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_v1_2", (Object)segmentId3.toString());
        Assert.assertEquals((Object)segmentId2, (Object)segmentId3);
        SegmentCreateRequest request4 = new SegmentCreateRequest("seq1", null, "v1", (PartialShardSpec)partialShardSpec, null);
        SegmentIdWithShardSpec segmentId4 = (SegmentIdWithShardSpec)this.coordinator.allocatePendingSegments("ds", interval, false, Collections.singletonList(request4), true).get(request4);
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_v1_3", (Object)segmentId4.toString());
    }

    @Test
    public void testAllocatePendingSegments() {
        NumberedPartialShardSpec partialShardSpec = NumberedPartialShardSpec.instance();
        String dataSource = "ds";
        Interval interval = Intervals.of((String)"2017-01-01/2017-02-01");
        String sequenceName = "seq";
        SegmentCreateRequest request = new SegmentCreateRequest("seq", null, "v1", (PartialShardSpec)partialShardSpec, null);
        SegmentIdWithShardSpec segmentId0 = (SegmentIdWithShardSpec)this.coordinator.allocatePendingSegments("ds", interval, false, Collections.singletonList(request), false).get(request);
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_v1", (Object)segmentId0.toString());
        SegmentCreateRequest request1 = new SegmentCreateRequest("seq", segmentId0.toString(), segmentId0.getVersion(), (PartialShardSpec)partialShardSpec, null);
        SegmentIdWithShardSpec segmentId1 = (SegmentIdWithShardSpec)this.coordinator.allocatePendingSegments("ds", interval, false, Collections.singletonList(request1), false).get(request1);
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_v1_1", (Object)segmentId1.toString());
        SegmentCreateRequest request2 = new SegmentCreateRequest("seq", segmentId1.toString(), segmentId1.getVersion(), (PartialShardSpec)partialShardSpec, null);
        SegmentIdWithShardSpec segmentId2 = (SegmentIdWithShardSpec)this.coordinator.allocatePendingSegments("ds", interval, false, Collections.singletonList(request2), false).get(request2);
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_v1_2", (Object)segmentId2.toString());
        SegmentCreateRequest request3 = new SegmentCreateRequest("seq", segmentId1.toString(), segmentId1.getVersion(), (PartialShardSpec)partialShardSpec, null);
        SegmentIdWithShardSpec segmentId3 = (SegmentIdWithShardSpec)this.coordinator.allocatePendingSegments("ds", interval, false, Collections.singletonList(request3), false).get(request3);
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_v1_2", (Object)segmentId3.toString());
        Assert.assertEquals((Object)segmentId2, (Object)segmentId3);
        SegmentCreateRequest request4 = new SegmentCreateRequest("seq1", null, "v1", (PartialShardSpec)partialShardSpec, null);
        SegmentIdWithShardSpec segmentId4 = (SegmentIdWithShardSpec)this.coordinator.allocatePendingSegments("ds", interval, false, Collections.singletonList(request4), false).get(request4);
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_v1_3", (Object)segmentId4.toString());
    }

    @Test
    public void testNoPendingSegmentsAndOneUsedSegment() {
        String maxVersion = "Z";
        DataSegment segment = new DataSegment("ds", Intervals.of((String)"2017-01-01T00Z/2017-02-01T00Z"), "A", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new LinearShardSpec(Integer.valueOf(0)), Integer.valueOf(9), 100L);
        this.coordinator.commitSegments(Set.of(segment), null);
        List<String> ids = this.retrieveUsedSegmentIds((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get());
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_A", (Object)ids.get(0));
        NumberedPartialShardSpec partialShardSpec = NumberedPartialShardSpec.instance();
        String dataSource = "ds";
        Interval interval = Intervals.of((String)"2017-01-01/2017-02-01");
        SegmentIdWithShardSpec identifier = this.allocatePendingSegment("ds", "seq", null, interval, (PartialShardSpec)partialShardSpec, maxVersion, true, null);
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_A_1", (Object)identifier.toString());
    }

    @Test
    public void testDeletePendingSegment() throws InterruptedException {
        NumberedPartialShardSpec partialShardSpec = NumberedPartialShardSpec.instance();
        String dataSource = "ds";
        Interval interval = Intervals.of((String)"2017-01-01/2017-02-01");
        String prevSegmentId = null;
        DateTime begin = DateTimes.nowUtc();
        for (int i = 0; i < 10; ++i) {
            SegmentIdWithShardSpec identifier = this.allocatePendingSegment("ds", "seq", prevSegmentId, interval, (PartialShardSpec)partialShardSpec, "version", false, null);
            prevSegmentId = identifier.toString();
        }
        Thread.sleep(100L);
        DateTime secondBegin = DateTimes.nowUtc();
        for (int i = 0; i < 5; ++i) {
            SegmentIdWithShardSpec identifier = this.allocatePendingSegment("ds", "seq", prevSegmentId, interval, (PartialShardSpec)partialShardSpec, "version", false, null);
            prevSegmentId = identifier.toString();
        }
        int numDeleted = this.coordinator.deletePendingSegmentsCreatedInInterval("ds", new Interval((ReadableInstant)begin, (ReadableInstant)secondBegin));
        Assert.assertEquals((long)10L, (long)numDeleted);
    }

    @Test
    public void testAllocatePendingSegmentsWithOvershadowingSegments() {
        String dataSource = "ds";
        Interval interval = Intervals.of((String)"2017-01-01/2017-02-01");
        String prevSegmentId = null;
        for (int i = 0; i < 10; ++i) {
            SegmentIdWithShardSpec identifier = this.allocatePendingSegment("ds", "seq", prevSegmentId, interval, (PartialShardSpec)new NumberedOverwritePartialShardSpec(0, 1, (short)(i + 1)), "version", false, null);
            Assert.assertEquals((Object)StringUtils.format((String)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_version%s", (Object[])new Object[]{"_" + (i + 32768)}), (Object)identifier.toString());
            prevSegmentId = identifier.toString();
            Set<DataSegment> toBeAnnounced = Collections.singleton(new DataSegment(identifier.getDataSource(), identifier.getInterval(), identifier.getVersion(), null, Collections.emptyList(), Collections.emptyList(), (ShardSpec)((NumberedOverwriteShardSpec)identifier.getShardSpec()).withAtomicUpdateGroupSize(1), Integer.valueOf(0), 10L));
            Set announced = this.coordinator.commitSegments(toBeAnnounced, new SegmentSchemaMapping(1));
            Assert.assertEquals(toBeAnnounced, (Object)announced);
        }
        Set visibleSegments = this.coordinator.retrieveUsedSegmentsForInterval("ds", interval, Segments.ONLY_VISIBLE);
        Assert.assertEquals((long)1L, (long)visibleSegments.size());
        Assert.assertEquals((Object)new DataSegment("ds", interval, "version", null, Collections.emptyList(), Collections.emptyList(), (ShardSpec)new NumberedOverwriteShardSpec(32777, 0, 1, 9, 1), Integer.valueOf(0), 10L), (Object)Iterables.getOnlyElement((Iterable)visibleSegments));
    }

    @Test
    public void testAllocatePendingSegmentsForHashBasedNumberedShardSpec() {
        HashBasedNumberedPartialShardSpec partialShardSpec = new HashBasedNumberedPartialShardSpec(null, 2, 5, null);
        String dataSource = "ds";
        Interval interval = Intervals.of((String)"2017-01-01/2017-02-01");
        SegmentIdWithShardSpec id = this.allocatePendingSegment("ds", "seq", null, interval, (PartialShardSpec)partialShardSpec, "version", true, null);
        HashBasedNumberedShardSpec shardSpec = (HashBasedNumberedShardSpec)id.getShardSpec();
        Assert.assertEquals((long)0L, (long)shardSpec.getPartitionNum());
        Assert.assertEquals((long)0L, (long)shardSpec.getNumCorePartitions());
        Assert.assertEquals((long)5L, (long)shardSpec.getNumBuckets());
        this.coordinator.commitSegments(Collections.singleton(new DataSegment(id.getDataSource(), id.getInterval(), id.getVersion(), null, Collections.emptyList(), Collections.emptyList(), id.getShardSpec(), Integer.valueOf(0), 10L)), new SegmentSchemaMapping(1));
        id = this.allocatePendingSegment("ds", "seq2", null, interval, (PartialShardSpec)partialShardSpec, "version", true, null);
        shardSpec = (HashBasedNumberedShardSpec)id.getShardSpec();
        Assert.assertEquals((long)1L, (long)shardSpec.getPartitionNum());
        Assert.assertEquals((long)0L, (long)shardSpec.getNumCorePartitions());
        Assert.assertEquals((long)5L, (long)shardSpec.getNumBuckets());
        this.coordinator.commitSegments(Collections.singleton(new DataSegment(id.getDataSource(), id.getInterval(), id.getVersion(), null, Collections.emptyList(), Collections.emptyList(), id.getShardSpec(), Integer.valueOf(0), 10L)), new SegmentSchemaMapping(1));
        id = this.allocatePendingSegment("ds", "seq3", null, interval, (PartialShardSpec)new HashBasedNumberedPartialShardSpec(null, 2, 3, null), "version", true, null);
        shardSpec = (HashBasedNumberedShardSpec)id.getShardSpec();
        Assert.assertEquals((long)2L, (long)shardSpec.getPartitionNum());
        Assert.assertEquals((long)0L, (long)shardSpec.getNumCorePartitions());
        Assert.assertEquals((long)3L, (long)shardSpec.getNumBuckets());
    }

    @Test
    public void testAddNumberedShardSpecAfterMultiDimensionsShardSpecWithUnknownCorePartitionSize() {
        String datasource = "datasource";
        Interval interval = Intervals.of((String)"2020-01-01/P1D");
        String version = "version";
        ImmutableList dimensions = ImmutableList.of((Object)"dim");
        ImmutableList metrics = ImmutableList.of((Object)"met");
        HashSet<DataSegment> originalSegments = new HashSet<DataSegment>();
        for (int i = 0; i < 6; ++i) {
            originalSegments.add(new DataSegment("datasource", interval, "version", (Map)ImmutableMap.of(), (List)dimensions, (List)metrics, (ShardSpec)new DimensionRangeShardSpec(Collections.singletonList("dim"), i == 0 ? null : StringTuple.create((String[])new String[]{String.valueOf(i - 1)}), i == 5 ? null : StringTuple.create((String[])new String[]{String.valueOf(i)}), i, null), Integer.valueOf(9), 10L));
        }
        this.coordinator.commitSegments(originalSegments, new SegmentSchemaMapping(1));
        SegmentIdWithShardSpec id = this.allocatePendingSegment("datasource", "seq", null, interval, (PartialShardSpec)NumberedPartialShardSpec.instance(), "version", false, null);
        Assert.assertNull((Object)id);
    }

    @Test
    public void testAddNumberedShardSpecAfterSingleDimensionsShardSpecWithUnknownCorePartitionSize() {
        String datasource = "datasource";
        Interval interval = Intervals.of((String)"2020-01-01/P1D");
        String version = "version";
        ImmutableList dimensions = ImmutableList.of((Object)"dim");
        ImmutableList metrics = ImmutableList.of((Object)"met");
        HashSet<DataSegment> originalSegments = new HashSet<DataSegment>();
        for (int i = 0; i < 6; ++i) {
            String start = i == 0 ? null : String.valueOf(i - 1);
            String end = i == 5 ? null : String.valueOf(i);
            originalSegments.add(new DataSegment("datasource", interval, "version", (Map)ImmutableMap.of(), (List)dimensions, (List)metrics, (ShardSpec)new SingleDimensionShardSpec("dim", start, end, i, null), Integer.valueOf(9), 10L));
        }
        this.coordinator.commitSegments(originalSegments, new SegmentSchemaMapping(1));
        SegmentIdWithShardSpec id = this.allocatePendingSegment("datasource", "seq", null, interval, (PartialShardSpec)NumberedPartialShardSpec.instance(), "version", false, null);
        Assert.assertNull((Object)id);
    }

    @Test
    public void testRemoveDataSourceMetadataOlderThanDatasourceActiveShouldNotBeDeleted() {
        this.coordinator.commitSegmentsAndMetadata((Set)ImmutableSet.of((Object)this.defaultSegment), (DataSourceMetadata)new ObjectMetadata(null), (DataSourceMetadata)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"bar")), new SegmentSchemaMapping(1));
        Assert.assertEquals((Object)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"bar")), (Object)this.coordinator.retrieveDataSourceMetadata("fooDataSource"));
        int deletedCount = this.coordinator.removeDataSourceMetadataOlderThan(System.currentTimeMillis(), (Set)ImmutableSet.of((Object)"fooDataSource"));
        Assert.assertEquals((Object)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"bar")), (Object)this.coordinator.retrieveDataSourceMetadata("fooDataSource"));
        Assert.assertEquals((long)0L, (long)deletedCount);
    }

    @Test
    public void testRemoveDataSourceMetadataOlderThanDatasourceNotActiveAndOlderThanTimeShouldBeDeleted() {
        this.coordinator.commitSegmentsAndMetadata((Set)ImmutableSet.of((Object)this.defaultSegment), (DataSourceMetadata)new ObjectMetadata(null), (DataSourceMetadata)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"bar")), new SegmentSchemaMapping(1));
        Assert.assertEquals((Object)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"bar")), (Object)this.coordinator.retrieveDataSourceMetadata("fooDataSource"));
        int deletedCount = this.coordinator.removeDataSourceMetadataOlderThan(System.currentTimeMillis(), (Set)ImmutableSet.of());
        Assert.assertNull((Object)this.coordinator.retrieveDataSourceMetadata("fooDataSource"));
        Assert.assertEquals((long)1L, (long)deletedCount);
    }

    @Test
    public void testRemoveDataSourceMetadataOlderThanDatasourceNotActiveButNotOlderThanTimeShouldNotBeDeleted() {
        this.coordinator.commitSegmentsAndMetadata((Set)ImmutableSet.of((Object)this.defaultSegment), (DataSourceMetadata)new ObjectMetadata(null), (DataSourceMetadata)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"bar")), new SegmentSchemaMapping(1));
        Assert.assertEquals((Object)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"bar")), (Object)this.coordinator.retrieveDataSourceMetadata("fooDataSource"));
        int deletedCount = this.coordinator.removeDataSourceMetadataOlderThan(DateTimes.of((String)"2012-01-01T00:00:00Z").getMillis(), (Set)ImmutableSet.of());
        Assert.assertEquals((Object)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"bar")), (Object)this.coordinator.retrieveDataSourceMetadata("fooDataSource"));
        Assert.assertEquals((long)0L, (long)deletedCount);
    }

    @Test
    public void testMarkSegmentsAsUnusedWithinIntervalOneYear() {
        this.coordinator.commitSegments((Set)ImmutableSet.of((Object)this.existingSegment1, (Object)this.existingSegment2), new SegmentSchemaMapping(1));
        this.coordinator.markSegmentsWithinIntervalAsUnused(this.existingSegment1.getDataSource(), Intervals.of((String)"1994-01-01/1994-01-02T12Z"), null);
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.existingSegment1), (Object)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUnusedSegmentsForInterval(this.existingSegment1.getDataSource(), this.existingSegment1.getInterval().withEnd((ReadableInstant)this.existingSegment1.getInterval().getEnd().plus(1L)), null, null, null)));
        Assert.assertEquals((Object)ImmutableSet.of(), (Object)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUnusedSegmentsForInterval(this.existingSegment2.getDataSource(), this.existingSegment2.getInterval().withEnd((ReadableInstant)this.existingSegment2.getInterval().getEnd().plusYears(1)), null, null)));
    }

    @Test
    public void testMarkSegmentsAsUnusedWithinIntervalTwoYears() {
        this.coordinator.commitSegments((Set)ImmutableSet.of((Object)this.existingSegment1, (Object)this.existingSegment2), new SegmentSchemaMapping(1));
        this.coordinator.markSegmentsWithinIntervalAsUnused(this.existingSegment1.getDataSource(), Intervals.of((String)"1993-12-31T12Z/1994-01-02T12Z"), null);
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.existingSegment1), (Object)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUnusedSegmentsForInterval(this.existingSegment1.getDataSource(), this.existingSegment1.getInterval().withEnd((ReadableInstant)this.existingSegment1.getInterval().getEnd().plus(1L)), null, null)));
        Assert.assertEquals((Object)ImmutableSet.of(), (Object)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUnusedSegmentsForInterval(this.existingSegment2.getDataSource(), this.existingSegment2.getInterval().withEnd((ReadableInstant)this.existingSegment2.getInterval().getEnd().plusYears(1)), null, null)));
    }

    @Test
    public void testRetrieveUsedSegmentsAndCreatedDates() {
        this.coordinator.commitSegments(Set.of(this.defaultSegment), null);
        List resultForIntervalOnTheLeft = this.coordinator.retrieveUsedSegmentsAndCreatedDates(this.defaultSegment.getDataSource(), Collections.singletonList(Intervals.of((String)"2000/2001")));
        Assert.assertTrue((boolean)resultForIntervalOnTheLeft.isEmpty());
        List resultForIntervalOnTheRight = this.coordinator.retrieveUsedSegmentsAndCreatedDates(this.defaultSegment.getDataSource(), Collections.singletonList(Intervals.of((String)"3000/3001")));
        Assert.assertTrue((boolean)resultForIntervalOnTheRight.isEmpty());
        List resultForExactInterval = this.coordinator.retrieveUsedSegmentsAndCreatedDates(this.defaultSegment.getDataSource(), Collections.singletonList(this.defaultSegment.getInterval()));
        Assert.assertEquals((long)1L, (long)resultForExactInterval.size());
        Assert.assertEquals((Object)this.defaultSegment, (Object)((Pair)resultForExactInterval.get((int)0)).lhs);
        List resultForIntervalWithLeftOverlap = this.coordinator.retrieveUsedSegmentsAndCreatedDates(this.defaultSegment.getDataSource(), Collections.singletonList(Intervals.of((String)"2000/2015-01-02")));
        Assert.assertEquals((Object)resultForExactInterval, (Object)resultForIntervalWithLeftOverlap);
        List resultForIntervalWithRightOverlap = this.coordinator.retrieveUsedSegmentsAndCreatedDates(this.defaultSegment.getDataSource(), Collections.singletonList(Intervals.of((String)"2015-01-01/3000")));
        Assert.assertEquals((Object)resultForExactInterval, (Object)resultForIntervalWithRightOverlap);
        List resultForEternity = this.coordinator.retrieveUsedSegmentsAndCreatedDates(this.defaultSegment.getDataSource(), Collections.singletonList(Intervals.ETERNITY));
        Assert.assertEquals((Object)resultForExactInterval, (Object)resultForEternity);
        List resultForFirstHalfEternity = this.coordinator.retrieveUsedSegmentsAndCreatedDates(this.defaultSegment.getDataSource(), Collections.singletonList(this.firstHalfEternityRangeSegment.getInterval()));
        Assert.assertEquals((Object)resultForExactInterval, (Object)resultForFirstHalfEternity);
        List resultForSecondHalfEternity = this.coordinator.retrieveUsedSegmentsAndCreatedDates(this.defaultSegment.getDataSource(), Collections.singletonList(this.secondHalfEternityRangeSegment.getInterval()));
        Assert.assertEquals((Object)resultForExactInterval, (Object)resultForSecondHalfEternity);
    }

    @Test
    public void testRetrieveUsedSegmentsAndCreatedDatesFetchesEternityForAnyInterval() {
        this.coordinator.commitSegments(Set.of(DataSegment.builder((DataSegment)this.eternitySegment).version("v1").build()), null);
        this.coordinator.commitSegments(Set.of(DataSegment.builder((DataSegment)this.firstHalfEternityRangeSegment).version("v2").build(), DataSegment.builder((DataSegment)this.secondHalfEternityRangeSegment).version("v3").build()), null);
        List resultForRandomInterval = this.coordinator.retrieveUsedSegmentsAndCreatedDates(this.defaultSegment.getDataSource(), Collections.singletonList(this.defaultSegment.getInterval()));
        Assert.assertEquals((long)3L, (long)resultForRandomInterval.size());
        List resultForEternity = this.coordinator.retrieveUsedSegmentsAndCreatedDates(this.defaultSegment.getDataSource(), Collections.singletonList(this.eternitySegment.getInterval()));
        Assert.assertEquals((long)3L, (long)resultForEternity.size());
        List resultForFirstHalfEternity = this.coordinator.retrieveUsedSegmentsAndCreatedDates(this.defaultSegment.getDataSource(), Collections.singletonList(this.firstHalfEternityRangeSegment.getInterval()));
        Assert.assertEquals((long)3L, (long)resultForFirstHalfEternity.size());
        List resultForSecondHalfEternity = this.coordinator.retrieveUsedSegmentsAndCreatedDates(this.defaultSegment.getDataSource(), Collections.singletonList(this.secondHalfEternityRangeSegment.getInterval()));
        Assert.assertEquals((long)3L, (long)resultForSecondHalfEternity.size());
    }

    @Test
    public void testTimelineVisibilityWith0CorePartitionTombstone() {
        Interval interval = Intervals.of((String)"2020/2021");
        DataSegment tombstoneSegment = this.createSegment(interval, "version", (ShardSpec)new TombstoneShardSpec());
        HashSet<DataSegment> tombstones = new HashSet<DataSegment>(Collections.singleton(tombstoneSegment));
        Assert.assertTrue((boolean)this.coordinator.commitSegments(tombstones, new SegmentSchemaMapping(1)).containsAll(tombstones));
        SegmentIdWithShardSpec identifier = this.allocatePendingSegment("wiki", "seq", tombstoneSegment.getVersion(), interval, (PartialShardSpec)NumberedPartialShardSpec.instance(), "version", false, null);
        Assert.assertEquals((Object)"wiki_2020-01-01T00:00:00.000Z_2021-01-01T00:00:00.000Z_version_1", (Object)identifier.toString());
        Assert.assertEquals((long)0L, (long)identifier.getShardSpec().getNumCorePartitions());
        DataSegment dataSegment = this.createSegment(interval, "version", identifier.getShardSpec());
        HashSet<DataSegment> dataSegments = new HashSet<DataSegment>(Collections.singleton(dataSegment));
        Assert.assertTrue((boolean)this.coordinator.commitSegments(dataSegments, new SegmentSchemaMapping(1)).containsAll(dataSegments));
        this.markAllSegmentsUnused(tombstones, DateTimes.nowUtc());
        Set allUsedSegments = this.coordinator.retrieveAllUsedSegments("wiki", Segments.ONLY_VISIBLE);
        SegmentTimeline segmentTimeline = SegmentTimeline.forSegments((Iterable)allUsedSegments);
        Assert.assertEquals((long)1L, (long)segmentTimeline.lookup(interval).size());
        Assert.assertEquals((Object)dataSegment, (Object)((TimelineObjectHolder)segmentTimeline.lookup(interval).get(0)).getObject().getChunk(1).getObject());
    }

    @Test
    public void testTimelineWith1CorePartitionTombstone() {
        this.mapper.registerSubtypes(new Class[]{IndexerSqlMetadataStorageCoordinatorTestBase.TombstoneShardSpecWith1CorePartition.class});
        Interval interval = Intervals.of((String)"2020/2021");
        DataSegment tombstoneSegment = this.createSegment(interval, "version", (ShardSpec)new IndexerSqlMetadataStorageCoordinatorTestBase.TombstoneShardSpecWith1CorePartition());
        HashSet<DataSegment> tombstones = new HashSet<DataSegment>(Collections.singleton(tombstoneSegment));
        Assert.assertTrue((boolean)this.coordinator.commitSegments(tombstones, new SegmentSchemaMapping(1)).containsAll(tombstones));
        SegmentIdWithShardSpec identifier = this.allocatePendingSegment("wiki", "seq", tombstoneSegment.getVersion(), interval, (PartialShardSpec)NumberedPartialShardSpec.instance(), "version", false, null);
        Assert.assertEquals((Object)"wiki_2020-01-01T00:00:00.000Z_2021-01-01T00:00:00.000Z_version_1", (Object)identifier.toString());
        Assert.assertEquals((long)1L, (long)identifier.getShardSpec().getNumCorePartitions());
        DataSegment dataSegment = this.createSegment(interval, "version", identifier.getShardSpec());
        HashSet<DataSegment> dataSegments = new HashSet<DataSegment>(Collections.singleton(dataSegment));
        Assert.assertTrue((boolean)this.coordinator.commitSegments(dataSegments, new SegmentSchemaMapping(1)).containsAll(dataSegments));
        this.markAllSegmentsUnused(tombstones, DateTimes.nowUtc());
        this.refreshCache();
        Set allUsedSegments = this.coordinator.retrieveAllUsedSegments("wiki", Segments.ONLY_VISIBLE);
        SegmentTimeline segmentTimeline = SegmentTimeline.forSegments((Iterable)allUsedSegments);
        Assert.assertEquals((long)0L, (long)segmentTimeline.lookup(interval).size());
    }

    @Test
    public void testSegmentIdShouldNotBeReallocated() {
        SegmentIdWithShardSpec idWithNullTaskAllocator = this.allocatePendingSegment("wiki", "seq", "0", Intervals.ETERNITY, (PartialShardSpec)NumberedPartialShardSpec.instance(), "version", false, null);
        DataSegment dataSegment0 = this.createSegment(idWithNullTaskAllocator.getInterval(), idWithNullTaskAllocator.getVersion(), idWithNullTaskAllocator.getShardSpec());
        SegmentIdWithShardSpec idWithValidTaskAllocator = this.allocatePendingSegment("wiki", "seq", "1", Intervals.ETERNITY, (PartialShardSpec)NumberedPartialShardSpec.instance(), "version", false, "taskAllocatorId");
        DataSegment dataSegment1 = this.createSegment(idWithValidTaskAllocator.getInterval(), idWithValidTaskAllocator.getVersion(), idWithValidTaskAllocator.getShardSpec());
        this.coordinator.commitSegments((Set)ImmutableSet.of((Object)dataSegment0, (Object)dataSegment1), null);
        this.coordinator.deletePendingSegmentsForTaskAllocatorId("wiki", "taskAllocatorId");
        this.coordinator.markSegmentsWithinIntervalAsUnused("wiki", Intervals.ETERNITY, null);
        SegmentIdWithShardSpec theId = this.allocatePendingSegment("wiki", "seq", "2", Intervals.ETERNITY, (PartialShardSpec)NumberedPartialShardSpec.instance(), "version", false, "taskAllocatorId");
        Assert.assertNull((Object)this.coordinator.retrieveSegmentForId(theId.getDataSource(), theId.asSegmentId().toString()));
    }

    @Test
    public void testRetrieveUnusedSegmentsForExactIntervalAndVersion() {
        DataSegment unusedForDifferentVersion = this.createSegment(Intervals.of((String)"2024/2025"), "v0", (ShardSpec)new NumberedShardSpec(0, 0));
        DataSegment unusedSegmentForExactIntervalAndVersion = this.createSegment(Intervals.of((String)"2024/2025"), "v1", (ShardSpec)new NumberedShardSpec(0, 0));
        DataSegment unusedSegmentForDifferentInterval = this.createSegment(Intervals.of((String)"2023/2024"), "v1", (ShardSpec)new NumberedShardSpec(0, 0));
        this.coordinator.commitSegments((Set)ImmutableSet.of((Object)unusedForDifferentVersion, (Object)unusedSegmentForDifferentInterval, (Object)unusedSegmentForExactIntervalAndVersion), null);
        this.coordinator.markSegmentsWithinIntervalAsUnused("wiki", Intervals.ETERNITY, null);
        DataSegment usedSegmentForExactIntervalAndVersion = this.createSegment(Intervals.of((String)"2024/2025"), "v1", (ShardSpec)new NumberedShardSpec(1, 0));
        this.coordinator.commitSegments((Set)ImmutableSet.of((Object)usedSegmentForExactIntervalAndVersion), null);
        SegmentId highestUnusedId = (SegmentId)this.transactionFactory.inReadWriteDatasourceTransaction("wiki", transaction -> transaction.findHighestUnusedSegmentId(Intervals.of((String)"2024/2025"), "v1"));
        Assert.assertEquals((Object)unusedSegmentForExactIntervalAndVersion.getId(), (Object)highestUnusedId);
    }

    @Test
    public void testRetrieveUpgradedFromSegmentIds() {
        String datasource = this.defaultSegment.getDataSource();
        HashMap<String, String> upgradedFromSegmentIdMap = new HashMap<String, String>();
        upgradedFromSegmentIdMap.put(this.defaultSegment2.getId().toString(), this.defaultSegment.getId().toString());
        this.insertUsedSegments((Set<DataSegment>)ImmutableSet.of((Object)this.defaultSegment, (Object)this.defaultSegment2), upgradedFromSegmentIdMap);
        this.coordinator.markSegmentsWithinIntervalAsUnused(datasource, Intervals.ETERNITY, null);
        upgradedFromSegmentIdMap.clear();
        upgradedFromSegmentIdMap.put(this.defaultSegment3.getId().toString(), this.defaultSegment.getId().toString());
        this.insertUsedSegments((Set<DataSegment>)ImmutableSet.of((Object)this.defaultSegment3, (Object)this.defaultSegment4), upgradedFromSegmentIdMap);
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put(this.defaultSegment2.getId().toString(), this.defaultSegment.getId().toString());
        expected.put(this.defaultSegment3.getId().toString(), this.defaultSegment.getId().toString());
        HashSet<String> segmentIds = new HashSet<String>();
        segmentIds.add(this.defaultSegment.getId().toString());
        segmentIds.add(this.defaultSegment2.getId().toString());
        segmentIds.add(this.defaultSegment3.getId().toString());
        segmentIds.add(this.defaultSegment4.getId().toString());
        Assert.assertEquals(expected, (Object)this.coordinator.retrieveUpgradedFromSegmentIds(datasource, segmentIds));
    }

    @Test
    public void testRetrieveUpgradedFromSegmentIdsInBatches() {
        Assume.assumeFalse((boolean)this.isCacheEnabled());
        int size = 500;
        int batchSize = 100;
        ArrayList<DataSegment> segments = new ArrayList<DataSegment>();
        for (int i = 0; i < 500; ++i) {
            segments.add(new DataSegment("DS", Intervals.ETERNITY, "v " + i % 5, (Map)ImmutableMap.of((Object)"num", (Object)(i / 5)), (List)ImmutableList.of((Object)"dim"), (List)ImmutableList.of((Object)"agg"), (ShardSpec)new NumberedShardSpec(i / 5, 0), Integer.valueOf(0), 100L));
        }
        HashMap<String, String> expected = new HashMap<String, String>();
        for (int i = 0; i < 100; ++i) {
            for (int j = 1; j < 5; ++j) {
                expected.put(((DataSegment)segments.get(5 * i + j)).getId().toString(), ((DataSegment)segments.get(5 * i)).getId().toString());
            }
        }
        this.insertUsedSegments((Set<DataSegment>)ImmutableSet.copyOf(segments), expected);
        Map actual = this.coordinator.retrieveUpgradedFromSegmentIds("DS", segments.stream().map(DataSegment::getId).map(SegmentId::toString).collect(Collectors.toSet()));
        Assert.assertEquals((long)400L, (long)actual.size());
        Assert.assertEquals(expected, (Object)actual);
    }

    @Test
    public void testRetrieveUpgradedToSegmentIds() {
        String datasource = this.defaultSegment.getDataSource();
        HashMap<String, String> upgradedFromSegmentIdMap = new HashMap<String, String>();
        upgradedFromSegmentIdMap.put(this.defaultSegment2.getId().toString(), this.defaultSegment.getId().toString());
        this.insertUsedSegments((Set<DataSegment>)ImmutableSet.of((Object)this.defaultSegment, (Object)this.defaultSegment2), upgradedFromSegmentIdMap);
        this.coordinator.markSegmentsWithinIntervalAsUnused(datasource, Intervals.ETERNITY, null);
        upgradedFromSegmentIdMap.clear();
        upgradedFromSegmentIdMap.put(this.defaultSegment3.getId().toString(), this.defaultSegment.getId().toString());
        this.insertUsedSegments((Set<DataSegment>)ImmutableSet.of((Object)this.defaultSegment3, (Object)this.defaultSegment4), upgradedFromSegmentIdMap);
        HashMap expected = new HashMap();
        expected.put(this.defaultSegment.getId().toString(), new HashSet());
        ((Set)expected.get(this.defaultSegment.getId().toString())).add(this.defaultSegment.getId().toString());
        ((Set)expected.get(this.defaultSegment.getId().toString())).add(this.defaultSegment2.getId().toString());
        ((Set)expected.get(this.defaultSegment.getId().toString())).add(this.defaultSegment3.getId().toString());
        HashSet<String> upgradedIds = new HashSet<String>();
        upgradedIds.add(this.defaultSegment.getId().toString());
        Assert.assertEquals(expected, (Object)this.coordinator.retrieveUpgradedToSegmentIds(datasource, upgradedIds));
    }

    @Test
    public void testRetrieveUpgradedToSegmentIdsInBatches() {
        int size = 500;
        int batchSize = 100;
        ArrayList<DataSegment> segments = new ArrayList<DataSegment>();
        for (int i = 0; i < 500; ++i) {
            segments.add(new DataSegment("DS", Intervals.ETERNITY, "v " + i % 5, (Map)ImmutableMap.of((Object)"num", (Object)(i / 5)), (List)ImmutableList.of((Object)"dim"), (List)ImmutableList.of((Object)"agg"), (ShardSpec)new NumberedShardSpec(i / 5, 0), Integer.valueOf(0), 100L));
        }
        HashMap expected = new HashMap();
        for (DataSegment segment : segments) {
            String id = segment.getId().toString();
            expected.put(id, new HashSet());
            ((Set)expected.get(id)).add(id);
        }
        HashMap<String, String> upgradeMap = new HashMap<String, String>();
        for (int i = 0; i < 100; ++i) {
            for (int j = 1; j < 5; ++j) {
                upgradeMap.put(((DataSegment)segments.get(5 * i + j)).getId().toString(), ((DataSegment)segments.get(5 * i)).getId().toString());
                ((Set)expected.get(((DataSegment)segments.get(5 * i)).getId().toString())).add(((DataSegment)segments.get(5 * i + j)).getId().toString());
            }
        }
        this.insertUsedSegments((Set<DataSegment>)ImmutableSet.copyOf(segments), upgradeMap);
        Map actual = this.coordinator.retrieveUpgradedToSegmentIds("DS", segments.stream().map(DataSegment::getId).map(SegmentId::toString).collect(Collectors.toSet()));
        Assert.assertEquals((long)500L, (long)actual.size());
        Assert.assertEquals(expected, (Object)actual);
    }

    @Test
    public void testRetrieveUsedSegmentsForSegmentAllocation() {
        String datasource = "DS";
        ImmutableMap loadspec = ImmutableMap.of((Object)"loadSpec", (Object)"loadSpec");
        ImmutableList dimensions = ImmutableList.of((Object)"dim1", (Object)"dim2");
        ImmutableList metrics = ImmutableList.of((Object)"metric1", (Object)"metric2");
        int numSegmentsPerInterval = 100;
        Interval month = Intervals.of((String)"2024-10-01/2024-11-01");
        Interval year = Intervals.of((String)"2024/2025");
        Interval overlappingDay = Intervals.of((String)"2024-10-01/2024-10-02");
        Interval nonOverlappingDay = Intervals.of((String)"2024-01-01/2024-01-02");
        ImmutableList intervals = ImmutableList.of((Object)month, (Object)year, (Object)overlappingDay, (Object)nonOverlappingDay);
        ImmutableList versions = ImmutableList.of((Object)"v0", (Object)"v1", (Object)"v2", (Object)"v2");
        for (int i = 0; i < 4; ++i) {
            HashSet<DataSegment> nextSegments = new HashSet<DataSegment>();
            DataSegment firstSegment = new DataSegment("DS", (Interval)intervals.get(i), (String)versions.get(i), (Map)loadspec, (List)dimensions, (List)metrics, (ShardSpec)new DimensionRangeShardSpec((List)dimensions, null, null, 0, Integer.valueOf(1)), Integer.valueOf(0), 100L);
            this.coordinator.commitSegments(Set.of(firstSegment), null);
            for (int j = 1; j < 100; ++j) {
                nextSegments.add(new DataSegment("DS", (Interval)intervals.get(i), (String)versions.get(i), (Map)loadspec, (List)dimensions, (List)metrics, (ShardSpec)new NumberedShardSpec(j, 0), Integer.valueOf(0), 100L));
            }
            this.coordinator.commitSegments(nextSegments, null);
        }
        HashSet<SegmentIdWithShardSpec> expected = new HashSet<SegmentIdWithShardSpec>();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 100; ++j) {
                expected.add(new SegmentIdWithShardSpec("DS", (Interval)intervals.get(i), (String)versions.get(i), (ShardSpec)new NumberedShardSpec(j, 1)));
            }
        }
        Set observed = (Set)this.transactionFactory.inReadWriteDatasourceTransaction("DS", transaction -> this.coordinator.retrieveUsedSegmentsForAllocation(transaction, "DS", month).stream().map(SegmentIdWithShardSpec::fromDataSegment).collect(Collectors.toSet()));
        Assert.assertEquals(expected, (Object)observed);
    }

    @Test
    public void testCachedTransaction_cannotReadWhatItWrites() {
        Assume.assumeTrue((boolean)this.isCacheEnabled());
        this.transactionFactory.inReadWriteDatasourceTransaction("wiki", transaction -> {
            DataSegmentPlus wikiSegment = CreateDataSegments.ofDatasource("wiki").updatedNow().markUsed().asPlus();
            Assert.assertEquals((long)1L, (long)transaction.insertSegments(Set.of(wikiSegment)));
            Assert.assertNull((Object)transaction.findUsedSegment(wikiSegment.getDataSegment().getId()));
            Assert.assertEquals((Object)wikiSegment.getDataSegment(), (Object)transaction.findSegment(wikiSegment.getDataSegment().getId()));
            return 0;
        });
        this.emitter.verifyValue("segment/metadataCache/transactions/readWrite", (Number)1L);
    }

    @Test
    public void testReadOperation_usesCache_ifSynced() {
        Assume.assumeTrue((boolean)this.isCacheEnabled());
        Assert.assertTrue((boolean)this.segmentMetadataCache.isSyncedForRead());
        this.insertUsedSegments(Set.of(this.defaultSegment), Map.of());
        Supplier<Set> retrieveAction = () -> this.coordinator.retrieveAllUsedSegments(this.defaultSegment.getDataSource(), Segments.INCLUDING_OVERSHADOWED);
        Assert.assertTrue((boolean)retrieveAction.get().isEmpty());
        this.refreshCache();
        Assert.assertEquals(Set.of(this.defaultSegment), (Object)retrieveAction.get());
        this.emitter.verifyEmitted("segment/metadataCache/transactions/readOnly", 2);
    }

    @Test
    public void testReadOperation_doesNotUseCache_ifNotSynced() {
        Assume.assumeTrue((boolean)this.isCacheEnabled());
        this.segmentMetadataCache.stopBeingLeader();
        Assert.assertFalse((boolean)this.segmentMetadataCache.isSyncedForRead());
        Supplier<Set> retrieveAction = () -> this.coordinator.retrieveAllUsedSegments(this.defaultSegment.getDataSource(), Segments.INCLUDING_OVERSHADOWED);
        this.insertUsedSegments(Set.of(this.defaultSegment), Map.of());
        Assert.assertEquals(Set.of(this.defaultSegment), (Object)retrieveAction.get());
        this.emitter.verifyNotEmitted("segment/metadataCache/transactions/readOnly");
        this.segmentMetadataCache.becomeLeader();
        Assert.assertFalse((boolean)this.segmentMetadataCache.isSyncedForRead());
        Assert.assertEquals(Set.of(this.defaultSegment), (Object)retrieveAction.get());
        this.emitter.verifyNotEmitted("segment/metadataCache/transactions/readOnly");
        this.refreshCache();
        this.refreshCache();
        Assert.assertTrue((boolean)this.segmentMetadataCache.isSyncedForRead());
        Assert.assertEquals(Set.of(this.defaultSegment), (Object)retrieveAction.get());
        this.emitter.verifyValue("segment/metadataCache/transactions/readOnly", (Number)1L);
    }

    @Test
    public void testWriteOperation_alwaysUsesCache_inModeIfSynced() {
        Assume.assumeTrue((this.cacheMode == SegmentMetadataCache.UsageMode.IF_SYNCED ? 1 : 0) != 0);
        this.segmentMetadataCache.stopBeingLeader();
        this.segmentMetadataCache.becomeLeader();
        Assert.assertTrue((boolean)this.segmentMetadataCache.isEnabled());
        Assert.assertFalse((boolean)this.segmentMetadataCache.isSyncedForRead());
        Supplier<Set> writeAction = () -> this.coordinator.commitSegments(Set.of(this.defaultSegment), null);
        Assert.assertEquals(Set.of(this.defaultSegment), (Object)writeAction.get());
        this.emitter.verifyValue("segment/metadataCache/transactions/writeOnly", (Number)1L);
        this.refreshCache();
        this.refreshCache();
        Assert.assertTrue((boolean)this.segmentMetadataCache.isSyncedForRead());
        Assert.assertTrue((boolean)writeAction.get().isEmpty());
        this.emitter.verifyValue("segment/metadataCache/transactions/readWrite", (Number)1L);
    }

    private SegmentIdWithShardSpec allocatePendingSegment(String datasource, String sequenceName, String previousSegmentId, Interval interval, PartialShardSpec partialShardSpec, String maxVersion, boolean skipSegmentLineageCheck, String taskAllocatorId) {
        return this.coordinator.allocatePendingSegment(datasource, interval, skipSegmentLineageCheck, new SegmentCreateRequest(sequenceName, previousSegmentId, maxVersion, partialShardSpec, taskAllocatorId));
    }

    private int insertPendingSegments(String dataSource, List<PendingSegmentRecord> pendingSegments, boolean skipLineageCheck) {
        return (Integer)this.transactionFactory.inReadWriteDatasourceTransaction(dataSource, transaction -> transaction.insertPendingSegments(pendingSegments, skipLineageCheck));
    }

    private void insertUsedSegments(Set<DataSegment> segments, Map<String, String> upgradedFromSegmentIdMap) {
        String table = ((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getSegmentsTable();
        IndexerSQLMetadataStorageCoordinatorTest.insertUsedSegments(segments, upgradedFromSegmentIdMap, (SQLMetadataConnector)this.derbyConnector, table, this.mapper);
    }
}

