/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import org.apache.druid.discovery.DruidLeaderSelector;
import org.apache.druid.indexing.overlord.DataSourceMetadata;
import org.apache.druid.indexing.overlord.SegmentPublishResult;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.metadata.IndexerSQLMetadataStorageCoordinator;
import org.apache.druid.metadata.IndexerSqlMetadataStorageCoordinatorTestBase;
import org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.druid.metadata.ReplaceTaskLock;
import org.apache.druid.metadata.SQLMetadataConnector;
import org.apache.druid.metadata.TestDerbyConnector;
import org.apache.druid.metadata.segment.SegmentMetadataTransaction;
import org.apache.druid.metadata.segment.SegmentMetadataTransactionFactory;
import org.apache.druid.metadata.segment.SqlSegmentMetadataTransactionFactory;
import org.apache.druid.metadata.segment.cache.NoopSegmentMetadataCache;
import org.apache.druid.metadata.segment.cache.SegmentMetadataCache;
import org.apache.druid.segment.SchemaPayload;
import org.apache.druid.segment.SchemaPayloadPlus;
import org.apache.druid.segment.SegmentSchemaMapping;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.metadata.CentralizedDatasourceSchemaConfig;
import org.apache.druid.segment.metadata.FingerprintGenerator;
import org.apache.druid.segment.metadata.SegmentSchemaManager;
import org.apache.druid.segment.metadata.SegmentSchemaTestUtils;
import org.apache.druid.server.coordinator.simulate.TestDruidLeaderSelector;
import org.apache.druid.server.metrics.NoopServiceEmitter;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.HashBasedNumberedShardSpec;
import org.apache.druid.timeline.partition.LinearShardSpec;
import org.apache.druid.timeline.partition.NumberedShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class IndexerSqlMetadataStorageCoordinatorSchemaPersistenceTest
extends IndexerSqlMetadataStorageCoordinatorTestBase {
    @Rule
    public final TestDerbyConnector.DerbyConnectorRule derbyConnectorRule = new TestDerbyConnector.DerbyConnectorRule(CentralizedDatasourceSchemaConfig.create((boolean)true));

    @Before
    public void setUp() {
        this.derbyConnector = this.derbyConnectorRule.getConnector();
        this.mapper.registerSubtypes(new Class[]{LinearShardSpec.class, NumberedShardSpec.class, HashBasedNumberedShardSpec.class});
        this.derbyConnector.createDataSourceTable();
        this.derbyConnector.createTaskTables();
        this.derbyConnector.createSegmentSchemasTable();
        this.derbyConnector.createSegmentTable();
        this.derbyConnector.createUpgradeSegmentsTable();
        this.derbyConnector.createPendingSegmentsTable();
        this.metadataUpdateCounter.set(0L);
        this.segmentTableDropUpdateCounter.set(0L);
        this.fingerprintGenerator = new FingerprintGenerator(this.mapper);
        this.segmentSchemaManager = new SegmentSchemaManager((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get(), this.mapper, (SQLMetadataConnector)this.derbyConnector);
        this.segmentSchemaTestUtils = new SegmentSchemaTestUtils(this.derbyConnectorRule, this.derbyConnector, this.mapper);
        CentralizedDatasourceSchemaConfig centralizedDatasourceSchemaConfig = new CentralizedDatasourceSchemaConfig();
        centralizedDatasourceSchemaConfig.setEnabled(true);
        SqlSegmentMetadataTransactionFactory transactionFactory = new SqlSegmentMetadataTransactionFactory(this.mapper, (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get(), (SQLMetadataConnector)this.derbyConnector, (DruidLeaderSelector)new TestDruidLeaderSelector(), (SegmentMetadataCache)NoopSegmentMetadataCache.instance(), (ServiceEmitter)NoopServiceEmitter.instance());
        this.coordinator = new IndexerSQLMetadataStorageCoordinator((SegmentMetadataTransactionFactory)transactionFactory, this.mapper, (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get(), (SQLMetadataConnector)this.derbyConnector, this.segmentSchemaManager, centralizedDatasourceSchemaConfig){

            protected SegmentPublishResult updateDataSourceMetadataWithHandle(SegmentMetadataTransaction transaction, String dataSource, DataSourceMetadata startMetadata, DataSourceMetadata endMetadata) throws IOException {
                IndexerSqlMetadataStorageCoordinatorSchemaPersistenceTest.this.metadataUpdateCounter.getAndIncrement();
                return super.updateDataSourceMetadataWithHandle(transaction, dataSource, startMetadata, endMetadata);
            }
        };
    }

    @Test
    public void testCommitAppendSegments() {
        DataSegment segment;
        int i;
        String v1 = "2023-01-01";
        String v2 = "2023-01-02";
        String v3 = "2023-01-03";
        String lockVersion = "2024-01-01";
        String replaceTaskId = "replaceTask1";
        ReplaceTaskLock replaceLock = new ReplaceTaskLock("replaceTask1", Intervals.of((String)"2023-01-01/2023-01-03"), "2024-01-01");
        HashSet<DataSegment> appendSegments = new HashSet<DataSegment>();
        SegmentSchemaMapping segmentSchemaMapping = new SegmentSchemaMapping(1);
        HashSet<DataSegment> expectedSegmentsToUpgrade = new HashSet<DataSegment>();
        Random random = new Random(5L);
        HashMap<String, Pair<SchemaPayload, Integer>> segmentIdSchemaMap = new HashMap<String, Pair<SchemaPayload, Integer>>();
        for (i = 0; i < 10; ++i) {
            segment = this.createSegment(Intervals.of((String)"2023-01-01/2023-01-02"), "2023-01-01", (ShardSpec)new LinearShardSpec(Integer.valueOf(i)));
            appendSegments.add(segment);
            expectedSegmentsToUpgrade.add(segment);
            int randomNum = random.nextInt();
            RowSignature rowSignature = RowSignature.builder().add("c" + randomNum, ColumnType.FLOAT).build();
            SchemaPayload schemaPayload = new SchemaPayload(rowSignature);
            segmentSchemaMapping.addSchema(segment.getId(), new SchemaPayloadPlus(schemaPayload, Long.valueOf(randomNum)), this.fingerprintGenerator.generateFingerprint(schemaPayload, segment.getDataSource(), 1));
            segmentIdSchemaMap.put(segment.getId().toString(), (Pair<SchemaPayload, Integer>)Pair.of((Object)schemaPayload, (Object)randomNum));
        }
        for (i = 0; i < 10; ++i) {
            segment = this.createSegment(Intervals.of((String)"2023-01-02/2023-01-03"), "2023-01-02", (ShardSpec)new LinearShardSpec(Integer.valueOf(i)));
            appendSegments.add(segment);
            expectedSegmentsToUpgrade.add(segment);
        }
        for (i = 0; i < 10; ++i) {
            segment = this.createSegment(Intervals.of((String)"2023-01-03/2023-01-04"), "2023-01-03", (ShardSpec)new LinearShardSpec(Integer.valueOf(i)));
            appendSegments.add(segment);
        }
        Map<DataSegment, ReplaceTaskLock> segmentToReplaceLock = expectedSegmentsToUpgrade.stream().collect(Collectors.toMap(s -> s, s -> replaceLock));
        SegmentPublishResult commitResult = this.coordinator.commitAppendSegments(appendSegments, segmentToReplaceLock, "append", segmentSchemaMapping);
        Assert.assertTrue((boolean)commitResult.isSuccess());
        Assert.assertEquals(appendSegments, (Object)commitResult.getSegments());
        Assert.assertEquals(appendSegments, (Object)ImmutableSet.copyOf(this.retrieveUsedSegments((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get())));
        this.segmentSchemaTestUtils.verifySegmentSchema(segmentIdSchemaMap);
        Set expectedUpgradeSegmentIds = expectedSegmentsToUpgrade.stream().map(s -> s.getId().toString()).collect(Collectors.toSet());
        Map<String, String> observedSegmentToLock = this.getSegmentsCommittedDuringReplaceTask("replaceTask1", (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get());
        Assert.assertEquals(expectedUpgradeSegmentIds, observedSegmentToLock.keySet());
        HashSet<String> observedLockVersions = new HashSet<String>(observedSegmentToLock.values());
        Assert.assertEquals((long)1L, (long)observedLockVersions.size());
        Assert.assertEquals((Object)replaceLock.getVersion(), (Object)Iterables.getOnlyElement(observedLockVersions));
    }

    @Test
    public void testAnnounceHistoricalSegments() throws IOException {
        HashSet<DataSegment> segments = new HashSet<DataSegment>();
        SegmentSchemaMapping segmentSchemaMapping = new SegmentSchemaMapping(1);
        ThreadLocalRandom random = ThreadLocalRandom.current();
        HashMap<String, Pair<SchemaPayload, Integer>> segmentIdSchemaMap = new HashMap<String, Pair<SchemaPayload, Integer>>();
        for (int i = 0; i < 105; ++i) {
            DataSegment segment2 = new DataSegment("fooDataSource", Intervals.of((String)"2015-01-01T00Z/2015-01-02T00Z"), "version", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new LinearShardSpec(Integer.valueOf(i)), Integer.valueOf(9), 100L);
            segments.add(segment2);
            int randomNum = ((Random)random).nextInt();
            RowSignature rowSignature = RowSignature.builder().add("c" + randomNum, ColumnType.FLOAT).build();
            SchemaPayload schemaPayload = new SchemaPayload(rowSignature);
            segmentIdSchemaMap.put(segment2.getId().toString(), (Pair<SchemaPayload, Integer>)Pair.of((Object)schemaPayload, (Object)randomNum));
            segmentSchemaMapping.addSchema(segment2.getId(), new SchemaPayloadPlus(schemaPayload, Long.valueOf(randomNum)), this.fingerprintGenerator.generateFingerprint(schemaPayload, segment2.getDataSource(), 1));
        }
        this.coordinator.commitSegments(segments, segmentSchemaMapping);
        for (DataSegment segment2 : segments) {
            Assert.assertArrayEquals((byte[])this.mapper.writeValueAsString((Object)segment2).getBytes(StandardCharsets.UTF_8), (byte[])this.derbyConnector.lookup(((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getSegmentsTable(), "id", "payload", segment2.getId().toString()));
        }
        List segmentIds = segments.stream().map(segment -> segment.getId().toString()).sorted(Comparator.naturalOrder()).collect(Collectors.toList());
        Assert.assertEquals(segmentIds, this.retrieveUsedSegmentIds((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()));
        Assert.assertEquals((long)0L, (long)this.metadataUpdateCounter.get());
        this.segmentSchemaTestUtils.verifySegmentSchema(segmentIdSchemaMap);
    }

    @Test
    public void testSchemaPermutation() throws JsonProcessingException {
        HashSet<DataSegment> segments = new HashSet<DataSegment>();
        SegmentSchemaMapping segmentSchemaMapping = new SegmentSchemaMapping(1);
        HashMap<String, Pair<SchemaPayload, Integer>> segmentIdSchemaMap = new HashMap<String, Pair<SchemaPayload, Integer>>();
        RowSignature originalOrder = RowSignature.builder().add("d7", ColumnType.LONG_ARRAY).add("b1", ColumnType.FLOAT).add("a5", ColumnType.DOUBLE).build();
        List<List> permutations = Arrays.asList(Arrays.asList("d7", "a5", "b1"), Arrays.asList("a5", "b1", "d7"), Arrays.asList("a5", "d7", "b1"), Arrays.asList("b1", "d7", "a5"), Arrays.asList("b1", "a5", "d7"), Arrays.asList("d7", "a5", "b1"));
        boolean first = true;
        ThreadLocalRandom random = ThreadLocalRandom.current();
        ThreadLocalRandom permutationRandom = ThreadLocalRandom.current();
        for (int i = 0; i < 105; ++i) {
            RowSignature rowSignature;
            DataSegment segment2 = new DataSegment("fooDataSource", Intervals.of((String)"2015-01-01T00Z/2015-01-02T00Z"), "version", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new LinearShardSpec(Integer.valueOf(i)), Integer.valueOf(9), 100L);
            segments.add(segment2);
            int randomNum = ((Random)random).nextInt();
            if (first) {
                rowSignature = originalOrder;
            } else {
                RowSignature.Builder builder = RowSignature.builder();
                List columns = permutations.get(((Random)permutationRandom).nextInt(permutations.size()));
                for (String column : columns) {
                    builder.add(column, (ColumnType)originalOrder.getColumnType(column).get());
                }
                rowSignature = builder.build();
            }
            SchemaPayload schemaPayload = new SchemaPayload(rowSignature);
            segmentIdSchemaMap.put(segment2.getId().toString(), (Pair<SchemaPayload, Integer>)Pair.of((Object)new SchemaPayload(originalOrder), (Object)randomNum));
            segmentSchemaMapping.addSchema(segment2.getId(), new SchemaPayloadPlus(schemaPayload, Long.valueOf(randomNum)), this.fingerprintGenerator.generateFingerprint(schemaPayload, segment2.getDataSource(), 1));
            if (!first) continue;
            this.coordinator.commitSegments(segments, segmentSchemaMapping);
            first = false;
        }
        this.coordinator.commitSegments(segments, segmentSchemaMapping);
        for (DataSegment segment2 : segments) {
            Assert.assertArrayEquals((byte[])this.mapper.writeValueAsString((Object)segment2).getBytes(StandardCharsets.UTF_8), (byte[])this.derbyConnector.lookup(((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getSegmentsTable(), "id", "payload", segment2.getId().toString()));
        }
        List segmentIds = segments.stream().map(segment -> segment.getId().toString()).sorted(Comparator.naturalOrder()).collect(Collectors.toList());
        Assert.assertEquals(segmentIds, this.retrieveUsedSegmentIds((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()));
        Assert.assertEquals((long)0L, (long)this.metadataUpdateCounter.get());
        this.segmentSchemaTestUtils.verifySegmentSchema(segmentIdSchemaMap);
    }

    @Test
    public void testAnnounceHistoricalSegments_schemaExists() throws IOException {
        HashSet<DataSegment> segments = new HashSet<DataSegment>();
        SegmentSchemaMapping segmentSchemaMapping = new SegmentSchemaMapping(1);
        ThreadLocalRandom random = ThreadLocalRandom.current();
        HashMap<String, Pair<SchemaPayload, Integer>> segmentIdSchemaMap = new HashMap<String, Pair<SchemaPayload, Integer>>();
        HashMap<String, SchemaPayload> schemaPayloadMapToPerist = new HashMap<String, SchemaPayload>();
        for (int i = 0; i < 105; ++i) {
            DataSegment segment2 = new DataSegment("fooDataSource", Intervals.of((String)"2015-01-01T00Z/2015-01-02T00Z"), "version", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new LinearShardSpec(Integer.valueOf(i)), Integer.valueOf(9), 100L);
            segments.add(segment2);
            int randomNum = ((Random)random).nextInt();
            RowSignature rowSignature = RowSignature.builder().add("c" + randomNum, ColumnType.FLOAT).build();
            SchemaPayload schemaPayload = new SchemaPayload(rowSignature);
            segmentIdSchemaMap.put(segment2.getId().toString(), (Pair<SchemaPayload, Integer>)Pair.of((Object)schemaPayload, (Object)randomNum));
            String fingerprint = this.fingerprintGenerator.generateFingerprint(schemaPayload, segment2.getDataSource(), 1);
            segmentSchemaMapping.addSchema(segment2.getId(), new SchemaPayloadPlus(schemaPayload, Long.valueOf(randomNum)), fingerprint);
            schemaPayloadMapToPerist.put(fingerprint, schemaPayload);
        }
        this.derbyConnector.retryWithHandle(handle -> {
            this.segmentSchemaManager.persistSegmentSchema(handle, "fooDataSource", 1, schemaPayloadMapToPerist);
            return null;
        });
        this.coordinator.commitSegments(segments, segmentSchemaMapping);
        for (DataSegment segment2 : segments) {
            Assert.assertArrayEquals((byte[])this.mapper.writeValueAsString((Object)segment2).getBytes(StandardCharsets.UTF_8), (byte[])this.derbyConnector.lookup(((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getSegmentsTable(), "id", "payload", segment2.getId().toString()));
        }
        List segmentIds = segments.stream().map(segment -> segment.getId().toString()).sorted(Comparator.naturalOrder()).collect(Collectors.toList());
        Assert.assertEquals(segmentIds, this.retrieveUsedSegmentIds((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()));
        Assert.assertEquals((long)0L, (long)this.metadataUpdateCounter.get());
        this.segmentSchemaTestUtils.verifySegmentSchema(segmentIdSchemaMap);
    }

    @Test
    public void testCommitReplaceSegments() {
        ReplaceTaskLock replaceLock = new ReplaceTaskLock("g1", Intervals.of((String)"2023-01-01/2023-02-01"), "2023-02-01");
        HashSet<DataSegment> segmentsAppendedWithReplaceLock = new HashSet<DataSegment>();
        HashMap<DataSegment, ReplaceTaskLock> appendedSegmentToReplaceLockMap = new HashMap<DataSegment, ReplaceTaskLock>();
        HashMap<String, Pair<SchemaPayload, Integer>> segmentIdSchemaMap = new HashMap<String, Pair<SchemaPayload, Integer>>();
        HashMap<String, Pair<String, Long>> segmentStatsMap = new HashMap<String, Pair<String, Long>>();
        Random random = new Random(5L);
        HashMap<String, SchemaPayload> schemaPayloadMap = new HashMap<String, SchemaPayload>();
        for (int i = 1; i < 9; ++i) {
            DataSegment segment = new DataSegment("foo", Intervals.of((String)("2023-01-0" + i + "/2023-01-0" + (i + 1))), "2023-01-0" + i, (Map)ImmutableMap.of((Object)"path", (Object)("a-" + i)), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new LinearShardSpec(Integer.valueOf(0)), Integer.valueOf(9), 100L);
            RowSignature rowSignature = RowSignature.builder().add("c6", ColumnType.FLOAT).build();
            SchemaPayload schemaPayload = new SchemaPayload(rowSignature);
            schemaPayloadMap.put(this.fingerprintGenerator.generateFingerprint(schemaPayload, segment.getDataSource(), 1), schemaPayload);
            segmentIdSchemaMap.put(segment.getId().toString(), Pair.of((Object)schemaPayload, (Object)6));
            segmentsAppendedWithReplaceLock.add(segment);
            appendedSegmentToReplaceLockMap.put(segment, replaceLock);
        }
        this.segmentSchemaTestUtils.insertSegmentSchema("foo", schemaPayloadMap, schemaPayloadMap.keySet());
        for (Map.Entry entry : segmentIdSchemaMap.entrySet()) {
            String segmentId = (String)entry.getKey();
            String fingerprint = this.fingerprintGenerator.generateFingerprint((SchemaPayload)((Pair)entry.getValue()).lhs, "foo", 1);
            long numRows = ((Integer)((Pair)entry.getValue()).rhs).intValue();
            segmentStatsMap.put(segmentId, (Pair<String, Long>)Pair.of((Object)fingerprint, (Object)numRows));
        }
        this.segmentSchemaTestUtils.insertUsedSegments(segmentsAppendedWithReplaceLock, segmentStatsMap);
        this.insertIntoUpgradeSegmentsTable(appendedSegmentToReplaceLockMap, (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get());
        SegmentSchemaMapping segmentSchemaMapping = new SegmentSchemaMapping(1);
        HashSet<DataSegment> replacingSegments = new HashSet<DataSegment>();
        for (int i = 1; i < 9; ++i) {
            DataSegment segment = new DataSegment("foo", Intervals.of((String)"2023-01-01/2023-02-01"), "2023-02-01", (Map)ImmutableMap.of((Object)"path", (Object)("b-" + i)), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new NumberedShardSpec(i, 9), Integer.valueOf(9), 100L);
            int randomNum = random.nextInt();
            RowSignature rowSignature = RowSignature.builder().add("c" + randomNum, ColumnType.FLOAT).build();
            SchemaPayload schemaPayload = new SchemaPayload(rowSignature);
            segmentSchemaMapping.addSchema(segment.getId(), new SchemaPayloadPlus(schemaPayload, Long.valueOf(randomNum)), this.fingerprintGenerator.generateFingerprint(schemaPayload, segment.getDataSource(), 1));
            segmentIdSchemaMap.put(segment.getId().toString(), Pair.of((Object)schemaPayload, (Object)randomNum));
            replacingSegments.add(segment);
        }
        this.coordinator.commitReplaceSegments(replacingSegments, (Set)ImmutableSet.of((Object)replaceLock), segmentSchemaMapping);
        Assert.assertEquals((long)(2L * (long)segmentsAppendedWithReplaceLock.size() + (long)replacingSegments.size()), (long)this.retrieveUsedSegmentIds((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()).size());
        HashSet<DataSegment> usedSegments = new HashSet<DataSegment>(this.retrieveUsedSegments((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()));
        Assert.assertTrue((boolean)usedSegments.containsAll(segmentsAppendedWithReplaceLock));
        usedSegments.removeAll(segmentsAppendedWithReplaceLock);
        Assert.assertTrue((boolean)usedSegments.containsAll(replacingSegments));
        usedSegments.removeAll(replacingSegments);
        Assert.assertEquals((long)segmentsAppendedWithReplaceLock.size(), (long)usedSegments.size());
        for (DataSegment segmentReplicaWithNewVersion : usedSegments) {
            boolean hasBeenCarriedForward = false;
            for (DataSegment appendedSegment : segmentsAppendedWithReplaceLock) {
                if (!appendedSegment.getLoadSpec().equals(segmentReplicaWithNewVersion.getLoadSpec())) continue;
                hasBeenCarriedForward = true;
                break;
            }
            RowSignature rowSignature = RowSignature.builder().add("c6", ColumnType.FLOAT).build();
            SchemaPayload schemaPayload = new SchemaPayload(rowSignature);
            segmentIdSchemaMap.put(segmentReplicaWithNewVersion.getId().toString(), (Pair<SchemaPayload, Integer>)Pair.of((Object)schemaPayload, (Object)6));
            Assert.assertTrue((boolean)hasBeenCarriedForward);
        }
        this.segmentSchemaTestUtils.verifySegmentSchema(segmentIdSchemaMap);
    }
}

