/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.druid.client.DataSourcesSnapshot;
import org.apache.druid.client.ImmutableDruidDataSource;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.druid.metadata.SQLMetadataConnector;
import org.apache.druid.metadata.SegmentsMetadataManagerConfig;
import org.apache.druid.metadata.SqlSegmentsMetadataManager;
import org.apache.druid.metadata.SqlSegmentsMetadataManagerTestBase;
import org.apache.druid.metadata.TestDerbyConnector;
import org.apache.druid.segment.SchemaPayload;
import org.apache.druid.segment.SchemaPayloadPlus;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.metadata.CentralizedDatasourceSchemaConfig;
import org.apache.druid.segment.metadata.FingerprintGenerator;
import org.apache.druid.segment.metadata.SegmentSchemaCache;
import org.apache.druid.segment.metadata.SegmentSchemaManager;
import org.apache.druid.server.metrics.NoopServiceEmitter;
import org.joda.time.Period;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class SqlSegmentsMetadataManagerSchemaPollTest
extends SqlSegmentsMetadataManagerTestBase {
    @Rule
    public final TestDerbyConnector.DerbyConnectorRule derbyConnectorRule = new TestDerbyConnector.DerbyConnectorRule(CentralizedDatasourceSchemaConfig.create((boolean)true));

    @Before
    public void setUp() throws Exception {
        this.connector = this.derbyConnectorRule.getConnector();
        SegmentsMetadataManagerConfig config = new SegmentsMetadataManagerConfig(Period.seconds((int)3), null);
        this.segmentSchemaCache = new SegmentSchemaCache((ServiceEmitter)new NoopServiceEmitter());
        this.segmentSchemaManager = new SegmentSchemaManager((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get(), this.jsonMapper, (SQLMetadataConnector)this.connector);
        this.sqlSegmentsMetadataManager = new SqlSegmentsMetadataManager(this.jsonMapper, Suppliers.ofInstance((Object)config), this.derbyConnectorRule.metadataTablesConfigSupplier(), (SQLMetadataConnector)this.connector, this.segmentSchemaCache, CentralizedDatasourceSchemaConfig.create(), (ServiceEmitter)NoopServiceEmitter.instance());
        this.sqlSegmentsMetadataManager.start();
        this.storageConfig = (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get();
        this.connector.createSegmentSchemasTable();
        this.connector.createSegmentTable();
        this.publishSegment(this.segment1);
        this.publishSegment(this.segment2);
    }

    @After
    public void teardown() {
        if (this.sqlSegmentsMetadataManager.isPollingDatabasePeriodically()) {
            this.sqlSegmentsMetadataManager.stopPollingDatabasePeriodically();
        }
        this.sqlSegmentsMetadataManager.stop();
    }

    @Test(timeout=60000L)
    public void testPollSegmentAndSchema() {
        ArrayList<SegmentSchemaManager.SegmentSchemaMetadataPlus> list = new ArrayList<SegmentSchemaManager.SegmentSchemaMetadataPlus>();
        FingerprintGenerator fingerprintGenerator = new FingerprintGenerator(this.jsonMapper);
        SchemaPayload payload1 = new SchemaPayload(RowSignature.builder().add("c1", ColumnType.FLOAT).build());
        SchemaPayloadPlus schemaMetadata1 = new SchemaPayloadPlus(payload1, Long.valueOf(20L));
        list.add(new SegmentSchemaManager.SegmentSchemaMetadataPlus(this.segment1.getId(), fingerprintGenerator.generateFingerprint(payload1, "wikipedia", 1), schemaMetadata1));
        SchemaPayload payload2 = new SchemaPayload(RowSignature.builder().add("c2", ColumnType.FLOAT).build());
        SchemaPayloadPlus schemaMetadata2 = new SchemaPayloadPlus(payload2, Long.valueOf(40L));
        list.add(new SegmentSchemaManager.SegmentSchemaMetadataPlus(this.segment2.getId(), fingerprintGenerator.generateFingerprint(payload2, "wikipedia", 1), schemaMetadata2));
        this.segmentSchemaManager.persistSchemaAndUpdateSegmentsTable("wikipedia", list, 1);
        CentralizedDatasourceSchemaConfig centralizedDatasourceSchemaConfig = new CentralizedDatasourceSchemaConfig();
        centralizedDatasourceSchemaConfig.setEnabled(true);
        this.config = new SegmentsMetadataManagerConfig(Period.seconds((int)3), null);
        this.sqlSegmentsMetadataManager = new SqlSegmentsMetadataManager(this.jsonMapper, Suppliers.ofInstance((Object)this.config), this.derbyConnectorRule.metadataTablesConfigSupplier(), (SQLMetadataConnector)this.connector, this.segmentSchemaCache, centralizedDatasourceSchemaConfig, (ServiceEmitter)NoopServiceEmitter.instance());
        this.sqlSegmentsMetadataManager.start();
        DataSourcesSnapshot dataSourcesSnapshot = this.sqlSegmentsMetadataManager.getDataSourcesSnapshot();
        Assert.assertNull((Object)dataSourcesSnapshot);
        Assert.assertFalse((boolean)this.segmentSchemaCache.getSchemaForSegment(this.segment1.getId()).isPresent());
        Assert.assertFalse((boolean)this.segmentSchemaCache.getSchemaForSegment(this.segment2.getId()).isPresent());
        Assert.assertFalse((boolean)this.segmentSchemaCache.isInitialized());
        this.sqlSegmentsMetadataManager.startPollingDatabasePeriodically();
        Assert.assertTrue((boolean)this.sqlSegmentsMetadataManager.isPollingDatabasePeriodically());
        this.sqlSegmentsMetadataManager.useLatestSnapshotIfWithinDelay();
        Assert.assertTrue((boolean)(this.sqlSegmentsMetadataManager.getLatestDatabasePoll() instanceof SqlSegmentsMetadataManager.PeriodicDatabasePoll));
        Assert.assertTrue((boolean)this.segmentSchemaCache.isInitialized());
        Assert.assertTrue((boolean)this.segmentSchemaCache.getSchemaForSegment(this.segment1.getId()).isPresent());
        Assert.assertTrue((boolean)this.segmentSchemaCache.getSchemaForSegment(this.segment2.getId()).isPresent());
        Assert.assertEquals((Object)schemaMetadata1, this.segmentSchemaCache.getSchemaForSegment(this.segment1.getId()).get());
        Assert.assertEquals((Object)schemaMetadata2, this.segmentSchemaCache.getSchemaForSegment(this.segment2.getId()).get());
        dataSourcesSnapshot = this.sqlSegmentsMetadataManager.getDataSourcesSnapshot();
        Assert.assertEquals((Object)ImmutableSet.of((Object)"wikipedia"), (Object)this.sqlSegmentsMetadataManager.retrieveAllDataSourceNames());
        Assert.assertEquals((Object)ImmutableList.of((Object)"wikipedia"), dataSourcesSnapshot.getDataSourcesWithAllUsedSegments().stream().map(ImmutableDruidDataSource::getName).collect(Collectors.toList()));
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.segment1, (Object)this.segment2), (Object)ImmutableSet.copyOf((Collection)dataSourcesSnapshot.getDataSource("wikipedia").getSegments()));
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.segment1, (Object)this.segment2), (Object)ImmutableSet.copyOf((Iterable)dataSourcesSnapshot.iterateAllUsedSegmentsInSnapshot()));
    }

    @Test
    public void testPollOnlyNewSchemaVersion() {
        ArrayList<SegmentSchemaManager.SegmentSchemaMetadataPlus> list = new ArrayList<SegmentSchemaManager.SegmentSchemaMetadataPlus>();
        FingerprintGenerator fingerprintGenerator = new FingerprintGenerator(this.jsonMapper);
        SchemaPayload payload1 = new SchemaPayload(RowSignature.builder().add("c1", ColumnType.FLOAT).build());
        SchemaPayloadPlus schemaMetadata1 = new SchemaPayloadPlus(payload1, Long.valueOf(20L));
        list.add(new SegmentSchemaManager.SegmentSchemaMetadataPlus(this.segment1.getId(), fingerprintGenerator.generateFingerprint(payload1, this.segment1.getDataSource(), 0), schemaMetadata1));
        SchemaPayload payload2 = new SchemaPayload(RowSignature.builder().add("c2", ColumnType.FLOAT).build());
        SchemaPayloadPlus schemaMetadata2 = new SchemaPayloadPlus(payload2, Long.valueOf(40L));
        list.add(new SegmentSchemaManager.SegmentSchemaMetadataPlus(this.segment2.getId(), fingerprintGenerator.generateFingerprint(payload2, this.segment2.getDataSource(), 0), schemaMetadata2));
        this.segmentSchemaManager.persistSchemaAndUpdateSegmentsTable("wikipedia", list, 0);
        CentralizedDatasourceSchemaConfig centralizedDatasourceSchemaConfig = new CentralizedDatasourceSchemaConfig();
        centralizedDatasourceSchemaConfig.setEnabled(true);
        this.config = new SegmentsMetadataManagerConfig(Period.seconds((int)3), null);
        this.sqlSegmentsMetadataManager = new SqlSegmentsMetadataManager(this.jsonMapper, Suppliers.ofInstance((Object)this.config), this.derbyConnectorRule.metadataTablesConfigSupplier(), (SQLMetadataConnector)this.connector, this.segmentSchemaCache, centralizedDatasourceSchemaConfig, (ServiceEmitter)NoopServiceEmitter.instance());
        this.sqlSegmentsMetadataManager.start();
        this.sqlSegmentsMetadataManager.poll();
        Assert.assertTrue((boolean)this.segmentSchemaCache.isInitialized());
        Assert.assertFalse((boolean)this.segmentSchemaCache.getSchemaForSegment(this.segment1.getId()).isPresent());
        Assert.assertFalse((boolean)this.segmentSchemaCache.getSchemaForSegment(this.segment2.getId()).isPresent());
        list.clear();
        list.add(new SegmentSchemaManager.SegmentSchemaMetadataPlus(this.segment1.getId(), fingerprintGenerator.generateFingerprint(payload1, this.segment1.getDataSource(), 1), schemaMetadata1));
        list.add(new SegmentSchemaManager.SegmentSchemaMetadataPlus(this.segment2.getId(), fingerprintGenerator.generateFingerprint(payload2, this.segment2.getDataSource(), 1), schemaMetadata2));
        this.segmentSchemaManager.persistSchemaAndUpdateSegmentsTable("wikipedia", list, 1);
        this.sqlSegmentsMetadataManager.poll();
        Assert.assertTrue((boolean)this.segmentSchemaCache.isInitialized());
        Assert.assertTrue((boolean)this.segmentSchemaCache.getSchemaForSegment(this.segment1.getId()).isPresent());
        Assert.assertTrue((boolean)this.segmentSchemaCache.getSchemaForSegment(this.segment2.getId()).isPresent());
    }
}

