/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.apache.druid.metadata.MetadataStorageConnectorConfig;
import org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.druid.metadata.NoopMetadataStorageProvider;
import org.apache.druid.metadata.PendingSegmentRecord;
import org.apache.druid.metadata.storage.derby.DerbyConnector;
import org.apache.druid.segment.metadata.CentralizedDatasourceSchemaConfig;
import org.apache.druid.segment.realtime.appenderator.SegmentIdWithShardSpec;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.rules.ExternalResource;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.PreparedBatch;
import org.skife.jdbi.v2.PreparedBatchPart;
import org.skife.jdbi.v2.exceptions.UnableToObtainConnectionException;

public class TestDerbyConnector
extends DerbyConnector {
    private final String jdbcUri;

    public TestDerbyConnector(Supplier<MetadataStorageConnectorConfig> config, Supplier<MetadataStorageTablesConfig> dbTables, CentralizedDatasourceSchemaConfig centralizedDatasourceSchemaConfig) {
        this(config, dbTables, "jdbc:derby:memory:druidTest" + TestDerbyConnector.dbSafeUUID(), centralizedDatasourceSchemaConfig);
    }

    public TestDerbyConnector(Supplier<MetadataStorageConnectorConfig> config, Supplier<MetadataStorageTablesConfig> dbTables) {
        this(config, dbTables, "jdbc:derby:memory:druidTest" + TestDerbyConnector.dbSafeUUID(), CentralizedDatasourceSchemaConfig.create());
    }

    protected TestDerbyConnector(Supplier<MetadataStorageConnectorConfig> config, Supplier<MetadataStorageTablesConfig> dbTables, String jdbcUri, CentralizedDatasourceSchemaConfig centralizedDatasourceSchemaConfig) {
        super(new NoopMetadataStorageProvider().get(), config, dbTables, new DBI(jdbcUri + ";create=true"), centralizedDatasourceSchemaConfig);
        this.jdbcUri = jdbcUri;
    }

    public void tearDown() {
        try {
            new DBI(this.jdbcUri + ";drop=true").open().close();
        }
        catch (UnableToObtainConnectionException e) {
            SQLException cause = (SQLException)e.getCause();
            Assert.assertEquals((String)StringUtils.format((String)"Derby not shutdown: [%s]", (Object[])new Object[]{cause.toString()}), (Object)"08006", (Object)cause.getSQLState());
        }
    }

    public static String dbSafeUUID() {
        return StringUtils.removeChar((String)UUID.randomUUID().toString(), (char)'-');
    }

    public String getJdbcUri() {
        return this.jdbcUri;
    }

    public static class DerbyConnectorRule5
    extends DerbyConnectorRule
    implements BeforeAllCallback,
    AfterAllCallback {
        public void beforeAll(ExtensionContext context) {
            this.before();
        }

        public void afterAll(ExtensionContext context) {
            this.after();
        }
    }

    public static class SegmentsTable {
        private final DerbyConnectorRule rule;

        private SegmentsTable(DerbyConnectorRule rule) {
            this.rule = rule;
        }

        public int update(String sqlFormat, Object ... args) {
            return (Integer)this.rule.getConnector().retryWithHandle(handle -> handle.update(StringUtils.format((String)sqlFormat, (Object[])new Object[]{this.getTableName()}), args));
        }

        public int updateUsedStatusLastUpdated(String segmentId, DateTime lastUpdatedTime) {
            return this.update("UPDATE %1$s SET USED_STATUS_LAST_UPDATED = ? WHERE ID = ?", lastUpdatedTime.toString(), segmentId);
        }

        public String getTableName() {
            return ((MetadataStorageTablesConfig)this.rule.metadataTablesConfigSupplier().get()).getSegmentsTable().toUpperCase(Locale.ENGLISH);
        }
    }

    public static class PendingSegmentsTable {
        private final DerbyConnectorRule rule;

        private PendingSegmentsTable(DerbyConnectorRule rule) {
            this.rule = rule;
        }

        public int insert(List<PendingSegmentRecord> records, boolean skipSegmentLineageCheck, ObjectMapper objectMapper) {
            TestDerbyConnector connector = this.rule.getConnector();
            String sql = StringUtils.format((String)"INSERT INTO %1$s (id, dataSource, created_date, start, %2$send%2$s, sequence_name, sequence_prev_id, sequence_name_prev_id_sha1, payload, task_allocator_id, upgraded_from_segment_id) VALUES (:id, :dataSource, :created_date, :start, :end, :sequence_name, :sequence_prev_id, :sequence_name_prev_id_sha1, :payload, :task_allocator_id, :upgraded_from_segment_id)", (Object[])new Object[]{((MetadataStorageTablesConfig)this.rule.metadataTablesConfigSupplier().get()).getPendingSegmentsTable(), connector.getQuoteString()});
            return (Integer)connector.retryWithHandle(handle -> {
                PreparedBatch insertBatch = handle.prepareBatch(sql);
                HashSet<SegmentIdWithShardSpec> processedSegmentIds = new HashSet<SegmentIdWithShardSpec>();
                for (PendingSegmentRecord pendingSegment : records) {
                    SegmentIdWithShardSpec segmentId = pendingSegment.getId();
                    if (processedSegmentIds.contains(segmentId)) continue;
                    Interval interval = segmentId.getInterval();
                    ((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)insertBatch.add().bind("id", segmentId.toString())).bind("dataSource", segmentId.getDataSource())).bind("created_date", pendingSegment.getCreatedDate().toString())).bind("start", interval.getStart().toString())).bind("end", interval.getEnd().toString())).bind("sequence_name", pendingSegment.getSequenceName())).bind("sequence_prev_id", pendingSegment.getSequencePrevId())).bind("sequence_name_prev_id_sha1", pendingSegment.computeSequenceNamePrevIdSha1(skipSegmentLineageCheck))).bind("payload", JacksonUtils.toBytes((ObjectMapper)objectMapper, (Object)segmentId))).bind("task_allocator_id", pendingSegment.getTaskAllocatorId())).bind("upgraded_from_segment_id", pendingSegment.getUpgradedFromSegmentId());
                    processedSegmentIds.add(segmentId);
                }
                int[] updated = insertBatch.execute();
                return Arrays.stream(updated).sum();
            });
        }
    }

    public static class DerbyConnectorRule
    extends ExternalResource {
        private TestDerbyConnector connector;
        private final Supplier<MetadataStorageTablesConfig> dbTables;
        private final MetadataStorageConnectorConfig connectorConfig;
        private final CentralizedDatasourceSchemaConfig centralizedDatasourceSchemaConfig;

        public DerbyConnectorRule() {
            this("druidTest" + TestDerbyConnector.dbSafeUUID());
        }

        public DerbyConnectorRule(CentralizedDatasourceSchemaConfig centralizedDatasourceSchemaConfig) {
            this((Supplier<MetadataStorageTablesConfig>)Suppliers.ofInstance((Object)MetadataStorageTablesConfig.fromBase((String)("druidTest" + TestDerbyConnector.dbSafeUUID()))), centralizedDatasourceSchemaConfig);
        }

        private DerbyConnectorRule(String defaultBase) {
            this((Supplier<MetadataStorageTablesConfig>)Suppliers.ofInstance((Object)MetadataStorageTablesConfig.fromBase((String)defaultBase)), CentralizedDatasourceSchemaConfig.create());
        }

        public DerbyConnectorRule(Supplier<MetadataStorageTablesConfig> dbTables, CentralizedDatasourceSchemaConfig centralizedDatasourceSchemaConfig) {
            this.dbTables = dbTables;
            this.connectorConfig = new MetadataStorageConnectorConfig(){

                public String getConnectURI() {
                    return connector.getJdbcUri();
                }
            };
            this.centralizedDatasourceSchemaConfig = centralizedDatasourceSchemaConfig;
        }

        protected void before() {
            this.connector = new TestDerbyConnector((Supplier<MetadataStorageConnectorConfig>)Suppliers.ofInstance((Object)this.connectorConfig), this.dbTables, this.centralizedDatasourceSchemaConfig);
            this.connector.getDBI().open().close();
        }

        protected void after() {
            this.connector.tearDown();
        }

        public TestDerbyConnector getConnector() {
            return this.connector;
        }

        public MetadataStorageConnectorConfig getMetadataConnectorConfig() {
            return this.connectorConfig;
        }

        public Supplier<MetadataStorageTablesConfig> metadataTablesConfigSupplier() {
            return this.dbTables;
        }

        public SegmentsTable segments() {
            return new SegmentsTable(this);
        }

        public PendingSegmentsTable pendingSegments() {
            return new PendingSegmentsTable(this);
        }
    }
}

