/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.lookup;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Map;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.query.lookup.LookupExtractorFactory;
import org.apache.druid.query.lookup.MapLookupExtractorFactory;
import org.junit.Assert;
import org.junit.Test;

public class MapLookupExtractorFactoryTest {
    private static final String KEY = "foo";
    private static final String VALUE = "bar";
    private static final MapLookupExtractorFactory FACTORY = new MapLookupExtractorFactory((Map)ImmutableMap.of((Object)"foo", (Object)"bar"), true);

    @Test
    public void testSimpleExtraction() {
        Assert.assertEquals((Object)FACTORY.get().apply(KEY), (Object)VALUE);
        Assert.assertTrue((boolean)FACTORY.get().isOneToOne());
    }

    @Test
    public void testReplaces() {
        Assert.assertFalse((boolean)FACTORY.replaces((LookupExtractorFactory)FACTORY));
        Assert.assertFalse((boolean)FACTORY.replaces((LookupExtractorFactory)new MapLookupExtractorFactory((Map)ImmutableMap.of((Object)KEY, (Object)VALUE), true)));
        Assert.assertTrue((boolean)FACTORY.replaces((LookupExtractorFactory)new MapLookupExtractorFactory((Map)ImmutableMap.of((Object)KEY, (Object)VALUE), false)));
        Assert.assertTrue((boolean)FACTORY.replaces((LookupExtractorFactory)new MapLookupExtractorFactory((Map)ImmutableMap.of((Object)"foo1", (Object)VALUE), true)));
        Assert.assertTrue((boolean)FACTORY.replaces((LookupExtractorFactory)new MapLookupExtractorFactory((Map)ImmutableMap.of((Object)KEY, (Object)"bar1"), true)));
        Assert.assertTrue((boolean)FACTORY.replaces(null));
    }

    @Test
    public void testSerDeserMapLookupExtractorFactory() throws IOException {
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        mapper.registerSubtypes(new Class[]{MapLookupExtractorFactory.class});
        MapLookupExtractorFactory lookupExtractorFactory = new MapLookupExtractorFactory((Map)ImmutableMap.of((Object)"key", (Object)"value"), true);
        Assert.assertEquals((Object)lookupExtractorFactory, (Object)mapper.readerFor(LookupExtractorFactory.class).readValue(mapper.writeValueAsString((Object)lookupExtractorFactory)));
    }
}

