/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.indexing;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.ValueInstantiationException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.JSONParseSpec;
import org.apache.druid.data.input.impl.LongDimensionSchema;
import org.apache.druid.data.input.impl.ParseSpec;
import org.apache.druid.data.input.impl.StringDimensionSchema;
import org.apache.druid.data.input.impl.StringInputRowParser;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.DruidExceptionMatcher;
import org.apache.druid.indexer.granularity.ArbitraryGranularitySpec;
import org.apache.druid.indexer.granularity.GranularitySpec;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.DurationGranularity;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.indexing.CombinedDataSchema;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.segment.indexing.TestModifiedDataSchema;
import org.apache.druid.segment.transform.ExpressionTransform;
import org.apache.druid.segment.transform.TransformSpec;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class DataSchemaTest
extends InitializedNullHandlingTest {
    private static ArbitraryGranularitySpec ARBITRARY_GRANULARITY = new ArbitraryGranularitySpec(Granularities.DAY, (List)ImmutableList.of((Object)Intervals.of((String)"2014/2015")));
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private final ObjectMapper jsonMapper = TestHelper.makeJsonMapper();

    @Test
    public void testDefaultExclusions() {
        Map parser = (Map)this.jsonMapper.convertValue((Object)new StringInputRowParser((ParseSpec)new JSONParseSpec(new TimestampSpec("time", "auto", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"dimB", (Object)"dimA"))), null, null, null), null), JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT);
        DataSchema schema = DataSchema.builder().withDataSource("alpha123..*~!@#&%^&*()-+ \u0420\u043e\u0441\u0441\u0438\u044f\\ \ud55c\uad6d \u4e2d\u56fd!").withParserMap(parser).withAggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("metric1", "col1"), new DoubleSumAggregatorFactory("metric2", "col2")}).withGranularity((GranularitySpec)ARBITRARY_GRANULARITY).withObjectMapper(this.jsonMapper).build();
        Assert.assertEquals((Object)ImmutableSet.of((Object)"__time", (Object)"time", (Object)"col1", (Object)"col2", (Object)"metric1", (Object)"metric2", (Object[])new String[0]), (Object)schema.getDimensionsSpec().getDimensionExclusions());
    }

    @Test
    public void testExplicitInclude() {
        Map parser = (Map)this.jsonMapper.convertValue((Object)new StringInputRowParser((ParseSpec)new JSONParseSpec(new TimestampSpec("time", "auto", null), DimensionsSpec.builder().setDimensions(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"time", (Object)"dimA", (Object)"dimB", (Object)"col2"))).setDimensionExclusions((List)ImmutableList.of((Object)"dimC")).build(), null, null, null), null), JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT);
        DataSchema schema = DataSchema.builder().withDataSource("alpha123..*~!@#&%^&*()-+ \u0420\u043e\u0441\u0441\u0438\u044f\\ \ud55c\uad6d \u4e2d\u56fd!").withParserMap(parser).withAggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("metric1", "col1"), new DoubleSumAggregatorFactory("metric2", "col2")}).withGranularity((GranularitySpec)ARBITRARY_GRANULARITY).withObjectMapper(this.jsonMapper).build();
        Assert.assertEquals((Object)ImmutableSet.of((Object)"__time", (Object)"dimC", (Object)"col1", (Object)"metric1", (Object)"metric2"), (Object)schema.getParser().getParseSpec().getDimensionsSpec().getDimensionExclusions());
    }

    @Test
    public void testTransformSpec() {
        Map parserMap = (Map)this.jsonMapper.convertValue((Object)new StringInputRowParser((ParseSpec)new JSONParseSpec(new TimestampSpec("time", "auto", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"time", (Object)"dimA", (Object)"dimB", (Object)"col2"))), null, null, null), null), JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT);
        DataSchema schema = DataSchema.builder().withDataSource("alpha123..*~!@#&%^&*()-+ \u0420\u043e\u0441\u0441\u0438\u044f\\ \ud55c\uad6d \u4e2d\u56fd!").withParserMap(parserMap).withAggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("metric1", "col1"), new DoubleSumAggregatorFactory("metric2", "col2")}).withGranularity((GranularitySpec)ARBITRARY_GRANULARITY).withTransform(new TransformSpec((DimFilter)new SelectorDimFilter("dimA", "foo", null), (List)ImmutableList.of((Object)new ExpressionTransform("expr", "concat(dimA,dimA)", TestExprMacroTable.INSTANCE)))).withObjectMapper(this.jsonMapper).build();
        StringInputRowParser parser = (StringInputRowParser)schema.getParser();
        InputRow row1bb = (InputRow)parser.parseBatch(ByteBuffer.wrap("{\"time\":\"2000-01-01\",\"dimA\":\"foo\"}".getBytes(StandardCharsets.UTF_8))).get(0);
        Assert.assertEquals((Object)DateTimes.of((String)"2000-01-01"), (Object)row1bb.getTimestamp());
        Assert.assertEquals((Object)"foo", (Object)row1bb.getRaw("dimA"));
        Assert.assertEquals((Object)"foofoo", (Object)row1bb.getRaw("expr"));
        InputRow row1string = parser.parse("{\"time\":\"2000-01-01\",\"dimA\":\"foo\"}");
        Assert.assertEquals((Object)DateTimes.of((String)"2000-01-01"), (Object)row1string.getTimestamp());
        Assert.assertEquals((Object)"foo", (Object)row1string.getRaw("dimA"));
        Assert.assertEquals((Object)"foofoo", (Object)row1string.getRaw("expr"));
        InputRow row2 = (InputRow)parser.parseBatch(ByteBuffer.wrap("{\"time\":\"2000-01-01\",\"dimA\":\"x\"}".getBytes(StandardCharsets.UTF_8))).get(0);
        Assert.assertNull((Object)row2);
    }

    @Test
    public void testOverlapMetricNameAndDim() {
        Map parser = (Map)this.jsonMapper.convertValue((Object)new StringInputRowParser((ParseSpec)new JSONParseSpec(new TimestampSpec("time", "auto", null), DimensionsSpec.builder().setDimensions(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"time", (Object)"dimA", (Object)"dimB", (Object)"metric1"))).setDimensionExclusions((List)ImmutableList.of((Object)"dimC")).build(), null, null, null), null), JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT);
        DataSchema schema = DataSchema.builder().withDataSource("alpha123..*~!@#&%^&*()-+ \u0420\u043e\u0441\u0441\u0438\u044f\\ \ud55c\uad6d \u4e2d\u56fd!").withParserMap(parser).withAggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("metric1", "col1"), new DoubleSumAggregatorFactory("metric2", "col2")}).withGranularity((GranularitySpec)ARBITRARY_GRANULARITY).withObjectMapper(this.jsonMapper).build();
        this.expectedException.expect(DruidException.class);
        this.expectedException.expectMessage("Cannot specify a column more than once: [metric1] seen in dimensions list, metricsSpec list");
        schema.getParser();
    }

    @Test
    public void testOverlapTimeAndDimPositionZero() {
        DataSchema schema = DataSchema.builder().withDataSource("alpha123..*~!@#&%^&*()-+ \u0420\u043e\u0441\u0441\u0438\u044f\\ \ud55c\uad6d \u4e2d\u56fd!").withTimestamp(new TimestampSpec("time", "auto", null)).withDimensions(DimensionsSpec.builder().setDimensions((List)ImmutableList.of((Object)new LongDimensionSchema("__time"), (Object)new StringDimensionSchema("dimA"), (Object)new StringDimensionSchema("dimB"))).setDimensionExclusions((List)ImmutableList.of((Object)"dimC")).build()).withGranularity((GranularitySpec)ARBITRARY_GRANULARITY).withObjectMapper(this.jsonMapper).build();
        Assert.assertEquals((Object)ImmutableList.of((Object)"__time", (Object)"dimA", (Object)"dimB"), (Object)schema.getDimensionsSpec().getDimensionNames());
        Assert.assertTrue((boolean)schema.getDimensionsSpec().isForceSegmentSortByTime());
    }

    @Test
    public void testOverlapTimeAndDimPositionZeroWrongType() {
        this.expectedException.expect(DruidException.class);
        this.expectedException.expectMessage("Encountered dimension[__time] with incorrect type[STRING]. Type must be 'long'.");
        DataSchema.builder().withDataSource("alpha123..*~!@#&%^&*()-+ \u0420\u043e\u0441\u0441\u0438\u044f\\ \ud55c\uad6d \u4e2d\u56fd!").withTimestamp(new TimestampSpec("time", "auto", null)).withDimensions(DimensionsSpec.builder().setDimensions((List)ImmutableList.of((Object)new StringDimensionSchema("__time"), (Object)new StringDimensionSchema("dimA"), (Object)new StringDimensionSchema("dimB"))).setDimensionExclusions((List)ImmutableList.of((Object)"dimC")).build()).withGranularity((GranularitySpec)ARBITRARY_GRANULARITY).withObjectMapper(this.jsonMapper).build();
    }

    @Test
    public void testOverlapTimeAndDimPositionOne() {
        this.expectedException.expect(DruidException.class);
        this.expectedException.expectMessage("Encountered dimension[__time] at position[1]. This is only supported when the dimensionsSpec parameter[forceSegmentSortByTime] is set to[false]. " + DimensionsSpec.WARNING_NON_TIME_SORT_ORDER);
        DataSchema.builder().withDataSource("alpha123..*~!@#&%^&*()-+ \u0420\u043e\u0441\u0441\u0438\u044f\\ \ud55c\uad6d \u4e2d\u56fd!").withTimestamp(new TimestampSpec("time", "auto", null)).withDimensions(DimensionsSpec.builder().setDimensions((List)ImmutableList.of((Object)new StringDimensionSchema("dimA"), (Object)new LongDimensionSchema("__time"), (Object)new StringDimensionSchema("dimB"))).setDimensionExclusions((List)ImmutableList.of((Object)"dimC")).build()).withGranularity((GranularitySpec)ARBITRARY_GRANULARITY).withObjectMapper(this.jsonMapper).build();
    }

    @Test
    public void testOverlapTimeAndDimPositionOne_withExplicitSortOrder() {
        DataSchema schema = DataSchema.builder().withDataSource("alpha123..*~!@#&%^&*()-+ \u0420\u043e\u0441\u0441\u0438\u044f\\ \ud55c\uad6d \u4e2d\u56fd!").withTimestamp(new TimestampSpec("time", "auto", null)).withDimensions(DimensionsSpec.builder().setDimensions((List)ImmutableList.of((Object)new StringDimensionSchema("dimA"), (Object)new LongDimensionSchema("__time"), (Object)new StringDimensionSchema("dimB"))).setDimensionExclusions((List)ImmutableList.of((Object)"dimC")).setForceSegmentSortByTime(Boolean.valueOf(false)).build()).withGranularity((GranularitySpec)ARBITRARY_GRANULARITY).withObjectMapper(this.jsonMapper).build();
        Assert.assertEquals((Object)ImmutableList.of((Object)"dimA", (Object)"__time", (Object)"dimB"), (Object)schema.getDimensionsSpec().getDimensionNames());
        Assert.assertFalse((boolean)schema.getDimensionsSpec().isForceSegmentSortByTime());
    }

    @Test
    public void testOverlapTimeAndDimLegacy() {
        Map parser = (Map)this.jsonMapper.convertValue((Object)new StringInputRowParser((ParseSpec)new JSONParseSpec(new TimestampSpec("time", "auto", null), DimensionsSpec.builder().setDimensions(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"__time", (Object)"dimA", (Object)"dimB", (Object)"metric1"))).setDimensionExclusions((List)ImmutableList.of((Object)"dimC")).build(), null, null, null), null), JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT);
        DataSchema schema = DataSchema.builder().withDataSource("alpha123..*~!@#&%^&*()-+ \u0420\u043e\u0441\u0441\u0438\u044f\\ \ud55c\uad6d \u4e2d\u56fd!").withParserMap(parser).withGranularity((GranularitySpec)ARBITRARY_GRANULARITY).withObjectMapper(this.jsonMapper).build();
        this.expectedException.expect(DruidException.class);
        this.expectedException.expectMessage("Encountered dimension[__time] with incorrect type[STRING]. Type must be 'long'.");
        schema.getParser();
    }

    @Test
    public void testDuplicateAggregators() {
        Map parser = (Map)this.jsonMapper.convertValue((Object)new StringInputRowParser((ParseSpec)new JSONParseSpec(new TimestampSpec("time", "auto", null), DimensionsSpec.builder().setDimensions(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"time"))).setDimensionExclusions((List)ImmutableList.of((Object)"dimC")).build(), null, null, null), null), JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT);
        this.expectedException.expect(DruidException.class);
        this.expectedException.expectMessage("Cannot specify a column more than once: [metric1] seen in metricsSpec list (2 occurrences); [metric3] seen in metricsSpec list (2 occurrences)");
        DataSchema schema = DataSchema.builder().withDataSource("alpha123..*~!@#&%^&*()-+ \u0420\u043e\u0441\u0441\u0438\u044f\\ \ud55c\uad6d \u4e2d\u56fd!").withParserMap(parser).withAggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("metric1", "col1"), new DoubleSumAggregatorFactory("metric2", "col2"), new DoubleSumAggregatorFactory("metric1", "col3"), new DoubleSumAggregatorFactory("metric3", "col4"), new DoubleSumAggregatorFactory("metric3", "col5")}).withGranularity((GranularitySpec)ARBITRARY_GRANULARITY).withObjectMapper(this.jsonMapper).build();
    }

    @Test
    public void testSerdeWithInvalidParserMap() throws Exception {
        String jsonStr = "{\"dataSource\":\"" + StringEscapeUtils.escapeJson((String)"alpha123..*~!@#&%^&*()-+ \u0420\u043e\u0441\u0441\u0438\u044f\\ \ud55c\uad6d \u4e2d\u56fd!") + "\",\"parser\":{\"type\":\"invalid\"},\"metricsSpec\":[{\"type\":\"doubleSum\",\"name\":\"metric1\",\"fieldName\":\"col1\"}],\"granularitySpec\":{\"type\":\"arbitrary\",\"queryGranularity\":{\"type\":\"duration\",\"duration\":86400000,\"origin\":\"1970-01-01T00:00:00.000Z\"},\"intervals\":[\"2014-01-01T00:00:00.000Z/2015-01-01T00:00:00.000Z\"]}}";
        DataSchema schema = (DataSchema)this.jsonMapper.readValue(this.jsonMapper.writeValueAsString(this.jsonMapper.readValue(jsonStr, DataSchema.class)), DataSchema.class);
        this.expectedException.expect(CoreMatchers.instanceOf(IllegalArgumentException.class));
        this.expectedException.expectCause(CoreMatchers.instanceOf(JsonMappingException.class));
        this.expectedException.expectMessage("Cannot construct instance of `org.apache.druid.data.input.impl.StringInputRowParser`, problem: parseSpec");
        schema.getParser();
    }

    @Test
    public void testEmptyDatasource() {
        Map parser = (Map)this.jsonMapper.convertValue((Object)new StringInputRowParser((ParseSpec)new JSONParseSpec(new TimestampSpec("time", "auto", null), DimensionsSpec.builder().setDimensions(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"time", (Object)"dimA", (Object)"dimB", (Object)"col2"))).setDimensionExclusions((List)ImmutableList.of((Object)"dimC")).build(), null, null, null), null), JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT);
        DruidExceptionMatcher.ThrowingSupplier thrower = () -> DataSchema.builder().withDataSource("").withParserMap(parser).withAggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("metric1", "col1"), new DoubleSumAggregatorFactory("metric2", "col2")}).withGranularity((GranularitySpec)ARBITRARY_GRANULARITY).withObjectMapper(this.jsonMapper).build();
        DruidExceptionMatcher.invalidInput().expectMessageIs("Invalid value for field [dataSource]: must not be null").assertThrowsAndMatches(thrower);
    }

    @Test
    public void testInvalidWhitespaceDatasource() {
        ImmutableMap invalidCharToDataSourceName = ImmutableMap.of((Object)"\\t", (Object)"\tab\t", (Object)"\\r", (Object)"\rcarriage\return\r", (Object)"\\n", (Object)"\nnew\nline\n");
        for (Map.Entry entry : invalidCharToDataSourceName.entrySet()) {
            String dataSource = (String)entry.getValue();
            String msg = StringUtils.format((String)"Invalid value for field [dataSource]: Value [%s] contains illegal whitespace characters.  Only space is allowed.", (Object[])new Object[]{dataSource});
            DruidExceptionMatcher.invalidInput().expectMessageIs(msg).assertThrowsAndMatches(() -> DataSchema.builder().withDataSource(dataSource).withParserMap(Collections.emptyMap()).withObjectMapper(this.jsonMapper).build());
        }
    }

    @Test
    public void testSerde() throws Exception {
        String jsonStr = "{\"dataSource\":\"" + StringEscapeUtils.escapeJson((String)"alpha123..*~!@#&%^&*()-+ \u0420\u043e\u0441\u0441\u0438\u044f\\ \ud55c\uad6d \u4e2d\u56fd!") + "\",\"parser\":{\"type\":\"string\",\"parseSpec\":{\"format\":\"json\",\"timestampSpec\":{\"column\":\"xXx\", \"format\": \"auto\", \"missingValue\": null},\"dimensionsSpec\":{\"dimensions\":[], \"dimensionExclusions\":[]},\"flattenSpec\":{\"useFieldDiscovery\":true, \"fields\":[]},\"featureSpec\":{}},\"encoding\":\"UTF-8\"},\"metricsSpec\":[{\"type\":\"doubleSum\",\"name\":\"metric1\",\"fieldName\":\"col1\"}],\"granularitySpec\":{\"type\":\"arbitrary\",\"queryGranularity\":{\"type\":\"duration\",\"duration\":86400000,\"origin\":\"1970-01-01T00:00:00.000Z\"},\"intervals\":[\"2014-01-01T00:00:00.000Z/2015-01-01T00:00:00.000Z\"]}}";
        DataSchema actual = (DataSchema)this.jsonMapper.readValue(this.jsonMapper.writeValueAsString(this.jsonMapper.readValue(jsonStr, DataSchema.class)), DataSchema.class);
        Assert.assertEquals((Object)actual.getDataSource(), (Object)"alpha123..*~!@#&%^&*()-+ \u0420\u043e\u0441\u0441\u0438\u044f\\ \ud55c\uad6d \u4e2d\u56fd!");
        Assert.assertEquals((Object)actual.getParser().getParseSpec(), (Object)new JSONParseSpec(new TimestampSpec("xXx", null, null), DimensionsSpec.builder().setDimensionExclusions(Arrays.asList("__time", "metric1", "xXx", "col1")).build(), null, null, null));
        Assert.assertArrayEquals((Object[])actual.getAggregators(), (Object[])new AggregatorFactory[]{new DoubleSumAggregatorFactory("metric1", "col1")});
        Assert.assertEquals((Object)actual.getGranularitySpec(), (Object)new ArbitraryGranularitySpec((Granularity)new DurationGranularity(86400000L, null), (List)ImmutableList.of((Object)Intervals.of((String)"2014/2015"))));
    }

    @Test
    public void testSerializeWithInvalidDataSourceName() throws Exception {
        ImmutableMap datasourceToErrorMsg = ImmutableMap.of((Object)"", (Object)"Invalid value for field [dataSource]: must not be null", (Object)"../invalid", (Object)"Invalid value for field [dataSource]: Value [../invalid] cannot start with '.'.", (Object)"\tname", (Object)"Invalid value for field [dataSource]: Value [\tname] contains illegal whitespace characters.  Only space is allowed.", (Object)"name\t invalid", (Object)"Invalid value for field [dataSource]: Value [name\t invalid] contains illegal whitespace characters.  Only space is allowed.");
        for (Map.Entry entry : datasourceToErrorMsg.entrySet()) {
            String jsonStr = "{\"dataSource\":\"" + StringEscapeUtils.escapeJson((String)((String)entry.getKey())) + "\",\"parser\":{\"type\":\"string\",\"parseSpec\":{\"format\":\"json\",\"timestampSpec\":{\"column\":\"xXx\", \"format\": \"auto\", \"missingValue\": null},\"dimensionsSpec\":{\"dimensions\":[], \"dimensionExclusions\":[]},\"flattenSpec\":{\"useFieldDiscovery\":true, \"fields\":[]},\"featureSpec\":{}},\"encoding\":\"UTF-8\"},\"metricsSpec\":[{\"type\":\"doubleSum\",\"name\":\"metric1\",\"fieldName\":\"col1\"}],\"granularitySpec\":{\"type\":\"arbitrary\",\"queryGranularity\":{\"type\":\"duration\",\"duration\":86400000,\"origin\":\"1970-01-01T00:00:00.000Z\"},\"intervals\":[\"2014-01-01T00:00:00.000Z/2015-01-01T00:00:00.000Z\"]}}";
            try {
                this.jsonMapper.readValue(this.jsonMapper.writeValueAsString(this.jsonMapper.readValue(jsonStr, DataSchema.class)), DataSchema.class);
            }
            catch (ValueInstantiationException e) {
                MatcherAssert.assertThat((String)((String)entry.getKey()), (Object)e.getCause(), (Matcher)DruidExceptionMatcher.invalidInput().expectMessageIs((String)entry.getValue()));
                continue;
            }
            Assert.fail((String)("Serialization of datasource " + (String)entry.getKey() + " should have failed."));
        }
    }

    @Test
    public void testSerdeWithUpdatedDataSchemaAddedField() throws IOException {
        Map parser = (Map)this.jsonMapper.convertValue((Object)new StringInputRowParser((ParseSpec)new JSONParseSpec(new TimestampSpec("time", "auto", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"dimB", (Object)"dimA"))), null, null, null), null), JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT);
        DataSchema originalSchema = DataSchema.builder().withDataSource("alpha123..*~!@#&%^&*()-+ \u0420\u043e\u0441\u0441\u0438\u044f\\ \ud55c\uad6d \u4e2d\u56fd!").withParserMap(parser).withAggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("metric1", "col1"), new DoubleSumAggregatorFactory("metric2", "col2")}).withGranularity((GranularitySpec)ARBITRARY_GRANULARITY).withObjectMapper(this.jsonMapper).build();
        String serialized = this.jsonMapper.writeValueAsString((Object)originalSchema);
        TestModifiedDataSchema deserialized = (TestModifiedDataSchema)((Object)this.jsonMapper.readValue(serialized, TestModifiedDataSchema.class));
        Assert.assertEquals(null, (Object)deserialized.getExtra());
        Assert.assertEquals((Object)originalSchema.getDataSource(), (Object)deserialized.getDataSource());
        Assert.assertEquals((Object)originalSchema.getGranularitySpec(), (Object)deserialized.getGranularitySpec());
        Assert.assertEquals((Object)originalSchema.getParser().getParseSpec(), (Object)deserialized.getParser().getParseSpec());
        Assert.assertArrayEquals((Object[])originalSchema.getAggregators(), (Object[])deserialized.getAggregators());
        Assert.assertEquals((Object)originalSchema.getTransformSpec(), (Object)deserialized.getTransformSpec());
        Assert.assertEquals((Object)originalSchema.getParserMap(), (Object)deserialized.getParserMap());
    }

    @Test
    public void testSerdeWithUpdatedDataSchemaRemovedField() throws IOException {
        Map parser = (Map)this.jsonMapper.convertValue((Object)new StringInputRowParser((ParseSpec)new JSONParseSpec(new TimestampSpec("time", "auto", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"dimB", (Object)"dimA"))), null, null, null), null), JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT);
        TestModifiedDataSchema originalSchema = new TestModifiedDataSchema("alpha123..*~!@#&%^&*()-+ \u0420\u043e\u0441\u0441\u0438\u044f\\ \ud55c\uad6d \u4e2d\u56fd!", null, null, new AggregatorFactory[]{new DoubleSumAggregatorFactory("metric1", "col1"), new DoubleSumAggregatorFactory("metric2", "col2")}, (GranularitySpec)ARBITRARY_GRANULARITY, null, parser, this.jsonMapper, "some arbitrary string");
        String serialized = this.jsonMapper.writeValueAsString((Object)originalSchema);
        DataSchema deserialized = (DataSchema)this.jsonMapper.readValue(serialized, DataSchema.class);
        Assert.assertEquals((Object)originalSchema.getDataSource(), (Object)deserialized.getDataSource());
        Assert.assertEquals((Object)originalSchema.getGranularitySpec(), (Object)deserialized.getGranularitySpec());
        Assert.assertEquals((Object)originalSchema.getParser().getParseSpec(), (Object)deserialized.getParser().getParseSpec());
        Assert.assertArrayEquals((Object[])originalSchema.getAggregators(), (Object[])deserialized.getAggregators());
        Assert.assertEquals((Object)originalSchema.getTransformSpec(), (Object)deserialized.getTransformSpec());
        Assert.assertEquals((Object)originalSchema.getParserMap(), (Object)deserialized.getParserMap());
    }

    @Test
    public void testWithDimensionSpec() {
        TimestampSpec tsSpec = (TimestampSpec)Mockito.mock(TimestampSpec.class);
        GranularitySpec gSpec = (GranularitySpec)Mockito.mock(GranularitySpec.class);
        DimensionsSpec oldDimSpec = (DimensionsSpec)Mockito.mock(DimensionsSpec.class);
        DimensionsSpec newDimSpec = (DimensionsSpec)Mockito.mock(DimensionsSpec.class);
        AggregatorFactory aggFactory = (AggregatorFactory)Mockito.mock(AggregatorFactory.class);
        Mockito.when((Object)aggFactory.getName()).thenReturn((Object)"myAgg");
        TransformSpec transSpec = (TransformSpec)Mockito.mock(TransformSpec.class);
        Map parserMap = (Map)Mockito.mock(Map.class);
        Mockito.when((Object)newDimSpec.withDimensionExclusions((Set)ArgumentMatchers.any(Set.class))).thenReturn((Object)newDimSpec);
        DataSchema oldSchema = DataSchema.builder().withDataSource("dataSource").withTimestamp(tsSpec).withDimensions(oldDimSpec).withAggregators(new AggregatorFactory[]{aggFactory}).withGranularity(gSpec).withTransform(transSpec).withParserMap(parserMap).withObjectMapper(this.jsonMapper).build();
        DataSchema newSchema = oldSchema.withDimensionsSpec(newDimSpec);
        Assert.assertSame((Object)oldSchema.getDataSource(), (Object)newSchema.getDataSource());
        Assert.assertSame((Object)oldSchema.getTimestampSpec(), (Object)newSchema.getTimestampSpec());
        Assert.assertSame((Object)newDimSpec, (Object)newSchema.getDimensionsSpec());
        Assert.assertSame((Object)oldSchema.getAggregators(), (Object)newSchema.getAggregators());
        Assert.assertSame((Object)oldSchema.getGranularitySpec(), (Object)newSchema.getGranularitySpec());
        Assert.assertSame((Object)oldSchema.getTransformSpec(), (Object)newSchema.getTransformSpec());
        Assert.assertSame((Object)oldSchema.getParserMap(), (Object)newSchema.getParserMap());
    }

    @Test
    public void testCombinedDataSchemaSetsMultiValuedColumnsInfo() {
        ImmutableSet multiValuedDimensions = ImmutableSet.of((Object)"dimA");
        CombinedDataSchema schema = new CombinedDataSchema("alpha123..*~!@#&%^&*()-+ \u0420\u043e\u0441\u0441\u0438\u044f\\ \ud55c\uad6d \u4e2d\u56fd!", new TimestampSpec("time", "auto", null), DimensionsSpec.builder().setDimensions(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"dimA", (Object)"dimB", (Object)"metric1"))).setDimensionExclusions((List)ImmutableList.of((Object)"dimC")).build(), null, (GranularitySpec)ARBITRARY_GRANULARITY, null, null, (Set)multiValuedDimensions);
        Assert.assertEquals((Object)ImmutableSet.of((Object)"dimA"), (Object)schema.getMultiValuedDimensions());
    }
}

