/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.realtime.appenderator;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.segment.realtime.appenderator.Committed;
import org.apache.druid.segment.realtime.appenderator.SegmentIdWithShardSpec;
import org.apache.druid.timeline.partition.LinearShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.junit.Assert;
import org.junit.Test;

public class CommittedTest {
    private static final ObjectMapper OBJECT_MAPPER = new DefaultObjectMapper();
    private static final SegmentIdWithShardSpec IDENTIFIER_OBJECT1 = new SegmentIdWithShardSpec("foo", Intervals.of((String)"2000/2001"), "2000", (ShardSpec)new LinearShardSpec(Integer.valueOf(1)));
    private static final SegmentIdWithShardSpec IDENTIFIER_OBJECT2 = new SegmentIdWithShardSpec("foo", Intervals.of((String)"2001/2002"), "2001", (ShardSpec)new LinearShardSpec(Integer.valueOf(1)));
    private static final SegmentIdWithShardSpec IDENTIFIER_OBJECT3 = new SegmentIdWithShardSpec("foo", Intervals.of((String)"2001/2002"), "2001", (ShardSpec)new LinearShardSpec(Integer.valueOf(2)));
    private static final String IDENTIFIER1 = IDENTIFIER_OBJECT1.toString();
    private static final String IDENTIFIER2 = IDENTIFIER_OBJECT2.toString();
    private static final String IDENTIFIER3 = IDENTIFIER_OBJECT3.toString();

    private static Committed fixedInstance() {
        HashMap<String, Integer> hydrants = new HashMap<String, Integer>();
        hydrants.put(IDENTIFIER1, 3);
        hydrants.put(IDENTIFIER2, 2);
        return new Committed(hydrants, (Object)ImmutableMap.of((Object)"metadata", (Object)"foo"));
    }

    @Test
    public void testFactoryMethod() {
        Committed committed = CommittedTest.fixedInstance();
        Committed committed2 = Committed.create((Map)ImmutableMap.of((Object)IDENTIFIER_OBJECT1, (Object)3, (Object)IDENTIFIER_OBJECT2, (Object)2), (Object)ImmutableMap.of((Object)"metadata", (Object)"foo"));
        Assert.assertEquals((Object)committed, (Object)committed2);
    }

    @Test
    public void testSerde() throws Exception {
        Committed committed = CommittedTest.fixedInstance();
        byte[] bytes = OBJECT_MAPPER.writeValueAsBytes((Object)committed);
        Committed committed2 = (Committed)OBJECT_MAPPER.readValue(bytes, Committed.class);
        Assert.assertEquals((String)"Round trip: overall", (Object)committed, (Object)committed2);
        Assert.assertEquals((String)"Round trip: metadata", (Object)committed.getMetadata(), (Object)committed2.getMetadata());
        Assert.assertEquals((String)"Round trip: identifiers", (Object)committed.getHydrants().keySet(), (Object)committed2.getHydrants().keySet());
    }

    @Test
    public void testGetCommittedHydrant() {
        Assert.assertEquals((long)3L, (long)CommittedTest.fixedInstance().getCommittedHydrants(IDENTIFIER1));
        Assert.assertEquals((long)2L, (long)CommittedTest.fixedInstance().getCommittedHydrants(IDENTIFIER2));
        Assert.assertEquals((long)0L, (long)CommittedTest.fixedInstance().getCommittedHydrants(IDENTIFIER3));
    }

    @Test
    public void testWithout() {
        Assert.assertEquals((long)0L, (long)CommittedTest.fixedInstance().without(IDENTIFIER1).getCommittedHydrants(IDENTIFIER1));
        Assert.assertEquals((long)2L, (long)CommittedTest.fixedInstance().without(IDENTIFIER1).getCommittedHydrants(IDENTIFIER2));
    }
}

